function [Ur_over_U0, Hw, Dw] = Jensen_VAWT(Ct,x,y,z,zh,D,H,kD,kH)
%Jensen Jensen model for predicting the wake of a HAWT.
%   Ct - Thrust coefficient
%   Dr - Rotor diameter
%   a - induction factor
%   x - dowstream distance
%   alpha - expanded rate. 
% kD = 0.0418 ;
% kH = 0.1602;
% kH = 0.0418;
a = (1- sqrt(1 - Ct))./2; 
Hw = (1 + 2.*kH.*x./H).*H; Dw =  (1 + 2.*kD.*x./D).*D;

Htop = zh+ 0.5.*Hw; Hbot = zh - 0.5.*Hw;
Dl = -0.5.*Dw; Dr = 0.5.*Dw;


Ur_over_U0 = 1 - 2.*a./(1 + 2.*kH.*x./H)./(1 + 2.*kD.*x./D);
Ur_over_U0(z >= Htop) = 1; Ur_over_U0(z <= Hbot) = 1;
Ur_over_U0(y <= Dl) = 1; Ur_over_U0(y >= Dr) = 1;


end