% function [DU_U0,sigma] = Fernando(Ct, x, k_star)
function [DU_U0,sigma] = Fernando(Ct, x,y,z,zh, k_star, Ia)
%Fernando Wake model by Majid Bastankhah and Fernando Port-Agel
%   x - non-dimentional downstream distance
%   k_star - wake expansion rate ;
%   z - non-dimentional height
%   zh - hub-height
%   delta - characteristic wake width

if Ia <=0.134 && Ia >= 0.069
    k_star = 0.3837*Ia + 0.003678;
end
beta = (1+sqrt(1- Ct))./sqrt(1- Ct)./2;
e = 0.2 .* sqrt(beta);
% e = 0.1672;
EXP_VALUE = -0.5/(k_star.*x + e).^2*((z-zh).^2+y.^2);
% DU_U0 = (1 - sqrt(1-(Ct./(8.*(k_star.*x + e).^2)))).*exp(EXP_VALUE);
DU_U0 = 1 - sqrt(abs(1-(Ct./(8.*(k_star.*x + e).^2))));
sigma = k_star*x + e;
end

