function [DU_U0, Dw] = Larsen_HAWT(Ct,x,y,z,D,Ia)
%Jensen Jensen model for predicting the wake of a HAWT.
%   Ct - Thrust coefficient
%   Dr - Rotor diameter
%   a - induction factor
%   x - dowstream distance
%   alpha - expanded rate. 
if Ia <= 0.05
    delt0 = 2.16;
else
    delt0 = 2.16 + 43.4.*(Ia -0.05);
end
Dp = sqrt((1+sqrt(1-Ct))./(2.*sqrt(1-Ct)));
k = 1./9.5.*(delt0.^3 - Dp.^3);
Dw = (Dp.^3 + k.*x./D.^3).^(1./3); rw = 0.5.*Dw;
DU_U0_c = 35./9.*0.5.*Ct./Dw.^2;
% Uxc_over_U0 = 1 - deficit;   % Centerline velocity
r = sqrt(y.^2+z.^2);
% r(r>=rw)=1;
% U_Uinf = DU_U0_c.*(1 - (2.*r(r<=0.5.*Dw)./Dw).^(3/2)).^2;
% DU_U0 = DU_U0_c.*(1 - (2.*r.*(r<=rw)/D./Dw).^(3/2)).^2;
DU_U0 = DU_U0_c.*(1 - (2.*r./D./Dw).^(3/2)).^2;
DU_U0(r>=rw)=0;

end