function [Ur_over_U0, Dw] = Jensen_HAWT(Ct,x,y,z,D,k)
%Jensen Jensen model for predicting the wake of a HAWT.
%   Ct - Thrust coefficient
%   Dr - Rotor diameter
%   a - induction factor
%   x - dowstream distance
%   alpha - expanded rate. 

a = (1- sqrt(1 - Ct))./2; 
Dw =  1 + 2.*k.*x./D; Dw = Dw.*D;
r = sqrt(y.^2+z.^2);
Ur_over_U0 = 1 - 2.*a./(1 + 2.*k.*x./D)./(1 + 2.*k.*x./D);
Ur_over_U0(r >= 0.5.*Dw) = 1;

end