function [DU_U0,sigmaD,sigmaH] = BPA_VAWT(Ct, x,y,z,zh,D,H, k_starD, k_starH,Ia)
%Fernando Wake model by Majid Bastankhah and Fernando Port?-Agel, expanded
%by ABKAR
%   x - non-dimentional downstream distance
%   k_star - wake expansion rate ;
%   z - non-dimentional height
%   zh - hub-height
%   delta - characteristic wake width


% ---------- Wake expansion rate------------------%
if Ia <=0.134 && Ia >= 0.069
    k_star = 0.3837.*Ia + 0.003678;
     k_starD = k_star; k_starH = k_star;
end

Dp = sqrt((1+sqrt(1-Ct))./(2.*sqrt(1-Ct)));
x0 = 1./k_starD.*(sqrt(Ct./8)-0.2.*Dp./D);
sigmaD = 0.2.*Dp.*D + k_starD.*x; 
sigmaH = 0.2.*Dp.*H + k_starH.*x; 
EXP_VALUE = -0.5.*(((z-zh)./sigmaH).^2 + (y./sigmaD).^2);
Uxc_over_U0 = sqrt(abs(1-(Ct./(2.*pi.*(sigmaD).*(sigmaH)./(pi.*H.*D./4)))));

DU_U0 = (1 - Uxc_over_U0).*exp(EXP_VALUE);
end

