#########################################################################################################
# Initial state of the discriminant analysis in the research, Siska Fitrianie, Merijn Bruijnes, 
# Fengxiang Li, Amal Abdulrahman, Willem-Paul Brinkman. 2022. The Artificial-Social-Agent Questionnaire: 
# Establishing the long and short questionnaire versions. In ACM International Conference on Intelligent 
# Virtual Agents (IVA’22), September, 2022, Faro, Portugal. ACM, New York, NY, USA.
# https://doi.org/10.1145/3514197.3549612
#
# Run EFA of predicted latent scores of 19 constructs including their dimensions (n=532, 24 measurements)
# Input:  result_all_pItem_std.csv (standardized observed data)
# Output: final_latentPredicted_convergentAnalysis.csv (predicted latent scores of constructs/dimensions)
#########################################################################################################

## Library
library(dplyr) 
library(psych)
library(crayon)
library(CTT)
library(factoextra)
library(lattice)
library(boot)
library(nFactors)
library(Rcsdp)
library(GPArotation)

## Retrieve predicted latent scores of constructs
d_predicted_std = read.csv2("../r_results/final_predictedLatent_convergentAnalysis.csv", header = TRUE, sep=",")
drop = c("C01") # C01 is dropped because it has a strong correlation with its dimensions
d_predicted_std = d_predicted_std[,!(names(d_predicted_std) %in% drop)]
d_predicted_std<- sapply(d_predicted_std[1:ncol(d_predicted_std)],as.numeric)

# Determine Number of Factors to Extract
parallel<-fa.parallel(d_predicted_std, fm='ml', fa='fa')

# Maximum Likelihood Factor Analysis
printFA <- function(data, nfactors){
  data_cor <- cor(data)
  factors_data <- fa(data_cor,  nfactors, rotate = "promax", SMC=FALSE, fm="ml", max.iter=100)
  print(factors_data, digits=2, sort=TRUE)
}
printFA(d_predicted_std, 5)