#########################################################################################################
# Final state of the discriminant analysis in the research, Siska Fitrianie, Merijn Bruijnes, 
# Fengxiang Li, Amal Abdulrahman, Willem-Paul Brinkman. 2022. The Artificial-Social-Agent Questionnaire: 
# Establishing the long and short questionnaire versions. In ACM International Conference on Intelligent 
# Virtual Agents (IVA’22), September, 2022, Faro, Portugal. ACM, New York, NY, USA.
# https://doi.org/10.1145/3514197.3549612
#
# Run CFA of 4 factorial models (n=532)
# Input:  result_all_pItem_std.csv (standardized observed data)
#########################################################################################################

## Library
library(lavaan)

## Retrieve standardised observed data
d_results_std=read.csv2("data/result_all_pItem_std.csv", header = TRUE, sep =",")
d_results_std <- mutate_all(d_results_std, function(x) as.numeric(as.character(x)))

######################## CFA of 4 factorial models 
#### 1st factorial model
set.seed(1234)
model_1 <- '
C01D05 =~ C01D05Q0 + C01D05Q2 + C01D05Q9   
C02 =~ C02D00Q1 + C02D00Q2 + C02D00Q8 
C03 =~ C03D01Q7   + C03D01Q12  + C03D02Q10 
C07 =~  C07D00Q0 + C07D00Q11 +  R_C07D00Q15 
C09 =~  C09D00Q4 + C09D00Q10 +  C09D00Q1 
C10 =~  C10D00Q6  + C10D00Q16 + C10D00Q18 
C11 =~  C11D01Q9 + C11D01Q10  + C11D01Q14 + C11D01Q11 + C11D02Q4 + C11D02Q7 
C12 =~ C12D00Q0 +  C12D00Q1 +  C12D00Q13 
C13 =~  R_C13D00Q11 + R_C13D00Q6 + R_C13D00Q15 + R_C13D00Q3
C14 =~ C14D00Q0 + C14D00Q10   + C14D00Q16 +  R_C14D00Q13
C15 =~ C15D00Q10 + C15D00Q11   + R_C15D00Q15 
C17 =~  C17D00Q2 + C17D00Q3  + C17D00Q9 + C17D00Q10 
C17D00Q9 ~~   C17D00Q10
C12D00Q0 ~~    C12D00Q1
C11D01Q9 ~~   C11D01Q11
C11D01Q9 ~~   C11D01Q10
C14D00Q10 ~~   C14D00Q16
C07D00Q11 ~~ R_C07D00Q15
C11D01Q9 ~~    C11D02Q7 
C11D01Q11 ~~    C11D02Q7
C07D00Q0 ~~ R_C07D00Q15
C11D01Q10 ~~    C11D02Q7
C14D00Q10 ~~ R_C14D00Q13
R_C13D00Q15 ~~  R_C13D00Q3  
C11D01Q10 ~~    C11D02Q4
C11D01Q10 ~~   C11D01Q11
'  
fit_1 <- cfa(model_1, data=d_results_std)
summary(fit_1, fit.measures=TRUE, standardize=TRUE)
MI_1=modificationIndices(fit_1, sort.=TRUE, minimum.value=4.0)
MI_1
d_fm1 <- data.frame(lavPredict(fit_1, type="lv"))

#### 2ND factorial model
model_2 <- '
C05 =~  C05D00Q6 + C05D00Q7  + C05D00Q1 
C06D01 =~  C06D01Q1   + C06D01Q11  + R_C06D01Q6 
C16 =~   C16D00Q12  + C16D00Q17  + C16D00Q13 
C18D01 =~ C18D01Q2 + C18D01Q3 +  R_C18D01Q5 + C18D01Q8 + R_C18D01Q14
C18D03 =~ C18D03Q0 + C18D03Q1 + C18D03Q2 +  C18D03Q12 
C19 =~   C19D00Q14   + C19D00Q28   + C19D00Q7 + C19D00Q26 
'  
fit_2 <- cfa(model_2, data=d_results_std)
summary(fit_2, fit.measures=TRUE, standardize=TRUE)
MI_2=modificationIndices(fit_2, sort.=TRUE, minimum.value=4.0)
MI_2
d_fm2 <- data.frame(lavPredict(fit_2, type="lv"))

#### 3rd factorial model
set.seed(1234)
model_3 <- '
C01D01 =~   C01D01Q10 + C01D01Q13 + C01D01Q15 + C01D01Q3
C01D02 =~   C01D02Q10 + C01D02Q0 + C01D02Q1 + C01D02Q9 + C01D02Q7
C01D03 =~  C01D03Q9 +  C01D03Q11 + C01D03Q10 + C01D03Q12 + C01D03Q7
C01D04 =~  C01D04Q13 +  C01D04Q15 + C01D04Q0
'  
fit_3 <- cfa(model_3, data=d_results_std)
summary(fit_3, fit.measures=TRUE, standardize=TRUE)
lavInspect(fit_3, "cor.lv")
MI_3=modificationIndices(fit_3, sort.=TRUE, minimum.value=4.0)
MI_3
d_fm3 <- data.frame(lavPredict(fit_3, type="lv"))

#### 4th factorial model
set.seed(1234)
model_4 <- '
C04 =~ C04D00Q1 +  C04D00Q10 + R_C04D00Q11 + C04D00Q4 + C04D00Q12 
C08 =~ R_C08D00Q3 + C08D00Q4   + R_C08D00Q9 + C08D00Q0
'
fit_4 <- cfa(model_4, data=d_results_std)
summary(fit_4, fit.measures=TRUE, standardize=TRUE)
MI_4=modificationIndices(fit_4, sort.=TRUE, minimum.value=4.0)
MI_4
d_fm4 <- data.frame(lavPredict(fit_4, type="lv"))
## Collect predicted latent scores of constructs/dimensions and write to .csv
d_predicted_std <- cbind(d_fm1,d_fm2,d_fm3,d_fm4)
write.csv(d_predicted_std,"../r_results/final_latentPredicted_discriminantAnalysis.csv", row.names = FALSE)

