#########################################################################################################
# Final state of the discriminant analysis in the research, Siska Fitrianie, Merijn Bruijnes, 
# Fengxiang Li, Amal Abdulrahman, Willem-Paul Brinkman. 2022. The Artificial-Social-Agent Questionnaire: 
# Establishing the long and short questionnaire versions. In ACM International Conference on Intelligent 
# Virtual Agents (IVA’22), September, 2022, Faro, Portugal. ACM, New York, NY, USA.
# https://doi.org/10.1145/3514197.3549612
#
# Calculate cronbach's alpha of individual construct/dimension (n=532)
# Input:  result_all_pItem_std.csv (standardized observed data)
#########################################################################################################

## Library
library(dplyr) 
library(psych)
library(crayon)
library(CTT)
library(ggplot2)

## Retrieve standardized observed data 
d_results_std=read.csv2("../r_results/result_all_pItem_std.csv", header = TRUE, sep =",")
d_results_std <- mutate_all(d_results_std, function(x) as.numeric(as.character(x)))

########### Functions
## Retrieve data based on their individual construct/dimension
getData <- function(data, inc){
  dat <- data.frame()
  begin <- ((inc-1)*5)+1
  end <- ((inc-1)*5)+5
  if (inc==14) {
    end = ((inc-1)*5)+6
  }
  else if (inc > 14) {
    begin= ((inc-1)*5)+2
    end=((inc-1)*5)+6
  }
  dat <- data[begin:end]
  dat[1:ncol(dat)] <- sapply(dat[1:ncol(dat)],as.numeric)
  return(dat)
}

## Calculate Cronbach's alpha for individual construct/dimension
calAlpha_indv <- function(data, constructs, i){
  title <- green $ bold 
  cat(title("CONSTRUCT: " %+% constructs[i] %+% "\n"))
  psych:::alpha(data, check.keys=TRUE)
}

## Calculate individual construct/dimension's cronbach's alpha 
## the items of each construct/dimension is based on the final discriminant validity analysis results
## some items were removed in the analysis process
C01D01 <- getData(d_results_std, inc=1)
drop = c("C01D01Q16")
C01D01 = C01D01[,!(names(C01D01) %in% drop)]
calAlpha_indv(C01D01, constructs, 1)

C01D02 <- getData(d_results_std, inc=2)
calAlpha_indv(C01D02, constructs, 2)
C01D03 <- getData(d_results_std, inc=3)
calAlpha_indv(C01D03, constructs, 3)

C01D04 <- getData(d_results_std, inc=4)
drop = c("C01D04Q8","C01D04Q9")
C01D04 = C01D04[,!(names(C01D04) %in% drop)]
calAlpha_indv(C01D04, constructs, 4)

C01D05 <- getData(d_results_std, inc=5)
drop = c("C01D05Q11","C01D05Q12")
C01D05 = C01D05[,!(names(C01D05) %in% drop)]
calAlpha_indv(C01D05, constructs, 5)

C02 <- getData(d_results_std, inc=6)
drop = c("R_C02D00Q11","R_C02D00Q15")
C02 = C02[,!(names(C02) %in% drop)]
calAlpha_indv(C02, constructs, 6)

C03D01 <- getData(d_results_std, inc=7)
C03D02 <- getData(d_results_std, inc=8)
C03 <- cbind(C03D01,C03D02)
drop = c("C03D01Q1","C03D01Q5","C03D01Q6","C03D02Q0","C03D02Q5","R_C03D02Q13","R_C03D02Q1")
C03 = C03[,!(names(C03) %in% drop)]
calAlpha_indv(C03, constructs, 7)

C04 <- getData(d_results_std, inc=9)
calAlpha_indv(C04, constructs, 9)

C05 <- getData(d_results_std, inc=10)
drop=c("R_C05D00Q3", "C05D00Q18")
C05 = C05[,!(names(C05) %in% drop)]
calAlpha_indv(C05, constructs, 10)

C06D01 <- getData(d_results_std, inc=11)
drop = c("R_C06D01Q13","C06D01Q8")
C06D01 = C06D01[,!(names(C06D01) %in% drop)]
calAlpha_indv(C06D01, constructs, 11)

C07 <- getData(d_results_std, inc=12)
drop=c("C07D00Q13", "C07D00Q14")
C07 = C07[,!(names(C07) %in% drop)]
calAlpha_indv(C07, constructs, 12)

C08 <- getData(d_results_std, inc=13)
drop=c("R_C08D00Q10")
C08 = C08[,!(names(C08) %in% drop)]
calAlpha_indv(C08, constructs, 13)

C09 <- getData(d_results_std, inc=14)
drop = c("C09D00Q5","C09D00Q3","R_C09D00Q9")
C09 = C09[,!(names(C09) %in% drop)]
calAlpha_indv(C09, constructs, 14)

C10 <- getData(d_results_std, inc=15)
drop = c("C10D00Q1", "C10D00Q10")
C10 = C10[,!(names(C10) %in% drop)]
calAlpha_indv(C10, constructs, 15)

C11D01 <- getData(d_results_std, inc=16)
C11D02 <- getData(d_results_std, inc=17)
C11 <- cbind(C11D01, C11D02)
drop = c("C11D01Q6", "C11D02Q1", "C11D02Q3", "C11D02Q8")
C11 = C11[,!(names(C11) %in% drop)]
calAlpha_indv(C11, constructs, 16)

C12 <- getData(d_results_std, inc=18)
drop = c("C12D00Q8", "R_C12D00Q6")
C12 = C12[,!(names(C12) %in% drop)]
calAlpha_indv(C12, constructs, 18)

C13 <- getData(d_results_std, inc=19)
drop = c("C13D00Q7")
C13 = C13[,!(names(C13) %in% drop)]
calAlpha_indv(C13, constructs, 19)

C14 <- getData(d_results_std, inc=20)
drop = c( "C14D00Q15")
C14 = C14[,!(names(C14) %in% drop)]
calAlpha_indv(C14, constructs, 20)

C15 <- getData(d_results_std, inc=21)
drop = c("C15D00Q8", "C15D00Q12")
C15 = C15[,!(names(C15) %in% drop)]
calAlpha_indv(C15, constructs, 21)

C16 <- getData(d_results_std, inc=22)
drop = c("C16D00Q11", "C16D00Q16")
C16 = C16[,!(names(C16) %in% drop)]
calAlpha_indv(C16, constructs, 22)

C17 <- getData(d_results_std, inc=23)
drop = c("C17D00Q8")
C17 = C17[,!(names(C17) %in% drop)]
calAlpha_indv(C17, constructs, 23)

C18D01 <- getData(d_results_std, inc=24)
calAlpha_indv(C18D01, constructs, 24) 

C18D03 <- getData(d_results_std, inc=25)
drop = c("C18D03Q9")
C18D03 = C18D03[,!(names(C18D03) %in% drop)]
calAlpha_indv(C18D03, constructs, 25) 

C19 <- getData(d_results_std, inc=26)
drop = c("C19D00Q3")
C19 = C19[,!(names(C19) %in% drop)]
calAlpha_indv(C19, constructs, 26)