import numpy
from numpy import genfromtxt
from scipy import stats
from scipy.stats import mstats

# This file calculates the Pearson Correlation Coefficient with its corresponding P-Value
# Please note! This function assumes to have two continuous data variables This function has not been used, it was
# solely for the purpose to show that both the phi coefficient and point-biserial coefficient result into the same value
if __name__ == '__main__':

    # Obtain the data stored in comma seperated file
    file = open('data1.csv', encoding="utf8")
    data1 = genfromtxt(file, delimiter=',')

    # Obtain the other data also stored in comma seperated file
    file = open('data2.csv', encoding="utf8")
    data2 = genfromtxt(file, delimiter=',')

    # Use Python Scipy function to calculate Pearson Correlation Coefficient and P-Value
    # result = mstats.pearsonr(data1, data2)
    result = stats.spearmanr(data1, data2)
    # Display Pearson Correlation Coefficient
    print("r_s:")
    print(result[0])
    # Display P-Value
    print("p-value:")
    print(result[1])