from numpy import genfromtxt
from sklearn.metrics import matthews_corrcoef
from scipy.stats import mstats

# This file calculates the Phi Coefficient with its corresponding P-Value
# Please note! This function assumes to have two binary data variables
if __name__ == '__main__':

    # Obtain the data stored in comma seperated file
    file = open('data1.csv', encoding="utf8")
    data1 = genfromtxt(file, delimiter=',')

    # Obtain the other data also stored in comma seperated file
    file = open('data2.csv', encoding="utf8")
    data2 = genfromtxt(file, delimiter=',')

    # Use Python Sklearn function to calculate Phi Coefficient
    res = matthews_corrcoef(data1, data2)
    # Use Python Scipy function to calculate P-Value
    p_res = mstats.pearsonr(data1, data2)
    # Display Phi Coefficient
    print("Phi-Coefficient :")
    print(res)
    # Display P-Value
    print("p-value:")
    print(p_res[1])
