import numpy as np
import matplotlib.pyplot as plt

if __name__ == '__main__':

    # Labels of the vertical axis
    v_ax = ["Rating"]
    # Labels of the horizontal axis
    h_ax = ["Young Adults", "Middle-Aged Adults", "Older Adults"]

    # Array storing the values
    data = np.array([[0.07, -0.07, -0.00]])
    fig, ax = plt.subplots()
    im = ax.imshow(data)

    # Display the colorbar horizonatally at the top
    # plt.colorbar(im, orientation='horizontal', location='top')

    # Display the colorbar horizonatally at the top shrinked to appropriate size and rescaled (used when 2 coefficients)
    # plt.colorbar(im, orientation='horizontal', location='top', fraction=0.7, shrink=0.3)

    # Display the colorbar horizonatally at the top shrinked to appropriate size and rescaled (used when 3 coefficients)
    plt.colorbar(im, orientation='horizontal', location='top', fraction=0.7, shrink=0.4)

    # Display the colorbar horizonatally at the top shrinked to appropriate size and rescaled (used when 3 by 3)
    # plt.colorbar(im, orientation='horizontal', location='top', shrink=0.6)

    # Show all ticks and label them with the respective list entries
    ax.set_xticks(np.arange(len(h_ax)), labels=h_ax)
    ax.set_yticks(np.arange(len(v_ax)), labels=v_ax)
    #     ax = sns.heatmap(arr, annot=True, cbar_kws={"orientation": "horizontal"}, cmap="YlGnBu", vmin=-0.3, vmax=0.3)

    # Rotate the tick labels and set their alignment.
    # plt.setp(ax.get_xticklabels(), rotation=45, ha="right",rotation_mode="anchor")
    plt.setp(ax.get_xticklabels(), rotation=45, ha="right",rotation_mode="anchor")

    # Loop over data dimensions and create text annotations.
    for i in range(len(v_ax)):
        for j in range(len(h_ax)):
            text = ax.text(j, i, data[i, j],
                           ha="center", va="center", color="w")

    # Title of the heatmap
    # ax.set_title('Impersonal correlated to Relation')


    # Set the range of the colorbar
    im.set_clim(vmin=-0.3, vmax=0.3)

    # Uncomment this line when you would like to save locally a copy of the heatmap
    # plt.savefig("heatmap_Imp_Rel.png")

    fig.tight_layout()
    plt.show()