import numpy
import numpy as np
from numpy import genfromtxt, transpose, loadtxt
from sklearn.metrics import cohen_kappa_score

if __name__ == '__main__':
    file = open('My_Encoding.csv', encoding="utf8")
    my_data = genfromtxt(file, delimiter=';')
    my_data_trimmed = []
    # trim away text codes, only leaving hot-one encodings.
    # Every row is a response
    print(my_data)
    for response in my_data[1:]:
        my_data_trimmed.append(response[10:])
    my_data_trimmed = transpose(my_data_trimmed)

    file = open('Second_Encoding.csv', encoding="utf8")
    second_data = genfromtxt(file, delimiter=';')
    text = loadtxt(file, delimiter=';')
    second_data_trimmed = []
    # trim away text codes, only leaving hot-one encodings.
    # Every row is a response
    for response in second_data[1:]:
        second_data_trimmed.append(response[10:])
    second_data_trimmed = transpose(second_data_trimmed)
    results = []
    for i in range(len(second_data_trimmed)):
        results.append(round(cohen_kappa_score(my_data_trimmed[i], second_data_trimmed[i]), 2))
    print(results)
