# 1. GENERAL INFORMATION

## 1.1 Title of Dataset
CRiSp geospatial data on urban river spaces

## 1.2 Dataset description
Geospatial data on urban river spaces used in CRiSp (City River Spaces)
software and related packages. Contains vector data of the city boundary,
spatial networks (street center lines, railway lines), the river (center
line and surface), buildings surrounding the river, as well as a digital
elevation model for River Dâmbovița in Bucharest. The dataset is derived
from OpenStreetMap data (https://www.openstreetmap.org/copyright) and
Copernicus GLO-30 DEM data
(https://dataspace.copernicus.eu/explore-data/data-collections/copernicus-contributing-missions/collections-description/COP-DEM)
and made available under the ODbL 1.0 open database license.

## 1.3 Author Information
A. Principal Investigator
- Name: Claudiu Forgaci
  - Institution: Faculty of Architecture and the Built Environment,
                 Department of Urbanism,
                 Delft University of Technology
  - Email: c.forgaci@tudelft.nl

  B. Associate or Co-investigator
- Name: Francesco Nattino
  - Institution: Netherlands eScience Center
  - Email: f.nattino@esciencecenter.nl

## 1.4 Dates of data collection
2025

## 1.5 Geographic location of data collection
Bucharest, Romania

## 1.6 Keywords
urban rivers, example data, geospatial data, OpenStreetMap,
Digital Elevation Model

## 1.7 Language
English

## 1.8 Information about funding sources that supported the collection of the data
This research project was funded by the Netherlands eScience Center

# 2. METHODOLOGICAL INFORMATION
## 2.1 Research questions, methods and envisioned uses
The dataset is meant to be used in user and developer documentation of the
CRiSp software.

## 2.2 Methods for processing the data
The data was generated using the CRiSp software

## 2.3 Instrument- or software-specific information
R version 4.4.2 was used to generate the dataset

# 3. FILE OVERVIEW
Are there multiple versions of the dataset? No

- "bucharest_osm.gpkg": vector layers derived from OpenStreetMap data
- "bucharest_dem.tiff": raster data derived from Copernicus GLO-30 DEM data

## 3.2 Relationship between files:
Geospatial data in both files is provided in the same coordinate reference
system (CRS): UTM zone 35N, EPSG:32635

## 3.3 File formats and naming conventions
### 3.3.1 File formats
- GPKG - Geopackage
- TIFF - Geotiff

### 3.3.2 Naming conventions
- files named lower case, spaces replaced with underscore (snake-case)

# 4. DATA-SPECIFIC INFORMATION

## 4.1 bucharest_osm.gpkg
1. Number of layers: 8

2. List of layers:

"boundary"
- Description: Bucharest city boundary

"river_centerline"
- Description: The center line of River Dâmbovița

"river_suface"
- Description: The surface of River Dâmbovița

"aoi_network"
- Description: The area of interest to clip the street network

"streets"
- Description: Street center lines in Bucharest, including information about
               the type of streets namely motorway, primary, secondary, and
               tertiary roads

"railways"
- Description: Railway lines in Bucharest

"aoi_buildings"
- Description: The area of interest to clip the buildings

"buildings"
- Description: Buildings along river Dâmbovița

Total file size: 3.5 MB

## 4.2 bucharest_dem.tiff
- Description: 30-meter resolution Digital Elevation Model (DEM) of the area
  inlcuding the river Dâmbovița within Bucharest
  
Total file size: 4.7 MB

# 5. SHARING/ACCESS INFORMATION
## 5.1 Licenses/restrictions placed on the data:
The dataset is licensed under the Open Database License (ODbL) 1.0

## 5.2 Links to other resources:

### 5.2.1 Links to publications that cite or use the data:
N/A

### 5.2.2 Links to other publicly accessible locations of the data:
N/A

### 5.2.3 Links/relationships to ancillary data sets:
N/A

### 5.2.4 Links to publicly accessible scripts for analysis of the dataset:
https://github.com/CityRiverSpaces/CRiSpExampleData

### 5.2.5 Was data derived from another source?
Yes

## 5.3 Recommended citation for this dataset:
Forgaci, C., & Nattino, F. (2025). CRiSp geospatial data on urban river spaces [Dataset].
