function [mycolormap] = custom_colormap(N,colorB,colorR)
% Make a custom colormap with a gradual scale between 2 colors, with white in the middle.

if nargin==1
    colorB = [0 0 1];
    colorR = [1 0 0];
elseif nargin~=3
    error('Number of input arguments should be either 1 or 3.');
end

% up = linspace(0,1,N+1).';
% down = flipud(up);

% scaleB_base = ones(N,3);
% scaleR_base = ones(N,3);
% for i=1:N
%     scaleB_base(i,:) = scaleB_base(i,:).*colorB;
%     scaleR_base(i,:) = scaleR_base(i,:).*colorR;
% end

% scaleB = [up(1:end-1) up(1:end-1) up(1:end-1)].*scaleB_base;
% scaleR = [down(2:end) down(2:end) down(2:end)].*scaleR_base;

scaleB = [linspace(colorB(1),1,N+1).' linspace(colorB(2),1,N+1).' linspace(colorB(3),1,N+1).'];
scaleR = flipud([linspace(colorR(1),1,N+1).' linspace(colorR(2),1,N+1).' linspace(colorR(3),1,N+1).']);

% scaleB = [up(1:end-1) up(1:end-1) ones(N,1)];
% scaleR = [ones(N,1) down(2:end) down(2:end)];

mycolormap = [scaleB(1:end-1,:); [1 1 1]; scaleR(2:end,:)];

end