%calculate curvature of river axis
%motified from Timo:
%W:\ESG\DOW_HWM\Backup\EnvironmentalFluidMechanics\SjoukjedeLange\W-schijf_PhD\Data_others\Timo_Langsdammenpaper2019\Dataset
%files (43.7 GB)\data\RF1_scripts\curvature_from_line_20190219.m

% script to calculate arc radius and curvature of river trajectory 

%lower fraser river

%%
BasePath = ['M:\PhDSjoukje\ProjectWaal\RiverCurvature'];
Path1= 'M:\PhDSjoukje\Data_analysis\MBES\curvilinear_cartesian';

cd (BasePath)
addpath(Path1)

%%%%%% INPUT VARIABLES %%%%%%%%%%%%%

range = 300;
load ('W:\ESG\DOW_HWM\Backup\EnvironmentalFluidMechanics\SjoukjedeLange\W-schijf_PhD\Data_others\RijkswaterstaatWaal\NEWNEW\centralaxis.mat')

X_data = Shp(:,1);
Y_data = Shp(:,2);

%% calculations
W = NaN(size(X_data));
Xmid = NaN(size(X_data));
Ymid = NaN(size(X_data));

for i=range/2+1:size(X_data)-range/2
    W(i) = sqrt( (X_data(i-range/2)-X_data(i+range/2))^2 + (Y_data(i-range/2)-Y_data(i+range/2))^2 );
    Xmid(i) = (X_data(i-range/2)+X_data(i+range/2))/2;
    Ymid(i) = (Y_data(i-range/2)+Y_data(i+range/2))/2;
end
H = sqrt( (X_data-Xmid).^2 + (Y_data-Ymid).^2 );

r = W.^2./(8*H) + H/2; % according to the intersecting chords theorem
alpha = 1./r; % calculate curvature from radius

alphaOrg = alpha;

for i=1:size(X_data)
    if Y_data(i) > Ymid(i)
        alpha(i) = -alpha(i); % here the definition of positive/negative curvature is fixed; for Waal: negative if the river bends to the left in the downstream direction (so negative curvature means point bar top at southern river bank)
    end
end

alphaMean = movingmean(alpha,range+1,[],2);
alpha = sign(alphaMean).*alphaOrg;

c_extreme = max(abs(max(alpha)),abs(min(alpha)));

%% calculate curvature in KP
[S, N] = xy2sn (Shp(:,1), Shp(:,2), Shp(:,1), Shp(:,2));

%KP = -0.0010151*S0 + 952.4734
KP = -0.0010151*S + 952.4734;


curvature(:,1) = KP;
curvature(:,2) = X_data;
curvature(:,3) = Y_data;
curvature(:,4) = alpha;

%% curvature per KP
%averaged over 1km, KP+/- 500m

%find s value closest to KP
for i = 1:size(KPSNXYW, 1)
[~, idxN(i)] = min(abs(KPSNXYW.KP(i)+0.5 - curvature(:,1)));
[~, idxS(i)] = min(abs(KPSNXYW.KP(i)-0.5 - curvature(:,1)));

curvKP(i) = nanmean(curvature(idxN(i):idxS(i), 4));
end

plot (KPSNXYW.KP, curvKP)

%saved as RiverCurvatureKP.mat and RiverCurvature.mat in  M:\PhDSjoukje\ProjectWaal\RiverCurvature
%% visualisation
c_extreme = max(abs(max(curvature(:,4))),abs(min(curvature(:,4))));


%%%%%%%%curvature in colorbar
figure(), 
subplot (4,1,1), hold on,
scatter(curvature(:,2),curvature(:,3),[],curvature(:,4),'.');
colormap(custom_colormap(50));
colorbar ('eastoutside')
caxis([-c_extreme c_extreme]);
axis equal
scatter (KPSNXYW.X(4:10:end), KPSNXYW.Y(4:10:end), 5, 'k', 'filled')
text (KPSNXYW.X(4:10:end), KPSNXYW.Y(4:10:end)-3000, num2str(KPSNXYW.KP(4:10:end)))
xlabel ('x-coordinate'); ylabel ('y-coordinate')

%%%%%%%curvature per KP
subplot (4,1,2)
plot (curvature(:,1), curvature(:,4), 'k')
xlim ([curvature(end, 1), curvature(1,1)])
yline (0, ':k')
% ylabel ('river curvature (km^-^1)'); xlabel ('river kilometer')
ylabel ('r (km^-^1)'); xlabel ('river kilometer')

ax = gca;
ax.YAxis(1).Color = 'k';
xlim ([KP(end), KP(1)])
x = [873 876 876 873]; y = [-1 -1 9 9]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
xlim ([KP(end), KP(1)]); ylim ([-1*10^-3 1*10^-3]);

subplot (4,1,3)
cursm = smooth(abs(curvature(:,4)), 1000);
plot (curvature(:,1), cursm, 'k')
% ylabel ('absolute river curvature (km^-^1)'); xlabel ('river kilometer')
ylabel ('abs(r) (km^-^1)'); xlabel ('river kilometer')

x = [873 876 876 873]; y = [0 0 9 9]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
xlim ([KP(end), KP(1)]); ylim ([0 6*10^-4]);

subplot (4,1,4), hold on,
yyaxis left
plot (KPSNXYW.KP, KPSNXYW.W, 'k')
plot (KPSNXYW.KP, KPSNXYW.WLTD, ':k')
xlim ([KP(end), KP(1)])
% ylabel ('river width (m)'); xlabel ('river kilometer')
ylabel ('W (m)'); xlabel ('river kilometer')

ax = gca;
ax.YAxis(1).Color = 'k';
yyaxis right
% for i = 1:length(Waal_char)
i=1;
plot (KPSNXYW.KP, Waal_char{i}.CrossSection);
plot (KPSNXYW.KP, Waal_char{i}.CrossSectionLTD, ':')
% end
% ylabel ('cross-sectional area (m^2)')
ylabel ('A (m^2)')

% legend (kk(3:5))
x = [873 876 876 873]; y = [0 0 2000 2000]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.2, 'LineStyle', 'none')
xlim ([KP(end), KP(1)]); ylim ([1000 2000]);


