%BTT for Waal data
%combined script of RunBTT_Sjoukje and rutBTT_testScriptKris


%loop for xyz_grid data Timo
% BM114, 116 and 147



    
    
%% load data

basePath = 'M:\PhDSjoukje\ProjectWaal\BTT\'; 
Path2 = ['W:\ESG\DOW_HWM\Backup\EnvironmentalFluidMechanics\SjoukjedeLange\W-schijf_PhD\Data_others\RijkswaterstaatWaal\xyz_grid' ]; %path of BMs
Path3 = [basePath 'transect2btt2dunechar']; %BTT

Path4 = [' W:\ESG\DOW_HWM\Backup\EnvironmentalFluidMechanics\SjoukjedeLange\W-schijf_PhD\Data_others\RijkswaterstaatWaal\xyz_grid']; %output P0 preprocessing

cd(Path2); 
addpath(Path2);
addpath(Path3);
addpath(Path4);

Ps = load ('Ps2_xyzgrid.mat'); %P0 values per km
Ps2 = Ps.Ps2; clear Ps
load 'M:\PhDSjoukje\ProjectWaal\KPSNXYW.mat' %KP values and coordinates
load 'M:\PhDSjoukje\ProjectWaal\Verhanglijnen RWS\verhanglijnen_matlab\Stations.mat' %location of waterlevel stations

shp = shaperead('M:\PhDSjoukje\ProjectWaal\ArcMap\aslijn_Waal_extended.shp'); %see script extend_centerline.m
shp.X = shp.X(~isnan(shp.X)); %delete NaN values and sort shapefile
shp.Y = shp.Y(~isnan(shp.Y));
Shp1(:,1) = shp.X; Shp1(:,2) = shp.Y;
Shp = sortrows(Shp1, [1 2]);
clear shp Shp1

profilesfolder = ['W:\ESG\DOW_HWM\Backup\EnvironmentalFluidMechanics\SjoukjedeLange\W-schijf_PhD\Data_others\RijkswaterstaatWaal\xyz_grid\' ];
numBMs = [114 116 147];
for i = 1:length(numBMs)
    numBM = numBMs(i);
    foldername = ['BM_',num2str(numBM,'%03d')];
    cd([profilesfolder,foldername]);
    bm = load(['lijnen_',foldername,'.mat']);
    BM{i} = bm.lijn{1,2}.data; %s = 3, z=5
end
    clear bm numBM
    
    
%% preprocessing
%remove wrong values
 for i = 1:length(BM)
     idx = BM{i}(:,5) > 100;
     BM{i}(idx,:) = NaN;
 end
    
%add KP
for i = 2:3 %1:length(BM)
Bm{i}(:,1) = BM{i}(~isnan(BM{i}(:,1)),1);
Bm{i}(:,2) = BM{i}(~isnan(BM{i}(:,1)),2);
Bm{i}(:,3) = BM{i}(~isnan(BM{i}(:,1)),5);

[SBM, NBM] = xy2sn(Shp(:,1),Shp(:,2), Bm{i}(:,1), Bm{i}(:,2));
KPbm = -0.0010151* SBM + 952.4734;


Bm{i}(:,4) = SBM;
Bm{i}(:,5) = NBM;
Bm{i}(:,6) = KPbm;
clear SBM NBM KPbm
end

%Bm 1:x, 2:y, 3:z, 4:s, 5:n, 6:kp




%% input parameters
limH = 0.1; %if H smaller than 0.1 --> ripples (criterium Yalin1964 says L=1000D --> Lripples = ~1m)
limL = 200; %if L larger than 200 m -->bars
limdens = 5; %if density smaller than 5 dunes per km --> flat bed 


%% divide data in parts of 1km (based of KP)
%divide into sections per KP (river kilometer)
i=1;
L = floor (min(Bm{i}(:,6))):1:ceil(max(Bm{i}(:,6)));
nr_sect= max(L) - min(L); %amount of profiles
KPdune = min(L):(max(L)-1); %length of profiles

for n = 1:length(Bm)
    for i = 1:nr_sect+1
       [~,idxE(i)]=min(abs(Bm{n}(:,6)-L(1,i))); %end point 
    end
%     idx = flip(idxE);
    for i = 1:nr_sect
           % save all data in the right section
        for k = 1:size(Bm{n}, 2)
            BM_sect{n}{i}(:,k)= Bm{n}(idxE(i):idxE(i+1),k);
        end
    end
end

clearidxE idx i k

% linetest_sect = flip(linetest_sect); %linetest_sect{1} corresponded with KPSNXYW.KP(95) --> now flipped
figure(), plot (BM_sect{3}{40}(:,6), BM_sect{3}{40}(:,3))

%% run BTT for long bedforms
%Po corresponding to Ps2(4) (100m long bedforms) --> apDetrend in Moving Mean
%EstBL estemated bedform length set to 100m as well in Find Crossings

EstBFL = 100;
BLint = 4; %1 or 4 --> bedform lenght of interest. 1: 5m, 2: 20m, 3:50, 4:100m;

output_long= [];
nums = [];

for n = 1:length(BM_sect)
for i = 1:length(BM_sect{n}) %num_sections
    try

   x_tot = flipud(BM_sect{n}{i}(:,6)*1000);
   x = sortrows(x_tot(1:end));
   z_tot = BM_sect{n}{i}(:,3);
   z = z_tot;
   [x,z] = replaceoutliers(x,z,x(1),x(end));
   close all
   apDetrend = Ps2{n}(i,BLint); %there are NaN values in Ps2, therefore:
   if BLint ==4 %if BLint == 1, take maximum value possible
        if any(isnan(apDetrend), 'all')
             apDetrend = max(Ps2{n}(i,:));
        end    
   else %if BLint == 1, take minimum value possible
           if any(isnan(apDetrend), 'all')
                apDetrend = min(Ps2{n}(i,:));
           end   
   end
   
   Stats_long{n}{i} = BDT_Rolien_editKris(x, z, apDetrend, EstBFL, 0); %fourth input is figure switch, 0 = off.
 
    catch 
        nums(end+1) = i;
    end 
end
end

fprintf('Inconsistent data in');
disp(nums);

%% run BTT for short bedforms 
%P0 corresponding to Ps2(1) (5m long bedforms) --> apDetrend in Moving Mean
%EstBL estemated bedform length set to 5m as well in Find Crossings
EstBLF = 5;
BLint = 1; %1 or 4 --> bedform lenght of interest. 1: 5m, 2: 20m, 3:50, 4:100m;

output_short= [];
nums = [];


for n = 1:length(BM_sect)
for i = 1:length(BM_sect{n}) %num_sections
    try

   x_tot = flipud(BM_sect{n}{i}(:,6)*1000);
   x = sortrows(x_tot(1:end));
   z_tot = BM_sect{n}{i}(:,3);
   z = z_tot;
   [x,z] = replaceoutliers(x,z,x(1),x(end));
   close all
   apDetrend = Ps2{n}(i,BLint); %there are NaN values in Ps2, therefore:
   if BLint ==4 %if BLint == 1, take maximum value possible
        if any(isnan(apDetrend), 'all')
             apDetrend = max(Ps2{n}(i,:));
        end    
   else %if BLint == 1, take minimum value possible
           if any(isnan(apDetrend), 'all')
                apDetrend = min(Ps2{n}(i,:));
           end   
   end
   
   Stats_short{n}{i} = BDT_Rolien_editKris(x, z, apDetrend, EstBFL, 0); %fourth input is figure switch, 0 = off.
 
    catch 
        nums(end+1) = i;
    end 
end
end

fprintf('Inconsistent data in');
disp(nums);





%% calculations and save output for Long bedforms
for n = 1:length(Stats_long)
for i = 1:length(Stats_long{n})
    %if ripples (H<0.05)--> excluded
    idxh = find (Stats_long{n}{i}.Htotr < limH);
    H = Stats_long{n}{i}.Htotr;
    H(idxh)=[]; 
    output_long{n}(i,1)= mean(H);
    output_long{n}(i,2)= std(H); 
    
    %if bars (L>200m)--> excluded
    Lg = Stats_long{n}{i}.Ltops;
    idx = find (Lg > limL);
    Lg(idx)=[]; clear idx
    
    output_long{n}(i,3)= nanmean(Lg);
    output_long{n}(i,4)= std(Lg);
    
    %inv tanges, from rad to deg
    output_long{n}(i,5)= mean(rad2deg(atan((Stats_long{n}{i}.slope_l)))); 
    output_long{n}(i,6)= std(rad2deg(atan((Stats_long{n}{i}.slope_l))));
    output_long{n}(i,7)= mean(rad2deg(atan((Stats_long{n}{i}.slope_s))));
    output_long{n}(i,8)= std(rad2deg(atan((Stats_long{n}{i}.slope_s))));
end
end
clear x z idx
    
%%%%%%%calculations
%bedform density
dens = {};
for n  = 1:length(Stats_long)
    for i = 1:length(BM_sect{n})
    dens{n}(i) = length(Stats_long{n}{i}.Htotr)/(BM_sect{n}{i}(end,6)-BM_sect{n}{i}(1,6));
    end
output_long {n}(:,9) = dens{n};
end

% %minimal values

% limdens = 5;%if bedform density <5: no bedforms but bars --> put NaN
% idx = find(dens < limdens);
% KPnodune(idx) = NaN;
% clear idx

for n = 1:length(output_long)
    KPnodune{n} = KPdune;
    %delete values where H is removed due to threshold in previous section
    idx = find(isnan(output_long{n}(:,1)));
    KPnodune{n}(idx) = NaN;
    %delete values where H is removed due to threshold in previous section
    idx = find(isnan(output_long{n}(:,3)));
    KPnodune{n}(idx) = NaN;
end


%% calculations and save output for short bedforms
for n = 1:length(Stats_short)
for i = 1:length(Stats_short{n})
    try
    %if ripples (H<0.05)--> excluded %%%not for short bedforms
%     idxh{i} = find (Stats_short{i}.Htotr < limH);
    H = Stats_short{n}{i}.Htotr;
%     H{i}(idxh{i})=[]; 
    output_short{n}(i,1)= mean(H);
    output_short{n}(i,2)= std(H); 
    
    %if bars (L>200m)--> excluded %%%not for short bedforms
    Lg = Stats_short{n}{i}.Ltops;
%     idx{i} = find (Lg{i} > limL);
%     Lg{i}(idx{i})=[]; clear idx
    
    output_short{n}(i,3)= nanmean(Lg);
    output_short{n}(i,4)= std(Lg);
    
    %inv tanges, from rad to deg
    output_short{n}(i,5)= mean(rad2deg(atan((Stats_short{n}{i}.slope_l)))); 
    output_short{n}(i,6)= std(rad2deg(atan((Stats_short{n}{i}.slope_l))));
    output_short{n}(i,7)= mean(rad2deg(atan((Stats_short{n}{i}.slope_s))));
    output_short{n}(i,8)= std(rad2deg(atan((Stats_short{n}{i}.slope_s))));
    catch
    end
end
end
clear x z idx
    
% %%%%%%%%%%% calculations
%bedform density
dens_short = {};
for n  = 1:length(Stats_short)
    for i = 1:length(BM_sect{n})
        if n == 1 && i == 4 %inconsistend data, no value of Stats
            continue
        end
    dens_short{n}(i) = length(Stats_short{n}{i}.Htotr)/(BM_sect{n}{i}(end,6)-BM_sect{n}{i}(1,6));
    end
output_short {n}(:,9) = dens_short{n};
end

% %minimal values
% limdens = 5;%if bedform density <5: no bedforms but bars --> put NaN
% idx = find(dens < limdens);
% KPnodune = KPdune;
% KPnodune(idx) = NaN;
% clear idx
% 
% %delete values where H is removed due to threshold in previous section
% idx = find(isnan(output_long(:,1)));
% KPnodune(idx) = NaN;
% %delete values where H is removed due to threshold in previous section
% idx = find(isnan(output_long(:,3)));
% KPnodune(idx) = NaN;


%% figure LONG bedform characteristics over space
%%%add: if H < 0.1 or L < 10, no bedforms 
basevalue = -1; 
figure(), 
col = ['k' , 'r', 'g'];
%bedform density
subplot (4,1,1), hold on,
for n = 1:length(output_long)
% scatter (KPdune, output_long{n}(:,9), 2, 'filled')
plot (KPdune, output_long{n}(:,9), col(n))
k = num2str(round(WSSLV.discharge(n)));
kk{n} = strcat('Qtiel = ', k , 'm^3/s');
end
for i = 1:length(Stations.KP)
xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
legend off
end
xlim ([KPdune(1) KPdune(end)]); ylim ([0 60]);
x = [873 876 876 873]; y = [-0.2 -0.2 200 200]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
yline (limdens, ':')
ylabel ('bedform density')
legend (kk)

%bedform height
subplot (4,1,2), hold on,
% x = KPnodune; 
% yv = output_long(:,1); yv(isnan(x)) = 0.001;
% st = output_long(:,2); st(isnan(x))=0.001;
% y2 = yv+st; y1 = yv-st;
% area (KPdune, y2, basevalue, 'FaceColor',  [.7 .7 .7], 'linestyle', 'none')
% area (KPdune, y1, basevalue, 'FaceColor',  [1 1 1], 'linestyle', 'none')
% errorbar (KPdune, output(:,1), output(:,2), 'b')
% scatter (KPnodune, output_long(:,1), 2, 'k', 'filled')
for n = 1:length(output_long)
plot (KPnodune{n}, output_long{n}(:,1), col(n))
end
xlabel ('river kilometer'); ylabel ('mean bedform height (m)')
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([KPdune(1) KPdune(end)]); ylim ([0 1.4]);
x = [873 876 876 873]; y = [-0.2 -0.2 200 200]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')

%bedform length
subplot (4,1,3), hold on,
% x = KPnodune; 
% yv = output_long(:,3); yv(isnan(x)) = 0.001;
% st = output_long(:,4); st(isnan(x))=0.001;
% y2 = yv+st; y1 = yv-st;
% area (KPdune, y2, basevalue, 'FaceColor',  [.7 .7 .7], 'linestyle', 'none')
% area (KPdune, y1, basevalue, 'FaceColor',  [1 1 1], 'linestyle', 'none')
% errorbar (KPdune, output(:,3), output(:,4), 'b')
% scatter (KPnodune, output_long(:,3), 2, 'k', 'filled')
for n  = 1:length(output_long)
plot (KPnodune{n}, output_long{n}(:,3), col(n))
end
xlabel ('river kilometer'); ylabel ('mean bedform length (m)')
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([KPdune(1) KPdune(end)]); ylim ([-1 120]);
x = [873 876 876 873]; y = [-1 -1 250 250]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')

%leeside angle
subplot (4,1,4), hold on,
% scatter (KPnodune, output_long(:,5), 2, 'k', 'filled')
% scatter (KPnodune, output_long(:,7), 2, 'c', 'filled')
for n = 1:length(output_long)
plot (KPnodune{n}, output_long{n}(:,5), col(n))
plot (KPnodune{n}, output_long{n}(:,7), strcat('-.', col(n)))
end
xlabel ('river kilometer'); ylabel ('angle ()')
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([KPdune(1) KPdune(end)]); ylim ([0 6]);
x = [873 876 876 873]; y = [0 0 200 200]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
legend ('leeside', 'stoss', 'Location', 'northwest')


%% figure SHORT bedform characteristics over space
basevalue = -1; 
figure(), 
col = ['k' , 'r', 'g'];
output_short{1}(4,:) = NaN;
%bedform density
subplot (4,1,1), hold on,
for n = 1:length(output_short)
% scatter (KPdune, output_short{n}(:,9), 2, 'filled')
plot (KPdune, output_short{n}(:,9), col(n))
k = num2str(round(WSSLV.discharge(n)));
kk{n} = strcat('Qtiel = ', k , 'm^3/s');
end
for i = 1:length(Stations.KP)
xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
legend off
end
xlim ([KPdune(1) KPdune(end)]); ylim ([30 150]);
x = [873 876 876 873]; y = [-0.2 -0.2 200 200]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
yline (limdens, ':')
ylabel ('bedform density')
legend (kk)

%bedform height
subplot (4,1,2), hold on,
% x = KPnodune; 
% yv = output_short(:,1); yv(isnan(x)) = 0.001;
% st = output_short(:,2); st(isnan(x))=0.001;
% y2 = yv+st; y1 = yv-st;
% area (KPdune, y2, basevalue, 'FaceColor',  [.7 .7 .7], 'linestyle', 'none')
% area (KPdune, y1, basevalue, 'FaceColor',  [1 1 1], 'linestyle', 'none')
% errorbar (KPdune, output(:,1), output(:,2), 'b')
% scatter (KPnodune, output_short(:,1), 2, 'k', 'filled')
for n = 1:length(output_short)
plot (KPnodune{n}, output_short{n}(:,1), col(n))
end
ylabel ('mean bedform height (m)')
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([KPdune(1) KPdune(end)]); ylim ([0 0.4]);
x = [873 876 876 873]; y = [-0.2 -0.2 200 200]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')

%bedform length
subplot (4,1,3), hold on,
% x = KPnodune; 
% yv = output_short(:,3); yv(isnan(x)) = 0.001;
% st = output_short(:,4); st(isnan(x))=0.001;
% y2 = yv+st; y1 = yv-st;
% area (KPdune, y2, basevalue, 'FaceColor',  [.7 .7 .7], 'linestyle', 'none')
% area (KPdune, y1, basevalue, 'FaceColor',  [1 1 1], 'linestyle', 'none')
% errorbar (KPdune, output(:,3), output(:,4), 'b')
% scatter (KPnodune, output_short(:,3), 2, 'k', 'filled')
for n  = 1:length(output_short)
plot (KPnodune{n}, output_short{n}(:,3), col(n))
end
ylabel ('mean bedform length (m)')
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([KPdune(1) KPdune(end)]); ylim ([-1 30]);
x = [873 876 876 873]; y = [-1 -1 250 250]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')

%leeside angle
subplot (4,1,4), hold on,
% scatter (KPnodune, output_short(:,5), 2, 'k', 'filled')
% scatter (KPnodune, output_short(:,7), 2, 'c', 'filled')
for n = 1:length(output_short)
plot (KPnodune{n}, output_short{n}(:,5), col(n))
plot (KPnodune{n}, output_short{n}(:,7), strcat('-.', col(n)))
end
xlabel ('river kilometer'); ylabel ('angle ()')
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([KPdune(1) KPdune(end)]); ylim ([0 6]);
x = [873 876 876 873]; y = [0 0 200 200]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
legend ('leeside', 'stoss', 'Location', 'northwest')

%% figure BTT procedure
i=40; n = 3;
figure(), hold on, plot(Stats_long{n}{i}.z_det, 'k')
plot (Stats_long{n}{i}.z_filt, 'r')
yline (0)
% scatter (Stats.upcrossX, 'b')


%% figure H,L
figure(), hold on,
for n = 1:length(output_long)
% mz = fitlm (output_long{n}(:,1), output_long{n}(:,3));
% plotAdded (mz)
% mzs = fitlm (output_short{n}(:,1), output_short{n}(:,3));
% plotAdded (mzs)

scatter (output_long{n}(:,1), output_long{n}(:,3), col(n), 'filled');
scatter (output_short{n}(:,1), output_short{n}(:,3), col(n));

end
% scatter (output(:,1), output(:,3), 'filled')
% legend off; 
title ''; 
xlabel ('bedform height (m)'); ylabel ('bedform length (m)'); 
text (0.1, 0.9, strcat('R^2 =', num2str(mz.Rsquared.Ordinary)), 'Units', 'normalized')
text (0.2, 0.9, strcat ('y =', num2str(mz.Estimate), '*x +', num2str(mz.intercept)), 'Units', 'normalized')
