%BTT for Waal data
%combined script of RunBTT_Sjoukje and rutBTT_testScriptKris
%% load data

% basePath = 'M:\PhDSjoukje\ProjectWaal\BTT\'; 
basePath = 'W:\ESG\DOW_HWM\Backup\EnvironmentalFluidMechanics\SjoukjedeLange\W-schijf_PhD\Project Roughness Waal\BTT\';
Path2 = [basePath 'tiff2transect']; %input linetest
% Path2 = [basePath 'tiff2transect\BMs']; %input linetest

Path3 = [basePath 'transect2btt2dunechar']; %BTT
Path4 = [basePath 'transect2btt2dunechar\Output\BM131']; %output P0 preprocessing
cd(basePath); 
addpath(Path2);
addpath(Path3);
addpath(Path4);

load 'linetest' %central line of 131
load 'Ps2.mat' %P0 values per km
load 'M:\PhDSjoukje\ProjectWaal\KPSNXYW.mat' %KP values and coordinates
load 'M:\PhDSjoukje\ProjectWaal\Verhanglijnen RWS\verhanglijnen_matlab\Stations.mat' %location of waterlevel stations


%% input parameters
limH = 0.1; %if H smaller than 0.1 --> ripples (criterium Yalin1964 says L=1000D --> Lripples = ~1m)
limL = 200; %if L larger than 200 m -->bars
limdens = 5; %if density smaller than 5 dunes per km --> flat bed 


% define length of profile in KP
KPdune = KPSNXYW.KP(1:end-1);

%% divide data in parts of 1km (based of KP)
%divide into sections per KP (river kilometer)
L = floor (min(linetest(:,6)):1:ceil(linetest(:,6)));
nr_sect = max(L) - min(L);

for i = 1:nr_sect+1
   [~,idxE(i)]=min(abs(linetest(:,6)-L(1,i))); %end point 
end
idx = flip(idxE);
for i = 1:nr_sect
       % save all data in the right section
    for k = 1:size(linetest, 2)
        linetest_sect{i}(:,k)= linetest(idx(i):idx(i+1),k);
    end
end
clear idxE idx i k

linetest_sect = flip(linetest_sect); %linetest_sect{1} corresponded with KPSNXYW.KP(95) --> now flipped

i=50;
figure(), plot (linetest_sect{i}(:,6), linetest_sect{i}(:,3))
%%attention: linetest_sect{1} is downstream (at highest KP, 952)

%% run BTT for long bedforms
%Po corresponding to Ps2(4) (100m long bedforms) --> apDetrend in Moving Mean
%EstBL estemated bedform length set to 100m as well in Find Crossings
EstBFL = 100;
BLint = 4; %1 or 4 --> bedform lenght of interest. 1: 5m, 2: 20m, 3:50, 4:100m;

output_long= [];
nums = [];

% line130_sect = linetest_sect;
for i = 1:length(line130_sect) %num_sections
    try

   x_tot = flipud(line130_sect{i}(:,6)*1000);
   x = x_tot(1:end);
   z_tot = line130_sect{i}(:,3);
   z = z_tot;
   [x,z] = replaceoutliers(x,z,x(1),x(end));
   close all
   apDetrend = Ps2(i,BLint); %there are NaN values in Ps2, therefore:
   if BLint ==4 %if BLint == 1, take maximum value possible
        if any(isnan(apDetrend), 'all')
             apDetrend = max(Ps2(i,:));
        end    
   else %if BLint == 1, take minimum value possible
           if any(isnan(apDetrend), 'all')
                apDetrend = min(Ps2(i,:));
           end   
   end
   
   Stats_long{i} = BDT_Rolien_editKris(x, z, apDetrend, EstBFL, 1); %fourth input is figure switch, 0 = off.
 
    catch 
        nums(end+1) = i;
    end 
end


fprintf('Inconsistent data in');
disp(nums);

%% run BTT for short bedforms 
%P0 corresponding to Ps2(1) (5m long bedforms) --> apDetrend in Moving Mean
%EstBL estemated bedform length set to 5m as well in Find Crossings
EstBLF = 5;
BLint = 1; %1 or 4 --> bedform lenght of interest. 1: 5m, 2: 20m, 3:50, 4:100m;

output_short= [];
nums = [];

for i = 1:length(line130_sect) %num_sections
    try

   x_tot = flipud(line130_sect{i}(:,6)*1000);
   x = x_tot(1:end);
   z_tot = line130_sect{i}(:,3);
   z = z_tot;
   [x,z] = replaceoutliers(x,z,x(1),x(end));
   close all
   apDetrend = Ps2(i,BLint); %there are NaN values in Ps2, therefore:
   if BLint ==4 %if BLint == 1, take maximum value possible
        if any(isnan(apDetrend), 'all')
             apDetrend = max(Ps2(i,:));
        end    
   else %if BLint == 1, take minimum value possible
           if any(isnan(apDetrend), 'all')
                apDetrend = min(Ps2(i,:));
           end   
   end
   
   Stats_short{i} = BDT_Rolien_editKris(x, z, apDetrend, EstBLF, 0); %fourth input is figure switch, 0 = off.
 
    catch 
        nums(end+1) = i;
    end 
end


fprintf('Inconsistent data in');
disp(nums);



%% calculations and save output for Long bedforms
for i = 1:length(Stats_long)
    %if ripples (H<0.05)--> excluded
    idxh{i} = find (Stats_long{i}.Htotr < limH);
    H{i} = Stats_long{i}.Htotr;
    H{i}(idxh{i})=[]; 
    output_long(i,1)= mean(H{i});
    output_long(i,2)= std(H{i}); 
    
    %if bars (L>200m)--> excluded
    Lg{i} = Stats_long{i}.Ltops;
    idx{i} = find (Lg{i} > limL);
    Lg{i}(idx{i})=[]; clear idx
    
    output_long(i,3)= nanmean(Lg{i});
    output_long(i,4)= std(Lg{i});
    
    %inv tanges, from rad to deg
    output_long(i,5)= mean(rad2deg(atan((Stats_long{i}.slope_l)))); 
    output_long(i,6)= std(rad2deg(atan((Stats_long{i}.slope_l))));
    output_long(i,7)= mean(rad2deg(atan((Stats_long{i}.slope_s))));
    output_long(i,8)= std(rad2deg(atan((Stats_long{i}.slope_s))));
end

clear x z idx
    
%%%%%%%calculations
%bedform density
dens = [];
for i = 1:length(line130_sect)
dens(i) = length(Stats_long{i}.Htotr)/(line130_sect{i}(1,6)-line130_sect{i}(end,6));
end
output_long (:,9) = dens;

%minimal values
limdens = 5;%if bedform density <5: no bedforms but bars --> put NaN
idx = find(dens < limdens);
KPnodune = KPdune;
KPnodune(idx) = NaN;
clear idx

%delete values where H is removed due to threshold in previous section
idx = find(isnan(output_long(:,1)));
KPnodune(idx) = NaN;
%delete values where H is removed due to threshold in previous section
idx = find(isnan(output_long(:,3)));
KPnodune(idx) = NaN;



%% calculations and save output for short bedforms
for i = 1:length(Stats_short)
    %if ripples (H<0.05)--> excluded %%%not for short bedforms
%     idxh{i} = find (Stats_short{i}.Htotr < limH);
    H{i} = Stats_short{i}.Htotr;
%     H{i}(idxh{i})=[]; 
    output_short(i,1)= mean(H{i});
    output_short(i,2)= std(H{i}); 
    
    %if bars (L>200m)--> excluded %%%not for short bedforms
    Lg{i} = Stats_short{i}.Ltops;
%     idx{i} = find (Lg{i} > limL);
%     Lg{i}(idx{i})=[]; clear idx
    
    output_short(i,3)= nanmean(Lg{i});
    output_short(i,4)= std(Lg{i});
    
    %inv tanges, from rad to deg
    output_short(i,5)= mean(rad2deg(atan((Stats_short{i}.slope_l)))); 
    output_short(i,6)= std(rad2deg(atan((Stats_short{i}.slope_l))));
    output_short(i,7)= mean(rad2deg(atan((Stats_short{i}.slope_s))));
    output_short(i,8)= std(rad2deg(atan((Stats_short{i}.slope_s))));
end

clear x z idx
    
% %%%%%%%%%%% calculations
%bedform density
dens_short = [];
for i = 1:length(line130_sect)
dens_short(i) = length(Stats_short{i}.Htotr)/(line130_sect{i}(1,6)-line130_sect{i}(end,6));
end
output_short (:,9) = dens_short;
% 
% %minimal values
% limdens = 5;%if bedform density <5: no bedforms but bars --> put NaN
% idx = find(dens < limdens);
% KPnodune = KPdune;
% KPnodune(idx) = NaN;
% clear idx
% 
% %delete values where H is removed due to threshold in previous section
% idx = find(isnan(output_long(:,1)));
% KPnodune(idx) = NaN;
% %delete values where H is removed due to threshold in previous section
% idx = find(isnan(output_long(:,3)));
% KPnodune(idx) = NaN;


%% figure LONG bedform characteristics over space
%%%add: if H < 0.1 or L < 10, no bedforms 
basevalue = -1; 
figure(), 

%bedform density
subplot (4,1,1), hold on,
scatter (KPdune, dens, 2, 'k', 'filled')
plot (KPdune, dens, 'k')
for i = 1:length(Stations.KP)
xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
legend off
end
xlim ([857 947]); ylim ([0 80]);
x = [873 876 876 873]; y = [-0.2 -0.2 200 200]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
yline (limdens, ':')
ylabel ('bedform density per km')

%bedform height
subplot (4,1,2), hold on,
x = KPnodune; 
yv = output_long(:,1); yv(isnan(x)) = 0.001;
st = output_long(:,2); st(isnan(x))=0.001;
y2 = yv+st; y1 = yv-st;
area (KPdune, y2, basevalue, 'FaceColor',  [.7 .7 .7], 'linestyle', 'none')
area (KPdune, y1, basevalue, 'FaceColor',  [1 1 1], 'linestyle', 'none')
% errorbar (KPdune, output(:,1), output(:,2), 'b')
scatter (KPnodune, output_long(:,1), 2, 'k', 'filled')
plot (KPnodune, output_long(:,1), 'k')
xlabel ('river kilometer'); ylabel ('mean bedform height (m)')
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([857 947]); ylim ([0 2]);
x = [873 876 876 873]; y = [-0.2 -0.2 200 200]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')

%bedform length
subplot (4,1,3), hold on,
x = KPnodune; 
yv = output_long(:,3); yv(isnan(x)) = 0.001;
st = output_long(:,4); st(isnan(x))=0.001;
y2 = yv+st; y1 = yv-st;
area (KPdune, y2, basevalue, 'FaceColor',  [.7 .7 .7], 'linestyle', 'none')
area (KPdune, y1, basevalue, 'FaceColor',  [1 1 1], 'linestyle', 'none')
% errorbar (KPdune, output(:,3), output(:,4), 'b')
scatter (KPnodune, output_long(:,3), 2, 'k', 'filled')
plot (KPnodune, output_long(:,3), 'k')
xlabel ('river kilometer'); ylabel ('mean bedform length (m)')
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([857 947]); ylim ([-1 170]);
x = [873 876 876 873]; y = [-1 -1 250 250]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')

%leeside angle
subplot (4,1,4), hold on,
scatter (KPnodune, output_long(:,5), 2, 'k', 'filled')
scatter (KPnodune, output_long(:,7), 2, 'c', 'filled')
plot (KPnodune, output_long(:,5), 'k')
plot (KPnodune, output_long(:,7), 'c')
xlabel ('river kilometer'); ylabel ('angle ()')
xlim ([857 947]);
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([857 947]); ylim ([0 6]);
x = [873 876 876 873]; y = [0 0 200 200]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
legend ('stoss side', 'leeside', 'Location', 'northwest')


%% figure SHORT bedform characteristics over space
%%%add: if H < 0.1 or L < 10, no bedforms 
basevalue = -1; 
figure(), 

%bedform density
subplot (4,1,1), hold on,
scatter (KPdune, output_short(:,9), 2, 'k', 'filled')
plot (KPdune, output_short(:,9), 'k')
for i = 1:length(Stations.KP)
xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
legend off
end
xlim ([857 947]); ylim ([50 300]);
x = [873 876 876 873]; y = [-0.2 -0.2 300 300]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
yline (limdens, ':')
ylabel ('bedform density per km')

%bedform height
subplot (4,1,2), hold on,
x = KPdune; 
yv = output_short(:,1); yv(isnan(x)) = 0.001;
st = output_short(:,2); st(isnan(x))=0.001;
y2 = yv+st; y1 = yv-st;
area (KPdune, y2, basevalue, 'FaceColor',  [.7 .7 .7], 'linestyle', 'none')
area (KPdune, y1, basevalue, 'FaceColor',  [1 1 1], 'linestyle', 'none')
% errorbar (KPdune, output(:,1), output(:,2), 'b')
scatter (KPdune, output_short(:,1), 2, 'k', 'filled')
plot (KPdune, output_short(:,1), 'k')
xlabel ('river kilometer'); ylabel ('mean bedform height (m)')
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([857 947]); ylim ([0 0.6]);
x = [873 876 876 873]; y = [-0.2 -0.2 200 200]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')

%bedform length
subplot (4,1,3), hold on,
x = KPdune; 
yv = output_short(:,3); yv(isnan(x)) = 0.001;
st = output_short(:,4); st(isnan(x))=0.001;
y2 = yv+st; y1 = yv-st;
area (KPdune, y2, basevalue, 'FaceColor',  [.7 .7 .7], 'linestyle', 'none')
area (KPdune, y1, basevalue, 'FaceColor',  [1 1 1], 'linestyle', 'none')
% errorbar (KPdune, output(:,3), output(:,4), 'b')
scatter (KPdune, output_short(:,3), 2, 'k', 'filled')
plot (KPdune, output_short(:,3), 'k')
xlabel ('river kilometer'); ylabel ('mean bedform length (m)')
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([857 947]); ylim ([-0.1 30]);
x = [873 876 876 873]; y = [-1 -1 250 250]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')

%leeside angle
subplot (4,1,4), hold on,
scatter (KPdune, output_short(:,5), 2, 'k', 'filled')
scatter (KPdune, output_short(:,7), 2, 'c', 'filled')
plot (KPdune, output_short(:,5), 'k')
plot (KPdune, output_short(:,7), 'c')
xlabel ('river kilometer'); ylabel ('angle ()')
xlim ([857 947]);
for i = 1:length(Stations.KP)
% xline(Stations.KP(i), '-.' ,Stations.Station(i),'DisplayName','Stations');
xline(Stations.KP(i), '-.');
legend off
end
xlim ([857 947]); ylim ([0 6]);
x = [873 876 876 873]; y = [0 0 200 200]; %erlecom
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [883 885 885 883]; %Nijmegen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [925 928 928 925]; %st Andries
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
x =  [911 921 921 911]; %langsdammen
patch(x, y, 'k', 'FaceAlpha', 0.1, 'LineStyle', 'none')
legend ('stoss side', 'leeside', 'Location', 'northwest')

%% figure BTT procedure
i=70;
figure(), hold on, plot(Stats_long{i}.z_det, 'k')
plot (Stats_long{i}.z_filt, 'r')
yline (0)
% scatter (Stats.upcrossX, 'b')


figure(), 
scatter (Data131_sect{i}(:,16), Data131_sect{i}(:,13), [], Data131_sect{i}(:,7))

%% figure H,L
figure(), hold on,
mz = fitlm (output_long(:,1), output_long(:,3));
plotAdded (mz)
mzs = fitlm (output_short(:,1), output_short(:,3));
plotAdded (mzs)
% scatter (output(:,1), output(:,3), 'filled')
% legend off; 
title ''; 
xlabel ('bedform height (m)'); ylabel ('bedform length (m)'); 
text (0.1, 0.9, strcat('R^2 =', num2str(mz.Rsquared.Ordinary)), 'Units', 'normalized')
text (0.2, 0.9, strcat ('y =', num2str(mz.Estimate), '*x +', num2str(mz.intercept)), 'Units', 'normalized')
