%% Find appropriate span values (P0)


%for more information: sjoukje.delange@wur.nl
%based on script of Kris van den Berg; kris.vandenberg@wur.nl


%%
Ps = [];
V = [5 20 50 100];                          % length of bedforms 
V_error = [5 10 20 30];                     % margin of error

load ('P0_all_xyzgrid') 
load ('Luni_all_xyzgrid')

for n = 1:length(P0_all)
for i = 1:length(P0_all{n})
%     try 
    % load and prepare data 
%     P0 = load(['P0_',num2str(i,'%03d')]);
%     Luni = load(['Luni',num2str(i,'%03d')]);
%     Luni = cell2mat(struct2cell(Luni));
%     P0 = cell2mat(struct2cell(P0)); 
    P0 = P0_all{n}{i};
    Luni = Luni_all{n}{i};
    for j = 1:length(V)
        % find Luni closest to given lengths
        [minValue,closestIndex] = min(abs(Luni-V(j)));
        closestValue = Luni(closestIndex); 
        
        % calculate upper and lower limit 
        V_up = V(j)+V_error(j);
        V_low = V(j)-V_error(j); 

        % find P0 with index of closest Luni
        if (closestValue>V_low) && (closestValue<V_up)
            P_temp = P0(closestIndex);
            P = P_temp;
            L_temp = closestValue;
        else 
            P = NaN;
            L_temp = 0;
        end 
      
        % write to matrix
        Ps2{n}(i,j) = P; 
        L{n}(i,j) = L_temp;
    end 
%     catch 
    end 
end 
end
% save 
%save('Ps_52050100')