%% Calculate span values (P0)
% aquired in 03-2020 in Bangladesh.
% data from Meghna System (UTM 46N)

% primary input data: xyz 2D DEM 

% 1: remove outliers 
% 2: do spectral density analysis
% 3: calculate unique values and P0
% 4: save figure 
% 5: calculate means within range 

%Sjoukje de Lange
%based on script of Kris van den berg: kris.vandenberg@wur.nl

%%

cd 'M:\PhDSjoukje\ProjectWaal\BTT\transect2btt2dunechar'
% 
% basePath= 'M:\My Documents\Scriptie\';
% Path2 = [basePath 'Scripts\'];          % matlab script
% Path3 = [basePath 'P0_west\'];          % save location
% Path4 = [basePath 'Scripts\BTT\'];      % BTT scripts 
% Path5 = [basePath 'Transect_west\'];    % transects 

% cd(basePath);
% addpath(Path2);
% addpath(Path3);
% addpath(Path4);
% addpath(Path5);

%% 
L_threshold = 3.5;                      % threshold unique values of length
P_threshold = 10;                       % threshold P0 values
P0_all = {};
Luni_all = {};

for i=1:length(linetest_sect) % amount of sections
    try 
        % load data 
%         section = importdata(['SN_section',num2str(i,'%03d'),'.txt']);
        sect = linetest_sect{i};
        section = sortrows (sect, 6);

        x = section(:,6)*1000; %from km to m
        y = section(:,5); z = section(:,3);
        
        % remove outliers
        [x,z] = replaceoutliers(x,z,x(1),x(end));
        close all 
        
        % initialisations 
%         apDetrend = [5:10:95 105:25:1200 1225:250:min(1475,length(x))];
          apDetrend = 1:length(x);


        delta = mean(abs(diff(x)));
        nullijn = []; z_det = []; k = []; S = []; Lpeak = [];
        
        % spectral analysis 
        for j=1:length(apDetrend)
            nullijn(j,:) = movingmean(z,apDetrend(j),[],2,'Hann');
            z_det(j,:) = z' - nullijn(j,:);
            [k(j,:),S(j,:),Lpeak(j,:)] = spectraldensity(x,z_det(j,:),delta);
        end

        % find unique values and P0
        apDetrend2 = apDetrend';
        PindStart = [];
        PindEnd = [];
        Luni = unique(Lpeak);
        n=0;
    
        for j=1:length(Luni)
            if Luni(j)>L_threshold   
                n=n+1;
                PindStart(n) = find(Lpeak==Luni(j),1);
                PindEnd(n) = find(Lpeak==Luni(j),1,'last');
            end
        end
        
        idx = mod(.6*apDetrend2(PindStart)+.4*apDetrend2(PindEnd),2)<1;
        P0 = floor(.6*apDetrend2(PindStart)+.4*apDetrend2(PindEnd));
        P0(idx) = P0(idx)-1;
        P0 = P0(P0>P_threshold);
        Luni = Luni(end-length(P0)+1:end);
        P0_all{i} = P0;
        Luni_all{i} = Luni;

        % plot and save figure 
        name_var_fig = ['M:\PhDSjoukje\ProjectWaal\BTT\transect2btt2dunechar\DetermineP0\fig_',num2str(i,'%03d'),'.fig'];
        name_var_P0 = ['M:\PhDSjoukje\ProjectWaal\BTT\transect2btt2dunechar\DetermineP0\P0_',num2str(i,'%03d'),'.mat'];
        name_var_Luni = ['M:\PhDSjoukje\ProjectWaal\BTT\transect2btt2dunechar\DetermineP0\Luni_',num2str(i,'%03d'),'.mat'];
        
        HF = figure('visible', 'off'); semilogx(apDetrend2,Lpeak,'.-');
        ylabel('Peak bedform length L_{p} (m)');
        xlabel('Span P_{0} (m)');
        grid on; hold on;
        plot(P0, Luni, 'x');
        
        savefig(HF, name_var_fig);
%         save(name_var_Luni, 'Luni');
%         save(name_var_P0, 'P0');
    
    catch
        disp('Inconsistent data in run ');
        disp(i);       
    end 
end 

save('M:\PhDSjoukje\ProjectWaal\BTT\transect2btt2dunechar\DetermineP0', 'Luni_all')
save('M:\PhDSjoukje\ProjectWaal\BTT\transect2btt2dunechar\DetermineP0', 'P0_all')

close all 

