% Rolien van der Mark, 2007

function [MAF] = wmovavrtrend(provoNos,dirread,provoloc);

MAF = [];
tel = 1;
for j = provoNos
    provoNr = num2str(j);
    fileNm=[dirread,'pr',provoNr,'.mat'];
    load(fileNm);
    profielnr = ['pr',provoNr];
    dist2 = eval([profielnr,'.dist2']); 
    provo123 = eval([profielnr,'.provo',num2str(provoloc)]);

    xbegin = eval([profielnr,'.xbegin']); xbegin = xbegin * 100;    % convert to cm
    xend = eval([profielnr,'.xend']); xend = xend * 100;            % convert to cm
    int = find((dist2 >= xbegin) & (dist2 <= xend)); % find interval profile outside testsection
    dist2 = dist2(int);                              % delete everything outside testsection
    provo123 = provo123(int);
    n = length(provo123);
    delt = mean(diff(dist2)); % afstand tussen 2 meetpunten
    
    % run this loop only if not done before, so, only if file does not exist:
    file = [dirread,'ma_pr',num2str(j),'.mat'];
    if exist(file) == 0  % this file does not exist; make and save file

        lengtes = [];
        step = 2;                   %....step must be even and >= 2!
        for ap = 5 : step : n
            w = hann(ap); w = w./sum(w);
            [ytrend] = wmovavr(provo123,ap,w); w=[];
            % throw away disturbed boundaries:
            X = (ap-1)/2; provo2 = provo123;
            % provo2(1:X) = []; ytrend(1:X) = [];
            % provo2(end+1-X:end) = []; ytrend(end+1-X:end) = [];
            % subtract filtered signal from profile
            provo0 = provo2 - ytrend;
            % subtract mean so that fluctuates around zero:
            N = length(provo0);
            provo0 = provo0 - ones(N,1)*mean(provo0);
            % determine Lpeak of detrended signal
            [k,S,Lpeak] = spectraldensity(dist2,provo0,delt);
            % save Lpeak corresponding to span ap
            lengtes = [lengtes; Lpeak ap];
        end

        P = lengtes(:,2); Lp = lengtes(:,1);
        eval(['save ''',file,''' P Lp']);

    elseif exist(file) == 2  % file does exist; load file
        load(file);
    end

    figure (1)
    semilogx(P,Lp,'b.-'); hold on;
    xlabel('P_0');
    ylabel('Lp (cm)');

    Lps = unique(Lp);
    aantalLps = length(Lps);

    AP = []; LPS = [];
    if aantalLps > 0
        for i = 1:aantalLps
            f = find(Lp == Lps(i));

            % check if data is complete
%             ff = diff(f);
%             g = find(ff ~= 1); aantalgaten = length(g);
%             gg = length(f); gg = [g; gg];
%             ap = [];
%             if aantalgaten > 0 % 1 or more gaps in data
%                 teller = 1;
%                 for h = [1 (g(1:end)'+1)] % begin of hor parts
%                     f11 = f( h : gg(teller) );
%                     Ap = ( P(f11(end)) - P(f11(1)) )* 0.4 + P(f11(1));
%                     ap = [ap; Ap];
%                     name = ['f',num2str(teller)]; % f1 is first hor part, etcetera
%                     eval([name,' = ','f11;']);
%                     teller = teller + 1;
%                 end

%             else % if aantalgaten == 0 % no gaps
                ap = ( P(f(end)) - P(f(1)) )* 0.4 + P(f(1));
%             end

            % find nearest odd integer of ap (maybe in bit laborious way..)
            for h = 1:length(ap)
                vloer = floor(ap(h)); plafond = ceil(ap(h));
                if iseven(vloer) == 1
                    vloer = vloer-1;
                end
                if iseven(plafond) == 1
                    plafond = plafond+1;
                end
                verschilv = ap(h) - vloer; verschilp = plafond - ap(h);
                if verschilp <= verschilv
                    ap(h) = plafond;
                elseif verschilp > verschilv
                    ap(h) = vloer;
                end
                %----------------------------------------------------------
                AP = [AP; ap(h)];
                LPS = [LPS; Lps(i)];
            end
        end
    end

    sills = [AP LPS]; % LPS is in cm
    sills = sortrows(sills,1); % sort with increasing AP
    AP = sills(:,1); LPS = sills(:,2);
    % make numbering for on the screen
    no = [];
    for i = 1:length(AP)
        no = [no; i];
    end
    sills = [no sills]; 
    format short g
    disp('         no          P_0 (-)        Lp (cm)');
    disp(sills); % plot on screen and then delete, not needed anymore
    sills = [];

    figure (1)
    plot(AP,LPS,'ro');
    text(AP,(LPS)+300,num2str(no),'Units','data');

    % plot data with trend lines so that user can choose 1 or more trend
    % lines:
    ytrend = [];
    for i = 1:length(AP)
        w = hann(AP(i)); w = w./sum(w);
        ytrend = wmovavr(provo123,AP(i),w); w=[];
        figure(i+1)
        plot(dist2,provo123,'-'); hold on;
        plot(dist2,ytrend,'r');
        tit = ['no = ' ,num2str(no(i)),', AP = ' ,num2str(AP(i)),', Lp = ',num2str(LPS(i)),' cm'];
        title(tit);
        % plot spectrum:
        %         X = (AP(i)-1)/2; provo2 = provo123;
        %         provo2(1:X) = []; ytrend(1:X) = [];
        %         provo2(end+1-X:end) = []; ytrend(end+1-X:end) = [];
        %         provo0 = provo2 - ytrend; N = length(provo0);
        %         provo0 = provo0 - ones(N,1)*mean(provo0);
        %         [k,S,Lpeak] = spectraldensity(dist2,provo0);
        %         figure(length(AP) + 1 + i)
        %         semilogx(k,S); Smax = max(S); km=find(S == Smax);
        %         text(k(km),Smax,num2str(Lpeak));
    end

    if aantalLps >= 1
        answer0 = input('\n Apparently, one or more dominant bedform lengths exist. \n How many bedform lengths do you want to analyze (< 6)? ');
        if answer0 > 5
            error('......Number should be smaller than 6!');
        end
        if answer0 > length(no)
            error('......Number should be smaller than the amount of dominant bedform lengths that were found!');
        end

        APinterest = []; Lpinterest = [];
        figuren = [];
        for i = 1:answer0
            answer1 = [];
            answer1 = input('\n Which length are you interested in (give number corresponding to P0)? \n Give 0 if you want to choose a P0 yourself  ');
            if answer1 > no(end)
                error('......Number not correct!');
            end
            if answer1 == 0 % give a number yourself
                answer2 = input('\n Give P0 yourself: ');
            end
            if answer1 ~= 0
                Lpinterest = [Lpinterest; LPS(answer1)];
                APinterest = [APinterest; AP(answer1)];
            elseif answer1 == 0
                APinterest = [APinterest; answer2];
                w = hann(answer2); w = w./sum(w);
                ytrend = wmovavr(provo123,answer2,w);
                provo0 = provo123 - ytrend;
                N = length(provo0);
                provo0 = provo0 - ones(N,1)*mean(provo0);
                [k,S,Lpeak] = spectraldensity(dist2,provo0,delt);
                Lpinterest = [Lpinterest; Lpeak];
            end
            figuren = [figuren; answer1];
        end
        % close figures: (if not chosen 0 for answer1)
%         f0 = find(figuren == 0);
%         if length(f0) == 0
%             weg = [];
%             for i = 1:length(no)
%                 f = find(no(i) == figuren);
%                 if length(f) == 0
%                     weg = [weg; no(i)];
%                 end
%             end
%             weg = weg + 1;
%             %             close (weg);
%         end
    elseif aantalLps < 1
        error('......No dominant bedform length was found');
    end

    % sort in increasing Lpinterest:
    SS = [APinterest Lpinterest]; SS = sortrows(SS,2);
    APinterest = SS(:,1); Lpinterest = SS(:,2);
    % apply mov avr again for lengths of interest and save in struct
    for i = 1 : length(Lpinterest)
        w = hann(APinterest(i)); w = w./sum(w);
        ytrend = wmovavr(provo123,APinterest(i),w); w=[];
        name1 = ['yy',num2str(i)];
        name2 = ['AP',num2str(i)];
        name3 = ['Lp',num2str(i)];
        eval([name1,' = ','ytrend;']); % yy1, yy2, etc, in workspace contain trend lines
        eval([name2,' = ','APinterest(i);']); % AP1, AP2, etc, in workspace contain corresp. AP
        eval([name3,' = ','Lpinterest(i);']); % Lp1, Lp2, etc, in workspace contain corresp. Lpeak
    end

    if length(Lpinterest) < 5 % alle structs moeten evenveel fields bevatten, dus lege fields aanmaken van restant
        for i = (length(Lpinterest) + 1): 5
            name1 = ['yy',num2str(i)];
            name2 = ['AP',num2str(i)];
            name3 = ['Lp',num2str(i)];
            eval([name1,' = ','[];']);
            eval([name2,' = ','[];']);
            eval([name3,' = ','[];']);
        end
    end
    % create struct MAf (Moving Average filters)
    name = ['MAf.profielnr'];
    eval([name,' = ','profielnr;']);
    name0 = ['MAf.amountofLinterest'];
    eval([name0,' = ',num2str(length(APinterest)),';']);
    for i = 1 : 5
        name1 = ['MAf.yy',num2str(i)];
        eval([name1,' = yy',num2str(i),';']);
        name2 = ['MAf.AP',num2str(i)];
        eval([name2,' = AP',num2str(i),';']);
        name3 = ['MAf.Lp',num2str(i)];
        eval([name3,' = Lp',num2str(i),';']);
    end

    MAF = [MAF MAf];
    MAf = []; % clear so that for next profile new struct is made
    close all;
    tel = tel + 1;
end
