% Rolien van der Mark, 2006
% Adapted Arjan Tuijnder May 2007

function [ytrend] = straighttrend(x, z_b, xbegin, xend);

    if length(z_b) > 0
        % if there are NaNs in the data, the trend line cannot be determined.
        if sum(isnan(z_b)) > 0, 'Filter NaNs first', return, end

        RangeX = [xbegin, xend];
    
        int = (x >= min(RangeX) & x <= max(RangeX)); % find interval profile outside testsection
        x = x(int);                              % delete everything outside testsection
        z_b = z_b(int);

        p = polyfit(x,z_b,1); % straight trend line
    end

ytrend = p(1).*x + p(2);

