% Given a spectrum S as functio of wave number k, dan spectral moments can be computed. 
% Output are the first 5 spectral moments. m0, m1, m2, m3, m4. 
% m0 is equal to the variance of a series.

% Rolien van der Mark, 2006

function [mom] = spmoments(S,k)

n = length(k);
dk = k(2)-k(1); % equal to fs/NFFT, or binwidth, see Hegge& Masselink 96


% spectral moments:
som0 = 0;
for m = 1:n
    somtemp = S(m)*dk*(k(m))^0;
    som0 = som0 + somtemp;
end
mom = [som0];

som0 = 0;
for m = 1:n
    somtemp = S(m)*dk*(k(m))^1;
    som0 = som0 + somtemp;
end
mom = [mom; som0];

som0 = 0;
for m = 1:n
    somtemp = S(m)*dk*(k(m))^2;
    som0 = som0 + somtemp;
end
mom = [mom; som0];

som0 = 0;
for m = 1:n
    somtemp = S(m)*dk*(k(m))^3;
    som0 = som0 + somtemp;
end
mom = [mom; som0];

som0 = 0;
for m = 1:n
    somtemp = S(m)*dk*(k(m))^4;
    som0 = som0 + somtemp;
end
mom = [mom; som0];