% Rolien van der Mark, 2006

function [k,S,Lpeak] = spectraldensity(x,y,delt)

N            = length(y);
NFFT         = 2^(nextpow2(N));
S            = fft(y,NFFT);
NumUniquePts = ceil((NFFT+1)/2);
S            = S(1:NumUniquePts);
S            = abs(S);
S            = S.^2;
fs           = 1/delt;
S            = S/(fs*N);
S            = S*2;
S(1)         = S(1)/2;
if ~rem(NFFT,2)
    S(end) = S(end)/2;
end

k = (0:NumUniquePts-1)*(1/delt)/NFFT;
k = k';

% find Lpeak. UNCOMMENTED 3 SENTENCES BELOW (EDIT MARNIX)
r=find(S == max(S));
kpeak = k(r(end));
Lpeak = 1/kpeak;

% A peak in spectrum is only a peak if points before and after are lower.
% We prevent with following listing that maximum is found at the beginning 
% whereas this is no peak.

%COMMENTED ALL BELOW (EDIT MARNIX) 
% Ssort = sort(S,'descend'); % sort in descending order
% 
% Lpeak = 0; % run loop until Lpeak > 0
% row = 1;
% while Lpeak == 0
%     Smax = Ssort(row);
%     r = find(Smax == S);
%     if (r(end) > 1) & (r(end) < length(S))
%         if (S(r(end)) > S(r(end)+1)) & (S(r(end)) > S(r(end)-1))
%             kpeak = k(r(end));
%             Lpeak = 1/kpeak;
%             if Lpeak > (x(end) - x(1)) % Lpeak can never be longer than the length of the series
%                 row = row + 1; Lpeak = 0;
%             end
%         else % if point before and/or after is not lower
%             row = row + 1; Lpeak = 0;
%         end
%     elseif r(end) == 1 | r(end) == length(S)
%         row = row + 1; Lpeak = 0;
%     end
% end

% first 2 points are maxima, but are no peaks. Point 4 is the first peak.
%     .
%      \
%       \
%        .
%         \   .
%          \./ \
%               \
%                \



