% Rolien van der Mark, 2006

function [ytrend] = secordertrend(provoNos,dirread,provoloc);

trendlijn = [];
for j = provoNos
    provoNr = num2str(j);
    fileNm=[dirread,'pr',provoNr,'.mat'];
    load(fileNm);
    profielnr = ['pr',provoNr];
    dist2 = eval([profielnr,'.dist2']);
    provo123 = eval([profielnr,'.provo',num2str(provoloc)]);
    if length(provo123) ~= 0
        % if there are NaNs in the data, the trend line cannot be determined.
        % Here these NaNs are deleted:
        f=isnan(provo123);
        if sum(f) > 0
            ff=find(f == 1);
            provo123(ff) = []; dist2(ff) = [];
        else end

        xbegin = eval([profielnr,'.xbegin']); xbegin = xbegin * 100;    % convert to cm
        xend = eval([profielnr,'.xend']); xend = xend * 100;            % convert to cm
        int = find((dist2 >= xbegin) & (dist2 <= xend)); % find interval profile outside testsection
        dist2 = dist2(int);                              % delete everything outside testsection
        provo123 = provo123(int);

        p = polyfit(dist2,provo123,2); % 2nd order trend line
        trendlijn = [trendlijn; p];
    elseif length(provo123) == 0
    end
end
p = mean(trendlijn,1); 

len = length(provoNos);
dist2 = eval([profielnr,'.dist2']);
for i =  1:len
    ytrend(:,i) = p(1)*(dist2).^2 + p(2)*dist2 + p(3);
end

