% Rolien van der Mark, 2006

% EDITED 2018/11/08 by Timo de Ruijsscher: removal of outliers: clicking
% outliers is possible, also when two neighbouring points are outliers.
% Made possible by variable Outliers, as input in crosscorr_dunes_bars.m.

% EDITED 2018/12/18 by Timo de Ruijsscher: added input argument
% plot_outliers. When set to zero, the outlier graph will be skipped.
% Default value 1.

function [x,z,xg] = replaceoutliers(x,z,xbegin,xend,C,outlier_manual,plot_outliers)%provoNos,dirread1,dirread2,provoloc)

if nargin<5 || isempty(C)
    C = 5;
end

if nargin<6 || isempty(outlier_manual)
    outlier_manual = 0;
end

if nargin<7 || isempty(plot_outliers)
    plot_outliers = 1;
end

% for j = provoNos
% 
%     provoNr = num2str(j);
%     fileNm1 = [dirread1,'pr',provoNr,'.mat'];
%     fileNm2 = [dirread2,'pr',provoNr,'.mat'];
% 
%     if exist(fileNm2) == 0  % no-outlier-file does not exist, so copy raw file to no-outlierfile and delete outliers in this file
%         load(fileNm1);
%         % save and load in new directory:
%         eval(['save ''',fileNm2,''' pr',provoNr,'']);
% 
%     elseif exist(fileNm2) == 2 % no-outlier-file already exists, save raw data here and use this:
%         load(fileNm1);
%         profielnr = ['pr',provoNr];
%         dist2 = eval([profielnr,'.dist2']);
%         provo123 = eval([profielnr,'.provo',num2str(provoloc)]);
%         load(fileNm2);
%         % replace dist2_raw and provo123_raw in n_o struct: n_o = no outliers
%         filename = ['pr',num2str(j),'.dist2'];
%         eval([eval('filename') '=dist2;']);
% 
%         filename = ['pr',num2str(j),'.provo',num2str(provoloc)];
%         eval([eval('filename') '=provo123;']);
%         % save struct prXXX with raw data in n_o directory
%         filename = [dirread2,'pr',num2str(j)];
%         eval(['save ''',filename,''' pr',num2str(j)]);
%     end
% 
%     % load to find outliers per profile:
%     load(fileNm2);
%     profielnr = ['pr',provoNr];
%     dist2 = eval([profielnr,'.dist2']);
%     provo123 = eval([profielnr,'.provo',num2str(provoloc)]);
    if ~isempty(z)
%         xbegin = eval([profielnr,'.xbegin']); xbegin = xbegin * 100;    % convert to cm
%         xend = eval([profielnr,'.xend']); xend = xend * 100;            % convert to cm
        int = find((x >= xbegin) & (x <= xend)); % find interval profile outside testsection
        x = x(int);                              % delete everything outside testsection
        z = z(int);

        %   delete NaNs from temporary ztemp.
        ztemp = z;
        f=isnan(ztemp);
        if sum(f) > 0
            ff=find(f == 1);
            ztemp(ff) = []; mini = min(ztemp); maxi = max(ztemp);
            z(ff) = 9999;
            %!        what do we do with this?
        else
            mini = min(ztemp); maxi = max(ztemp);
        end

        %------------------------------------------------------------------
        % determine vertical dist (absolute value) between all subsequent
        % data points (dz). Mean is measure for vertical deviation (dzm).
        % Do this for ztemp as these does not contain NaNs. Outlier
        % if point deviates more than 5dzm from previous point and -5dzm
        % from next point.
        %------------------------------------------------------------------
        N = length(ztemp); dz = [];
%         for i = 1:N-1
%             dztemp = abs(ztemp(i+1)-ztemp(i));
%             dz = [dz; dztemp];
%         end
        dz = abs(diff(ztemp));
        dzm = mean(dz);

%         C = 5;
        outliers = [];
        f = [];
        for i = 1:N-2
            if (abs(z(i)-z(i+1)) >= C*dzm) && (abs(z(i+1)-z(i+2)) >= C*dzm) && ...
                    (((z(i)>z(i+1)) && (z(i+2)>z(i+1))) || ((z(i)<z(i+1)) && (z(i+2)<z(i+1))))
                outliers = [outliers; x(i+1) z(i+1)];
                f = [f i+1];
            end
        end
% % % %         for i = 1:N
% % % %             if abs(z(i)) >= 999 && (isempty(outliers) || ~ismember(x(i),outliers(:,1)))
% % % %                 outliers = [outliers; x(i) z(i)];
% % % %             end
% % % %         end
        
        if plot_outliers==1
            figure;
            plot(x,z,'.-'); hold on;
            xlabel('X coordinate (m)');
            ylabel('Bed elevation (m)');
%             title(j);
            xlim([xbegin xend]);
            ylim([mini maxi]);
        end
        % if there are one or more outliers in the profile, plot the outliers:
        if ~isempty(outliers)
            for i = 1:size(outliers,1)
                if plot_outliers==1
                    plot(outliers(i,1),outliers(i,2),'ro');
                end
% % % % %                 if i==1
% % % % %                     answer = input('\n Outlier found. Do you want to interpolate (1), \n or keep this point (2)  (choose 1/2) [default (any key) = 1]?  ','s');
% % % % %                     if isempty(answer) || all(~strcmp(answer,{'1','2'}))
% % % % %                         answer = '1';
% % % % %                     end
% % % % %                 end
% % % % %                 if answer == '1' % interpolate
                    z(f) = (z(f-1) + z(f+1))/2;
                    if plot_outliers==1
                        plot(x(f),z(f),'ko');
                    end
% % % % %                 end
%                 if answer == '2' % keep
%                 end
            end

            % consider profile again, maybe after interpolation more outliers:
            outliers2 = [];
            for i = 1:N-2
                if (abs(z(i)-z(i+1)) >= C*dzm) && (abs(z(i+1)-z(i+2)) >= C*dzm) && ...
                    (((z(i)>z(i+1)) && (z(i+2)>z(i+1))) || ((z(i)<z(i+1)) && (z(i+2)<z(i+1))))
                    outliers2 = [outliers2; x(i+1) z(i+1)];
                end
            end
            if ~isempty(outliers2)
                for i = 1:size(outliers2,1)
                    if plot_outliers==1
                        plot(outliers2(i,1),outliers2(i,2),'ro');
                    end
% % % % %                     if i==1
% % % % %                         answer2 = input('\n Outlier found. Do you want to interpolate (1), \n or keep this point (2)  (choose 1/2) [default (any key) = 1]?  ','s');
% % % % %                         if isempty(answer2) || all(~strcmp(answer2,{'1','2'}))
% % % % %                             answer2 = '1';
% % % % %                         end
% % % % %                     end
% % % % %                     if answer2 == '1' % interpolate
                        f = find(x == outliers2(i,1));
                        z(f) = (z(f-1) + z(f+1))/2;
                        if plot_outliers==1
                            plot(x(f),z(f),'ko');
                        end
% % % % %                     end
%                     if answer2 == '2' % keep
%                     end
                end
            end
        end
        
% AUTOMATIC DETECTON OF LONGER OUTLIER STRETCHES; ADDED 2018/11/12 Timo de Ruijsscher
        xi = [];
        for i=1:length(x)-1
            if abs(z(i))>1000
                if i==1 || abs(z(i-1))<1000 || abs(z(i+1))<1000
                    xi = [xi; i];
                end
            end
        end
        if abs(z(end))>1000
            xi = [xi; i];
        end
        for i=1:2:length(xi)-1
            if xi(i)==1
                z(xi(i):xi(i+1)) = z(xi(i+1)+1);
            elseif xi(i+1)==length(x)
                z(xi(i):xi(i+1)) = z(xi(i)-1);
            elseif xi(i)==xi(i+1)
                z(xi(i)) = z(xi(i)-1);
            else
                z(xi(i):xi(i+1)) = interp1([x(xi(i)-1) x(xi(i+1)+1)],[z(xi(i)-1) z(xi(i+1)+1)],x(xi(i):xi(i+1)));
            end
        end
        
        if plot_outliers==1
            close;
            figure;
            plot(x,z,'.-'); hold on;
            xlabel('X coordinate (m)');
            ylabel('Bed elevation (m)');
            xlim([xbegin xend]);
        end

        if outlier_manual==1
            % visually maybe outliers that were not found as outlier.
            % if so,click these manually:
            answer3 = input('\n Are there outliers that you want to remove manually? \n If so, click on the right place and press enter when finished. \n (choose y/n) [default (any key) = n]?  ','s');
            if isempty(answer3) || ~any(strcmp(answer3,{'n','y'}))
                answer3 = 'n';
            elseif answer3 == 'y' % click
                [xg,~] = ginput();
                answer_input = input('\n Do you add more outliers to the removal algorithm (choose y/n) [default (any key) = n]? ','s');
                if isempty(answer_input) || ~any(strcmp(answer_input,{'n','y'}))
                    answer_input = 'n';
                else
                    while answer_input == 'y'
                        [xg1,~] = ginput();
                        xg = [xg; xg1];
%                         yg = [yg; yg1];
                        answer_input = input('\n Do you add more outliers to the removal algorithm (choose y/n) [default (any key) = n]? ','s');
                        if isempty(answer_input) || ~any(strcmp(answer_input,{'n','y'}))
                            answer_input = 'n';
                        end
                    end
                end
                for i = 1:length(xg)
                    dif = abs(x - xg(i)); f1(i) = find(dif == min(dif));
%                     plot(x(f1),z(f1),'ro');
%                     plot(x(f1),yg(i),'ko');
%                     z(f1) = yg(i);
%                     f1 = [];
                end
%                 for i = 1:length(f1)
%                     if ~ismember(f1(i)-1,f1)
%                         z(f1(i)) = z(f1(i)-1);
%                     elseif ~ismember(f1(i)+1,f1)
%                         z(f1(i)) = z(f1(i)+1);
%                     else
%                         warning('Neighbouring points are also outliers');
%                     end
%                 end
                for i=1:2:length(f1)-1
                    if f1(i)==f1(i+1)
                        z(f1(i)) = z(f1(i)-1);
                    else
                        z(f1(i):f1(i+1)) = interp1([x(f1(i)-1) x(f1(i+1)+1)],[z(f1(i)-1) z(f1(i+1)+1)],x(f1(i):f1(i+1)));
                    end
                end
            end
        end
        if ~exist('xg') || isempty(xg)
            xg = [];
        end
% 
%         % replace dist2_n_o en provo123_n_o in struct: n_o = no outliers
%         filename = ['pr',num2str(j),'.dist2'];
%         eval([eval('filename') '=dist2;']);
%         filename = ['pr',num2str(j),'.provo',num2str(provoloc)];
%         eval([eval('filename') '=provo123;']);
% 
%         % save struct prXXX with n_o in n_o directory
%         filename = [dirread2,'pr',num2str(j)];
%         eval(['save ''',filename,''' pr',num2str(j)]);
% 
%         %         pause(1)
%         close;
    end
% end % of provoNos loop, new profile
end

