% Rolien van der Mark, 2006

function [ap] = determineap(Lav,delt,C,LManualOption)

if nargin == 2
    C = 1/6;
end

apperL = 1+(Lav/delt); % amount of data points per bedform length
if nargin == 3
    ap = apperL*(C); % amount of data points per 1/6 Lav, default
elseif nargin == 4
    ap = LManualOption / delt;
    ap = ap/10; %Mysterious factor 10...
end

vloer = floor(ap);
plafond = ceil(ap);

if iseven(vloer) == 1
    vloer = vloer-1;
else end

if iseven(plafond) == 1
    plafond = plafond+1;
else end

verschilv = ap - vloer; verschilp = plafond - ap;

if verschilp <= verschilv
    ap = plafond;
elseif verschilp > verschilv
    ap = vloer;
end

