function SaveOutputFunction(FileName, BFStats, Selection)
%Function for exporting requested variables
%Arjan Tuijnder 05/2007

%Determine requested variable numbers
ReqVariableNumbers = find(Selection);

% VariableOrder 
    % LevelCrest
    % LevelTrough
    % HeightStoss
    % HeigthLee
    % LengthDowncrossings
    % LengthUpcrossings
    % LengthTroughs
    % LengthTops
    % SlopeLee

% The selection 'bits' are passed in the order of this cell array:
LinkVariables = {   'crests',...
                    'troughs',...
                    'Htrto',...
                    'Htotr',...
                    'Ldowncr',...
                    'Lupcr',...
                    'Ltroughs',...
                    'Ltops',...
                    'slopelee'};

FieldNamesBFStats = fieldnames(BFStats);
BFStatsCell = struct2cell(BFStats);

%Initialise variables 
FieldnamesToWrite = cell(size(ReqVariableNumbers,2),1);
MaxLength = 0;


for i = 1: length(ReqVariableNumbers)
   j = ReqVariableNumbers(i);
   %Find the index of requested variable in the BFStats struct
   reqVar = find(strcmp(LinkVariables(j), FieldNamesBFStats));
   %Find size of export matrix
   MaxLength            = max([MaxLength length(BFStatsCell{reqVar})]);
end

for i = 1: length(ReqVariableNumbers)
    j = ReqVariableNumbers(i);
    %Find the index of requested variable in the BFStats struct
    reqVar = find(strcmp(LinkVariables(j), FieldNamesBFStats));
    FieldnamesToWrite{i} = FieldNamesBFStats{reqVar};
    n                	= MaxLength - length(BFStatsCell{reqVar});
    %add NaNs if rows are unequal in size 
    Data = BFStatsCell{reqVar}';
    if n > 0
       DataToWrite(i,:)       = [Data, repmat([NaN], 1, n)];
    else
        DataToWrite(i,:)      = Data;
    end
end

% create cell array of strings 
S = [FieldnamesToWrite,reshape(cellstr(num2str(DataToWrite(:),'%.5e')), size(DataToWrite))]';

%Write data
fid=fopen(FileName,'w'); 
fprintf(fid,[repmat('%s\t ',1,size(S,1)-1),'%s\n'],S{:}); 
fclose(fid);