%% Find appropriate span values (P0)


%for more information: sjoukje.delange@wur.nl
%based on script of Kris van den Berg; kris.vandenberg@wur.nl

load ('M:\PhDSjoukje\ProjectWaal\BTT\transect2btt2dunechar\Output\DetermineP0.mat')
load ('M:\PhDSjoukje\ProjectWaal\BTT\transect2btt2dunechar\Output\Luni.mat')
%%
figure(), hold on,
for i = 1:length(P0_all)
    for k = 1:length(P0_all{i})
%         scatter (KPSNXYW.KP (i,1), P0_all{i}(k))
        scatter (KPSNXYW.KP (i,1), Luni_all{i}(k))
    end
end

 openfig ('fig_001.fig', 'visible' )
%% 
Ps = [];
V = [5 20 50 100];                          % length of bedforms 
V_error = [5 10 25 30];                     % margin of error

for i = 1:length(P0_all)
    try 
    % load and prepare data 
%     P0 = load(['P0_',num2str(i,'%03d')]);
%     Luni = load(['Luni',num2str(i,'%03d')]);
    Luni = cell2mat(Luni_all(i));
    P0 = cell2mat(P0_all(i)); 
    
    for j = 1:length(V)
        % find Luni closest to given lengths
        [minValue,closestIndex] = min(abs(Luni-V(j)));
        closestValue = Luni(closestIndex); 
        
        % calculate upper and lower limit 
        V_up = V(j)+V_error(j);
        V_low = V(j)-V_error(j); 

        % find P0 with index of closest Luni
        if (closestValue>V_low) && (closestValue<V_up)
            P_temp = P0(closestIndex);
            P = P_temp;
            L_temp = closestValue;
        else 
            P = NaN;
            L_temp = 0;
        end 
      
        % write to matrix
        Ps2(i,j) = P; 
        Ls2(i,j) = L_temp;
    end 
    catch 
    end 
end 

% save 
save('Ps2')
save('Ls2')
