function [troughs, crests] = FindExtremes(x, z, z_filt, upcross, downcross, ap)

crossings = [upcross; downcross];
crossings = sortrows(crossings,1);

% toppen en troggen zoeken
crests = []; troughs = [];
for i = 1:length(crossings(:,1))-1
    if crossings(i+1,3)-crossings(i,3) == 1 % dan top tussen deze 2 crossings
        f = []; f = find((x > crossings(i,1)) & (x < crossings(i+1,1)));
        dist2f = x(f); z_f = z_filt(f); provo0f = z(f);
        z_cresttemp = max(z_f);
        if z_cresttemp >= 0
            row = []; row = find(z_f == z_cresttemp);
            xcoord = []; xcoord = dist2f(row(end)); % xcoord bij maximum filter
            row = []; row = find(xcoord == x);
            bereik = []; bereik = [(row - 0.5 *(ap-1)) : (row + 0.5*(ap-1))];
            if (bereik(1) >= 1) & (bereik(end) <= length(z))
                z_crest = max(z(bereik));
                row1 = find(z_crest == z(bereik));
                xcrest = x(bereik(row1(end))); %xcoord bij top, bij vlakke top laatste punt
                if bereik(1) < f(1) | bereik(end) > f(end)
                    if bereik(1) < f(1) & bereik(end) > f(end)
                        bereiknew = [f(1) : f(end)];
                    elseif bereik(1) < f(1) & bereik(end) <= f(end)
                        bereiknew = [f(1) : bereik(end)];
                    elseif bereik(1) >= f(1) & bereik(end) > f(end)
                        bereiknew = [bereik(1) : f(end)];
                    end
                    z_crest = max(z(bereiknew));
                    row1 = find(z_crest == z(bereiknew));
                    xcrest = x(bereiknew(row1(end))); %xcoord bij top, bij vlakke top laatste punt
                end
            else
                z_crest = max(provo0f);
                row = []; row = find(provo0f == z_crest);
                xcrest = []; xcrest = dist2f(row(end));
            end
            crests = [crests; xcrest z_crest 3]; % top krijgt label 3 mee
        end
    elseif crossings(i+1,3)-crossings(i,3) == -1 % dan trog tussen deze 2 crossings
        f = []; f = find((x > crossings(i,1)) & (x < crossings(i+1,1)));
        dist2f = x(f); z_f = z_filt(f); provo0f = z(f);
        z_troughtemp = min(z_f);
        if z_troughtemp <= 0
            row = []; row = find(z_f == z_troughtemp);
            xcoord = []; xcoord = dist2f(row(1)); % xcoord bij minimum filter
            row = []; row = find(xcoord == x);
            bereik = []; bereik = [(row - 0.5 *(ap-1)) : (row + 0.5*(ap-1))];
            if (bereik(1) >= 1) & (bereik(end) <= length(z))
                z_trough = min(z(bereik));
                row1 = find(z_trough == z(bereik));
                xtrough = x(bereik(row1(1))); %xcoord bij trog, bij vlakke trog eerste punt
                if bereik(1) < f(1) | bereik(end) > f(end)
                    if bereik(1) < f(1) & bereik(end) > f(end)
                        bereiknew = [f(1) : f(end)];
                    elseif bereik(1) < f(1) & bereik(end) <= f(end)
                        bereiknew = [f(1) : bereik(end)];
                    elseif bereik(1) >= f(1) & bereik(end) > f(end)
                        bereiknew = [bereik(1) : f(end)];
                    end
                    z_trough = min(z(bereiknew));
                    row1 = find(z_trough == z(bereiknew));
                    xtrough = x(bereiknew(row1(1))); %xcoord bij trog, bij vlakke trog eerste punt
                end
            else
                z_trough = min(provo0f);
                row = []; row = find(provo0f == z_trough);
                xtrough = []; xtrough = dist2f(row(end));
            end
            troughs = [troughs; xtrough z_trough 4]; % trog krijgt label 4 mee
        end
    end
end


% checken of toppen en troggen wel om-en-om voorkomen
if ((length(crests) > 0) & (length(troughs) > 0))
    if (length(crests(:,1)) == length(troughs(:,1))) | (length(crests(:,1)) == length(troughs(:,1))+1) | (length(crests(:,1)) == length(troughs(:,1))-1) % OK
    else error('The amount of troughs does not agree with the amount of crests!')
    end
end
extremes = [crests; troughs];
% % % figure; hold on; for i=1:size(extremes,1); plot(extremes(i,1),extremes(i,3),'o'); end
if length(extremes) > 0
    extremes = sortrows(extremes,1);
    if extremes(1,3) == 3 % eerste element is een top
        for i=1:2:length(extremes(:,1))-1
            if extremes(i+1,3) - extremes(i,3) == 1 % na 3 (top) moet een 4 (trog) komen, dus verschil moet 1 zijn
            else error('1e = top: er gaat iets mis, want top en trog komen niet om-en-om voor!')
            end
        end
    elseif extremes(1,3) == 4 % eerste element is een trog
        for i=1:2:length(extremes(:,1))-1
            if extremes(i,3) - extremes(i+1,3) == 1 % na 4 (trog) moet een 3 (top) komen, dus verschil moet 1 zijn
            else error('1e = trog: er gaat iets mis, want top en trog komen niet om-en-om voor!')
            end
        end
    end
end

% -------------------------------------------------------------------------
%    Aan randen zitten misschien nog toppen en troggen die niet worden
%    meegenomen. Vooral bij korte labgoten met maar weinig bodemvormen
%    zonde van de data als die niet worden meegenomen.
% -------------------------------------------------------------------------
if length(extremes) > 0
    C = 0.5; % constante voor aantal punten aan rand
    if (extremes(end,3) == 4) & (crossings(end,3) == 1) % dan missch top aanw eindrand
        g = find(x > crossings(end,1));
        dist2g = x(g);
        provo0g = z(g); z_g = z_filt(g);
        z_toptemp = max(provo0g);
        row = find(provo0g == z_toptemp); xtop = dist2g(row(end)); z_top = provo0g(row(end));
        g1 = find(dist2g > xtop);
        if length(g1) >= C*ap
            crests = [crests; xtop z_top 3]; % top krijgt label 3 mee
            crests = sortrows(crests,1);
        end
    end

    if (extremes(end,3) == 3) & (crossings(end,3) == 2) % dan missch trog aanw eindrand
        g = find(x > crossings(end,1));
        dist2g = x(g);
        provo0g = z(g); z_g = z_filt(g);
        z_trogtemp = min(provo0g);
        row = find(provo0g == z_trogtemp); xtrog = dist2g(row(end)); z_trog = provo0g(row(1));
        g1 = find(dist2g > xtrog);
        if length(g1) >= C*ap
            troughs = [troughs; xtrog z_trog 4]; % trog krijgt label 4 mee
            troughs = sortrows(troughs,1);
        end
    end

    if (extremes(1,3) == 4) & (crossings(1,3) == 2) % dan missch top aanw beginrand
        g = find(x < crossings(1,1));
        dist2g = x(g);
        provo0g = z(g); z_g = z_filt(g);
        z_toptemp = max(provo0g);
        row = find(provo0g == z_toptemp); xtop = dist2g(row(end)); z_top = provo0g(row(end));
        g1 = find(dist2g < xtop);
        if length(g1) >= C*ap
            crests = [crests; xtop z_top 3]; % top krijgt label 3 mee
            crests = sortrows(crests,1);
        end
    end

    if (extremes(1,3) == 3) & (crossings(1,3) == 1) % dan missch trog aanw beginrand
        g = find(x < crossings(1,1));
        dist2g = x(g);
        provo0g = z(g); z_g = z_filt(g);
        z_trogtemp = min(provo0g);
        row = find(provo0g == z_trogtemp); xtrog = dist2g(row(end)); z_trog = provo0g(row(1));
        g1 = find(dist2g < xtrog);
        if length(g1) >= C*ap
            troughs = [troughs; xtrog z_trog 4]; % trog krijgt label 4 mee
            troughs = sortrows(troughs,1);
        end
    end
end


