function [z_filt, upcross, downcross, ap] = FindCrossings(x, z, C, EstBFL)
% if exist('temp_Crossings.mat') & 0
%     load temp_Crossings.mat;
% else

    %------------------------------------------------------------------
    % bepalen aantal punten voor filter en plotten van filter z_filt
    %------------------------------------------------------------------
    delt        = mean(diff(x)); % afstand tussen 2 meetpunten
    [k,S,~] = spectraldensity(x,z,delt); %[k,S,Lpeak]
    mom         = spmoments(S,k); mom(1);
%     variance    = var(z);
    [Lav,~]    = bedflength(mom); %[Lav,L0]
    
    if EstBFL > 0 
        ap = determineap(Lav,delt,C,EstBFL);
    elseif isempty(C)
        ap = determineap(Lav,delt);   
    else
        ap = determineap(Lav,delt,C); 
    end

    if ap == 1 || ap == 3           
        ap = 5;
    end
%     ap = 3;
%     w       = hann(ap); w = w./sum(w);
%     z_filt  = filtfilt(w,1,z); w=[];
    z_filt = movingmean(z,ap,[],2,'Hann');     % z_filt=z_det ,use ap= 1 or 3
    
% 
%     w = hann(ap); w = w./sum(w);
%     z_filt = wmovavr(z,ap,w); w=[];        % weighted moving average
    % -------------------------------------------------------
    % find zero-crossings in gefilterd signaal (downcrossings AND upcrossings):
    % aanname dat zero-crossings van gefilterd signaal ongeveer op de zelfde
    % plek liggen als de zero-crossings van het originele signaal, en aangezien
    % het op toppen en troggen ertussenin gaat en niet om de exacte
    % zero-crossings, zal dit vrijwel altijd goed gaan. y-coord van
    % crossing hebben we in vervolg niet nodig, hier wordt 0 ingevuld.
    %------------------------------------------------------------------
    upcross = []; downcross = [];
    for i = 1:(length(z_filt)-1)
        if z_filt(i) * z_filt(i+1) < 0 % kleiner dan nul betekent tekenwisseling, dus zerocrossing tussen deze punten
            fit = polyfit(x(i:i+1),z_filt(i:i+1),1);
            crossing = -fit(2)/fit(1); % x-coordinaat van de up- of downcrossing
            if fit(1) > 0 % rico positief, dan upcrossing, krijgt label 1 mee
                upcross = [upcross; crossing 0 1];
            elseif fit(1) < 0 % rico negatief, dan downcrossing, krijgt label 2 mee
                downcross = [downcross; crossing 0 2];
            end
        end
    end


    % -------------------------------------------------------------------------
    % up- en downcrossing moeten om en om voorkomen en er moeten evenveel zijn of verschil van 1. Check:
    % ERROR UIGESCHAKELD VOOR ANALYSE
    % -------------------------------------------------------------------------
    crossings = [upcross; downcross];
    crossings = sortrows(crossings,1);

    if ~isempty(upcross) && ~isempty(downcross)
        if (length(upcross(:,1)) == length(downcross(:,1))) || (length(upcross(:,1)) == length(downcross(:,1))+1) || (length(upcross(:,1)) == length(downcross(:,1))-1) % OK
        else error('The amount of upcrossings does not agree with the amount of downcrossings!')
        end
    end
    if crossings(1,3) == 1 % eerste element is een upcrossing
        for i=1:2:length(crossings(:,1))-1
            if crossings(i+1,3) - crossings(i,3) == 1 % na 2 (down) moet een 1 (up) komen, dus verschil moet 1 zijn
            else error('1e = upcrossing: er gaat iets mis, want up- en downcrossings komen niet om-en-om voor!')
            end
        end
    elseif crossings(1,3) == 2 % eerste element is een downcrossing
        for i=1:2:length(crossings(:,1))-1
            if crossings(i,3) - crossings(i+1,3) == 1 % na 2 (down) moet een 1 (up) komen, dus verschil moet 1 zijn
            else error('1e = downcrossing: er gaat iets mis, want up- en downcrossings komen niet om-en-om voor!')
            end
        end
    end

    % -------------------------------------------------------------------------
    % top is maximum tussen up- en downcrossing
    % trog is minimum tussen down- en upcrossing
    % -------------------------------------------------------------------------

    % controleren of tussen up- en downcrossing wel een POSITIEVE top zit
    % en tussen down- en upcrossing een NEGATIEVE trog. Zo niet, dan worden
    % deze crossings weggegooid. Dit kan voorkomen doordat het filter
    % onterecht crossings aanwijst.
    for i = 1:length(crossings(:,1))-1
        if crossings(i+1,3)-crossings(i,3) == 1 % dan top tussen deze 2 crossings
            f = find((x > crossings(i,1)) & (x < crossings(i+1,1)));
%             dist2f = x(f);
            provo0f = z(f);
            z_crest = max(provo0f);
            if z_crest < 0 % tussen up- en downcross zit een trog ipv top, deze 2 crossings wegdoen
                crossings(i,3) = 6; crossings(i+1,3) = 6;
            end
        elseif crossings(i+1,3)-crossings(i,3) == -1 % dan trog tussen deze 2 crossings
            f = find((x > crossings(i,1)) & (x < crossings(i+1,1)));
%             dist2f = x(f);
            provo0f = z(f);
            z_trough = min(provo0f);
            if z_trough > 0 % tussen down- en upcross zit een top ipv trog, deze 2 crossings wegdoen
                crossings(i,3) = 6; crossings(i+1,3) = 6;
            end
        end
    end
    % alle crossings weggooien met label 6:
%     f = find(crossings(:,3) == 6);
%     crossings(f,:) = [];
    upcross = crossings(crossings(:,3)==1,:);
    downcross = crossings(crossings(:,3)==2,:);

% save('temp_Crossings.mat')

end


