function Stats = CalcBFStats(x, z, z_filt, upcross, downcross, crests, troughs, nullijn)

crossings = [upcross; downcross];
crossings = sortrows(crossings,1);

% ---------------------------------------------------------------------
% nu alle toppen en troggen, ook aan de rand, bekend zijn,
% definities berekenen mbv bepaalde extremen (toppen en troggen) en de
% zero-crossings: matrices extremes en crossings.
extremes = [crests; troughs];

Stats.clx = crests(:,1)'; %toevoeging Timo de Ruijsscher 2018/01/25
Stats.cl = crests(:,2)';
Stats.tlx = troughs(:,1)';
Stats.tl = troughs(:,2)';

Lupcr = []; Ldowncr = []; Lups = []; Ldowns = [];
Ltroughs = []; Ltops = []; slopelee = [];
% cresttemp = []; troughtemp = []; hordists = [];
Htotr = []; Htrto = []; slope_l = []; slope_s = [];
if length(extremes) > 0
    extremes = sortrows(extremes,1);
    % alfa is angle of repose, hoek trendlijn en horizontaal
    alfa = 0;

    ff = find(crossings(:,3) == 1);
    upcross = crossings(ff,:);
    ff = find(crossings(:,3) == 2);
    downcross = crossings(ff,:);

    % Lupcr = afstand tussen 2 upcrossings:
    Lupcr = [];
    for i = 2:length(upcross(:,1))
        Lupcr1 = upcross(i,1)-upcross(i-1,1);
        Lupcr = [Lupcr; Lupcr1];
    end
    Lupcr = Lupcr/cos(alfa);
    % Ldowncr = afstand tussen 2 downcrossings:
    Ldowncr = [];
    for i = 2:length(downcross(:,1))
        Ldowncr1 = downcross(i,1)-downcross(i-1,1);
        Ldowncr = [Ldowncr; Ldowncr1];
    end
    Ldowncr = Ldowncr/cos(alfa);

    % toppen en troggen worden gedefinieerd als afstand loodrecht op trendlijn,
    % nu nog zijn de toppen en troggen punten in een x-z_filt-stelsel:
    cresttemp = []; troughtemp = [];
    if length(crests) > 0
        for i=1:length(crests(:,1))
            f5 = find(crests(i,1) == x);
            crest = crests(i,2) - nullijn(f5);
            cresttemp = [cresttemp; crest]; % afstand van top tot nullijn in cm
        end
        cresttemp = cresttemp*cos(alfa);
    end
    if length(troughs) > 0
        for i=1:length(troughs(:,1))
            f6 = find(troughs(i,1) == x);
            trough = troughs(i,2) - nullijn(f6);
            troughtemp = [troughtemp; trough]; % verticale afstand van nullijn tot trog in cm
        end
        troughtemp = troughtemp*cos(alfa);
    end

    % Lups = afstand tussen trog en volgende top
    % Ldowns = afstand tussen top en volgende trog
    % Ltroughs = afstand tussen 2 troggen (= Lup + Ldown)
    hordists = []; Lups = []; Ldowns = []; Htotr = []; Htrto = []; slope_l = []; slope_s = [];
    for i=2:length(extremes(:,1))
        hordist = extremes(i,:) - extremes(i-1,:);
        hordists = [hordists; hordist];
    end
    if length(hordists) > 0
        ff = find(hordists(:,3) == 1); % trog - vorige top = lijzijde info (down)
        b = hordists(ff,1); fff = abs(hordists(ff,2));
        ff = find(hordists(:,3) == -1); % top - vorige trog = loefzijde info (up)
        a = hordists(ff,1); g = hordists(ff,2);
        Ldowns = (b/cos(alfa)) + (fff*sin(alfa));
        Lups = (a/cos(alfa)) - (g*sin(alfa));
        Htotr = fff*cos(alfa); % hoogte duin van top tot volgende trog
        Htrto = g*cos(alfa); % hoogte duin van trog tot volgende top
        %%% toevoeging Timo de Ruijsscher/Bas Wullems 2018/01/25
        if extremes(end,3)==4
            Htotr_x = crests(:,1);
        elseif extremes(end,3)==3
            Htotr_x = crests(1:end-1,1);
        end   
        if extremes(1,3) ==4
            Htrto_x = crests(:,1);
        elseif extremes(1,3)==3
            Htrto_x = crests(2:end,1);
        end
        %%%%%%%%%
    end

    % bepaling helling lijzijde
    delt = mean(diff(x)); % afstand tussen 2 meetpunten
    atp = round((Ldowns./delt) + 1); % aantal tussenliggende punten incl top en trog
    slopelee = []; slopelee_x = [];
    if length(atp) >= 1
        for i = 1:length(atp)
            % eerste lijzijde volgt na eerste top:
            f77 = find(troughs(:,1) > crests(i,1)); f77 = f77(1); % vind eerstvolgende trog
            f7 = find((x >= crests(i,1)) & (x <= troughs(f77,1))); % stuk tussen top en trog
            if atp(i) == length(f7) % dan zitten er geen gaten in prof en wordt lee bepaald!
                zz = z_filt(f7); % stukje filter tussen beschouwde top en trog incl de trog en top
                xx = x(f7); % xas van stukje tussen top en trog
                pp = z(f7);
                z_trog1 = pp(end); xtrog1 = xx(end); % als geen wordt gevonden, gebruik dan de gevonden trog
                % plot(hFigure,xtrog1,z_trog1,'go','markersize',7,'linewidth',2);
                f9 = find(xx == xtrog1); xx = xx(1:f9); zz = zz(1:f9); pp = pp(1:f9);
                H = 0.5*(crests(i,2) - z_trog1);
                H1 = (1/6)*(crests(i,2) - z_trog1);
                H2 = (5/6)*(crests(i,2) - z_trog1);
                pploc = crests(i,2) - H;
                pploc1 = crests(i,2) - H1;
                pploc2 = crests(i,2) - H2;
                f10 = find(pp >= pploc);
                if length(f10) ~= 0
                    f10 = f10(end);
                end
                f101 = find(pp >= pploc1);
                if length(f101) ~= 0
                    f101 = f101(end);
                end
                f102 = find(pp <= pploc2);
                if length(f102) ~= 0
                    f102 = f102(1);
                end
                xxx = xx(f101:f102); Len = length(xxx);
                zzz = zz(f101:f102);
                ppp = pp(f101:f102);

                if Len >= 2 % beoogd deel op lijzijde; bepaal helling lijzijde, als <, dan niet
                    % kijken of op beoogde helling een 'ribbel' zit die helling
                    % verstoord. als ratio aantal stijgende punten - aantal
                    % dalende punten 0.3 of groter is, helling niet bepalen:
                    % Ru / Rd > 0.3 dan niet bepalen
                    zz_g = gradient(zzz);
                    fu = find(zz_g >= 0); Ru = length(fu);
                    fd = find(zz_g < 0); Rd = length(fd);
                    if Ru/Rd > 0.3
                        L = 1;
                    else L = 2; end
                    P = polyfit(xxx,ppp,1);
                    sl = P(1);
                    if sl < 0 % niet opslaan als >= 0, want dat kan niet goed zijn.
                        zzs = polyval(P,xxx); % ycoord helling
                        if L == 1 % wel plotten niet opslaan
%                             plot(hFigure,xxx,zzs,'r','linewidth',2); Ru/Rd;
                        else
%                            plot(hFigure,xxx,zzs,'g','linewidth',2);
                             slopelee = [slopelee; sl]; % helling-list. dy/dx, dus dimensieloos. negatief, afnemende helling
                             slopelee_x = [slopelee_x; crests(i,1)];
                        end
                    end
                end
            end
        end
    end

    Ltops = []; Ltroughs = [];
    if extremes(1,3) == 4       %eerste is een trog
        if length(troughs) > 0
            for i = 1:length(troughs(:,1))-1
                Ltrough = Lups(i) + Ldowns(i);
                Ltroughs = [Ltroughs; Ltrough];
            end
        end
        if length(crests) > 0
            for i = 1:length(crests(:,1))-1
                Ltop = Ldowns(i) + Lups(i+1);
                Ltops = [Ltops; Ltop];
            end
        end
    elseif extremes(1,3) == 3   %eerste is een top
        if length(troughs) > 0
            for i = 1:length(troughs(:,1))-1
                Ltrough = Lups(i) + Ldowns(i+1);
                Ltroughs = [Ltroughs; Ltrough];
            end
        end
        if length(crests) > 0
            for i = 1:length(crests(:,1))-1
                Ltop = Ldowns(i) + Lups(i);
                Ltops = [Ltops; Ltop];
            end
        end
    end

    slope_l = Htotr./Ldowns; % helling lijzijde (lee) [-]
    slope_s = Htrto./Lups;   % helling loefzijde (stoss) [-]

    crests = cresttemp; troughs = troughtemp;
end

% Gater data to return
% 
% FourierL.peak = Lpeak;
% FourierL.avr = Lav;
% FourierL.zero = L0;

% series.x = x;
% series.z = z;
% series.ztrend = trendlijn;
% series.var = variance;
% series.filter = z_filt;
% series.P = ap;

Stats.tlRel=troughs'; %trough height relative to zero line
Stats.clRel=crests'; %crest height relative to zero line

Stats.Lups=Lups'; %distance from trough to subsequent crest (length stoss side)
Stats.Ldowns=Ldowns'; %distance from crest to subsequent trough (length lee side)
Stats.Ltroughs=Ltroughs'; %dune length between troughs
Stats.Ltops=Ltops'; %dune length between tops
Stats.Lupcr=Lupcr'; %dune length between upcrossings
Stats.Ldowncr=Ldowncr'; %dune length between downcrossings

Stats.Htotr=Htotr'; %dune height top to subsequent (downstream) trough
Stats.Htrto=Htrto'; %dune height trought to subsequent (downstream) top
Stats.Htotr_x=Htotr_x'; %x-location top of Htotr
Stats.Htrto_x=Htrto_x'; %x-location top of Htrto

Stats.slope_l=slope_l'; %slope lee side (height/length)
Stats.slope_s=slope_s'; %slope stoss side (height/length)
Stats.slopelee=slopelee'; %slope lee side (linear fit)
Stats.slopelee_x=slopelee_x'; %x-location top of slope lee side (linear fit)

% Stats.FourierL=FourierL;
% Stats.series=series;
