function [Stats,x,z,z_det,nullijn] = BFSL_func(x,z,apDetrend,C_ap,limits_rough,C_outliers,fig_switch)
%Arjan Tuijnder 2008 gebaseerd op stukken uit Bedformtool Rolien van der Mark
%Input has to be a detrended array with mean equal to 0.
%
%Comment Timo: goede richting duinen: plot(Z) dan met toenemende X duinen ->
%
%Comment Timo: in CalcBFStats.m alfa=0 (hoek van trendlijn met horizontaal)

%Hoe te gebruiken op bodemprofielen van de Waal (Timo 2018/01/25)
% figure; plot(-lijn{1}.data(:,3),lijn{1}.data(:,5));
% [Stats,x,z,z_det,nullijn] = BFSL_func(-lijn{1}.data(:,3),lijn{1}.data(:,5),1149,1/3,[-1.5e4 0],[],1);

[x,z] = replaceoutliers(x,z,limits_rough(1),limits_rough(2),C_outliers);

nullijn = movingmean(z,apDetrend,[],2,'Hann'); %aanpassing Timo de Ruijsscher 2018/01/25
z_det = z-nullijn;

[z_filt, upcross, downcross, ap] = FindCrossings(x, z_det, C_ap, 0);%1); %aanpassing Olav 2011/06/10
%[z_filt, upcross, downcross, ap] = FindCrossings(x, z, 1);
[troughs, crests]                = FindExtremes(x, z, z_filt, upcross, downcross, ap);
% nullijn                          = zeros(length(x),1); %aanpassing Timo de Ruijsscher 2018/01/25
Stats                            = CalcBFStats (x, z, z_filt, upcross, downcross, crests, troughs, nullijn);

%plot stuff
if nargin<7
    fig_switch=1;
end
if fig_switch==1%1
    
    close all;
%     scrsz = get(0,'ScreenSize');
    figure; % hFigure = figure('Position',[1 512 1024 512]);
    axes();
    
    xlabel('X coordinate (m)');
    ylabel('Bed level (cm)');
    hold on;
    
%     dz = mean(z);
    plot(x, z,'.-');
    plot(x, x.*0,'r-');
    plot(x, z_filt,'m--');
    plot(upcross(:,1),   0,'ro');
    plot(downcross(:,1), 0,'r*');
    plot(crests(:,1),  crests(:,2),'ko','markersize',7,'linewidth',2);
    plot(troughs(:,1), troughs(:,2),'ro','markersize',7,'linewidth',2);
    
    drawnow;
% % % % %     waitforbuttonpress;
end

%Part below set to commented by Timo de Ruijsscher (2018/01/25)

% ucx = upcross(:,1)';
% dcx = downcross(:,1)';
% tlx = troughs(:,1)';
% tl  = troughs(:,2)';
% clx = crests(:,1)';
% cl  = crests(:,2)';
% 
% %Number of dunes:
% %Dune begins with dcr
% if min(clx) < min(dcx); clx(clx == min(clx)) = []; cl(clx == min(clx)) = []; end
% if min(ucx) < min(dcx); ucx(ucx == min(ucx)) = []; end
% %Before the first start delete
% if min(tlx) < min(clx); tlx(tlx == min(tlx)) = []; tl(tlx == min(tlx)) = []; end
% if min(tlx) < min(clx); tlx(tlx == min(tlx)) = []; tl(tlx == min(tlx)) = []; end
% 
% %At the end we finish with a trough
% if max(clx) > max(tlx); clx(clx == max(clx)) = []; cl(clx == max(clx)) = []; end
% if max(ucx) > max(tlx); ucx(ucx == max(ucx)) = []; end
% if max(dcx) > max(tlx); dcx(dcx == max(dcx)) = []; end
% 
% if isempty(clx)||isempty(ucx)||isempty(dcx)||isempty(cl)||isempty(tl)
%     H = 0;
%     L = 0;
% else
%     if fig_switch==1
%         if length(cl) ~= length(tl) || length(cl) ~= length(diff(dcx)) || length(cl) ~= length(diff(dcx))
%             figure(); hold on;
%             plot(ucx,   zeros(size(ucx)), 'k.')
%             plot(dcx,   zeros(size(dcx)), 'b.')
%             plot(tlx, tl, 'r.')
%             plot(clx, cl, 'r.')
%             plot(ucx,   zeros(size(ucx)), 'g.')
%             plot(dcx,   zeros(size(dcx)),  'go')
%             plot(tlx, tl, 'rx')
%             plot(clx, cl, 'rx')
%         end
%     end
%     
%     
%     H = cl - tl;
%     L = diff(dcx);
% end
% 
% Stats.dcx         = dcx;
% Stats.tlx         = tlx;
% Stats.ucx         = ucx;
% Stats.clx         = clx;
% Stats.tl          = tl;
% Stats.cl          = cl;
% Stats.H           = H;
% Stats.L           = L;

end
