function Stats = BDT_Rolien_editKris(x, z, apDetrend, EstBFL, fig_switch) %fig_switch added by Sjoukje

% Adjusted Kris van den Berg 2020/07/02, based on BDT_Roelien.m & BFSL_func.m 
% apDetrend  = P0 = window for moving mean (to determine trend line span) 
% C_ap       = C  = filter span constant for FindCrossings (generally 1/2, 1/3, 1/4, 1/6 (default), 1/10)
% fig_switch = turn on/off figures, 1 = plot, 0 = no plot


    %[x, z_det]                         = Detrend(x, z, x, z);
    %z_det                              = loess_interp(x,z_d,0,x,5,2);
    nullijn                             = movingmean(z,apDetrend,[],2,'Hann'); 
    z_det                               = z-nullijn;
%    deze werkt! [z_filt, upcross, downcross, ap]    = FindCrossings(x, z_det, 0, []);
%     [z_filt, upcross, downcross, ap]    = FindCrossings(x, z_det, 0, 100); %for long bedforms
%     [z_filt, upcross, downcross, ap]    = FindCrossings(x, z_det, 0, 5); %for short bedforms
    [z_filt, upcross, downcross, ap]    = FindCrossings(x, z_det, 0, EstBFL); %for short bedforms

    % 3rd parameter is C, fourth parameter is EstBFL. The higher EstBFL,
    % the larger the smoothing.
    [troughs, crests]                   = FindExtremes(x, z_det, z_filt, upcross, downcross, ap);
    nullijn                             = ones(length(x),1)*mean(z_det);
    Stats                               = CalcBFStats (x, z, z_filt, upcross, downcross, crests, troughs, nullijn);
    Stats.upcrossX    = upcross;
    Stats.downcrossX  = downcross;
    Stats.crestsX     = crests;
    Stats.troughsX    = troughs;
    Stats.MeanLevel   = mean(z);
    Stats.z_det       = z_det;
    Stats.nullijn     = nullijn;
    Stats.z_filt      = z_filt;

    
    
%plot stuff
if fig_switch == 1
%     scrsz = get(0,'ScreenSize');
%     hFigure = figure('Position',[1 scrsz(4)/2 scrsz(3) scrsz(4)/2]);
    hFigure = figure();%'Position',[1 scrsz(4)/2 scrsz(3) scrsz(4)/2]);

    axes();
%     xlabel('X coordinate (m)');
%     ylabel('Bed level (cm)');
    xlabel ('river kilometer (km)')
    ylabel('Bed level (m)');

    hold on; box on;
%     title('Filterlength 1/3 \Lambda')

    dz = mean(z);
    plot(x, z_det+dz,'.-', 'linewidth', 1.5); 
    plot(x, nullijn+dz,'r-','linewidth', 1.5);
    plot(x, z_filt+dz,'m--','linewidth', 1.5); 
    plot(upcross(:,1),   dz,'k^','linewidth', 1.5, 'markerfacecolor', 'k');
    plot(downcross(:,1), dz,'kv', 'linewidth', 1.5, 'markerfacecolor', 'k'); 
    plot(crests(:,1), crests(:,2)+dz,'ko','markersize',7,'linewidth',2);
    plot(troughs(:,1), troughs(:,2)+dz,'ro','markersize',7,'linewidth',2);
    
%     SetFont(gca, 20)
%     paperpositionmode
%     drawnow;
%     saveas(gcf, 'Exp14-1-3-Filt1_3.emf')
    %close gcf
 end
end %additional end added by Sjoukje

function [x, z_det] = Detrend(x, z, x_rb, z_rb)
    fit1    = polyfit(x_rb,z_rb,1); % straight trend line
    z_trend = fit1(1).*x + fit1(2);        
    z_det   = z - z_trend;

    %Center around zero
    N = length(z_det);
    MeanZdet = mean(z_det);
    z_det   = z_det - ones(N,1)*MeanZdet;
    
    figure(); 
    plot(x, z);
    hold on 
    plot(x,z_trend);
    plot(x,z_det);
end
