%version used by Sjoukje (waal)
function Stats = BDT_Rolien(x, z)

    [x, z_det]                       = Detrend(x, z, x, z);
%     [z_filt, upcross, downcross, ap] = FindCrossings(x, z_det, 0, []);
    [z_filt, upcross, downcross, ap] = FindCrossings(x, z_det, 0, 50);
%     [z_filt, upcross, downcross, ap] = FindCrossings(x, z_det, 50, [], 2, 'Hann');
    [troughs, crests]                = FindExtremes(x, z_det, z_filt, upcross, downcross, ap);
    nullijn                          = ones(length(x),1)*mean(z_det);
    Stats                            = CalcBFStats (x, z, z_filt, upcross, downcross, crests, troughs, nullijn);
    Stats.upcrossX    = upcross;
    Stats.downcrossX  = downcross;
    Stats.crestsX     = crests;
    Stats.troughsX    = troughs;
    Stats.MeanLevel   = mean(z);
    Stats.z_det       = z_det;
    Stats.nullijn     = nullijn;
    Stats.z_filt      = z_filt;


%plot stuff
if 0
    scrsz = get(0,'ScreenSize');
    hFigure = figure('Position',[1 scrsz(4)/2 scrsz(3) scrsz(4)/2]);
    axes();
    xlabel('X coordinate (m)');
    ylabel('Bed level (cm)');
    hold on; box on;
    title('Filterlength 1/3 \Lambda')

    dz = mean(z);
    plot(x, z_det+dz,'.-', 'linewidth', 1.5); 
    plot(x, nullijn+dz,'r-','linewidth', 1.5);
    plot(x, z_filt+dz,'m--','linewidth', 1.5); 
    plot(upcross(:,1),   dz,'k^','linewidth', 1.5, 'markerfacecolor', 'k');
    plot(downcross(:,1), dz,'kv', 'linewidth', 1.5, 'markerfacecolor', 'k'); 
    plot(crests(:,1), crests(:,2)+dz,'ko','markersize',7,'linewidth',2);
    plot(troughs(:,1), troughs(:,2)+dz,'ro','markersize',7,'linewidth',2);
    
    %SetFont(gca, 20)
    %paperpositionmode
    drawnow;
    saveas(gcf, 'Exp14-1-3-Filt1_3.emf')
    close gcf
end

end
function [x, z_det] = Detrend(x, z, x_rb, z_rb)
    fit1    = polyfit(x_rb,z_rb,1); % straight trend line
    z_trend = fit1(1).*x + fit1(2);        
    z_det   = z - z_trend;

    %Center around zero
    N = length(z_det);
    MeanZdet = mean(z_det);
    z_det   = z_det - ones(N,1)*MeanZdet;
end
