#IF-------------------------------------------------------------------------------------------------------
import pandas as pd

df_raw_data = pd.read_csv('C:\Data_waterapps\Data_Janina\Raw data and data analysis\data, scripts for analysis, figures\data_(raw_and_preprocessed)\IF_and_rainfall_observations_Tamale_FSapp_entries.csv',sep=';')
df_raw_data = df_raw_data.replace('tie','x')
df_raw_data = df_raw_data[['Date','How many mm did the rain gauge indicate?','scorching_sun','strong_wind_W_E_direction','dark_clouds','bird_sounds','ants_carry_food_to_hole','frogs_squeaking','red_circle_around_moon','dew']]

# Although x indicates an inconsistent amount of data, it is legitimate to turn each x into a 1 because it still means that this indicator was observed.
# All nan values are turned into 0, assuming that no entry means that the indicator could not be found / observed that day

df_raw_data = df_raw_data.replace('x',int(1))
df_raw_data = df_raw_data.replace(np.nan, int(0))
df_raw_data['dew'] = df_raw_data['dew'].replace(1,2).replace(0,1).replace(2,0)
df_raw_data.to_csv('C:/Users/joepb/PycharmProjects/data_storage/raw_indicator_data_janina.csv')
#df_raw_data = df_raw_data.astype(np.float)

df_shorter = df_raw_data[42:]
dew = df_shorter['dew'].replace(1,2).replace(0,1).replace(2,0)
df_shorter['dews'] = dew
df_shorter = df_shorter.drop(columns=['dew'])
df_shorter.to_csv('C:/Data_waterapps/Data_Janina/shortdataset_janina.csv')

#Overall farmer forecast------------------------------------------------------------------------------------------------------------
Janina_FF = pd.read_csv('C:/Data_waterapps/Data_Janina/Tamale_overall_farmer_forecast_janina.csv',sep = ';')
Janina_FF['datetime'] = pd.to_datetime(Janina_FF['datetime'], format = '%d-%m-%Y')
janina_datetime = Janina_FF['datetime']
Janina_FF.fillna(0, inplace=True)
del Janina_FF['datetime']

Janina_FF_altered = pd.DataFrame(index = np.arange(1))
for i in Janina_FF.index:
    if sum(Janina_FF.loc[i, ['low', 'medium', 'high']]) == Janina_FF.loc[i, 'no_rain']:
        if sum(Janina_FF.loc[i, ['low', 'medium', 'high','no_rain']]) == 0:
            Janina_FF_altered[i] = 0
        else:
            Janina_FF_altered[i] = (Janina_FF.loc[i, 'low']*1 + Janina_FF.loc[i, 'medium']*2 + Janina_FF.loc[i, 'high']*3)/ sum(Janina_FF.loc[i,['low','medium','high']])
    if sum(Janina_FF.loc[i,['low','medium','high']]) > Janina_FF.loc[i,'no_rain']:
        Janina_FF_altered[i] = (Janina_FF.loc[i, 'low']*1 + Janina_FF.loc[i, 'medium']*2 + Janina_FF.loc[i, 'high']*3)/ sum(Janina_FF.loc[i,['low','medium','high']])
    if sum(Janina_FF.loc[i, ['low','medium','high']]) < Janina_FF.loc[i, 'no_rain']:
        Janina_FF_altered[i] = 0


Janina_FF_altered = Janina_FF_altered.transpose()
Janina_FF_altered['datetime'] = janina_datetime

Janina_FF_altered.to_csv('C:/Users/joepb/PycharmProjects/data_storage/Farmer_forecast_janina.csv',index=False)

#SF------------------------------------------------------------------------------------------------------------

SF_janina = pd.read_csv('C:/Users/joepb/OneDrive/Documenten/Wageningen - Uni/Master Thesis/Data_analysis/Data_Janina/Raw data and data analysis/data, scripts for analysis, figures/data_(raw_and_preprocessed)/meteoblue_hindcast_Tamale.csv')
del SF_janina['Tamale Temperature [2 m elevation corrected]']
del SF_janina['Tamale Relative Humidity [2 m]']
del SF_janina['Tamale Wind Speed [10 m]']
del SF_janina['Tamale Wind Direction [10 m]']
SF_janina['timestamp'] = pd.to_datetime(SF_janina['timestamp'])

# daily
SF_janina = SF_janina.groupby(pd.Grouper(freq='D', key='timestamp')).sum()
SF_janina.to_csv('C:/Data_waterapps/Data_Janina/SF_janina.csv')
