clc
clear all
close all

V = [2 4 6 8];                         %% applied voltage
E =[1 2 3 4 5 6 7 8 9];                %% Electrode position
A = 0.01 ;                           %% Area of each stack 10cm x 10cm
V = 7*500*0.1*1e-6;                 % Volume of stack m3
l = 0.1;                                % length of stack

                 %%%%%%%% Uncoated Spacers     %%%%%%%% 
%%%%%%%%%      2V           %%%%%%%%%%%%%%%%%%%%%
t1_2801_2V=[33 28.94 29.1 25.7 23.8 24.4 21.8 20.6 18.4]./33; %  trial1 --current in mA
t2_2801_2V=[35 29.4 29.6 26.2 24.4 24.8 22.2 20.8 18.7]./35; % trial 2 -- current in mA
t3_2801_2V=[35 29.5 29.5 26.1 24 24.2 21.6 19.9 17.8]./35;   % trial 3 --- current in mA
t5_0502_2V=[35 29.64 31.2 27.6 25.7 26 23.4 22.7 20.3]./35; % trial 4--current in mA
t6_0502_2V=[35 29.74 31 27.7 25.7 26 23.3 22.7 20.2]./35; % trial 5--current in mA
avg_2V=(t1_2801_2V + t2_2801_2V + t3_2801_2V + t5_0502_2V + t6_0502_2V)./5; %% average of 5 trials 
all_2V= [t1_2801_2V;  t2_2801_2V; t3_2801_2V;t5_0502_2V; t6_0502_2V]; %% average values stored together
SD_2V=(std(all_2V))./sqrt(5).*tinv(1-0.05/2,4);  %% standard deviation

%k_2V = (avg_2V).*(A*V/l);    %% conductivity to concentration
%C_2V = (k_2V.*1e-3./108)-(12.4/108); %% 

%%%%%%%%%%%%%%       4V             %%%%%%%%%%%%
t1_2801_4V=[140 93.8 88.2 58.5 44.2 36.8 25.5 18.0 13.1]./140;     %  trial1 --current in mA
t2_2801_4V=[135 91.3 85.7 56.3 42.2 34.9 23.7 17.1 12.6]./135;    %  trial2 --current in mA
t3_2801_4V =[138 93.8 87.6 57.4 42.7 35.2 23.9 17.3 12.8]./138;    %  trial3 --current in mA
t5_0502_4V=[124 85 79.9 57.3 43.4 36.6 22.5 15.6 12.2]./124;     %  trial4 --current in mA
t6_0502_4V=[126 87 82.1 59.1 44.1 37.3 23.3 17 13.1]./126;    %  trial5 --current in mA

avg_4V=(t1_2801_4V + t2_2801_4V +t3_2801_4V  + t5_0502_4V + t6_0502_4V)./5;   %% average of 5 trials

all_4V= [t1_2801_4V;  t2_2801_4V; t3_2801_4V; t5_0502_4V;t6_0502_4V ];

SD_4V=(std(all_4V))./sqrt(5).*tinv(1-0.05/2,4);

%%%%%%%%%        6V           %%%%%%%%%%%%%%%
t1_2801_6V=[209 124.4 104.6 56.2 35.1 25.1 12.4 7.9 5.9]./209; %trial1 --current in mA
t2_2801_6V=[203 120 98 53.7 32.2 21.9 10.1 6.6 4.6]./203;   %trial2 --current in mA
t3_2801_6V=[203 120 98 53.7 32.2 21.9 10.1 6.6 4.6]./203;   %trial3 --current in mA
t5_0502_6V=[180 111.6 94.8 56.5 34.8 25.4 11.2 8.6 5.7]./180;   %trial4 --current in mA
t6_0502_6V=[178 107.6 90.8 53.7 32.2 22.7 9.6 7.5 4.9]./178;    %trial5 --current in mA

avg_6V=(t1_2801_6V + t2_2801_6V +t3_2801_6V  +t5_0502_6V + t6_0502_6V)./5;    %% average of 5 trials

all_6V= [t1_2801_6V;  t2_2801_6V; t3_2801_6V; t5_0502_6V;t6_0502_6V ];

SD_6V=(std(all_6V))./sqrt(5).*tinv(1-0.05/2,4);

%%%%%%%%%%%%%%            8V               %%%%%%%%%%%%%%
t1_2801_8V=[219 115.1 82 33.5 17.8 10.9 3.3 2.1 2.4]./219;   %trial1 --current in mA
t2_2801_8V=[239 126.7 91.6 38.5 20.1 12.1 3.7 2.2 2.4]./239;   %trial2 --current in mA
t3_2801_8V=[243 128.1 91.9 38.9 20.1 11.9 3.6 2.1 2.4]./243;   %trial3 --current in mA
t5_0502_8V=[230 127.8 99.4 45.6 24 12.8 3 2 2.3]./230;       %trial4 --current in mA
t6_0502_8V=[231 127.5 99 45.4 23.5 12.3 2.8 1.9 2.3]./231;  %trial5 --current in mA


avg_8V=(t1_2801_8V + t2_2801_8V +t3_2801_8V + t5_0502_8V+t6_0502_8V)./5;

all_8V= [t1_2801_8V;  t2_2801_8V; t3_2801_8V; t5_0502_8V;t6_0502_8V ];

SD_8V=(std(all_8V))./sqrt(5).*tinv(1-0.05/2,4);

%%%% Concentrate and Dilute for all voltages measured 4 times each %%%

C2801= [757 1063 1095  1042]./108-12.4/108;
D2801=[334 131.9 104 80.3]./108-12.4/108;

C2801i=[764 1039 1015 1057]./108-12.4/108;
D2801i=[352 115.1 104 88.1]./108-12.4/108;

C0302=[776 1050  1015 1078]./108-12.4/108;
D0302=[334 116.7 104 89]./108-12.4/108;
    
C0502=[828 1023 1015 1073]./108-12.4/108;
D0502=[344 141.6 127 124]./108-12.4/108;

C_avg=[C2801 + C2801i + C0302 + C0502]./4;
D_avg=[D2801 + D2801i + D0302 + D0502]./4;

C=[C2801; C2801i; C0302; C0502];
D=[D2801; D2801i;  D0302; D0502];
SD_C=(std(C))./sqrt(4).*tinv(1-0.05/2,2);
SD_D=(std(D))./sqrt(4).*tinv(1-0.05/2,2);

        %%%%%%%%%%           PSS Coated        %%%%%%         %%%%%
%%% 2V %%
t1_1002_2V=[35 35 30.3 28.9 26.5 25.7 22.2 22.6 21.1]./35;
t2_1002_2V=[33 35 29.3 28.1 25.5 24.1 21.1 21.8 20.3]./33;
t3_1202_2V=[33 34 29 27.7 26.4 25.5 23 23.4 21.5]./33;
t4_1202_2V=[33 33 28.3 27.1 25.9 25.1 22.8 23.2 21.1]./33; 
t5_1802_2V=[35 35 30 27.5 25.9 24.3 21.7 21.8 20.2]./35;

avg_2V_pss=[t1_1002_2V + t2_1002_2V + t3_1202_2V + t4_1202_2V + t5_1802_2V]./5;
    
all_2V_pss=[t1_1002_2V; t2_1002_2V; t3_1202_2V; t4_1202_2V; t5_1802_2V];

SD_2V_pss=(std(all_2V_pss))./sqrt(5).*tinv(1-0.05/2,4);


%%% 4V%%

t1_1002_4V=[118 104 78.2 70.1 55.1 42.9 34.4 30.8 27];
t2_1002_4V=[118 103 77.1 68.8 53.3 41.2 33.5 30.9 26.5];
t3_1202_4V=[122 91 67 64.1 53.4 42.6 30.7 24.9 21.7];
t4_1202_4V=[132 102 72.9 69.9 58.4 47.3 35.7 29.4 25.5];
t5_1802_4V=[122 91 67.6 64.4 57.5 45.8 32.3 24.8 19.7];

avg_4V_pss=[t1_1002_4V + t2_1002_4V + t3_1202_4V + t4_1202_4V + t5_1802_4V]./5;
    
all_4V_pss=[t1_1002_4V; t2_1002_4V; t3_1202_4V; t4_1202_4V; t5_1802_4V];

SD_4V_pss=(std(all_4V_pss))./sqrt(5).*tinv(1-0.05/2,4);

%%%% 6V %%%%
t1_1002_6V=[172 134 93.9 76.5 55.4 36 25.2 19.9 15.8]./172;
t2_1002_6V=[166 130 90.6 73.2 52.4 34 24 19.1 14.3]./166;
t3_1202_6V=[189 119 80.2 72 55.2 39.1 24.3 17 14]./189;
t4_1202_6V=[185 115 78.8 71.2 54.4 37.1 23.1 16.2 13.2]./185;
t5_1802_6V=[201 122 84.6 77 64.6 44.7 26.5 19.1 13.5]./201;

avg_6V_pss=[t1_1002_6V + t2_1002_6V + t3_1202_6V + t4_1202_6V + t5_1802_6V ]./5;
    
all_6V_pss=[t1_1002_6V; t2_1002_6V; t3_1202_6V; t4_1202_6V; t5_1802_6V];

SD_6V_pss=(std(all_6V_pss))./sqrt(5).*tinv(1-0.05/2,4);

%%% 8V %%
t1_1002_8V=[205 149 96.4 73.2 48.6 27 16.5 12.2 9.5]./205;
t2_1002_8V=[205 151 96.8 73.5 48.1 26 16.3 11.3 8.7]./205;
t3_1202_8V=[233 130 81.3 69.7 49.4 29.4 15.3 9.7 7.8]./233;
t4_1202_8V=[245 137 85 73.5 51.2 30.6 16.6 10.1 8.1]./245;
t5_1802_8V=[241 128 83.7 73 58.4 35.6 15.3 13.1 11.5]./241;


avg_8V_pss=[t1_1002_8V + t2_1002_8V + t3_1202_8V + t4_1202_8V + t5_1802_8V]./5;
    
all_8V_pss=[t1_1002_8V; t2_1002_8V; t3_1202_8V; t4_1202_8V; t5_1802_8V];

SD_8V_pss=(std(all_8V_pss))./sqrt(5).*tinv(1-0.05/2,4);

%%%% Concentrate and Dilute- PSS coated %%%

C1002=[814 1063 1154 1141]./112+19.9/112;
D1002=[374 91.3 56.4 47.4]./108-12.4/108;  

C1002i=[790 1051 1086 1134]./112+19.9/112;
D1002i=[365 89.9 56.8 45]./108-12.4/108;

C1202=[777 1007 1144 1124]./112+19.9/112;
D1202=[357 129.3 98.5 89.8]./108-12.4/108;

C1202i=[776 1111 1091 1187]./112+19.9/112;
D1202i=[359 138.3 96.9 97.4]./108-12.4/108;

C_avg_pss=[C1002 + C1002i + C1202 + C1202i]./4;
D_avg_pss=[D1002 + D1002i + D1202 + D1202i]./4;

C_pss=[C1002; C1002i; C1202; C1202i];
D_pss=[D1002; D1002i;  D1202; D1202i];
SD_C_pss=(std(C_pss))./sqrt(4).*tinv(1-0.05/2,2);
SD_D_pss=(std(D_pss))./sqrt(4).*tinv(1-0.05/2,2);


                          %%%%%%%%%% Fitting %%%%%%%%%%%%%%%

  avg = [avg_2V ;avg_4V; avg_6V; avg_8V] ; 
 Markers={'vk','^k','sk','ok'};
 Marker_Counter=1;
                          
for i=1:1:size(avg,1)
 x= 0:0.1:0.8;      %%% length of stack in meter 
X=transpose(x);
Y=transpose(avg(i,:));
tbl = table(X(:),Y(:));
model = @(b,x) b(1) * exp(-b(2)*x(:, 1)) + b(3);  

a0= 1;     % 
b0= 1;
c0 = 0;
parameters = [a0, b0, c0]; 
model = fitnlm(X, Y, model, parameters);

coefficients = model.Coefficients{:, 'Estimate'}

yFitted = coefficients(1) * exp(-coefficients(2)*X) + coefficients(3);


plot(E, Y, Markers{Marker_Counter}, 'MarkerSize', 8);
Marker_Counter=Marker_Counter+1; 

hold on;
plot(E, yFitted,'-k','LineWidth',1);
hold on
set(gca,'FontSize',12)
ylabel('Normalised current [I/I_{0}]')
xlabel('Electrode pair [-]')
xlim([1 9.7])
ylim([0 1])
legend('2V','','4V','','6V','','8V')
end


% figure(2)    %%%% Normalized current for uncoated vs electrode position   %%%%
% errorbar(E,avg_2V,SD_2V,'-vk','MarkerSize',8)
% hold on
% errorbar(E,avg_4V,SD_4V,'^k','MarkerSize',8)
% hold on
% plot(y,x)
% errorbar(E,avg_6V,SD_6V,'-sk','MarkerSize',8)
% hold on
% errorbar(E,avg_8V,SD_8V,'-ok','MarkerSize',8)
% set(gca,'FontSize',12)
% ylabel('Normalised current [I/I_{0}]')
% xlabel('Electrode pair position [-]')
% legend('2V 4V 6V 8V')

%figure(2)  %%%% Normalized current for uncoated, coated vs electrode position   %%%%
%errorbar(E,avg_2V,SD_2V,'-vk','MarkerSize',8)
%hold on
%errorbar(E,avg_4V,SD_4V,'-^k','MarkerSize',8)
%hold on
%errorbar(E,avg_6V,SD_6V,'-sk','MarkerSize',8)
%hold on
%errorbar(E,avg_8V,SD_8V,'-ok','MarkerSize',8)
 %hold on
 %errorbar(E,avg_2V_pss,SD_2V_pss,'vk','MarkerFaceColor','k','MarkerSize',8)
 %hold on
 %errorbar(E,avg_4V_pss,SD_4V_pss,'^k','MarkerFaceColor','k','MarkerSize',8)
 %hold on
%errorbar(E,avg_6V_pss,SD_6V_pss,'sk','MarkerFaceColor','k','MarkerSize',8)
 %hold on
 %errorbar(E,avg_8V_pss,SD_8V_pss,'ok','MarkerFaceColor','k','MarkerSize',8)
% hold on
% % plot(E,LF_2801_2V,'--vb',E,LF_2801_4V,'--^b','MarkerSize',8)
%set(gca,'FontSize',12)
%ylabel('Normalised current [I/I_{0}]')
%xlabel('Electrode pair position [-]')
%xlim([1 9.7])
%ylim([0 1.1])
%legend('2V uncoated','4V uncoated','6V uncoated','8V uncoated','2V PSS-coated','4V PSS-coated','6V PSS-coated','8V PSS-coated')



%figure (3) %%%% Normalized current for coated vs electrode position   %%%%

 %errorbar(E,avg_2V_pss,SD_2V_pss,'--vk','MarkerFaceColor','k','MarkerSize',8)
 %hold on
 %errorbar(E,avg_4V_pss,SD_4V_pss,'--^k','MarkerFaceColor','k','MarkerSize',8)
 %hold on
%errorbar(E,avg_6V_pss,SD_6V_pss,'--sk','MarkerFaceColor','k','MarkerSize',8)
 %hold on
 %errorbar(E,avg_8V_pss,SD_8V_pss,'--ok','MarkerFaceColor','k','MarkerSize',8)
% % hold on
% % plot(E,LF_2801_2V,'--vb',E,LF_2801_4V,'--^b','MarkerSize',8)
%set(gca,'FontSize',12)
%ylabel('Normalised current [I/I_{0}]')
%xlabel('Electrode pair [-]')
%xlim([0 9.7])
%ylim([0 270])
%legend('2V-PSS coated','4V-PSS coated','6V-PSS coated','8V-PSS coated')

