
function Segmented_Calculator_v4()
clc
clear all
close all

V = [2 4 6 8];                         %% applied voltage
E =[1 2 3 4 5 6 7 8 9];                %% Electrode position
A = 0.01 ;                           %% Area of each stack 10cm x 10cm

Vol = 7e-2*500e-6*0.1;   % Volume of segment, 7cm (70% available?) x 500 micron x 10cm converted to m
l = 0.1;   % length of segment

t1_1002_6V=[172 134 93.9 76.5 55.4 36 25.2 19.9 15.8];
t2_1002_6V=[166 130 90.6 73.2 52.4 34 24 19.1 14.3];
t3_1202_6V=[189 119 80.2 72 55.2 39.1 24.3 17 14];
t4_1202_6V=[185 115 78.8 71.2 54.4 37.1 23.1 16.2 13.2];
t5_1802_6V=[201 122 84.6 77 64.6 44.7 26.5 19.1 13.5];
    %trial5 --current in mA
    
t1_1002_4V=[118 104 78.2 70.1 55.1 42.9 34.4 30.8 27];
t2_1002_4V=[118 103 77.1 68.8 53.3 41.2 33.5 30.9 26.5];
t3_1202_4V=[122 91 67 64.1 53.4 42.6 30.7 24.9 21.7];
t4_1202_4V=[132 102 72.9 69.9 58.4 47.3 35.7 29.4 25.5];
t5_1802_4V=[122 91 67.6 64.4 57.5 45.8 32.3 24.8 19.7];


CurrentMatrix = [t1_1002_4V(:) t2_1002_4V(:) t3_1202_4V(:) t4_1202_4V(:) t5_1802_4V(:)];
Avg_Segmented = mean(CurrentMatrix')
Std_Segmented = std(CurrentMatrix')
StdError_Segmented = Std_Segmented/sqrt(5);
CI_exp = StdError_Segmented*tinv(1-0.05/2,4);
x = linspace(0,0.9);
[betas resnorm res exitflag output lambda jac] = lsqcurvefit(@currentFit,[50 1],x,Avg_Segmented);

Lseg = 10e-2;
Nseg = 9;
Ltot = Lseg*Nseg;
Imax = betas(1);
b = betas(2)

%CurrentLocal = Imax*exp(-b*x/Ltot);
% in exponential form, the discontinuity in current doesn't matter
% this is the distribution along the electrode though, the value in the
% solution is a bit different since the membrane can conduct current
CurrentLocal = Imax*exp(-b*x/Ltot);
xToInterp = [0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9];
% I = Imax*exp(-b*x)

% measurements are average of I over 10cm segments
IntegralCurrent = cumtrapz(x,CurrentLocal);
IntegralCurrentSegments = interp1(x,IntegralCurrent,xToInterp);
Avg_Current = (IntegralCurrentSegments(2:end)-IntegralCurrentSegments(1:end-1))/(0.1);
CalculatedCurrents = Avg_Current;

figure (1)

bar([1 2 3 4 5 6 7 8 9],[Avg_Segmented],1)
xlim([0.5 9.5])
ylim([0 250])
hold on
er=errorbar([1 2 3 4 5 6 7 8 9],Avg_Segmented,CI_exp);
er.Color = [0 0 0];                            
er.LineStyle = 'none';  
hold off
xlabel('Segment No.')
ylabel('Avg. Current Density (A/m^2)')
%plot(xToInterp(2:end)-0.05,Avg_Current,'^k')
figure (2)
x1 =x(1:12)
Cur1 = CurrentLocal(1:12)
x2 = x(12:23)+.5/100
Cur2 = CurrentLocal(12:23)
x3 = x(23:34)+2*.5/100
Cur3 = CurrentLocal(23:34)
x4 = x(34:45)+3*.5/100
Cur4 = CurrentLocal(34:45)
x5 = x(45:56)+4*.5/100
Cur5 = CurrentLocal(45:56)
x6 = x(56:67)+5*.5/100
Cur6 = CurrentLocal(56:67)
x7 = x(67:78)+6*.5/100
Cur7 = CurrentLocal(67:78)
x8 = x(78:89)+7*.5/100
Cur8 = CurrentLocal(78:89)
x9 = x(89:100)+8*.5/100
Cur9 = CurrentLocal(89:100)

plot(x1,Cur1,'-k',x2,Cur2,'-k',x3,Cur3,'-k',x4,Cur4,'-k',x5,Cur5,'-k',x6,Cur6,'-k',x7,Cur7,'-k',x8,Cur8,'-k',x9,Cur9,'-k')
ylim([0 250])
xlabel('x-position (m)')
ylabel('Local Current Density (A/m^2)')
CI_betas = nlparci(betas,res,'jacobian',jac)
figure(3)
normplot(res)

function F = currentFit(betas,x)
Lseg = 10e-2;
Nseg = 9;
Ltot = Lseg*Nseg;
Imax = betas(1);
b = betas(2)
CurrentLocal = Imax*exp(-b*x/Ltot);
xToInterp = [0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9];
% I = Imax*exp(-b*x)

% measurements are average of I over 10cm segments
IntegralCurrent = cumtrapz(x,CurrentLocal);
IntegralCurrentSegments = interp1(x,IntegralCurrent,xToInterp);
Avg_Current = (IntegralCurrentSegments(2:end)-IntegralCurrentSegments(1:end-1))/(0.1);
F = Avg_Current;




