function Segmented_Calculator_v3()
clc
clear all
close all

V = [2 4 6 8];                         %% applied voltage
E =[1 2 3 4 5 6 7 8 9];                %% Electrode position
A = 0.01 ;                           %% Area of each stack 10cm x 10cm

Vol = 7e-2*500e-6*0.1;   % Volume of segment, 7cm (70% available?) x 500 micron x 10cm converted to m
l = 0.1;   % length of segment

%%% Uncoated spacers %%%

t1_2801_2V=[33 28.94 29.1 25.7 23.8 24.4 21.8 20.6 18.4]; %  trial1 --current in mA
t2_2801_2V=[35 29.4 29.6 26.2 24.4 24.8 22.2 20.8 18.7]; % trial 2 -- current in mA
t3_2801_2V=[35 29.5 29.5 26.1 24 24.2 21.6 19.9 17.8];   % trial 3 --- current in mA
t5_0502_2V=[35 29.64 31.2 27.6 25.7 26 23.4 22.7 20.3]; % trial 4--current in mA
t6_0502_2V=[35 29.74 31 27.7 25.7 26 23.3 22.7 20.2]; % trial 5--current in mA
%%%4V%%%%
t1_2801_4V=[140 93.8 88.2 58.5 44.2 36.8 25.5 18.0 13.1];     %  trial1 --current in mA
t2_2801_4V=[135 91.3 85.7 56.3 42.2 34.9 23.7 17.1 12.6];    %  trial2 --current in mA
t3_2801_4V =[138 93.8 87.6 57.4 42.7 35.2 23.9 17.3 12.8];    %  trial3 --current in mA
t5_0502_4V=[124 85 79.9 57.3 43.4 36.6 22.5 15.6 12.2];     %  trial4 --current in mA
t6_0502_4V=[126 87 82.1 59.1 44.1 37.3 23.3 17 13.1];    %  trial5 --current in mA

%%%6V%%%%
t1_2801_6V=[209 124.4 104.6 56.2 35.1 25.1 12.4 7.9 5.9]; %trial1 --current in mA
t2_2801_6V=[203 120 98 53.7 32.2 21.9 10.1 6.6 4.6];   %trial2 --current in mA
t3_2801_6V=[203 120 98 53.7 32.2 21.9 10.1 6.6 4.6];   %trial3 --current in mA
t5_0502_6V=[180 111.6 94.8 56.5 34.8 25.4 11.2 8.6 5.7];   %trial4 --current in mA
t6_0502_6V=[178 107.6 90.8 53.7 32.2 22.7 9.6 7.5 4.9];    %trial5 --current in mA
%%%% 8V %%%
   
t1_2801_8V=[219 115.1 82 33.5 17.8 10.9 3.3 2.1 2.4];   %trial1 --current in mA
t2_2801_8V=[239 126.7 91.6 38.5 20.1 12.1 3.7 2.2 2.4];   %trial2 --current in mA
t3_2801_8V=[243 128.1 91.9 38.9 20.1 11.9 3.6 2.1 2.4];   %trial3 --current in mA
t5_0502_8V=[230 127.8 99.4 45.6 24 12.8 3 2 2.3];       %trial4 --current in mA
t6_0502_8V=[231 127.5 99 45.4 23.5 12.3 2.8 1.9 2.3];  %trial5 --current in mA


%%%%% Coated %%%%%
%%2V
t1_1002_2V=[35 35 30.3 28.9 26.5 25.7 22.2 22.6 21.1];
t2_1002_2V=[33 35 29.3 28.1 25.5 24.1 21.1 21.8 20.3];
t3_1202_2V=[33 34 29 27.7 26.4 25.5 23 23.4 21.5];
t4_1202_2V=[33 33 28.3 27.1 25.9 25.1 22.8 23.2 21.1]; 
t5_1802_2V=[35 35 30 27.5 25.9 24.3 21.7 21.8 20.2];

%%% 4V%%

t1_1002_4V=[118 104 78.2 70.1 55.1 42.9 34.4 30.8 27];
t2_1002_4V=[118 103 77.1 68.8 53.3 41.2 33.5 30.9 26.5];
t3_1202_4V=[122 91 67 64.1 53.4 42.6 30.7 24.9 21.7];
t4_1202_4V=[132 102 72.9 69.9 58.4 47.3 35.7 29.4 25.5];
t5_1802_4V=[122 91 67.6 64.4 57.5 45.8 32.3 24.8 19.7];
%%% 6V%%
t1_1002_6V=[172 134 93.9 76.5 55.4 36 25.2 19.9 15.8];
t2_1002_6V=[166 130 90.6 73.2 52.4 34 24 19.1 14.3];
t3_1202_6V=[189 119 80.2 72 55.2 39.1 24.3 17 14];
t4_1202_6V=[185 115 78.8 71.2 54.4 37.1 23.1 16.2 13.2];
t5_1802_6V=[201 122 84.6 77 64.6 44.7 26.5 19.1 13.5];

%%% 8V %%
t1_1002_8V=[205 149 96.4 73.2 48.6 27 16.5 12.2 9.5];
t2_1002_8V=[205 151 96.8 73.5 48.1 26 16.3 11.3 8.7];
t3_1202_8V=[233 130 81.3 69.7 49.4 29.4 15.3 9.7 7.8];
t4_1202_8V=[245 137 85 73.5 51.2 30.6 16.6 10.1 8.1];
t5_1802_8V=[241 128 83.7 73 58.4 35.6 15.3 13.1 11.5];

%CurrentMatrix = [t1_2801_6V(:) t2_2801_6V(:) t3_2801_6V(:) t5_0502_6V(:) t6_0502_6V(:)]; %% uncoated
CurrentMatrix = [t1_1002_2V(:) t2_1002_2V(:) t3_1202_2V(:) t4_1202_2V(:) t5_1802_2V(:)] %%% coated %%%
Avg_Segmented = mean(CurrentMatrix')
Std_Segmented = std(CurrentMatrix')
StdError_Segmented = Std_Segmented/sqrt(5);
CI_exp = StdError_Segmented*tinv(1-0.05/2,4);
x = linspace(0,0.9);
[betas resnorm res exitflag output lambda jac] = lsqcurvefit(@currentFit,[50 1],x,Avg_Segmented);

Lseg = 10e-2;
Nseg = 9;
Ltot = Lseg*Nseg;
Imax = betas(1)
b = betas(2)

%CurrentLocal = Imax*exp(-b*x/Ltot);
% in exponential form, the discontinuity in current doesn't matter
% this is the distribution along the electrode though, the value in the
% solution is a bit different since the membrane can conduct current
CurrentLocal = Imax*exp(-b*x/Ltot);
xToInterp = [0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9];
% I = Imax*exp(-b*x)

% measurements are average of I over 10cm segments
IntegralCurrent = cumtrapz(x,CurrentLocal);
IntegralCurrentSegments = interp1(x,IntegralCurrent,xToInterp);
Avg_Current = (IntegralCurrentSegments(2:end)-IntegralCurrentSegments(1:end-1))/(0.1);
CalculatedCurrents = Avg_Current;
figure (1)
bar([1 2 3 4 5 6 7 8 9],[Avg_Segmented],1)
xlim([0.5 9.5])
ylim([0 250])
hold on
er=errorbar([1 2 3 4 5 6 7 8 9],Avg_Segmented,CI_exp);
er.Color = [0 0 0];                            
er.LineStyle = 'none';  
hold off
xlabel('Segment No.')
ylabel('Avg. Current Density (A/m^2)')
plot(xToInterp(2:end)-0.05,Avg_Current,'^k')
figure (2)
x1 =x(1:12);
Cur1 = CurrentLocal(1:12);
x2 = x(12:23)+.5/100;
Cur2 = CurrentLocal(12:23);
x3 = x(23:34)+2*.5/100;
Cur3 = CurrentLocal(23:34);
x4 = x(34:45)+3*.5/100;
Cur4 = CurrentLocal(34:45);
x5 = x(45:56)+4*.5/100;
Cur5 = CurrentLocal(45:56);
x6 = x(56:67)+5*.5/100;
Cur6 = CurrentLocal(56:67);
x7 = x(67:78)+6*.5/100;
Cur7 = CurrentLocal(67:78);
x8 = x(78:89)+7*.5/100;
Cur8 = CurrentLocal(78:89);
x9 = x(89:100)+8*.5/100;
Cur9 = CurrentLocal(89:100);

plot(x1,Cur1,'-k',x2,Cur2,'-k',x3,Cur3,'-k',x4,Cur4,'-k',x5,Cur5,'-k',x6,Cur6,'-k',x7,Cur7,'-k',x8,Cur8,'-k',x9,Cur9,'-k')
ylim([0 350])
hold on
plot(xToInterp(2:end)-0.05,Avg_Current,'^k')
xlabel('x-position (m)')
ylabel('Local Current Density (A/m^2)')
CI_betas = nlparci(betas,res,'jacobian',jac)
figure(3)
normplot(res)
X1 = [x1 x2 x3 x4 x5 x6 x7 x8 x9]

function F = currentFit(betas,x)
Lseg = 10e-2;
Nseg = 9;
Ltot = Lseg*Nseg;
Imax = betas(1);
b = betas(2)
CurrentLocal = Imax*exp(-b*x/Ltot);
xToInterp = [0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9];
% I = Imax*exp(-b*x)

% measurements are average of I over 10cm segments
IntegralCurrent = cumtrapz(x,CurrentLocal);
IntegralCurrentSegments = interp1(x,IntegralCurrent,xToInterp);
Avg_Current = (IntegralCurrentSegments(2:end)-IntegralCurrentSegments(1:end-1))/(0.1);
F = Avg_Current;




