clc
clear all
close all

V = [2 4 6 8];                         %% applied voltage
E =[1 2 3 4 5 6 7 8 9];                %% Electrode position
A = 0.01 ;                           %% Area of each stack 10cm x 10cm
V = 7*500*0.1*1e-6;                 % Volume of stack m3
l = 0.1;                                % length of stack

                 %%%%%%%% Uncoated Spacers     %%%%%%%% 
%%%%%%%%%      2V           %%%%%%%%%%%%%%%%%%%%%
t1_1002_2V=[35 35 30.3 28.9 26.5 25.7 22.2 22.6 21.1]./35;
t2_1002_2V=[33 35 29.3 28.1 25.5 24.1 21.1 21.8 20.3]./33;

t3_1202_2V=[33 34 29 27.7 26.4 25.5 23 23.4 21.5]./33;
t4_1202_2V=[33 33 28.3 27.1 25.9 25.1 22.8 23.2 21.1]./33; 
t5_1802_2V=[35 35 30 27.5 25.9 24.3 21.7 21.8 20.2]./35;

avg_2V_pss=[t1_1002_2V + t2_1002_2V + t3_1202_2V + t4_1202_2V + t5_1802_2V]./5;
    
all_2V_pss=[t1_1002_2V; t2_1002_2V; t3_1202_2V; t4_1202_2V; t5_1802_2V];

SD_2V_pss=(std(all_2V_pss))./sqrt(5).*tinv(1-0.05/2,4);


%k_2V = (avg_2V).*(A*V/l);    %% conductivity to concentration
%C_2V = (k_2V.*1e-3./108)-(12.4/108); %% 

%%%%%%%%%%%%%%       4V             %%%%%%%%%%%%
t1_1002_4V=[118 104 78.2 70.1 55.1 42.9 34.4 30.8 27]./118;
t2_1002_4V=[118 103 77.1 68.8 53.3 41.2 33.5 30.9 26.5]./118;
t3_1202_4V=[122 91 67 64.1 53.4 42.6 30.7 24.9 21.7]./122;
t4_1202_4V=[132 102 72.9 69.9 58.4 47.3 35.7 29.4 25.5]./132;
t5_1802_4V=[122 91 67.6 64.4 57.5 45.8 32.3 24.8 19.7]./122;

avg_4V_pss=[t1_1002_4V + t2_1002_4V + t3_1202_4V + t4_1202_4V + t5_1802_4V]./5;
    
all_4V_pss=[t1_1002_4V; t2_1002_4V; t3_1202_4V; t4_1202_4V; t5_1802_4V];

SD_4V_pss=(std(all_4V_pss))./sqrt(5).*tinv(1-0.05/2,4);
%%%%%%%%%        6V           %%%%%%%%%%%%%%%
t1_1002_6V=[172 134 93.9 76.5 55.4 36 25.2 19.9 15.8]./172;
t2_1002_6V=[166 130 90.6 73.2 52.4 34 24 19.1 14.3]./166;
t3_1202_6V=[189 119 80.2 72 55.2 39.1 24.3 17 14]./189;
t4_1202_6V=[185 115 78.8 71.2 54.4 37.1 23.1 16.2 13.2]./185;
t5_1802_6V=[201 122 84.6 77 64.6 44.7 26.5 19.1 13.5]./201;

avg_6V_pss=[t1_1002_6V + t2_1002_6V + t3_1202_6V + t4_1202_6V + t5_1802_6V ]./5;
    
all_6V_pss=[t1_1002_6V; t2_1002_6V; t3_1202_6V; t4_1202_6V; t5_1802_6V];

SD_6V_pss=(std(all_6V_pss))./sqrt(5).*tinv(1-0.05/2,4);
%%%%%%%%%%%%%%            8V               %%%%%%%%%%%%%%
t1_1002_8V=[205 149 96.4 73.2 48.6 27 16.5 12.2 9.5]./205;
t2_1002_8V=[205 151 96.8 73.5 48.1 26 16.3 11.3 8.7]./205;
t3_1202_8V=[233 130 81.3 69.7 49.4 29.4 15.3 9.7 7.8]./233;
t4_1202_8V=[245 137 85 73.5 51.2 30.6 16.6 10.1 8.1]./245;
t5_1802_8V=[241 128 83.7 73 58.4 35.6 15.3 13.1 11.5]./241;


avg_8V_pss=[t1_1002_8V + t2_1002_8V + t3_1202_8V + t4_1202_8V + t5_1802_8V]./5;
    
all_8V_pss=[t1_1002_8V; t2_1002_8V; t3_1202_8V; t4_1202_8V; t5_1802_8V];

SD_8V_pss=(std(all_8V_pss))./sqrt(5).*tinv(1-0.05/2,4);

avg = [avg_2V_pss ;avg_4V_pss; avg_6V_pss; avg_8V_pss] ; 
 Markers={'vk','^k','sk','ok'};
 Marker_Counter=1;
                          
for i=1:1:size(avg,1)
 x = linspace(0,0.9);
[betas resnorm res exitflag output lambda jac] = lsqcurvefit(@currentFit,[50 1],x,Avg_Segmented);

Lseg = 10e-2;
Nseg = 9;
Ltot = Lseg*Nseg;
Imax = betas(1);
b = betas(2)

plot(E, Y, Markers{Marker_Counter},'MarkerSize', 8);
Marker_Counter=Marker_Counter+1; 

hold on;
plot(E, yFitted,'-k','LineWidth',1);
hold on
set(gca,'FontSize',12)
ylabel('Normalised current [I/I_{0}]')
xlabel('Electrode pair [-]')
xlim([1 9.7])
ylim([0 1.1])
legend('2V','','4V','','6V','','8V')
end


% figure(2)    %%%% Normalized current for uncoated vs electrode position   %%%%
% errorbar(E,avg_2V,SD_2V,'-vk','MarkerSize',8)
% hold on
% errorbar(E,avg_4V,SD_4V,'^k','MarkerSize',8)
% hold on
% plot(y,x)
% errorbar(E,avg_6V,SD_6V,'-sk','MarkerSize',8)
% hold on
% errorbar(E,avg_8V,SD_8V,'-ok','MarkerSize',8)
% set(gca,'FontSize',12)
% ylabel('Normalised current [I/I_{0}]')
% xlabel('Electrode pair position [-]')
% legend('2V 4V 6V 8V')

%figure(2)  %%%% Normalized current for uncoated, coated vs electrode position   %%%%
%errorbar(E,avg_2V,SD_2V,'-vk','MarkerSize',8)
%hold on
%errorbar(E,avg_4V,SD_4V,'-^k','MarkerSize',8)
%hold on
%errorbar(E,avg_6V,SD_6V,'-sk','MarkerSize',8)
%hold on
%errorbar(E,avg_8V,SD_8V,'-ok','MarkerSize',8)
 %hold on
 %errorbar(E,avg_2V_pss,SD_2V_pss,'vk','MarkerFaceColor','k','MarkerSize',8)
 %hold on
 %errorbar(E,avg_4V_pss,SD_4V_pss,'^k','MarkerFaceColor','k','MarkerSize',8)
 %hold on
%errorbar(E,avg_6V_pss,SD_6V_pss,'sk','MarkerFaceColor','k','MarkerSize',8)
 %hold on
 %errorbar(E,avg_8V_pss,SD_8V_pss,'ok','MarkerFaceColor','k','MarkerSize',8)
% hold on
% % plot(E,LF_2801_2V,'--vb',E,LF_2801_4V,'--^b','MarkerSize',8)
%set(gca,'FontSize',12)
%ylabel('Normalised current [I/I_{0}]')
%xlabel('Electrode pair position [-]')
%xlim([1 9.7])
%ylim([0 1.1])
%legend('2V uncoated','4V uncoated','6V uncoated','8V uncoated','2V PSS-coated','4V PSS-coated','6V PSS-coated','8V PSS-coated')



%figure (3) %%%% Normalized current for coated vs electrode position   %%%%

 %errorbar(E,avg_2V_pss,SD_2V_pss,'--vk','MarkerFaceColor','k','MarkerSize',8)
 %hold on
 %errorbar(E,avg_4V_pss,SD_4V_pss,'--^k','MarkerFaceColor','k','MarkerSize',8)
 %hold on
%errorbar(E,avg_6V_pss,SD_6V_pss,'--sk','MarkerFaceColor','k','MarkerSize',8)
 %hold on
 %errorbar(E,avg_8V_pss,SD_8V_pss,'--ok','MarkerFaceColor','k','MarkerSize',8)
% % hold on
% % plot(E,LF_2801_2V,'--vb',E,LF_2801_4V,'--^b','MarkerSize',8)
%set(gca,'FontSize',12)
%ylabel('Normalised current [I/I_{0}]')
%xlabel('Electrode pair [-]')
%xlim([0 9.7])
%ylim([0 270])
%legend('2V-PSS coated','4V-PSS coated','6V-PSS coated','8V-PSS coated')

