%-------------------
%GENERAL INFORMATION
%-------------------

% 1. Dataset title: Supporting data belonging to publication entitled 
% "A study of the near wake deformation of the X-Rotor vertical-axis wind turbine with pitched blades"

% 2. Authorship: 
    % Name: David Bensason 
    % Institution: Delft University of Technology 
    % Email: d.y.bensason@tudelft.nl
    % ORCID: 0000-0002-0590-1524

%-------------------
% DESCRIPTION
%-------------------

% This is a README file for an experimental data repository
% on 4TU DOI: 10.22541/au.170664317.75532826/v1. The data concerns the
% experimental results presented in the manuscript titled " A study of the
% near wake deflection of the X-Rotor vertical-axis wind turbine with
% pitched blades". 
% 

% Two zip folders are provided entitled "Stitched_flow.zip" and
% "Stiched_flow_std.zip". Furthermore, the simulated X-Rotor results are
% presented in "cactus_lab_scale_definitive.mat". Finnaly, the polar data
% from simulated on XFOIL for the NACA0021 blade at Re = 15x10^4 is
% provided in the excel file "NACA_0021_single_1p5e5.xlsx". 
 
%% Description of Stitched_flow.zip
%{
 
This zip folder includes data structures of the stitched flowfields at each
cross-stream and blade pitch setting combination. The cross-stream location
with respect to the turbine tower is reported in mm units. For example, the
file entitled "Pitch_0_x_600.mat" has the stitched flowfield data for the
blade pitch setting of 0 at a cross-stream location 600mm (0.4D) from the
tower center. 
 
When loading the mat structure using load(Pitch_0_x_600.mat), it will load
a structure named "concat_data" of a 801x801 matrix. The definition of the entries of this
structure is as follows: 
 
concat_data.x; % streamwise coordinate by R
concat_data.y; % lateral coordinate by R
concat_data.z; % axial coordinate by R
concat_data.Ux; % streamwise flow normalized by Uinf
concat_data.Uy; % lateral flow normalized by Uinf
concat_data.Uz; % axial flow normalized by Uinf
concat_data.vortx; % out-of-plane vorticity
concat_data.induction;  %Rotor induction (Ux-1)/Uinf
concat_data.v_du_dy; %Lateral momentum budget terms(-dUx/dy *
Uy)
concat_data.w_du_dz; %Axial momentum budget terms(-dUx/dz *
Uz)

NOTE, FOR THE x/D = 0.9 (x=1350mm), the additional data is available

concat_data.TI ; % Standard deviation magntiude 
concat_data.std_Ux ; % Normalized standard deviation of streamwise flow
concat_data.std_Uy ; % Normalized standard deviation of latteral flow
concat_data.std_Uz ; % Normalized standard deviation of axial flow
concat_data.Rxy ; % Reynolds stress xy (dimensional [m/s]^2)
concat_data.Rxz; % Reynolds stress xz (dimensional [m/s]^2)
%}
    

%% Description of the Stiched_flow_std.zip
%{
 
This zip folder includes data structures of the standard deviations of terms 
for the stitched flowfields at each
cross-stream and blade pitch setting combination. The cross-stream location
with respect to the turbine tower is reported in mm units. For example, the
file entitled "Pitch_0_x_600_std.mat" has the stitched flowfield data for the
blade pitch setting of 0 at a cross-stream location 600mm (0.4D) from the
tower center. The standard deviation reported is with respect to that of the 
mean from an average of 120 phase-locked measurements.  
 
When loading the mat structure using load(Pitch_0_x_600_std.mat), it will load
a structure named "concat_data" of a 801x801 matrix. The definition to the entries of this
structure is as follows: 
 
concat_data.x; % streamwise coordinate by R
concat_data.y; % lateral coordinate by R
concat_data.z; % axial coordinate by R
concat_data.Ux;  % standard deviation in streamwise flow normalized by Uinf
concat_data.Uy ; % standard deviation in lateral flow normalized by Uinf
concat_data.Uz; % standard deviation in axial flow normalized by Uinf
concat_data.TI; % normalized standard deviation magnitude (sqrt(UX^2 + UY^2 + UZ^2))

% Note, that for the x/D = 0.9 plane (x=1350mm), this data is contained in
the aforementioned data structure.
%}
%% Description of cactus_lab_scale_definitive.mat
 
%{
 
This mat file includes a data structure for the simulated results of the X-Rotor 
using CACTUS.
 
When loading the mat structure using load(cactus_lab_scale_definitive.mat), it will load
a structure named "cactus" of a 801x801 matrix. The definition of the entries of this
structure is as follows: 
 
Azimuth - azimuth of the blade elements. 0 azimuth is the start of the upwind cycle 
AoA - Angle of attack of blade elements
ZCoord - the axial coordinate of the blade elements (rotation axis is oriented with Z axis in simulation)
NormalForce - Normal force of blade elements
TangentialForce - tangential force of blade elements
Ur - Relative velocity of blade elements
Span - Location of blade element along the span
Radius - radius of rotation of blade element
El_len - blade element length
Induction_U - Streamwise induction by the blade element
Induction_V - Lateral induction by the blade element
Induction_W - Axial induction by the blade element
CP - Power coefficient of the rotor normalized by 0.5*rho*Uinf^3*turbine_frontal_area
CT - Thrust coefficient of the rotor normalized by 0.5*rho*Uinf^2*turbine_frontal_area*rotor_radius
Span_coordinate - Specifies positive value of span for upper blades and negative values for lower blades
Fx, Fy - Forces by blade element in streamwise and lateral directions
UpperMask - logical mask to obtain upper blade elements
VA - cone angle of upper and lower blade elements
Torque - torque of blade elements
Thrust - thrust of blade elements
NormalMom - Normal moment of blade elements
TorqueUpper - Blade integrated torque of the upper blade
TorqueLower - Blade integrated torque of the lower blade
ThrustUpper - Blade integrated thrust of the upper blade
ThrustLower - Blade integrated thrust of the lower blade
NormalMomUpper - Blade integrated normal moment of the upper blade
NormalMomLower - Blade integrated normal moment of the lower blade
TangentialForceUpper - Blade integrated tangential force of the upper blade
TangentialForceLower - Blade integrated tangential force of the lower blade
NormalForceUpper - Blade integrated normal force of the upper blade
NormalForceLower - Blade integrated normal force of the lower blade
InductionWUpper - Blade integrated axial induction of the upper blade
InductionWLower - Blade integrated axial induction of the lower blade
RotorThrust_x - Dimensional rotor streamwise thrust
RotorThrust_y - Dimensional rotor lateral thrust
 
 
For entries unique to the pitch case, indexing of the structure is as
follows: 
cactus(i,1).*; - Pitch -10
cactus(i,2).*; - Pitch 0
cactus(i,3).*; - Pitch 10
Where * can be an entry in the structure, for example, AoA
%}

%% Description of the XFOIL simulated NACA0021 polar

% A static polar for the NACA0021 blade is simulated using XFOIL. The excel
% file NACA_0021_single_1p5e5.xlsx contains three columns, namley (i) angle
% of attack (ii) lift coefficient (CL) and drag coefficient (CD).