# Measurement program Kun Zuo & Vincent Mourik
# Last updated: May 2012

# We use this script for transport measurements, both DC and AC,
# as a function of 1 or 2 other variables. Its well suited to measure 
# with 1 or 2 Keithleys and/or 1 or 2 Lockins in 2 or 4 terminal geometries.
# If you are a first time user, we recommend scrolling down to the 
# 'initialization' part of the script, we put some usefull comments there.
# Comments/improvements are appreciated.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.



from numpy import pi, random, arange, size, array, sin, cos, tan, arcsin,arccos,arctan2, linspace, sinc, sqrt, log10, power, abs, matrix, radians
from time import time, sleep
from shutil import copyfile
from os import mkdir
from os.path import exists
from lib.file_support.spyview import SpyView

import qt
import timetrack
import sys
import numpy as np
import data as d
import traces
import shutil
import os
import time
import math

keithley1 = qt.instruments.get('keithley1')
keithley2 = qt.instruments.get('keithley2')
keithley3 = qt.instruments.get('keithley3')
lockin1 = qt.instruments.get('lockin1')
lockin2 = qt.instruments.get('lockin2')
#lockin3 = qt.instruments.get('lockin3')
ivvi = qt.instruments.get('ivvi')
magnet  = qt.instruments.get('magnet')
#AMI430 = qt.instruments.get('AMI430')
#kepco = qt.instruments.get('kepco')
#OxfordMK3 = qt.instruments.get('OxfordMK3')
#mw = qt.instruments.get('mw')



    
class majorana():
    
    # Function generates data file, spyview file and copies the pyton script.
    def create_data(self,x_vector,x_coordinate,x_parameter,y_vector,y_coordinate,y_parameter,z_vector,z_coordinate,z_parameter):
        self.filename=filename
        self.generator=d.IncrementalGenerator(qt.config['datadir']+'\\'+filename,1);
        qt.Data.set_filename_generator(self.generator)
        data = qt.Data(name=self.filename)
        print "Current filename: "+self.filename
        '''
        multiplier = eval('multiplier'+x_parameter)
        if xmultiplier == 0.01:
            unitmultiplier = 1e-3
        elseif == 1e-3:
            unitmultiplier = 1e-6
        else:
            unitmultiplier = 1
        
        x
        '''
        data.add_coordinate(x_parameter+' ('+x_coordinate+')',
                            size=len(x_vector),
                            start=x_vector[0],
                            end=x_vector[-1]) 
        data.add_coordinate(y_parameter+' ('+y_coordinate+')',
                            size=len(y_vector),
                            start=y_vector[0],
                            end=y_vector[-1]) 
        data.add_coordinate(z_parameter+' ('+z_coordinate+')',
                            size=len(z_vector),
                            start=z_vector[0],
                            end=z_vector[-1])
        data.add_value('processed data Keithley1')          # Processed data Keithley 1
        data.add_value('processed data Keithley2')          # Processed data Keithley 2
        data.add_value('processed data Keithley3')
        data.add_value('processed data Lockin1')            # Processed data Lockin 1
        data.add_value('processed data Lockin2')            # Processed data Lockin 2
        data.add_value('processed data Lockin3')
        data.add_value('Keithley 1')                        # Read out of Keithley 1
        data.add_value('Keithley 2')                        # Read out of Keithley 2
        data.add_value('Keithley 3')
        data.add_value('R Lockin 1')                        # Read out of R Lockin 1 
        data.add_value('Theta Lockin 1')                    # Read out of Theta Lockin 1
        data.add_value('R Lockin 2')                        # Read out of R Lockin 2
        data.add_value('Theta Lockin 2')                    # Read out of Theta Lockin 2
        data.add_value('R lockin 3')
        data.add_value('Theta Lockin 3')
        data.add_value('Mixing Chamber')                    # Fridge temperature
        data.create_file()                                  # Create data file
        SpyView(data).write_meta_file()                     # Create the spyview meta.txt file
        traces.copy_script(sys._getframe().f_code.co_filename,data._dir,filename+'_'+str(self.generator._counter-1))           # Copy the python script into the data folder
        return data

    def AutoSensPerLineInit(self): # Initialize Lockin1Readings and Lockin2Readings as empty arrays
        self.Lockin1Readings = []
        self.Lockin2Readings = []
        self.Lockin3Readings = []

    def AutoSensPerLineAddValue(self,datavalues): # Record raw lockin measurements of the current linescan in Lockin1Readings and Lockin2Readings
        if AutoSensPerLine:
            if Nlockins == 3:
                self.Lockin1Readings.append(datavalues[9])
                self.Lockin2Readings.append(datavalues[11])
                self.Lockin3Readings.append(datavalues[13])
            else:
                self.Lockin1Readings.append(datavalues[9])
                if Nlockins == 2:
                    self.Lockin2Readings.append(datavalues[11])

    def AutoSensPerLineSetSens(self,output=1): # Find maximum of current linescan, find appropriate value for the sensitivity and set the lockin(s) to this sensitivity.
        if AutoSensPerLine:
            loc1 = self.Lockin1Readings
            loc2 = self.Lockin2Readings
            sens1=lockin1.get_sensitivity()
            FullScaleList = [2e-9,5e-9,1e-8,2e-8,5e-8,1e-7,2e-7,5e-7,1e-6,2e-6,5e-6,1e-5,2e-5,5e-5,1e-4,2e-4,5e-4,1e-3,2e-3,5e-3,1e-2,2e-2,5e-2,1e-1,2e-1,5e-1,1]
            TauList = [1e-5,3e-5,1e-4,3e-4,1e-3,3e-3,1e-2,3e-2,1e-1,3e-1,1,3,1e1,3e1,1e2,3e2,1e3,3e3,1e4,3e4]
            a=TauList[1]
            bndinc = 0.7
            bnddec = 0.2
            loc1max = max(abs(loc1))
            RelToFullScaleList1=[loc1max/FullScaleList[x] for x in xrange(len(FullScaleList))]
            try:
                SensOpt1=min([i for i in xrange(len(FullScaleList)) if RelToFullScaleList1[i]<bndinc])
            except(ValueError):
                SensOpt1 = sens1
            if SensOpt1 != sens1:
                lockin1.set_sensitivity(SensOpt1)
                qt.msleep(10*TauList[lockin1.get_tau()])
                if output==1: print 'Sensitivity lockin1 changed from {:d} to {:d}'.format(sens1,SensOpt1)
            if Nlockins == 2:
                sens2=lockin2.get_sensitivity()
                loc2max = max(abs(loc2))
                RelToFullScaleList2=[loc2max/FullScaleList[x] for x in xrange(len(FullScaleList))]
                try:
                    SensOpt2=min([i for i in xrange(len(FullScaleList)) if RelToFullScaleList2[i]<bndinc])
                except(ValueError):
                    SensOpt2 = sens2
                if SensOpt2 != sens2:
                    lockin2.set_sensitivity(SensOpt2)
                    qt.msleep(10*TauList[lockin2.get_tau()])
                    if output==1: print 'Sensitivity lockin2 changed from {:d} to {:d}'.format(sens2,SensOpt2)

    def set_sensitivity(self,dac='dac1',val=560,output=1):
        self.AutoSensPerLineInit()
        self.AutoSensPerLineAddValue(self.take_data('dac1',val))
        self.AutoSensPerLineSetSens(output=output)
    
    #Function to read the gate leakage current using Keithley2 and compare it to a set limit. If the leakage exceeds the set limit, the dac is sweeped to zero to prevent damage. The measurement is stopped. (Added by Jouri)
    # def gateleakage_exit(self,limit,timedelay=1.0,offset=0.30,amp=1,dacx='dac3',output=0):
    def gateleakage_exit(self,limit,timedelay=1.0,offset=+1.529,amp=0.1,dacx='dac3',output=0):
        if leak_exit == 1:
            leakage = (keithley3.get_readlastval()*1e3+offset)*amp #Gives leakage in nA. amp=0.1 for Rs=10M or amp=1 when using HV monitor (1uA/V)
            if abs(leakage) > limit:
                time.sleep(timedelay)       #Wait for leakage to settle to prevent the contribution of the displacement current setting of the exit procedure.
                leakage = (keithley3.get_readlastval()*1e3+offset)*amp
                if abs(leakage) > limit:
                    print('Gate leakage exceeds set limit of {:.2f} nA: I = {:.2f} nA at {:s}={:.1f}'.format(limit,leakage,dacx,ivvi.get(dacx)))
                    print('Setting '+dacx+' to zero and stopping measurement')
                    ivvi.set(dacx,0)
                    sys.exit()
            if output == 1: print('I = {:.2f} nA at {:s}={:.1f}'.format(leakage,dacx,ivvi.get(dacx)))

    #Sweep a dac in steps and check if gate leakage stays below set limit.
    # def set_dac_safe(self,value,dacx='dac3',limit='default',offset=0.30,amp=1,output=1):
    def set_dac_safe(self,value,dacx='dac3',limit='default',offset=+1.529,amp=0.1,output=1):
        """ Set dacx to value while monitoring the leakage current. If it exceeds limit, sweep is stopped and dacx is set to zero.
        Units of variables: limit (nA), offset (mV), amp (nA/mV)
        """
        if leak_exit != 1: print('The parameter leak_exit is not set to 1. Gate leakage is not monitored by using m.set_dac_safe!')
        if limit=='default': limit = leaklimit
        self.gateleakage_exit(limit,offset=offset,amp=amp,dacx=dacx)
        start=ivvi.get(dacx)
        steps = math.ceil(abs(value-start)/5)+1
        dacs=np.linspace(start,value,steps)
        for x in dacs:
            ivvi.set(dacx,x)
            self.gateleakage_exit(limit,offset=offset,amp=amp,dacx=dacx,output=output)
        if output!=0:
            time.sleep(3)
            leakage = (keithley3.get_readlastval()*1e3+offset)*amp
            print('End of sweep: I = {:.2f} nA at {:s}={:.1f}'.format(leakage,dacx,ivvi.get(dacx)))

    # Function reads out relevant data
    def take_data(self,dacx,x):
        
        ivvi.set(dacx,x)                                                            # Set specified dac to specified value, has to be done here because of delays needed for Lockin measurements
        
        self.gateleakage_exit(leaklimit,output=0)
        if 'dacs' in globals(): dacs.set_coupled_dacs()

        if Nkeithleys == 0:
            
            if Nlockins == 0:
                print 'Why are you using this function if you dont want to read out any Keithley or Lockin...'
                qt.msleep(3.0)
                sys.exit()
            
            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                RL1 = lockin1.get_X()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                datavalues = [0,0,0,valueL1,0,0,0,0,0,RL1,thetaL1,0,0,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                RL1 = lockin1.get_X()                                                   # Read out Lockin1
                thetaL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                RL2 = lockin2.get_X()                                                   # Read out Lockin2
                thetaL2 = lockin2.get_Y()                                               # Read out theta Lockin2
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (RL2/GainL2)/(amplitude2/sqrt(2)-(RL2/GainL2)*RsL2)           # Process data Lockin2
                datavalues = [0,0,0,valueL1,valueL2,0,0,0,0,RL1,thetaL1,RL2,thetaL2,0,0]
                qt.msleep(0.01)
        
        elif Nkeithleys == 1:
            
            if Nlockins == 0:
                qt.msleep(delay2)
                K1 = keithley1.get_readnextval()                                        # Read out Keithley1            
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                datavalues = [valueK1,0,0,0,0,0,K1,0,0,0,0,0,0,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                RL1 = lockin1.get_X()                                                   # Read out R Lockin1
                SENSL1 = lockin1.get_sensitivity()                                      # Read out sensitivity of Lockin1
                thetaL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1

                RL2 = lockin1.get_R()
                valueL1_R = (RL2/GainL1)/(amplitude1/sqrt(2)-(RL2/GainL1)*RsL1)           # Process data Lockin1
                Tmc  =magnet.get_MCTemp()
                #Tmc = 0
                datavalues = [valueK1,0,0,valueL1,valueL1_R,0,K1,0,RL1,RL2,thetaL1,0,0,0, float(Tmc)]
                
                qt.msleep(0.01)
            
            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                RL1 = lockin1.get_X()                                                   # Read out Lockin1
                thetaL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                RL2 = lockin2.get_X()                                                   # Read out Lockin2
                thetaL2 = lockin2.get_Y()                                               # Read out theta Lockin2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (RL2/GainL2)/(amplitude2/sqrt(2)-(RL2/GainL2)*RsL2)           # Process data Lockin2value = (L1/GainL1)*(GainL2/L2)                                      # Process the data
                datavalues = [valueK1,0,0,valueL1,valueL2,0,K1,0,0,RL1,thetaL1,RL2,thetaL2,0,0]
                qt.msleep(0.01)
            
        elif Nkeithleys == 2:
            
            if Nlockins == 0:
                qt.msleep(delay2)
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                datavalues = [valueK1,valueK2,0,0,0,0,K1,K2,0,0,0,0,0,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                RL1 = lockin1.get_X()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1) 
                Tmc  = magnet.get_MCTemp()          # Process data Lockin1
                datavalues = [valueK1,valueK2,0,valueL1,0,0,K1,K2,0,RL1,thetaL1,0,0,0,float(Tmc)]
                qt.msleep(0.01)
            
            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                RL1 = lockin1.get_X()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                RL2 = lockin2.get_X()                                                   # Read out R Lockin2
                thetaL2 = lockin2.get_Y()                                               # Read out theta Lockin2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (RL2/GainL2)/(amplitude2/sqrt(2)-(RL2/GainL2)*RsL2)           # Process data Lockin2
                datavalues = [valueK1,valueK2,0,valueL1,valueL2,0,K1,K2,0,RL1,thetaL1,RL2,thetaL2,0,0]
                if SynchronizedLockins == 1:
                    Rfil = 2080 + 814
                    RsL_1 = 1.0e4*Vrange + Rfil
                    RsL1_2 = 2.0e3 + GainK1*1.0e-3 + Rfil
                    RsL2_2 = 2.0e3 + GainK2*1.0e-3 + Rfil
                    valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-((RL1/GainL1+RL2/GainL2)*RsL_1)-RL1/GainL1*RsL1_2)    # Process data Lockin1
                    valueL2 = (RL2/GainL2)/(amplitude1/sqrt(2)-((RL1/GainL1+RL2/GainL2)*RsL_1)-RL2/GainL2*RsL2_2)    # Process data Lockin2
                    datavalues = [valueK1,valueK2,0,valueL1,valueL2,0,K1,K2,0,RL1,thetaL1,RL2,thetaL2,0,0]
                    #print(valueL1*12906,valueL2*12906)
                    #print(lockin1.get_amplitude()*(Vrange*1e-2*sqrt(2)),lockin2.get_amplitude()*(Vrange*1e-2*sqrt(2)))
                    #print(amplitude1,amplitude2)
                if NonlocalV == 1:
                    Rnl = (RL2/GainL2-RL1/GainL1*RsL1) / (RL1/GainL1)   #Nonlocal resistance: Rnl = Vnl / Iloc (Vnl is corrected for the series resistance of the local current)
                    datavalues = [valueK1,valueK2,0,valueL1,Rnl,0,K1,K2,0,RL1,thetaL1,RL2,thetaL2,0,0]
                if SynchronizedLockins == 1 and NonlocalV == 1: print('Both SynchronizedLockins=1 and NonlocalV=1. Defition for valueL2 for nonlocal voltage is used now!')
                qt.msleep(0.01)

        elif Nkeithleys == 3:
            
            if Nlockins == 0:
                qt.msleep(delay2)
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                K3 = keithley3.get_readlastval()                                        # Read out Keithley3
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueK3 = K3/GainK3                                                     # Process data Keithley3
                datavalues = [valueK1,valueK2,valueK3,0,0,0,K1,K2,K3,0,0,0,0,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                K3 = keithley3.get_readlastval()                                        # Read out Keithley3
                RL1 = lockin1.get_X()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_phase()                                               # Read out theta Lockin1
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueK3 = K3/GainK3                                                     # Process data Keithley3
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                datavalues = [valueK1,valueK2,valueK3,valueL1,0,0,K1,K2,K3,RL1,thetaL1,0,0,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()
                K3 = keithley3.get_readlastval()                                     # Read out Keithley2
                RL1 = lockin1.get_X()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                RL2 = lockin2.get_X()                                                   # Read out R Lockin2
                thetaL2 = lockin2.get_Y()                                               # Read out theta Lockin2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2
                valueK3 = K3/GainK3                                                     # Process data Keithley2
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (RL2/GainL2)/(amplitude2/sqrt(2)-(RL2/GainL2)*RsL2)           # Process data Lockin2
                datavalues = [valueK1,valueK2,valueK3,valueL1,valueL2,0,K1,K2,K3,RL1,thetaL1,RL2,thetaL2,0,0]
                if SynchronizedLockins == 1:
                    Rfil = 2080 + 814
                    RsL_1 = 1.0e4*Vrange + Rfil
                    RsL1_2 = 2.0e3 + GainK1*1.0e-3 + Rfil
                    RsL2_2 = 2.0e3 + GainK2*1.0e-3 + Rfil
                    valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-((RL1/GainL1+RL2/GainL2)*RsL_1)-RL1/GainL1*RsL1_2)    # Process data Lockin1
                    valueL2 = (RL2/GainL2)/(amplitude1/sqrt(2)-((RL1/GainL1+RL2/GainL2)*RsL_1)-RL2/GainL2*RsL2_2)    # Process data Lockin2
                    datavalues = [valueK1,valueK2,valueK3,valueL1,valueL2,0,K1,K2,K3,RL1,thetaL1,RL2,thetaL2,0,0]
                    #print(valueL1*12906,valueL2*12906)
                    #print(lockin1.get_amplitude()*(Vrange*1e-2*sqrt(2)),lockin2.get_amplitude()*(Vrange*1e-2*sqrt(2)))
                    #print(amplitude1,amplitude2)
                if NonlocalV == 1:
                    Rnl = (RL2/GainL2-RL1/GainL1*RsL1) / (RL1/GainL1)   #Nonlocal resistance: Rnl = Vnl / Iloc (Vnl is corrected for the series resistance of the local current)
                    datavalues = [valueK1,valueK2,valueK3,valueL1,Rnl,0,K1,K2,K3,RL1,thetaL1,RL2,thetaL2,0,0]
                if SynchronizedLockins == 1 and NonlocalV == 1: print('Both SynchronizedLockins=1 and NonlocalV=1. Defition for valueL2 for nonlocal voltage is used now!')
                qt.msleep(0.01)

            elif Nlockins == 3:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                K3 = keithley3.get_readlastval()                                        # Read out Keithley3
                RL1 = lockin1.get_X()
                #RL1 = lockin1.get_X()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_Y()    
                #thetaL1 = lockin1.get_Y()                                            # Read out theta Lockin1
                RL2 = lockin2.get_X()  
                #RL2 = lockin2.get_X()                                                   # Read out R Lockin2
                thetaL2 = lockin2.get_Y() 
                #thetaL2 = lockin2.get_Y()                                               # Read out theta Lockin2                                              # Read out theta Lockin2
                RL3 = lockin3.get_X()  
                #RL3 = lockin3.get_X()                                                  # Read out R Lockin3
                thetaL3 = lockin3.get_Y()  
                #thetaL3 = lockin3.get_Y()                                             # Read out theta Lockin3
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueK3 = K3/GainK3                                                     # Process data Keithley3
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (RL2/GainL2)/(amplitude2/sqrt(2)-(RL2/GainL2)*RsL2)           # Process data Lockin2
                valueL3 = (RL3/GainL3)/(amplitude3/sqrt(2)-(RL3/GainL3)*RsL3)           # Process data Lockin3
                datavalues = [valueK1,valueK2,valueK3,valueL1,valueL2,valueL3,K1,K2,K3,RL1,thetaL1,RL2,thetaL2,RL3,thetaL3]
                if SynchronizedLockins == 1:
                    Rfil = 2080 + 814
                    RsL_1 = 1.0e4*Vrange + Rfil
                    RsL1_2 = 2.0e3 + GainK1*1.0e-3 + Rfil
                    RsL2_2 = 2.0e3 + GainK2*1.0e-3 + Rfil
                    RsL3_2 = 2.0e3 + GainK3*1.0e-3 + Rfil
                    valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-((RL1/GainL1+RL2/GainL2+RL3/GainL3)*RsL_1)-(RL1/GainL1)*RsL1_2)    # Process data Lockin1
                    valueL2 = (RL2/GainL2)/(amplitude1/sqrt(2)-((RL1/GainL1+RL2/GainL2+RL3/GainL3)*RsL_1)-(RL2/GainL2)*RsL2_2)    # Process data Lockin2
                    valueL3 = (RL3/GainL3)/(amplitude1/sqrt(2)-((RL1/GainL1+RL2/GainL2+RL3/GainL3)*RsL_1)-(RL3/GainL3)*RsL3_2)           # Process data Lockin3
                    datavalues = [valueK1,valueK2,valueK3,valueL1,valueL2,valueL3,K1,K2,K3,RL1,thetaL1,RL2,thetaL2,RL3,thetaL3]
                    #print(valueL1*12906,valueL2*12906)
                    #print(lockin1.get_amplitude()*(Vrange*1e-2*sqrt(2)),lockin2.get_amplitude()*(Vrange*1e-2*sqrt(2)))
                    #print(amplitude1,amplitude2)
                if NonlocalV == 1:
                    Rnl = (RL2/GainL2-RL1/GainL1*RsL1) / (RL1/GainL1)   #Nonlocal resistance: Rnl = Vnl / Iloc (Vnl is corrected for the series resistance of the local current)
                    datavalues = [valueK1,valueK2,valueK3,valueL1,Rnl,valueL3,K1,K2,K3,RL1,thetaL1,RL2,thetaL2,RL3,thetaL3]
                if SynchronizedLockins == 1 and NonlocalV == 1: print('Both SynchronizedLockins=1 and NonlocalV=1. Defition for valueL2 for nonlocal voltage is used now!')
                qt.msleep(0.01)
            
        else:
            print 'You try to run a too complicated experiment...'
            qt.msleep(3.0)
            sys.exit()
        
        return datavalues
        qt.msleep(0.01)                                                              # Keep GUI responsive
            
    ################ 1D SCANS #####################    
    # Monitor instruments without sweeping dacs (useful for looking for noise/interference)
    def _no_dac_sweep(self,xname,dacx,xstart,xend,xsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                # create data file, spyview metafile, copy script
        
        #ivvi.set(dacx,x_vector[0])
        qt.msleep(delay1)
        
        for x in x_vector:
            qt.msleep(delay2)
            K1 = keithley1.get_readnextval()                                        # Read out Keithley1            
            valueK1 = K1/GainK1                                                     # Process data Keithley1
            datavalues = [valueK1,0,0,0,K1,0,0,0,0,0]
            qt.msleep(0.01)                                                                                                # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
        
        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # 1D sweep of a single dac
    def _single_dac_sweep(self,xname,dacx,xstart,xend,xsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                # create data file, spyview metafile, copy script
        
        ivvi.set(dacx,x_vector[0])
        qt.msleep(delay1)

        
        
        for x in x_vector:
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            #T_mc = self.read_T()
            T_mc = 0
            datavalues.append(T_mc)                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],datavalues[10],datavalues[11],T_mc, 0, 0 ,0)                               # write datapoint into datafile
            #data.add_data_point(x,0,0,*datavalues)
        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    # Repeatedly sweep a single dac n times, n = repetions
    def _repeat_single_dac_sweep(self,xname,dacx,xstart,xend,xsteps,repetions):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(1,repetions,repetions)                                                                                              # this sweep variable is defined to enable 2D plotting in spyview
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'n','repetions',z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script
        
        counter = 0
        
        for i in arange(repetions):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,repetions,counter)                                                                                # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()    
    
    # 1D sweep of 2 dac's simultaneously; sweep vectors can have arbitrary start and end values.
    def _2dacs_sweep(self,xname,dacx,xstart,xend,mname,dacm,mstart,mend,steps):
        qt.mstart()
                
        # Create sweep vectors
        x_vector = linspace(xstart,xend,steps+1)
        y_vector = [0]
        z_vector = linspace(mstart,mend,steps+1)
        #z_vector = [0]
        
        #data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script
        #data = self.create_data(x_vector,xname,dacx,y_vector,mname,dacm,z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,mname,dacm)                               # create data file, spyview metafile, copy script
        
        # Define sweep vector for other dac
        m_vector = linspace(mstart,mend,steps+1)
        
        for i in arange(len(x_vector)):
            x = x_vector[i]
            m = m_vector[i]
            ivvi.set(dacm,m)                                                                                                                    # Other dac needs to be set before running take_data
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            datavalues.append(T_mc)                                                                                                                # Read out mixing chamber temperature
            # data.add_data_point(x,0,m,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
            data.add_data_point(x,0,m,*datavalues)
        
        data.new_block()
        data._write_settings_file()
        data.close_file()
        qt.mend()

    # 1D sweep of 3 dac's simultaneously; sweep vectors can have arbitrary start and end values.
    def _3dacs_sweep(self,xname,dacx,xstart,xend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,steps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,steps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script
        
        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,steps+1)
        n_vector = linspace(nstart,nend,steps+1)
        
        for i in arange(len(x_vector)):
            x = x_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            ivvi.set(dacm,m)                                                                                                                    # Other dacs needs to be set before running take_data
            ivvi.set(dacn,n)
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            datavalues.append(T_mc)
            #data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
            data.add_data_point(x,m,n,*datavalues)

        data.new_block()
        data._write_settings_file()
        data.close_file()
        qt.mend()

    # 1D sweep of 3 dac's simultaneously; sweep vectors can have arbitrary start and end values.
    def _3dacs_sweep_vector(self,xname,dacx,x_vector,mname,dacm,m_vector,nname,dacn,n_vector):
        qt.mstart()
        
        # Create sweep vectors
        #x_vector = linspace(xstart,xend,steps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script
        
        for i in arange(len(x_vector)):
            x = x_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            ivvi.set(dacx,x)
            ivvi.set(dacm,m)                                                                                                                    # Other dacs needs to be set before running take_data
            ivvi.set(dacn,n)
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
        
        data.new_block()
        data._write_settings_file()
        data.close_file()
        qt.mend()    
    
    # 1D sweep of 4 dac's simultaneously; sweep vectors can have arbitrary start and end values.
    def _4dacs_sweep(self,xname,dacx,xstart,xend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,pname,dacp,pstart,pend,steps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,steps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script
        
        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,steps+1)
        n_vector = linspace(nstart,nend,steps+1)
        p_vector = linspace(pstart,pend,steps+1)
        
        for i in arange(len(x_vector)):
            x = x_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            p = p_vector[i]
            ivvi.set(dacm,m)                                                                                                                    # Other dacs needs to be set before running take_data
            ivvi.set(dacn,n)
            ivvi.set(dacp,p)
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
        
        data.new_block()
        data._write_settings_file()
        data.close_file()
        qt.mend()
    
    # 1D sweep of 11 dacs, all together, same range
    def _11_dacs_sweep(self,xname,dacx,yname,dacy,zname,dacz,kname,dack,lname,dacl,mname,dacm,nname,dacn,oname,daco,pname,dacp,qname,dacq,rname,dacr,xstart,xend,xsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                # create data file, spyview metafile, copy script
        
        for x in x_vector:
            ivvi.set(dacy,x)
            ivvi.set(dacz,x)
            ivvi.set(dack,x)
            ivvi.set(dacl,x)
            ivvi.set(dacm,x)
            ivvi.set(dacn,x)
            ivvi.set(daco,x)
            ivvi.set(dacp,x)
            ivvi.set(dacq,x)
            ivvi.set(dacr,x)
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
        
        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    
    #################### 2D SCANS ####################
    # 2D scan of one dac vs another one
    def _dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script
        
        counter = 0
        
        for y in y_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            ivvi.set(dacy,y)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            #T_mc = 0
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            if setG != 0:
                dac1 = ivvi.get_dac1()
                ivvi.set_dac1(setG_bias)
                self.set_transmission(Gset,'dac4',1)
                if setG == 2:
                    self.set_transmission(Gset,'dac5',2)
                ivvi.set_dac1(dac1)
                #set_transmission(self,Gset,dacx,lockin,limits=[],tol=0.005,exc=50e-6):
            
            self.AutoSensPerLineInit()
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)
                datavalues.append(T_mc)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,*datavalues)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)

            self.AutoSensPerLineSetSens()

            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # Scan dac vs dac where xstart and xend vary linearly while stepping along y. xstart and xend should be entered as an array/tuple of two elements, eg: xstart = (xstart@ystart,xstart@yend))
    # 25/7/17: Written by Jouri, not yet tested in qtlab.
    def _dac_vs_dac_diag(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()
        
        # Create sweep vectors
        # x_vector = linspace(xstart,xend,xsteps+1)
        x_vector = range(xsteps)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]
        
        xstarts = np.linspace(xstart[0],xstart,[1],ysteps+1)
        xends = np.linspace(xend[0],xend,[1],ysteps+1)

        data = self.create_data(x_vector,'index','none',y_vector,yname,dacy,z_vector,xname,dacx)                                          # create data file, spyview metafile, copy script
        
        counter = 0
        
        for i,y in enumerate(y_vector):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()

            x_vector = linspace(xstarts[i],xends[i],xsteps)
            ivvi.set(dacy,y)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            # T_mc = 0
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            self.AutoSensPerLineInit()
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)
                datavalues.append(T_mc)                                                                                             # Go to next sweep value and take data
                data.add_data_point(i,y,x,*datavalues)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)

            self.AutoSensPerLineSetSens()

            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # 2D scan of one dac vs another dac. Range of first dac (bias) is corrected after every ysweep to keep the voltage range over the device constant by correcting for the series resistance.
    def _dac_vs_dac_subseries(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps,dacval=1500,exc=20e-6):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'Vdac1',dacx)                                          # create data file, spyview metafile, copy script
        
        counter = 0
        self.amplitude = amplitude1
        if Nlockins == 2: print('Nlockins=2! This function is written for use with only one lockin.')
        
        for y in y_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()

            #Set excitation to exc to measure point at start of scan
            #global amplitude1
            amplitude1 = exc
            if amplitude1/(Vrange*1e-2*sqrt(2)) > 2: print('Excitation voltage exceeds 2V on ISO-AMP IN (possible clipping problem)')
            lockin1.set_amplitude(amplitude1/(Vrange*1e-2*sqrt(2))); sens1 = lockin1.get_sensitivity(); lockin1.set_sensitivity(18)
            qt.msleep(delay1)
            self.set_sensitivity(val=-dacval,output=0)

            datavalues = max(self.take_data(dacx,-dacval),self.take_data(dacx,dacval))
            I1 = datavalues[0]
            G1 = datavalues[2]
            Vstart = xstart*(1+G1*RsL1)
            Vend = xend*(1+G1*RsL1)
            V_vector = linspace(Vstart,Vend,xsteps+1)
            amplitude1 = self.amplitude*(1+G1*RsL1)
            print(amplitude1)

            #Set the lockin amplitude and reset sensitivity
            lockin1.set_amplitude(amplitude1/(Vrange*1e-2*sqrt(2))); lockin1.set_sensitivity(sens1)

            ivvi.set(dacy,y)
            ivvi.set(dacx,Vstart)
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            self.AutoSensPerLineInit()
            
            for i,x in enumerate(x_vector):
                datavalues = self.take_data(dacx,V_vector[i])                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,V_vector[i],datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)

            self.AutoSensPerLineSetSens()

            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        global amplitude1
        print(amplitude1)
        amplitude1 = self.amplitude
        print(amplitude1)
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # added by onder 2015.05
    # 2D scan of 2 dacs vs another one
    # swept dac values (dacx and dacx2) are the same!
    def _2dacs_vs_dac(self,x1name,dacx1,x1start,x1end,x2name,dacx2,x2start,x2end,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()
        
        # Create sweep vectors
        x1_vector = linspace(x1start,x1end,xsteps+1)
        x2_vector = linspace(x2start,x2end,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]
        
        #data = self.create_data(x1_vector,x1name,dacx1,x2_vector,x2name,dacx2,y_vector,yname,dacy)                                          # create data file, spyview metafile, copy script
        data = self.create_data(x1_vector,x1name,dacx1,y_vector,yname,dacy,x2_vector,x2name,dacx2)                                          # create data file, spyview metafile, copy script

        counter = 0
        
        for y in y_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            ivvi.set(dacy,y)
            ivvi.set(dacx1,x1_vector[0])
            ivvi.set(dacx2,x2_vector[0])#line modified by Jouri  
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            
            if AutoSensIncrease:
                self.sens_check_increase(lockin1.get_sensitivity(),lockin1.get_X())
                self.sens_check_increase(lockin2.get_sensitivity(),lockin2.get_X())
            if AutoSensDecrease:
                self.sens_check_decrease(lockin1.get_sensitivity(),lockin1.get_X())
                self.sens_check_decrease(lockin2.get_sensitivity(),lockin2.get_X())
            
            
            self.AutoSensPerLineInit()
            for i in range(len(x1_vector)):
                x1=x1_vector[i]
                x2=x2_vector[i]
                ivvi.set(dacx1,x1)
                ivvi.set(dacx2,x2)
                datavalues = self.take_data(dacx1,x1)#line modified by Jouri                                                                                             # Go to next sweep value and take data
                # data.add_data_point(x1,y,x2,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
                datavalues.append(T_mc)                                                                                                                # Read out mixing chamber temperature
                data.add_data_point(x1,y,x2,*datavalues)
                self.AutoSensPerLineAddValue(datavalues)

            self.AutoSensPerLineSetSens()
            
            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    # 2D scan of one dac vs 2 others; the 2 dacs that are stepped together can have arbitrary start and end values
    def _dac_vs_2dacs(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,ymsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymsteps+1)
        z_vector = [0]
        # Define sweep vector for other dac
        m_vector = linspace(mstart,mend,ymsteps+1)
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,m_vector,mname,dacm)                                          # create data file, spyview metafile, copy script
        
        
        
        counter = 0
        
        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            # Set transmission, i.e. compensate gate to keep out of gap conductance constant
            if setG != 0:
                dac1 = ivvi.get_dac1()
                ivvi.set_dac1(setG_bias)
                self.set_transmission(Gset,'dac4',1)
                if setG == 2:
                    self.set_transmission(Gset,'dac5',2)
                ivvi.set_dac1(dac1)
            
            self.AutoSensPerLineInit()
            for x in x_vector:
                datavalues = self.take_data(dacx,x)
                datavalues.append(T_mc)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,m,*datavalues)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)

            self.AutoSensPerLineSetSens()
            
            timetrack.remainingtime(starttime,ymsteps+1,counter)                                                                                # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    # Added by Jouri to use manually defined y_vector and m_vector
    def _dac_vs_2dacs_vector(self,xname,dacx,xstart,xend,xsteps,yname,dacy,y_vector,mname,dacm,m_vector):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = y_vector
        z_vector = [0]
        # Define sweep vector for other dac
        m_vector = m_vector
        ymsteps = len(y_vector)

        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,m_vector,mname,dacm)                                          # create data file, spyview metafile, copy script
        
        counter = 0
        
        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            self.AutoSensPerLineInit()
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,m,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)
            
            self.AutoSensPerLineSetSens()

            timetrack.remainingtime(starttime,ymsteps+1,counter)                                                                                # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    # 2D scan of one dac vs 3 others; the 3 dacs that are stepped together can have arbitrary start and end values
    def _dac_vs_3dacs(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,ymnsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymnsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script
        
        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,ymnsteps+1)
        n_vector = linspace(nstart,nend,ymnsteps+1)
        
        counter = 0
        
        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacn,n)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            self.AutoSensPerLineInit()
            for x in x_vector:
                datavalues = self.take_data(dacx,x)
                datavalues.append(n)                                                                                             # Go to next sweep value and take data
                #data.add_data_point(x,y,m,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc) 
                data.add_data_point(x,y,m,n,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],datavalues[10],datavalues[11],datavalues[12],datavalues[13],T_mc)
                #data.add_data_point(x,y,m,n,*datavalues)                          # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)
            self.AutoSensPerLineSetSens()

            timetrack.remainingtime(starttime,ymnsteps+1,counter)                                                                               # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    # 2D scan of one dac vs 3 others; the 3 dacs that are stepped together can have arbitrary start and end values
    def _dac_vs_3dacs_vector(self,xname,dacx,xstart,xend,xsteps,  yname,dacy,y_vector,  mname,dacm,m_vector,  nname,dacn,n_vector):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        #y_vector = linspace(ystart,yend,ymnsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script
        
        ymnsteps = len(y_vector)

        # Define sweep vector for other dacs
        #m_vector = linspace(mstart,mend,ymnsteps+1)
        #n_vector = linspace(nstart,nend,ymnsteps+1)
        
        counter = 0
        
        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacn,n)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            self.AutoSensPerLineInit()
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)
            self.AutoSensPerLineSetSens()

            timetrack.remainingtime(starttime,ymnsteps+1,counter)                                                                               # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # 2D scan of one dac vs 4 others; the 4 dacs that are stepped together can have arbitrary start and end values
    def _dac_vs_4dacs(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,pname,dacp,pstart,pend,ymnpsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymnpsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script
        
        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,ymnpsteps+1)
        n_vector = linspace(nstart,nend,ymnpsteps+1)
        p_vector = linspace(pstart,pend,ymnpsteps+1)
        
        counter = 0
        
        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            p = p_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacn,n)
            ivvi.set(dacp,p)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,ymnpsteps+1,counter)                                                                              # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # 2D scan of one dac vs another one n times repeated, n = repetions
    def _repeat_dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps,repetions):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = linspace(1,repetions,repetions)
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'n','repetions')                                               # create data file, spyview metafile, copy script
        
        counter = 0
        numloops = repetions*(ysteps+1)
        
        for i in arange(repetions):
            ivvi.set(dacy,y[0])
            ivvi.set(dacx,x[0])

            for y in y_vector:
                [starttime, counter] = timetrack.start(counter)
                tstart = timetrack.time()
                ivvi.set(dacy,y)
                ivvi.set(dacx,x[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature 
                qt.msleep(delay1)                                                                                                               # use explained at the bottom of the script

                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile
            
                timetrack.remainingtime(starttime,numloops,counter)                                                                             # Calculate and print remaining scantime
                data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # 2D scan, every sweep consists of 2 times a dac sweep (first one from start to end of the sweep vector, 2nd one backwards from end to start of the sweep vector), this is done as a function of another dac.
    def _fwdbwd_dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]        
        
        data_fwd = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script for fwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction of sweep vector to ensure proper spyview metafile
        data_bwd = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script for bwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction sweep vector back to original

        counter = 0

        for y in y_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            ivvi.set(y_parameter,y)
            
            
            for data_loop in (data_fwd, data_bwd):
                
                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
                qt.msleep(delay1)
                
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                    data_loop.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                      # write datapoint into datafile
                    
                data_loop.new_block()
                
                # Toggle forward / backward by reversing vector
                x_vector = x_vector[::-1]

            tstop = timetrack.time()
            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            
        for data_loop in (data_fwd, data_bwd):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()
            
        qt.mend()


    ############### 3D scans ########################
    # 3D scan of one dac vs another dac vs another dac
    def _dac_vs_dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps,zname,dacz,zstart,zend,zsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = linspace(zstart,zend,zsteps+1)
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,zname,dacz)                                                    # create data file, spyview metafile, copy script
        
        counter = 0
        numloops = (zsteps+1)*(ysteps+1)
        
        for z in z_vector:
            ivvi.set(dacz,z)
            
            for y in y_vector:
                [starttime, counter] = timetrack.start(counter)
                tstart = timetrack.time()
                ivvi.set(dacy,y)
                ivvi.set(dacx,x[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature 
                qt.msleep(delay1)                                                                                                               # use explained at the bottom of the script
            
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data.add_data_point(x,y,z,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile
            
                timetrack.remainingtime(starttime,numloops,counter)                                                                             # Calculate and print remaining scantime
                data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    ############### SCANS INVOLVING OTHER EQUIPMENT (MAGNET SUPPLY, RF SOURCE) #################    
    # To scan a dac as a function of B
    def _dac_vs_magnet(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script
        
        counter = 0
        
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                       # Sets B field
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)
                datavalues.append(T_mc)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,*datavalues)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    # To scan a dac as a function of B 
    def _dac_vs_1dac_and_magnet(self,xname,dacx,xstart,xend,xsteps,yname,dacy,dacy_zeroB,dacy_mvperT,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        y_vector = linspace(dacy_zeroB+Bstart*dacy_mvperT,dacy_zeroB+Bend*dacy_mvperT,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script
        
        counter = 0
        
        for i in arange(len(B_vector)):
            B = B_vector[i]
            y = y_vector[i]
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                      # Sets B field
            ivvi.set(dacy,y)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    # To scan a dac as a function of B and simultaneously sweep 2 dacs.
    def _dac_vs_2dac_and_magnet(self,xname,dacx,xstart,xend,xsteps,yname,dacy,dacy_zeroB,dacy_mvperT,qname,dacq,dacq_zeroB,dacq_mvperT,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        y_vector = linspace(dacy_zeroB+Bstart*dacy_mvperT,dacy_zeroB+Bend*dacy_mvperT,Bsteps+1)
        q_vector = linspace(dacq_zeroB+Bstart*dacq_mvperT,dacy_zeroB+Bend*dacq_mvperT,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script
        
        counter = 0
        
        for i in arange(len(B_vector)):
            B = B_vector[i]
            y = y_vector[i]
            q = q_vector[i]
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                       # Sets B field
            ivvi.set(dacy,y)
            ivvi.set(dacq,q)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    
    # To sweep a dac as a function of B, every sweep consists of 2 times a dac sweep (first one from start to end of the sweep vector, 2nd one backwards from end to start of the sweep vector).
    def _fwdbwd_dac_vs_B(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]        
        
        data_fwd = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for fwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction of sweep vector to ensure proper spyview metafile
        data_bwd = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for bwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction sweep vector back to original
        
        
        counter = 0
                
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            self.set_B(B)                                                                                                                       # Sets B field
            
            
            for data_loop in (data_fwd, data_bwd):
                
                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature
                qt.msleep(delay1)
                
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                  # write datapoint into datafile
                    
                data_loop.new_block()
                
                # Toggle forward / backward by reversing vector
                x_vector = x_vector[::-1]
            
            tstop = timetrack.time()
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            
        for data_loop in (data_fwd, data_bwd):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()
            
        qt.mend()

    # Scan a dac as a function of B, while at the same time another dac is stepped linearly, this allows to correct a bit for features affected by both gate and B field so they don't move much.
    def _dac_vs_dacmagnet(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,Bstart,Bend,Bsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script
        
        # Create sweep vector for the dac that needs to be stepped together with B
        y_vector = linspace(ystart,yend,Bsteps+1)
        
        counter = 0

        for i in arange(len(B_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            B = B_vector[i]
            y = y_vector[i]
            kepco.set_B(B)                                                                                                                      # Specific for kepco as magnet supply
            ivvi.set(dacy,y)
            ivvi.set(dacx,x[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # dac vs rf power, to do power dependence of Shapiro steps. rf power is stepped with non-uniform steps following P^2 ~ Vrf. Function only works well if you start the sweep at the lowest power.
    def _dac_vs_rfpower(self,xname,dacx,xstart,xend,xsteps,Pstart,Pend,Psteps,freq):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        
        # P vector needs to have quadratic shape
        yend = (Pend-Pstart)*(Pend-Pstart)
        y_vector = linspace(0,yend,Psteps+1)
        P_vector = sqrt(y_vector)+Pstart
        
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,P_vector,'Prf (dB)','MW source',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script
        
        counter = 0
        
        # initialization of MW source
        mw.set_power(-20.0)
        mw.set_frequency(freq)
        mw.set_status('ON')
        
        for P in P_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            mw.set_power(P)                                                                                                                     # Set mw power
            ivvi.set(dacx,x[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,P,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Psteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
        
        mw.set_status('OFF')
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    ################# SCANS TO USE WITH Oxford 3D MAGNET #######################
    # All functions assume input in standard spherical coordinates (r = B magnitude, theta = angle wrt to positive Z axis, phi = angle wrt to positive X axis)
     #Units = Tesla
    def _get_field(self,mode='CART',output=1):
        mode0=magnet.get_Magnet_Mode()
        if mode0 != mode: magnet.set_Magnet_Mode(mode)
        field = magnet.get_field()
        if mode0 != mode: magnet.set_Magnet_Mode(mode0)
        field = ''.join([x for x in field if x in '0123456789. '])
        ind = [field.find(' '),field.find(' ',field.find(' ')+1)]
        B1= field[0:ind[0]]
        B2 = field[ind[0]+1:ind[1]]
        B3 = field[ind[1]+1:]
        if mode == 'CART':
            if output==1: print('X='+B1+'T; Y='+B2+'T; Z='+B3+'T')
            return([float(B1),float(B2),float(B3)])
        elif mode == 'SPH': 
            B2=str(float(B2)*180/pi)
            B3=str(float(B3)*180/pi)
            if output==1: print('R='+B1+'T; THETA='+B3+'deg; PHI='+B2+'deg')
            return([float(B1),float(B3),float(B2)])
        elif mode == 'CYL':
            B2=str(float(B2)*180/pi)
            if output==1: print('RHO='+B1+'T; THETA='+B2+'deg; Z='+B3+'T')
            return([float(B1),float(B2),float(B3)])
        else: print('Invalid mode of operation. Specify CART, CYL or SPH coordinates.')

    # Function that transforms an arbitrary B field vector in spherical coordinates to the cartesian coordinate field values and sets it.
    # It takes into account the correction angles defined wrt to positive z and x axis!
    def _set_3Dfield(self,r,theta,phi):  # Hao modified theta and phi
        
        # Check if field is already at setpoint
        B=self._get_field(mode='SPH',output=0)
        if round(B[0],4)==r and round(B[1],2)==theta and round(B[2],2)==phi: print('Field is already at setpoint and not set again.'); return

        # Compute the real magnet values in x,y,z from the transformed spherical coordinates by taking into account the correction angles.
        
        # First convert all angles to radians
        theta = radians(theta)
        phi = radians(phi)     
        
        real_new_field = r*matrix([[cos(phi)*sin(theta)],[sin(theta)*sin(phi)],[cos(theta)]])
        
        Xnew = real_new_field[0,0]
        Ynew = real_new_field[1,0]
        Znew = real_new_field[2,0]
        
        if Ynew > 0.93: Ynew=0.93; print('Magnet tends to get stuck at By > 0.93 T. Field limited to By = 0.93 T!')

        '''
        print Xnew
        print Ynew
        print Znew
        '''
        
        magnet.set_field('CART',Xnew,Ynew,Znew)

    # To scan a dac as a function of B where each magnet axis value can be set independently in Cartesian coordinates
    def _dac_vs_B_XYZ(self,xname,dacx,xstart,xend,xsteps,Bxstart,Bxend,Bystart,Byend,Bzstart,Bzend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        Bx_vector = linspace(Bxstart,Bxend,Bsteps+1)
        By_vector = linspace(Bystart,Byend,Bsteps+1)
        Bz_vector = linspace(Bzstart,Bzend,Bsteps+1)
        Bmag_start = sqrt(pow(Bxstart,2)+pow(Bystart,2)+pow(Bzstart,2))
        Bmag_end = sqrt(pow(Bxend,2)+pow(Byend,2)+pow(Bzend,2))
        B_vector = linspace(0,Bsteps,Bsteps+1)
        B_magnitude = linspace(Bmag_start,Bmag_end,Bsteps+1)
        
        data = self.create_data(x_vector,xname,dacx,B_magnitude,'B field','B',B_vector,'B step','B_field index')                                      # create data file, spyview metafile, copy script
        
        counter = 0
        
        for index in range(0,Bsteps+1):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            if By_vector[index] > 0.93: By_vector[index]=0.93; print('Magnet tends to get stuck at By > 0.93 T. Field limited to By = 0.93 T!')
            magnet.set_field('CART',Bx_vector[index],By_vector[index],Bz_vector[index])            # Sets B field
            self.wait_T(Tmax)
            
            # print '\nBx = '+`Bx_vector[index]`
            # print '\nBy = '+`By_vector[index]`
            # print '\nBz = '+`Bz_vector[index]`
            if (Bystart == Byend and Bzstart == Bzend):
                B_mag = np.sign(Bx_vector[index])*sqrt(pow(Bx_vector[index],2)+pow(By_vector[index],2)+pow(Bz_vector[index],2))
            elif (Bxstart == Bxend and Bzstart == Bzend):
                B_mag = np.sign(By_vector[index])*sqrt(pow(Bx_vector[index],2)+pow(By_vector[index],2)+pow(Bz_vector[index],2))
            elif (Bxstart == Bxend and Bystart == Byend):
                B_mag = np.sign(Bz_vector[index])*sqrt(pow(Bx_vector[index],2)+pow(By_vector[index],2)+pow(Bz_vector[index],2))
            else:
                B_mag = sqrt(pow(Bx_vector[index],2)+pow(By_vector[index],2)+pow(Bz_vector[index],2))
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B_mag,index,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # To scan a dac as a function of B arbitrary angle
    def _dac_vs_B_3D(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps,theta,phi):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)','magnet',z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script
        
        counter = 0
        
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(B,theta,phi)                                                                                                                       # Sets B field
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                            # Read out mixing chamber temperature 
            self.wait_T(Tmax)
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            self.AutoSensPerLineInit()
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)
                datavalues.append(T_mc)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,*datavalues)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)
            
            self.AutoSensPerLineSetSens()
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # To scan 2 dacs as a function of B arbitrary angle, added by Jie 2017-09-06
    def _2dacs_vs_B_3D(self,xname,dacx,xstart,xend,yname,dacy,ystart,yend,steps,Bstart,Bend,Bsteps,theta,phi):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,steps+1)
        y_vector = linspace(ystart,yend,steps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)','magnet',y_vector,yname,dacy)                                      # create data file, spyview metafile, copy script
        
        counter = 0
        
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(B,theta,phi)                                                                                                                       # Sets B field
            ivvi.set(dacx,x_vector[0])
            ivvi.set(dacy,y_vector[0])
            T_mc = self.read_T()                                                                                                                            # Read out mixing chamber temperature 
            self.wait_T(Tmax)
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            self.AutoSensPerLineInit()
            
            for i in arange(len(x_vector)):
                x = x_vector[i]
                y = y_vector[i]
                ivvi.set(dacy,y)
                datavalues = self.take_data(dacx,x)
                datavalues.append(T_mc)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,y,*datavalues)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)
            
            self.AutoSensPerLineSetSens()
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


     # To scan 3 dacs as a function of B arbitrary angle, added by Jie 2017-12-09
    def _3dacs_vs_B_3D(self,xname,dacx,xstart,xend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,steps,Bstart,Bend,Bsteps,theta,phi):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,steps+1)
        m_vector = linspace(mstart,mend,steps+1)
        n_vector = linspace(nstart,nend,steps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        
        
        #data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)','magnet',y_vector,yname,dacy)                                      # create data file, spyview metafile, copy script
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)','magnet',m_vector,mname,dacm)

        counter = 0
        
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(B,theta,phi)                                                                                                                       # Sets B field
            ivvi.set(dacx,x_vector[0])
            ivvi.set(dacm,m_vector[0])
            ivvi.set(dacn,n_vector[0])
            T_mc = self.read_T()                                                                                                                            # Read out mixing chamber temperature 
            self.wait_T(Tmax)
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            self.AutoSensPerLineInit()
            
            for i in arange(len(x_vector)):
                x = x_vector[i]
                m = m_vector[i]
                n = n_vector[i]
                ivvi.set(dacm,m)
                ivvi.set(dacn,n)
                datavalues = self.take_data(dacx,x)
                datavalues.append(T_mc)                                                                                             # Go to next sweep value and take data
                #data.add_data_point(x,B,m,z,*datavalues)                           # write datapoint into datafile
                data.add_data_point(x,B,m,n,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],datavalues[10],datavalues[11],datavalues[12],datavalues[13],T_mc)
                self.AutoSensPerLineAddValue(datavalues)
            
            self.AutoSensPerLineSetSens()
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # To scan a dac as a function of B arbitrary angle
    def _B_3D_vs_dac(self,Bstart,Bend,Bsteps,theta,phi,xname,dacx,xstart,xend,xsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(B_vector,'B (T)','magnet',x_vector,xname,dacx,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script
        qt.msleep(delay1)
        counter = 0
        
        for x in x_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()                                                                                                                      # Sets B field
            ivvi.set(dacx,x)
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature                                                                                                                    # use explained at the bottom of the script
            
            for B in B_vector:
                self._set_3Dfield(B,theta,phi)
                qt.msleep(delay2)
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(B,x,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    def _dac_vs_B_3D_Pi(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps,theta,phi):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)','magnet',z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script
        
        counter = 0
        
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(B,theta,phi)                                                                                                                       # Sets B field
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                ivvi.set_dac2(0)
                ivvi.set_dac2(275)
                qt.msleep(0.3)
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # To take several scans of a dac as a function of B arbitrary angle at multiple values of a second dac
    def _dac_vs_B_3D_gate(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps,theta,phi,zname,dacz,points):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = points
        i = 0
        datafile = [0]*len(points)
        for z in z_vector:
            datafile[i] = self.create_data(x_vector,xname,dacx,B_vector,'B (T)','magnet',z_vector,zname,dacz)                                      # create data file, spyview metafile, copy script
            i = i+1
        
        counter = 0
        
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(B,theta,phi) 
            self.wait_T(Tmax)                                                                                                                    # Sets B field
            # print B
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            for x in x_vector:
                i = 0
                ivvi.set(dacx,x)
                ivvi.set(dacz,z_vector[0])
                for z in z_vector:
                    datavalues = self.take_data(dacz,z)                                                                                             # Go to next sweep value and take data
                    datafile[i].add_data_point(x,B,z,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
                    i=i+1
            i=0
            for z in z_vector:
                datafile[i].new_block()
                i=i+1
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
        qt.mend()
        i = 0
        for z in z_vector:
            datafile[i]._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            datafile[i].close_file()
            i = i+1
    
    # To take several scans of a dac as a function of Bx, By and Bz at multiple values of a second dac        
    def _dac_vs_B_XYZ_gate(self,xname,dacx,xstart,xend,xsteps,Bx0,Bx1,By0,By1,Bz0,Bz1,Bsteps,zname,dacz,points):
        qt.mstart()
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        Bx_vector = linspace(Bx0,Bx1,Bsteps+1)
        By_vector = linspace(By0,By1,Bsteps+1)
        Bz_vector = linspace(Bz0,Bz1,Bsteps+1)
        Bmag_start = sqrt(pow(Bx0,2)+pow(By0,2)+pow(Bz0,2))
        Bmag_end = sqrt(pow(Bx1,2)+pow(By1,2)+pow(Bz1,2))
        B_vector = linspace(0,Bsteps,Bsteps+1)
        B_magnitude = linspace(Bmag_start,Bmag_end,Bsteps+1)
        z_vector = points
        
        counter = 0
        
        i = 0
        datafile = [0]*len(points)
        for z in z_vector:
            datafile[i] = self.create_data(x_vector,xname,dacx,B_vector,'B step','B_field index',B_magnitude,'B field','B')                                      # create data file, spyview metafile, copy script
            i = i+1
        
        counter = 0
        
        for index in range(0,Bsteps+1):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            magnet.set_field('CART',Bx_vector[index],By_vector[index],Bz_vector[index])            # Sets B field
            # print '\nBx = '+`Bx_vector[index]`
            # print '\nBy = '+`By_vector[index]`
            # print '\nBz = '+`Bz_vector[index]`
            B_mag = sqrt(pow(Bx_vector[index],2)+pow(By_vector[index],2)+pow(Bz_vector[index],2))
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)     
                                                                                                                      # Sets B field                                                                                                                  # use explained at the bottom of the script
            i = 0
            for z in z_vector:
                ivvi.set(dacz,z)
                ivvi.set(dacx,x_vector[0])
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data                                      
                    datafile[i].add_data_point(x,index,B_mag,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)   # write datapoint into datafile
                datafile[i].new_block()
                i = i+1
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
        qt.mend()
        i = 0
        for z in z_vector:
            datafile[i]._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            datafile[i].close_file()
            i = i+1
            
    def _fwdbwd_dac_vs_B_XYZ_gate(self,xname,dacx,xstart,xend,xsteps,Bx0,Bx1,By0,By1,Bz0,Bz1,Bsteps,zname,dacz,points):
        qt.mstart()
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        Bx_vector = linspace(Bx0,Bx1,Bsteps+1)
        By_vector = linspace(By0,By1,Bsteps+1)
        Bz_vector = linspace(Bz0,Bz1,Bsteps+1)
        Bmag_start = sqrt(pow(Bx0,2)+pow(By0,2)+pow(Bz0,2))
        Bmag_end = sqrt(pow(Bx1,2)+pow(By1,2)+pow(Bz1,2))
        B_vector = linspace(0,Bsteps,Bsteps+1)
        B_magnitude = linspace(Bmag_start,Bmag_end,Bsteps+1)
        z_vector = points

        counter = 0

        i = 0
        datafile = [0]*2*len(points)
        for z in z_vector:
            datafile[i] = self.create_data(x_vector,xname,dacx,B_vector,'B step','B_field index',B_magnitude,'B field','B')
            x_vector = x_vector[::-1] 
            datafile[i+1] = self.create_data(x_vector,xname,dacx,B_vector,'B step','B_field index',B_magnitude,'B field','B')# create data file, spyview metafile, copy script
            x_vector = x_vector[::-1] 
            i = i+2
        
        counter = 0
        
        for index in range(0,Bsteps+1):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            magnet.set_field('CART',Bx_vector[index],By_vector[index],Bz_vector[index])            # Sets B field
            # print '\nBx = '+`Bx_vector[index]`
            # print '\nBy = '+`By_vector[index]`
            # print '\nBz = '+`Bz_vector[index]`
            B_mag = sqrt(pow(Bx_vector[index],2)+pow(By_vector[index],2)+pow(Bz_vector[index],2))
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)     

            i = 0
            for z in z_vector:
                ivvi.set(dacz,z)
                ivvi.set(dacx,x_vector[0])
                
                for x in x_vector:
                    ivvi.set(dacx,x)
                    qt.msleep(delay2)
                    datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data                                      
                    datafile[i].add_data_point(x,index,B_mag,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)   # write datapoint into datafile
                datafile[i].new_block()
                
                x_vector = x_vector[::-1] 
                for x in x_vector:
                    ivvi.set(dacx,x)
                    qt.msleep(delay2)
                    datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data                                      
                    datafile[i+1].add_data_point(x,index,B_mag,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)   # write datapoint into datafile
                datafile[i+1].new_block()
                x_vector = x_vector[::-1]
                i = i+2
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
        qt.mend()
        i = 0
        for z in z_vector:
            datafile[i]._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            datafile[i].close_file()
            i = i+1        

    # To take an upward swept and downward swept VI as a function of B at arbitrary angle
    def _fwdbwd_dac_vs_B_3D(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps,theta,phi):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]        
        
        data_fwd = self.create_data(x_vector,xname,dacx,B_vector,'B (T)','magnet',z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for fwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction of sweep vector to ensure proper spyview metafile
        data_bwd = self.create_data(x_vector,xname,dacx,B_vector,'B (T)','magnet',z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for bwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction sweep vector back to original
        
        counter = 0
                
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            self._set_3Dfield(B,theta,phi)                                                                                                                      # Sets B field
            
            
            for data_loop in (data_fwd, data_bwd):
                
                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature
                qt.msleep(delay1)
                
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                  # write datapoint into datafile
                    
                data_loop.new_block()
                
                # Toggle forward / backward by reversing vector
                x_vector = x_vector[::-1]
            
            tstop = timetrack.time()
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            
        for data_loop in (data_fwd, data_bwd):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()
            
        qt.mend()

    # Scan dac as a function of theta angle at some fixed B value and phi angle. theta is defined wrt to positive z-axis.
    def _dac_vs_theta(self,xname,dacx,xstart,xend,xsteps,thetastart,thetaend,thetasteps,r,phi):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        theta_vector = linspace(thetastart,thetaend,thetasteps+1)
        z_vector = [0]
        data = self.create_data(x_vector,xname,dacx,theta_vector,'theta (deg)','magnet',z_vector,'none','z_parameter')        # create data file, spyview metafile, copy script
        
        counter = 0
        
        for theta in theta_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(r,theta,phi)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            self.wait_T(Tmax)
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            self.AutoSensPerLineInit()
            for x in x_vector:
                datavalues = self.take_data(dacx,x) 
                datavalues.append(T_mc)                                                                                            # Go to next sweep value and take data
                data.add_data_point(x,theta,0,*datavalues)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)

            self.AutoSensPerLineSetSens()            
            timetrack.remainingtime(starttime,thetasteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # Scan dac as a function of angle in a yz plane rotated towards x at fixed B. The x and z axes are rotated by theta_rot towards the magnet x-axis. theta is defined wrt to z-axis in the yz-plane (i.e. phi=90)!
    def _dac_vs_B_yzplane_rotated(self,xname,dacx,xstart,xend,xsteps,thetastart,thetaend,thetasteps,r,theta_rot):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        theta_vector = linspace(thetastart,thetaend,thetasteps+1)

        z_vector = [0]
        data = self.create_data(x_vector,xname,dacx,theta_vector,'theta (deg)','magnet',z_vector,'none','z_parameter')        # create data file, spyview metafile, copy script
        
        counter = 0
        
        for theta in theta_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            Bx = r*sin(radians(theta_rot))*cos(radians(theta))
            By = r*                        sin(radians(theta))
            Bz = r*cos(radians(theta_rot))*cos(radians(theta))
            magnet.set_field('CART',Bx,By,Bz)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            self.wait_T(Tmax)
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            self.AutoSensPerLineInit()
            for x in x_vector:
                if setG != 0:
                    dac1 = ivvi.get_dac1()
                    ivvi.set_dac1(setG_bias)
                    self.set_transmission(Gset,'dac4',1)
                    if setG == 2:
                        self.set_transmission(Gset,'dac5',2)
                    ivvi.set_dac1(dac1)
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,theta,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)

            self.AutoSensPerLineSetSens()            
            timetrack.remainingtime(starttime,thetasteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # Scan magnetic field in rotated coordinate frame vs dac. Theta and phi are defined in the rotated coordinate frame, which is rotated wrt to magnet frame with alpha from z towards x and then by beta from x towards y. r is magnitude of field.
    def _B_phi_rotated_vs_dac(self,phistart,phiend,phisteps,xname,dacx,xstart,xend,xsteps,r,theta,alpha,beta):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        phi_vector = linspace(phistart,phiend,phisteps+1)

        z_vector = [0]
        data = self.create_data(phi_vector,'phi (deg)','magnet',x_vector,xname,dacx,z_vector,'none','z_parameter')        # create data file, spyview metafile, copy script
        
        counter = 0
        
        for x in x_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()                                                                                                                      # Sets B field
            ivvi.set(dacx,x)
            T_mc = self.read_T()

            self.AutoSensPerLineInit()
            for phi in phi_vector:
                if setG != 0:
                    dac1 = ivvi.get_dac1()
                    ivvi.set_dac1(setG_bias)
                    self.set_transmission(Gset,'dac4',1)
                    if setG == 2:
                        self.set_transmission(Gset,'dac5',2)
                    ivvi.set_dac1(dac1)
                a = sin(theta*pi/180)*cos(phi*pi/180)
                b = sin(theta*pi/180)*sin(phi*pi/180)
                c = cos(theta*pi/180)
                _,th_mag,phi_mag = self.axes_transform(a,b,c,alpha,beta,mode='SPH')
                self._set_3Dfield(r,th_mag,phi_mag)
                qt.msleep(delay2)
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(B,x,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)

            self.AutoSensPerLineSetSens()            
            timetrack.remainingtime(starttime,xsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # Scan dac as a function of theta angle at some fixed B value and phi angle in a coordinate system rotated from the magnet axes. theta is defined wrt to positive z''-axis.
    def _dac_vs_theta_rotframe(self,xname,dacx,xstart,xend,xsteps,thetastart,thetaend,thetasteps,r,phi,alpha,beta):
        """ Scan dac as a function of theta angle at some fixed B value and phi angle in a coordinate system rotated from the magnet axes.
        
        x'',y'',z'' is the coordinate system of interest, which is rotated by the angle alpha measured from z to x  to form x',y',z' and then rotated by angle beta measured from x' to y'.
        x,y,z are the magnet axes.
        This function scans a dac vs theta with theta defined wrt to the positive z''-axis (i.e. in the rotated coordinate system.)
        """
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        theta_vector = linspace(thetastart,thetaend,thetasteps+1)
        z_vector = [0]
        data = self.create_data(x_vector,xname,dacx,theta_vector,'theta (deg)','magnet',z_vector,'none','z_parameter')        # create data file, spyview metafile, copy script
        
        Bx = r*sin(theta_vector*pi/180)*cos(phi*pi/180)
        By = r*sin(theta_vector*pi/180)*sin(phi*pi/180)
        Bz = r*cos(theta_vector*pi/180)
        r_mag,theta_mag,phi_mag = self.axes_transform(Bx,By,Bz,alpha,beta,mode='SPH') #Input alpha, beta in units of degrees. This function transforms alpha and beta to radians

        counter = 0
        
        for i in range(len(theta_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(r_mag[i],theta_mag[i],phi_mag[i])
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            self.wait_T(Tmax)
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            self.AutoSensPerLineInit()
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,theta_vector[i],0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)

            self.AutoSensPerLineSetSens()            
            timetrack.remainingtime(starttime,thetasteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()        

    # Scan dac as a function of phi angle at some fixed B value and theta angle. Phi is defined wrt to positive x-axis.
    def _dac_vs_phi(self,xname,dacx,xstart,xend,xsteps,phistart,phiend,phisteps,r,theta):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        phi_vector = linspace(phistart,phiend,phisteps+1)
        z_vector = [0]
        data = self.create_data(x_vector,xname,dacx,phi_vector,'phi (deg)','magnet',z_vector,'none','z_parameter')        # create data file, spyview metafile, copy script
        
        counter = 0
        
        for phi in phi_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(r,theta,phi)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            self.wait_T(Tmax)

            self.AutoSensPerLineInit()
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                datavalues.append(T_mc)                                                                                            # Go to next sweep value and take data
                data.add_data_point(x,phi,0,*datavalues)                    # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)
            
            self.AutoSensPerLineSetSens()            
            timetrack.remainingtime(starttime,phisteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # Scan dac as a function of phi angle at some fixed B value with the phi angle in a coordinate system rotated from the magnet axes. phi is defined wrt to positive x''-axis.
    def _dac_vs_phi_rotframe(self,xname,dacx,xstart,xend,xsteps,phistart,phiend,phisteps,r,theta,alpha,beta):
        """ Scan dac as a function of phi angle at some fixed B value with the phi angle in a coordinate system rotated from the magnet axes.
        
        x'',y'',z'' is the coordinate system of interest, which is rotated by the angle alpha measured from z to x  to form x',y',z' and then rotated by angle beta measured from x' to y'.
        x,y,z are the magnet axes.
        This function scans a dac vs phi with theta defined wrt to the positive x''-axis (i.e. in the rotated coordinate system.)
        """
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        phi_vector = linspace(phistart,phiend,phisteps+1)
        z_vector = [0]
        data = self.create_data(x_vector,xname,dacx,phi_vector,'phi (deg)','magnet',z_vector,'none','z_parameter')        # create data file, spyview metafile, copy script
        
        Bx = r*sin(theta*pi/180)*cos(phi_vector*pi/180)
        By = r*sin(theta*pi/180)*sin(phi_vector*pi/180)
        Bz = r*cos(theta*pi/180)
        r_mag,theta_mag,phi_mag = self.axes_transform(Bx,By,Bz,alpha,beta,mode='SPH') #Input alpha, beta in units of degrees. This function transforms alpha and beta to radians

        counter = 0
        
        for i in range(len(phi_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(r_mag[i],theta_mag[i],phi_mag[i])
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            self.wait_T(Tmax)
            
            self.AutoSensPerLineInit()
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,phi_vector[i],0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
                self.AutoSensPerLineAddValue(datavalues)

            self.AutoSensPerLineSetSens()            
            timetrack.remainingtime(starttime,phisteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()          

    # To take an upward swept and downward swept VI as a function of theta angle at some fixed b value and phi angle. Theta defined wrt to positive Z-axis
    def _fwdbwd_dac_vs_theta(self,xname,dacx,xstart,xend,xsteps,thetastart,thetaend,thetasteps,r,phi):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        theta_vector = linspace(thetastart,thetaend,thetasteps+1)
        z_vector = [0]        
        
        data_fwd = self.create_data(x_vector,xname,dacx,theta_vector,'theta (deg)','magnet',z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for fwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction of sweep vector to ensure proper spyview metafile
        data_bwd = self.create_data(x_vector,xname,dacx,theta_vector,'theta (deg)','magnet',z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for bwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction sweep vector back to original
        
        counter = 0

        for theta in theta_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            self._set_3Dfield(r,theta,phi)                                                                                                                      # Sets B field

            for data_loop in (data_fwd, data_bwd):
                
                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature
                qt.msleep(delay1)
                
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,theta,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                  # write datapoint into datafile
                    
                data_loop.new_block()
                
                # Toggle forward / backward by reversing vector
                x_vector = x_vector[::-1]
            
            tstop = timetrack.time()
            timetrack.remainingtime(starttime,thetasteps+1,counter)                                                                                 # Calculate and print remaining scantime
            
        for data_loop in (data_fwd, data_bwd):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()
            
        qt.mend()

     # To take an upward swept and downward swept VI as a function of theta angle at some fixed b value and phi angle. Theta defined wrt to positive Z-axis
    def _fwdbwd_dac_vs_phi(self,xname,dacx,xstart,xend,xsteps,phistart,phiend,thetasteps,r,theta):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        phi_vector = linspace(phistart,phiend,phisteps+1)
        z_vector = [0]        
        
        data_fwd = self.create_data(x_vector,xname,dacx,phi_vector,'phi (deg)','magnet',z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for fwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction of sweep vector to ensure proper spyview metafile
        data_bwd = self.create_data(x_vector,xname,dacx,phi_vector,'phi (deg)','magnet',z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for bwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction sweep vector back to original
        
        counter = 0
        for theta in phi_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            self._set_3Dfield(r,theta,phi)                                                                                      
                                            # Sets B field
            
            for data_loop in (data_fwd, data_bwd):
                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature
                qt.msleep(delay1)
                
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,phi,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                  # write datapoint into datafile
                    
                data_loop.new_block()
                
                # Toggle forward / backward by reversing vector
                x_vector = x_vector[::-1]
            
            tstop = timetrack.time()
            timetrack.remainingtime(starttime,phisteps+1,counter)                                                                                 # Calculate and print remaining scantime
            
        for data_loop in (data_fwd, data_bwd):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()
            
        qt.mend()


    ############### Other custom functions (Jouri) ###############
    def read_T(self,Treadout='K4'): # Function to read out temperature
        if Treadout == 'cryocon':
            T_mc = cryocon.get_ch1_temperature
        elif Treadout == 'off':
            T_mc = 0
        elif Treadout == 'lockin3':                     # works for reading out T with lockin at F016 set up
            Vmeas = lockin3.get_R()
            R_mc = 1e5*Vmeas/amplitude3
            T_mc = 10**(958.53667-1344.34333*log10(R_mc)+787.5427*log10(R_mc)**2-245.5275*log10(R_mc)**3+42.90402*log10(R_mc)**4-3.98195*log10(R_mc)**5+0.1533*log10(R_mc)**6)
        elif Treadout == 'K4':
            T_mc = float(magnet.get_MCTemp())
        
        return T_mc

    def wait_T(self,Tlim=0.025): # Function to wait for temperature to drop below threshold Tlim (added by Jouri)
        if waitT == 1:
            T_mc=self.read_T()
            if T_mc>Tlim:
                print('T = {:.2f} mK: Waiting for T < {:g} mK'.format(T_mc*1000,Tlim*1000))
                for t in range(31):                                                                                                                # Wait for temperature to drop below Tlim
                    T_mc = self.read_T()
                    if T_mc<Tlim:
                        print '\nT = {:.02f} mK: Continuing measurement'.format(T_mc*1000)
                        break
                    elif t == 30:
                        print '\nT = {:.02f} mK: Setpoint not reached in 30 minutes. Continuing anyway.'.format(T_mc*1000)
                    else:
                        print '\rT = {:.02f} mK (max {:02d} min left)'.format(T_mc*1000,30-t),
                        time.sleep(60.)
            return

    def wait_T_set(self,Tset,tol): #Function to wait for temperature to reach set point (added by Jouri); Tset=setpoint in K, tol = tolerance in K
        print('Waiting for temperature to reach T = {:g} +/- {:g} mK').format(Tset*1000,tol*1000)
        T_mc=np.array(self.read_T())
        time.sleep(60)
        T_mc=np.append(T_mc,self.read_T())
        t=0
        while max(abs(T_mc[-5:]-Tset))>tol:
            time.sleep(60)
            T_mc=np.append(T_mc,self.read_T())
            t += 1
            print '\rDeviation = {:.4g} mK: Waiting for T = {:g} +/- {:g} mK for {:d} min)'.format(max(abs(T_mc[-5:]-Tset))*1000,Tset*1000,tol*1000,t)
        print '\nT = {:.4g} mK: Temperature at setpoint within tolerance'.format(T_mc[-1]*1000)
        return

    def set_heaterrange(self,Tset): # Change heater range depending on temperature setpoint (Added by Jouri)
        #Trange = [30e-3,100e-3,300e-3,1,3,30] # In Oxford documentation
        Trange = [30e-3,67e-3,200e-3,.67,2,30]
        heater = [316e-3,1,3.16,10,31.6,100]
        if Tset<30:
            ind=[i for i in range(len(Trange)) if Tset<Trange[i]][0]
            magnet.set_heaterrange(heater[ind])
            print('Heater range set to {:g} mA'.format(heater[ind]))
        else: 
            raise Exception('Setpoint too high: > 30 K')

    def set_transmission(self,Gset,dacx,lockin,limits=[],tol=0.001,exc=20e-6,sens=20):
        if limits == []:
            if dacx=='dac4': limits=[-1500,1500]
            if dacx=='dac5': limits=[-1500,1500]
            if dacx=='dac3': limits=[-1800,1800]
        #Set excitation to 50e-6, set it back at end of script
        def save_amplitude(): return amplitude1,amplitude2
        amp1,amp2 = save_amplitude()
        global amplitude1
        global amplitude2
        amplitude1 = exc
        amplitude2 = exc
        if exc/(Vrange*1e-2*sqrt(2)) > 2: print('Excitation voltage exceeds 2V on ISO-AMP IN (possible clipping problem)')
        lockin1.set_amplitude(amplitude1/(Vrange*1e-2*sqrt(2))); sens1 = lockin1.get_sensitivity(); lockin1.set_sensitivity(sens)
        lockin2.set_amplitude(amplitude2/(Vrange*1e-2*sqrt(2))); sens2 = lockin2.get_sensitivity(); lockin2.set_sensitivity(sens)
        qt.msleep(delay1)

        qt.msleep(delay1)

        dac=ivvi.get(dacx)
        G=self.take_data(dacx,dac)[lockin+2]*12906
        dac0=dac
        Gini=G

        #Print initial settings
        #print('dac1={:g}'.format(ivvi.get_dac1()))
        #print('\t| {:s}\t| G\t|'.format(dacx).expandtabs(10))
        #print('Initial \t| {:0.1f}\t| {:0.3f}\t|'.format(dac,G).expandtabs(10))
        #print 'Initial,current\t| {:s}: {:0.1f},{:0.1f}\t|G: {:0.3f},{:0.3f}\t|'.format(dacx,dac0,dac,G0,G).expandtabs(10),
        
        n=0
        grad=[]
        while abs(G-Gset)>tol:
            dG=G-Gset
            G0=G

            #Determine dac stepsize to take to approach the setpoint
            if G < 1.0/3.0*Gset or G > 3.0*Gset:
                if 'grad' in locals() and grad!=0: ddac = max(min(5,abs(0.2*dG/grad)),1.0)*-np.sign(dG)
                else: ddac=-5*np.sign(dG)
                mode = '(coarse)'
            elif G < 1.0/2.0*Gset or G > 2.0*Gset:
                if 'grad' in locals() and grad!=0: ddac = max(min(1,abs(0.2*dG/grad)),0.1)*-np.sign(dG)
                else: ddac=-1*np.sign(dG)
                mode = '(medium)'
            else:
                if 'grad' in locals() and grad!=0: ddac = max(min(0.2,abs(0.2*dG/grad)),0.02)*-np.sign(dG)
                else: ddac=-0.2*np.sign(dG)
                mode='( fine )'
            #Exit if the dac the program wants to set exceeds the preset limits
            if dac+ddac<limits[0] or dac+ddac>limits[1]:
                print('\nError: Limit of dac range reached - {:s} = {:f}'.format(dacx,dac))
                break
            
            print 'Initial,current|{:s}:{:0.1f},{:0.1f}|G:{:0.3f},{:0.3f}|ddac={:4.1f} {:s}      \r'.format(dacx,dac0,dac,Gini,G,ddac,mode),  #Update the printed current settings
            G=self.take_data(dacx,dac+ddac)[lockin+2]*12906     #Set dac to new value and measure conductance
            dac=ivvi.get(dacx)                                  #Overwrite value for current dac settings
            grad = (G-G0)/ddac                          #Calculate gradient of the last step (dG/ddac)
            #print '\rCurrent \t| {:0.1f}\t| {:0.3f}\t| ddac={:4.1f} {:s}'.format(dac,G,ddac,mode).expandtabs(10),   #Update the printed current settings
            n+=1
            if n>10000 and ddac<10: print('\nNot converged to setpoint within the tolerance after 10.000 iterations.'); break
        print ' '*78,'\r',
        
        #Reset the lockin amplitude and sensitivity
        amplitude1 = amp1
        amplitude2 = amp2
        lockin1.set_amplitude(amplitude1/(Vrange*1e-2*sqrt(2))); lockin1.set_sensitivity(sens1)
        lockin2.set_amplitude(amplitude2/(Vrange*1e-2*sqrt(2))); lockin2.set_sensitivity(sens2)
        qt.msleep(delay1)
        #print(' Setpoint reached\n')
        return dac,G

    def find_gatecomp(self,G,dac1,dacx,xname,xstart,xend,xsteps,ynames,dacys,lockins,exc=50e-6):
        qt.mstart()
        ivvi.set_dac1(dac1)

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = [0]
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                # create data file, spyview metafile, copy script

        ivvi.set(dacx,x_vector[0])
        T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
        qt.msleep(delay1)

        #Check if variables for y are a list. If not, convert them to a list with one element to ensure compatibility with for-loop.
        if type(ynames) != list: ynames = [ynames]
        if type(dacys) != list: dacys = [dacys]
        if type(lockins) != list: lockins = [lockins]
            
        for x in x_vector:
            ivvi.set(dacx,x)
            dacy_values = [0,0]
            G_set = [0,0]
            for i in range(len(dacys)):
                #sys.stdout = open(os.devnull, "w") #Prevent function in between from printing
                dacy_values[i],G_set[i] = self.set_transmission(G,dacys[i],lockins[i],exc=exc)
                #sys.stdout = sys.__stdout__ #Prevent function in between from printing
            data.add_data_point(x,0,0,G_set[0],G_set[1],dacy_values[0],dacy_values[1],0,0,0,0,0,0,T_mc)                               # write datapoint into datafile

        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    def gatecomp(self,sg_find,G_find,fid='default',cols=[0,1,5],method='interp',filter=1):
        tg_row=cols[0]
        sg_row=cols[1]
        G_row =cols[2]
        if fid == 'default': fid = globals()['fid']
        
        data=np.loadtxt(fid,skiprows=55)
        tg_raw=data[:,tg_row]
        sg_raw = data[:,sg_row]
        G_raw = data[:,G_row]
        Ntg = np.where(tg_raw==tg_raw[0])[0][1]
        tg = tg_raw[0:Ntg]
        sg = sg_raw[0::Ntg]
        Nsg = len(sg)
        G=np.resize(G_raw,(Nsg,Ntg))*12906

        if filter == 1:
            N_int=501
            Gfil=np.zeros((Nsg,N_int))
            tg_orig=tg
            tg=np.linspace(tg[0],tg[-1],N_int)
            for i in range(Nsg):
                Gfil[i,:]=m.savitzky_golay(np.interp(tg,tg_orig,G[i,:]),75,3)
            G=Gfil
        
        ind_G = []
        for i in range(Nsg):
            ind_G.append(np.abs(G[i,:]-G_find).argmin())
        tg_found = tg[ind_G]
        if method == 'interp':
            tg_found2 = m.savitzky_golay(tg_found,13,3)
            tg_comp=np.interp(sg_find,sg,tg_found2)
        elif method == 'linfit':
            fit=np.polyfit(sg,tg_found,1)
            tg_comp=np.polyval(fit,sg_find)
        else: 
            print('Method is undefined. Possible methods: linfit (default), interp')
            return
        return tg_comp
    def gatecompline(self,sg_comp,fid):
        """
        Determine tgs based on a constant G scan of tg as a function of sg (using m.find_gatecomp). Written for a measurement with simultaneous measurement of two devices, specifically for 2 N contacts connected to 1 S.
        """
        sg_row=0
        tg_row1=5
        tg_row2=6
        G_row1 = 3
        G_row2 = 4
        
        data=np.loadtxt(fid,skiprows=55)
        sg = data[:,sg_row]
        tg1=data[:,tg_row1]
        tg2=data[:,tg_row2]
        G1 = data[:,G_row1]
        G2 = data[:,G_row2]
        # Lowpass filter to remove high frequency noise / narrow resonances. Check in python notebook to see if the window size is appropriate.
        tg1_fil = self.savitzky_golay(tg1,25,2)
        tg2_fil = self.savitzky_golay(tg2,25,2)
        # Find tg for the sg values in sg_comp by interpolating between the lowpass filtered tg values.
        tg1_comp = np.interp(sg_comp,sg,tg1_fil)
        tg2_comp = np.interp(sg_comp,sg,tg2_fil)
        return tg1_comp,tg2_comp
    def savitzky_golay(self,y, window_size, order, deriv=0, rate=1):
        from math import factorial
        
        try:
            window_size = np.abs(np.int(window_size))
            order = np.abs(np.int(order))
        except ValueError, msg:
            raise ValueError("window_size and order have to be of type int")
        if window_size % 2 != 1 or window_size < 1:
            raise TypeError("window_size size must be a positive odd number")
        if window_size < order + 2:
            raise TypeError("window_size is too small for the polynomials order")
        order_range = range(order+1)
        half_window = (window_size -1) // 2
        # precompute coefficients
        b = np.mat([[k**i for i in order_range] for k in range(-half_window, half_window+1)])
        m = np.linalg.pinv(b).A[deriv] * rate**deriv * factorial(deriv)
        # pad the signal at the extremes with
        # values taken from the signal itself
        firstvals = y[0] - np.abs( y[1:half_window+1][::-1] - y[0] )
        lastvals = y[-1] + np.abs(y[-half_window-1:-1][::-1] - y[-1])
        y = np.concatenate((firstvals, y, lastvals))
        return np.convolve( m[::-1], y, mode='valid')
    def rotframe2sph(self,alpha,th_rot):
        """"Find angles in spherical coordinates from a frame in which the z and x axis are rotated by alpha towards x,-z respectively. th_rot is the angle towards y wrt to the rotated z axis."""
        alpha=radians(alpha)
        th_rot=radians(th_rot)
        x=sin(alpha)*cos(th_rot)
        y=sin(th_rot)
        z=cos(alpha)*cos(th_rot)
        th = arccos(z)*180/pi
        phi = arctan2(y,x)*180/pi
        return th,phi
    def axes_transform(self,a,b,c,theta,phi,mode='CART'):
        """ Transform coordinates from a doubly rotated cartesian system to the system used by the vector magnet.

        x'',y'',z'' system is the system of interest, which is rotated by angle theta measured from z to x  to form x',y',z' and then rotated by angle phi measured from x' to y'.
        x,y,z are the magnet axes.
        This function calculates the coordinates (x,y,z) in the magnet vector space from the vector in the rotated system [a,b,c]*[x'',y'',z'']'
        The angles theta and phi should be given in units of degrees.

        The optional parameters mode controls whether the transformed coordinates are returned in the cartesian ('CART') or spherical ('SPH') coordinates of the magnet system.
        """
        theta = theta*pi/180
        phi = phi*pi/180
        x = a*cos(theta)*cos(phi)-b*cos(theta)*sin(phi)+c*sin(theta)
        y = a*sin(phi)+b*cos(phi)
        z = -a*sin(theta)*cos(phi)+b*sin(theta)*sin(phi)+c*cos(theta)
        if mode == 'CART':
            return x,y,z
        elif mode == 'SPH':
            r = sqrt(x**2+y**2+z**2)
            theta = arccos(z/r)*180/pi
            phi = arctan2(y,x)*180/pi
            return r,theta,phi


# class couple_dacs():
#     def couple_dacs(self,dac_master,dac_slave):
#         self.dac_master = dac_master
#         self.dac_slave = dac_slave
#     def set_coupled_dacs(self):
#         if self.activate = 1:
#             val = ivvi.get(self.dac_master)
#             for dac in self.dac_slave:
#                 ivvi.set(dac,val)


#################### INITIALIZATION #########################

# DON'T SKIP THIS PART, ITS CRUCIAL FOR PROPER MEASUREMENTS AND DATA PROCESSING!!!


# Gains and ranges
# Please set the gains and ranges before starting measurements. This ensures proper scaling of axis and data in Spyview.
# Make sure that you put the right gain at the right Keithley/Lockin.
GainK1=1e6                       # Gain for Keithley 1
GainK2=1e6                      # Gain for Keithley 2 
GainK3=1e6                       # Gain for Keithley 3 
GainL1=1e6                       # Gain for Lockin 1 
GainL2=1e6                      # Gain for Lockin 2 
#GainL3=1e6                       # Gain for Lockin 2 
Vrange=10e-3                      # voltage range in V/V, first source
Vrange2=10e-3                    # voltage range in V/V, second source
#Vrange3=10e-3                    # voltage range in V/V, third source
Irange=10e-9                    # current range in A/V
BGrange=15.0                      # Back gate range in V/V
SGrange=1.0                          # Super gate range in V/V
TArange=1.0                            #Tunnel gate A range V/V
TBrange=1.0                            #Tunnel gate B range V/V
TCrange=1.0                            #Tunnel gate C range V/V
#Rfilter = 2*2080.0 + 2*814.0            # 814 Ohm from PCB
Rfilter = 2*2080.0 + 2*51.0              # 51 Ohm from the PCB
#RsL1 = 0                  # series resitance of the fridge wire + filtering
RsL1 = 2.0e3 + GainK1*1.0e-3 + Rfilter + 1.0e4*Vrange  # Take care! this is only true if the M1b is set at low noise!
RsL2 = 2.0e3 + GainK2*1.0e-3 + Rfilter + 1.0e4*Vrange2 # Take care! this is only true if the M1b is set at low noise!
#RsL3 = 2.0e3 + GainK3*1.0e-3 + Rfilter + 1.0e4*Vrange3 # Take care! this is only true if the M1b is set at low noise!
#Gain 1M:  Rs=8.9kOhm  (10mV/V) or 8.8kOhm  (1mV/V)
#Gain 10M: Rs=17.9kOhm (10mV/V) or 17.8kOhm (1mV/V)

print '\nGainK1='+`GainK1`+'\t\tGain for Keithley 1\nGainK2='+`GainK2`+'\t\tGain for Keithley 2\nGainL1='+`GainL1`+'\t\tGain for Lockin 1\nGainL2='+`GainL2`+'\t\tGain for Lockin 2\nVrange='+`Vrange`+'\t\tVoltage range in V/V\nIrange='+`Irange`+'\t\tCurrent range in A/V\nBGrange='+`BGrange`+'\t\tGate range in V/V\n'
s=raw_input("Ensure smooth dataprocessing in spyview by checking if gains, Vrange, Irange and BGrange are stored correct. Press enter to continue, press any other key and enter to stop: ")
if s!='':
    print '\nVery kind of you to avoid future data processing problems.'
    #time.sleep(3.0)
    sys.exit()

# DEFINE MEASUREMENT TYPE 

    # LOCKIN VS KEITHLEY 

    # Please update the number of Keithleys/Lockins used in the measurement, this ensures proper data readout and storage.
    # Remark: In the program its assumed that if you use a single Keithley, this one is Keithley 1. Same for the lockins.
    # To ensure proper data processing, we encourage reading the 'take_data' function above.

Nkeithleys = 3      # Allowed values: 0,1,2
Nlockins = 2    # Allowed values: 0,1,2

    
    # 2 TERMINAL READOUT (Jouri)
    
    # I made this function for a 3 terminal device to measure the current to ground via 2 terminals
    # if you bias via the 3th terminal. 
    # Right now it only works if you measure with 2 lockins and 2 keithleys.
    # Column 4 (usual column) contains the data from Lockin1, column
    # 8 contains the data from Lockin2 (as usual), but corrected for gains and series resistances (unusual).
    # This way of implementing it is a bit lame, it would be better to store it in an extra column and also
    # store the raw data, something to be implemented in future.
SynchronizedLockins = 0 #1: Bias super, measure at two N contacts at the same time using synchronized lockins. Changes the definition for the conductance in take_data().
if SynchronizedLockins == 1: print('SynchronizedLockins=1: Beware, the series resistance substracted from the lockin data is only correct for a setup using synchronized lockins (only if Nkeithleys=2 and Nlockins=2)!')
NonlocalV = 0 #1: Measure non local voltage using the second Keithley and lockin. The definition of the calculated values in take_data() is changed.

# INITIALIZATION OF THE Lockins

# Lockin1
amplitude1 = 10e-6 #0.3e-9 #5e-6                                  # Excitation amplitude in V (this is the A from A*sin(omega*t+B) )
lockin1.set_amplitude(amplitude1/(Vrange*1e-2*sqrt(2)))     # Calculates true output excitation voltage lockin
#lockin1.set_amplitude(amplitude1/(Irange*1e-2*sqrt(2)))      #for Ibias
lockin1.set_frequency(37.13) #(37.13) 17.31
lockin1.set_phase(0)
lockin1.set_sensitivity(18)                                 #16 good for 10 microV excitation #24 needed at high conductance!                  # Check S830 driver for the meaning of this number
lockin1.set_tau(8)
lockin1.set_sync_filter(0)                                          # tau = 9 equals 300 ms, check S830 driver for other integration times
lockin1.set_reserve(1) 

AutoSensIncrease = 0                                               # Set to 1 to rescale the sensitivity to keep the signal between 5% and 90% of full-scale, set to 0 to disable autoscaling
AutoSensDecrease = 0                                                # Set to 1 to rescale the sensitivity to keep the signal between 5% and 90% of full-scale, set to 0 to disable autoscaling
AutoSensPerLine = 0                                                 #Set to 1 to set the sensitivity to the lowest value for which the highest value of the last sweep is smaller than 80% of fullscale
if Nlockins == 0: AutoSensPerLine=0


# Lockin2
#lockin2.set_mode(1)                                       # This command synchronizes lockin2 with lockin1. Set to 0 to synchronize
amplitude2 = 10e-6                                           # Excitation amplitude in V (this is the A from A*sin(omega*t+B) )
lockin2.set_amplitude(amplitude2/(Vrange2*1e-2*sqrt(2)))     # Calculates true output excitation voltage lockin
lockin2.set_frequency(27.13)
lockin2.set_phase(0)
lockin2.set_sensitivity(18)                                 #16 good for 10 microV excitation #24 needed at high conductance!                  # Check S830 driver for the meaning of this number
lockin2.set_tau(8)
lockin2.set_sync_filter(0)
lockin2.set_reserve(1)                                          # tau = 9 equals 300 ms, check S830 driver for other integration times

# Lockin3
'''
lockin3.set_mode(0)                                       # This command synchronizes lockin3 with lockin1. Set to 0 to synchronize
amplitude3 = 5e-6                                           # Excitation amplitude in V (this is the A from A*sin(omega*t+B) )
lockin3.set_amplitude(amplitude3/(Vrange3*1e-2*sqrt(2)))     # Calculates true output excitation voltage lockin
lockin3.set_frequency(37.13)
lockin3.set_phase(0)
lockin3.set_sensitivity(18)                                 #16 good for 10 microV excitation #24 needed at high conductance!                  # Check S830 driver for the meaning of this number
lockin3.set_tau(8)
lockin3.set_sync_filter(0)
lockin3.set_reserve(1)                                          # tau = 9 equals 300 ms, check S830 driver for other integration times
'''

# This delay is needed at the beginning of a sweep, a good value is ~ 10*tau. If you don't use it, first few datapoints of the sweep will be weird. 
# It's safe to put it to 0 for Keithley measurements. 
delay1 = 4 #4 #1 #3
# Delay after setting dac during sweep, you should at least wait 1.5*tau, longer is better. This avoids integration over the previous dac value.
delay2 = 0.15 #0.15 #0.18 #0.05 #0.5 #1.8 #0.6 #0.4 #0.25 #0.73 #units: seconds
# The lazy way - by Jouri
def set_delay1(Nlockins,factor=15): # Function to set delay1 to 10*tau
    if Nlockins==1:
        tau=float(lockin1.get_tau())
    elif Nlockins==2:
        tau=float(max([lockin1.get_tau(),lockin2.get_tau()]))
    elif Nlockins==3:
        tau=float(max([lockin1.get_tau(),lockin2.get_tau(),lockin3.get_tau()]))
    if Nlockins==0:
        delay=0
    else:
        if tau % 2 == 0: # if tau is even
            delay = 10**(tau/2-5)*factor
        elif tau % 2 == 1: #if tau is odd
            delay = 0.3*10**((tau+1)/2-5)*factor
    return delay
def set_delay2(Nlockins): # Function to set delay2 to ~1.7*tau
    if Nlockins==1:
        tau=float(lockin1.get_tau())
    elif Nlockins==2:
        tau=float(max([lockin1.get_tau(),lockin2.get_tau()]))
    elif Nlockins==3:
        tau=float(max([lockin1.get_tau(),lockin2.get_tau(),lockin3.get_tau()]))
    if Nlockins==0:
        delay=0
    else:
        if tau % 2 == 0:
            delay = 1.7*10**(tau/2-5)
        elif tau % 2 == 1:
            delay = 0.5*10**((tau+1)/2-5)
    return delay
delay1 = set_delay1(Nlockins)
delay2 = set_delay2(Nlockins)


#################### MEASUREMENTS #########################

m = majorana()
# remark: You cannot take more than 16 pnts/mV on a dac. 4000mV/2^16 = 0.061, below that stepsize you hit dac quantization.
ivvi.set_parameter_rate('dac1',1,1) #normal rate 1/1 with 10mV/V
ivvi.set_parameter_rate('dac2',1,1) #normal rate 1/1 with 10mV/V

dac_quantization = 4000.0/65536.0 # = 4000/2^16 unit = mV #0.06103515625
sweeprateHV = 0.01 #mV/ms = V/s (0.04,0.008)
sweeprate = 0.02 #mV/ms = V/s (for top gates) (0.03 is safe and fast)
# sweeprate = 0.001 # mV/ms = V/s
amp = SGrange
waittime = (dac_quantization * amp) / sweeprate # unit = millisecond
''' !!!!!!!!!!!!!!!!!!!!! Beware, BGrange is changed to SGrange for SiN backgate, so sweeping is faster now!!!!!!!!!!!!!!!!! '''
waittimeHV = (dac_quantization * SGrange) / sweeprateHV # unit = millisecond ######!!!!!!!!!!!!!!!!!!!!! Beware, BGrange is changed to SGrange for SiN backgate, so sweeping is faster now!!!!!!!!!!!!!!!!!
''' !!!!!!!!!!!!!!!!!!!!! Beware, BGrange is changed to SGrange for SiN backgate, so sweeping is faster now!!!!!!!!!!!!!!!!! '''
'''
ivvi.set_parameter_rate('dac3',dac_quantization,waittimeHV)
for i in range(4,17): ivvi.set_parameter_rate('dac'+str(i),dac_quantization,waittime)
magnet.set_Magnet_Sweeprate(0.05)
'''
keithley1.set_nplc(2)

ivvi.get_all()

waitT = 0             # 1: Wait for temperature to reach Tmax during B sweeps
Tmax = 0.028          # Maximum temperature to continue measurements during B sweeps
leak_exit = 0        # 1: Check gate leakage and set gate to zero if leakage exceeds the set limit 'leaklimit' (see def. gateleakage_exit)
leaklimit = 2.5    # Limit for the gate leakage in nA (when using HV current monitor) above which the gate is set to zero.

setG = 0        #Set conductance in outer for loop in dac_vs_dac to Gset at bias setG_bias (e.g. sweep bias vs sg, set tgs to yield G=Gset each iteration) if setG == 1
Gset = 0.2
setG_bias = -150

offset = 62

filename = 'Wires_15a_17a'

ivvi.set_parameter_rate('dac1',10,1)
ivvi.set_parameter_rate('dac2',60,1)

ivvi.set_parameter_rate('dac12',1,5)
ivvi.set_parameter_rate('dac3',0.1,10)
ivvi.set_parameter_rate('dac14',1,5)
ivvi.set_parameter_rate('dac16',1,5)
ivvi.set_parameter_rate('dac11',1,1)
ivvi.set_parameter_rate('dac13',1,1)
ivvi.set_parameter_rate('dac15',1,1)

ivvi.set_parameter_rate('dac5',1,5)
ivvi.set_parameter_rate('dac6',1,5)




#R, theta, phi
#m._set_3Dfield(0.0, 0, 0)

#ivvi.set_dacs_zero()
ivvi.set_dac2(100)     #10mV/V
#ivvi.set_dac3(250)        #BG: 15V/V


#ivvi.set_dac11(0)    #TG1-coarse: 10mV/V
#ivvi.set_dac12(0)  #TG1-fine: 1V/V


#ivvi.set_dac13(0)     #TG2-coarse: 10mV/V
#ivvi.set_dac14(0)   #TGb-fine:1V/V

#ivvi.set_dac15(0)   #PG-coarse: 10mV/V
#ivvi.set_dac16(0)  #Pg-fine: 1V/V



#m._dac_vs_dac('Vbias (2mV/V)','dac2', -50+40, 50+40, 150, 'PG fine (10mV/V)','dac16', 0, 200, 200)
#m._dac_vs_dac('Vbias (1mV/V)','dac2',-420, 580, 500,'TG (1V/V)','dac5', -35, -45, 40)
#m._dac_vs_dac('TG1 fine (10mV/V)','dac12', 1200, 2000, 300,'TG2 (1V/V)','dac14', 0, 500, 10)
#ivvi.set_dac2(40) 
#m._dac_vs_dac('TG1 (1V/V)','dac11', -220, 200, 50,'TG2 (1V/V)','dac13', -400, 200, 60)
#m._dac_vs_dac('TG1 (1V/V)','dac11', -300, -100, 200,'PG fine (10mV/V)','dac16', -100 , 100, 200)
#ivvi.set_dac11(-180) 
#m._dac_vs_dac('TG2 (1V/V)','dac13', -300, 100, 40,'PG fine (10mV/V)','dac16', -500 , 100, 60)
#ivvi.set_dac2(1000)
#m._single_dac_sweep('Vbias (2mV/V)','dac2', -150+40, 150+40, 120)
m._single_dac_sweep('BG(15V/V)','dac3', -200, 600, 300)
m._single_dac_sweep('BG(15V/V)','dac3', 600, -200, 300)
#m._single_dac_sweep('TG1 coarse (1V/V)','dac11', -400, 100, 100)
#m._single_dac_sweep('TG2 coarse (1V/V)','dac13', 100, -600, 140)

#m._single_dac_sweep('PG coarse','dac15', -1600, -2000, 400)

#m._dac_vs_dac('Vbias (2mV/V)','dac2', -50+40, 50+40, 80, 'TG2 coarse (1V/V)','dac13', -390, -450, 30)
#m._single_dac_sweep('TG2 coarse (1V/V)','dac13', -277, -267, 60)   #m._single_dac_sweep('TG2 fine (10mV/V)','dac14', -1000, 1000, 100)

#m._single_dac_sweep('Vbias (2mV/V)','dac2', -40+40, 40+40, 80)
#m._dac_vs_theta('Vbias (2mV/V)','dac2',-40+40, 40+40, 80, -20+6, 20+6, 80, 0.14, 0)
#m._dac_vs_theta('Vbias (2mV/V)','dac2',-40+40, 40+40, 80,  20+6,-20+6, 80, 0.14, 0)

#m._dac_vs_phi('Vbias (2 mV/V)','dac2',-40+40, 40+40, 80, 120, 240, 60, 0.14, 6)  
#m._dac_vs_phi('Vbias (2 mV/V)','dac2',-40+40, 40+40, 80, 20, -20, 80, 0.14, 6)  
#m._dac_vs_theta('Vbias (2mV/V)','dac2',-25+40, 25+40, 100, 22, 0, 44, 0.4, 0)
#m._dac_vs_B_3D('Vbias (2mV/V)','dac2', -30+40 , 30+40, 90, 0, 0.8, 80, 3, 0)
#m._dac_vs_B_3D('Vbias (2mV/V)','dac2', -80+40 , 80+40, 160, 1, 0, 250, 3, 0)

#m._single_dac_sweep('PG fine (10mV/V)','dac16', -50 , -50, 50)
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -25+40, 25+40, 80, 'PG fine (10mV/V)','dac16', -250, -175, 75) 
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -25+40, 25+40, 80, 'PG fine (10mV/V)','dac16', -175, -250, 75)


#m._dac_vs_B_3D('PG fine (10mV/V)','dac16', -250 , -150, 80, 0, 0.7, 70, 0, 3)

#m._dac_vs_dac('PG fine (10mV/V)', 'dac16', -50, 50, 40, 'TG1 (1V/V)','dac11', -300, 100, 80)

#m._single_dac_sweep('TG1 coarse (1V/V)','dac11', 0, -300, 100)
#m._single_dac_sweep('PG fine (10mV/V)','dac16', -200 , 200, 200)





#m._dac_vs_2dacs('PG fine (10mV/V)', 'dac16',-150,150, 150, 'TG1 (1V/V)','dac11', -200, 200, 'TG2 (1V/V)', 'dac13', -400, 200, 80)

#ivvi.set_dac11(-180)

#m._dac_vs_2dacs('PG fine (10mV/V)', 'dac16',-60 , 60, 50, 'TG1 (1V/V)','dac11', -300, 100, 'TG2 (1V/V)', 'dac13', -500, 100, 100)

#m._set_3Dfield(0.0, 0, 3)


#m._single_dac_sweep('PG fine (10mV/V)', 'dac16', -100, 100, 80)
#m._2dacs_sweep('TG1 (1V/V)','dac11', -305, -50, 'TG2 (1V/V)', 'dac13', -473, -93, 255)

#m._dac_vs_2dacs('Vbias (2mV/V)','dac2', -5+40, 5+40, 10, 'TG1 (1V/V)','dac11', -305, -50, 'TG2 (1V/V)', 'dac13', -473, -93, 51)
#m._dac_vs_2dacs('PG fine (10mV/V)', 'dac16',-100,100, 80, 'TG1 (1V/V)','dac11', -50, -305, 'TG2 (1V/V)', 'dac13', -93, -473, 51)



#m._dac_vs_B_3D('Vbias (2mV/V)','dac2', -150+40 , 150+40, 150, 0, 0.5, 50, 0, 3)


#m._dac_vs_dac('Vbias (2mV/V)','dac2', -100+40, 100+40, 200, 'TG2 coarse (1V/V)','dac13', -500, -800, 300)

#m._dac_vs_dac('Vbias (2mV/V)','dac2', -100+40, 100+40, 200, 'TG2 coarse (1V/V)','dac13', -300, -600, 60)


'''
ivvi.set_dac15(300)
Bs = [0.12,16]  #np.linspace(0.6, 0.10, 17)
for B in Bs:
    m._set_3Dfield(B, 0, 3)
    m._dac_vs_2dacs('PG fine (10mV/V)', 'dac16',-100,100, 80, 'TG1 (1V/V)','dac11', -305, -50, 'TG2 (1V/V)', 'dac13', -473, -93, 51)
'''

'''
ivvi.set_dac15(-700)
Bs = np.linspace(0.34, 0.70, 10)
for B in Bs:
    m._set_3Dfield(B, 0, 3)
    m._dac_vs_2dacs('PG fine (10mV/V)', 'dac16',-100,100, 100, 'TG1 (1V/V)','dac11', -305, 325, 'TG2 (1V/V)', 'dac13', -473, 382, 71)
'''





#m._single_dac_sweep('PG fine (10mV/V)','dac16', -300 , 300, 350)
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -20+40, 20+40, 120, 'PG fine (10mV/V)','dac16', 120, 620, 300)
#m._dac_vs_dac('TG1 (1V/V)','dac11', -600, 0, 150,'TG2 (1V/V)','dac13', -800, -100, 100)


#m._set_3Dfield(0.6, 0, 3)

'''
Tunnelrange = np.linspace(0.00, -0.5, 10)
for TG1 in Tunnelrange:
    filename = ''.format(B)
    ivvi.set_dac11(TG1)

    m._dac_vs_dac('PG fine (10mV/V)','dac16', -100 , 200, 150, 'PG coarse','dac15', -600, -1200, 60)
'''
'''

m._dac_vs_B_3D('PG fine','dac16', 0, 250, 250, 1.0, 0.0, 100, 0, 3)
m._set_3Dfield(0.0, 0, 0)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -30+40, 30+40, 120, 'PG fine (10mV/V)','dac16', 100, 200, 100)

m._set_3Dfield(0.2, 0, 0)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -30+40, 30+40, 120, 'PG fine (10mV/V)','dac16', 100, 200, 100)

m._set_3Dfield(0.4, 0, 0)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -25+40, 25+40, 120, 'PG fine (10mV/V)','dac16', 100, 200, 100)

m._set_3Dfield(0.6, 0, 0)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -25+40, 25+40, 120, 'PG fine (10mV/V)','dac16', 100, 200, 100)

m._set_3Dfield(0.8, 0, 0)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -20+40, 20+40, 120, 'PG fine (10mV/V)','dac16', 100, 200, 100)

m._set_3Dfield(1.0, 0, 0)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -20+40, 20+40, 120, 'PG fine (10mV/V)','dac16', 100, 200, 100)

'''

 

#m._single_dac_sweep('TG1 fine (10mV/V)','dac12', 0, 1000, 500)
#m._single_dac_sweep('TG2 fine (10mV/V)','dac14', -500,  500, 300)
#m._single_dac_sweep('Vbias (2mV/V)','dac2', -80+40, 80+40, 120)

#m._single_dac_sweep('PG fine (10mV/V)','dac16', -200, 200, 700)
#m._single_dac_sweep('PG coarse (1V/V)','dac15', 0, 1000, 500)

#ivvi.set_dacs_zero()
#m._single_dac_sweep('BG(15V/V)','dac3',600, 0, 200)
#$ivvi.set_dac2(1000)
#m._single_dac_sweep('BG(15V/V)','dac3',0, 600, 200)
#m._single_dac_sweep('BG(15V/V)','dac3',600, 0, 200)

#m._dac_vs_theta('Vbias (2mV/V)','dac2', -30+40, 30+40, 120, -40, 40, 80, 0.10, 90)








#m._dac_vs_dac('Vbias (2mV/V)','dac2', -200, 200, 100, 'TG2','dac13', -1000, -300, 350)


#m._dac_vs_dac('TG1-coarse','dac11', 0, -300, 90, 'TG2-coarse','dac13', 0, -400, 60)
#ivvi.set_dac2(0)
#m._dac_vs_dac('TG1','dac5', -1100, -400, 150, 'TG2','dac6', -1400, -600, 150)








#--------------------------------------------------------------------#

#ivvi.set_dac3(-45.8)
#m._dac_vs_theta('Vbias (2mV/V)','dac2',-200+40, +200+40, 110, -20, 20, 40, 0.25, 0)
#m._single_dac_sweep('Vbias(1m/V)','dac2',-1000, 1000, 200)

#m._dac_vs_B_3D('Vbias(1mV/V)','dac2', -800, 800, 200 , 0, 2, 100, -2, 0)

#ivvi.set_dacs_zero()
#ivvi.set_dac3(-200)

#m._dac_vs_dac('Vbias (1mV/V)','dac2',-1800, 1800, 400,'BG (15V/V)','dac3',143, 145, 100)


#m._dac_vs_dac('Vbias (1mV/V)','dac2',-800, 800, 200,'BG (15V/V)','dac3',170, 175, 100)



#Ibias
#ivvi.set_dac3(600)

#m._single_dac_sweep('Ibias(10nA/1V)','dac2',-1800, 1800, 350)
#m._dac_vs_dac('Ibias (10nA/1V)','dac2', -1800, 1800, 350, 'BG (15V/V)','dac3', 100, 800, 100)

#m._dac_vs_dac('Vbias (1mV/V)','dac2',-750, 750, 200,'BG (5V/V)','dac3',240,270,150)
#m._dac_vs_dac('Vbias (1mV/V)','dac2',-750, 750, 200,'BG (5V/V)','dac3',450,480,150)
#m._dac_vs_theta('Vbias (1mV/V)','dac2',-750, +750, 200, -40, 40, 80, 0.25, 0)
#opt theta -7   
#m._dac_vs_phi('Vbias (2 mV/V)','dac2',-600, 600, 200, -80, 80, 160, 0.2, 73)  
#opt phi 1

#wire 1.1 angles
#opt theta 356
#opt phi =0

#ivvi.set_dac3(810)    #BG: 5V/V

#ivvi.set_dac3(1783.3)    #BG: 5V/V
#m._dac_vs_B_3D('Ibias (10nA/1V)','dac2', -1800, 1800, 300, 0, 0.2, 100, 92, 0)

#ivvi.set_dac3(205)    #BG: 5V/V



#ivvi.set_dac3(220)    #BG: 15V/V
#m._dac_vs_B_3D('Vbias(1mV/V)','dac2',-750, 750, 250 , 1.5, 0, 75, -7, 0)

#ivvi.set_dac3(950)    #BG: 5V/V
#m._dac_vs_B_3D('Vbias(1mV/V)','dac2',-750, 750, 250 , 1.5, 0.0, 75, 355, 0)

#ivvi.set_dac3(500)    #BG: 15V/V
#m._dac_vs_B_3D('Vbias(1mV/V)','dac2',-1000, 1000, 400 , 1.8, 0.0, 90, 356, 0)

#tonight at zero field
#m._set_3Dfield(0.0, 75, 2)
#m._set_3Dfield(0.0, 0, 0)
#m._dac_vs_dac('Vbias (1mV/V)','dac2', -700, 700, 250, 'BG (15V/V)','dac3', -100, 350, 500)

#---------------------------------------------------------------------#

#Ibias
#m._single_dac_sweep('Ibias(10nA/1V)','dac2',-1500, 1500, 300)
#m._dac_vs_dac('Ibias (10nA/1V)','dac2', -2000, 2000, 300, 'BG (15V/V)','dac3', 50, 700, 100)




#Single Sweep

#m._single_dac_sweep('Vbias(10mV/V)','dac2',1000, -1000, 500)

#ivvi.set_dac2(1000)
#m._single_dac_sweep('BG(15V/V)','dac3',0, 1500, 500)
#m._single_dac_sweep('BG(15V/V)','dac3',1500, 0, 500)
#ivvi.set_dac2(0)

#m._single_dac_sweep('BG(15V/V)','dac3',0, 2000, 500)
#m._single_TGdac_sweep('BG(30V/V)','dac3',0,-500,500)
#m._single_dac_sweep('TG (5V/V)','dac3', -30, 100, 130)
#m._single_dac_sweep('TG (5V/V)','dac12', -400, 400, 800)
#m._single_dac_sweep('TGb(50mV/V)','dac13',-2000,2000,2000)
#m._single_dac_sweep('TGb(5V/V)','dac14',-400,400,800)
#m._set_3Dfield(0.0, 75, 2)
#m._single_dac_sweep('PG(50mV/V)','dac15',-510,-300,420)
#m._single_dac_sweep('PG(5V/V)','dac16',-400, 400, 800)

#ivvi.set_dac2(0)
#m._set_3Dfield(0.0, 75, 2)
#m._single_dac_sweep('PG(50mV/V)','dac15', -1000, 500, 3000)


#m._set_3Dfield(0.0, 52, 14)
#m._single_dac_sweep('TGa (50mV/V)','dac11', -2000, 0, 2000 )
 
#m._dac_vs_dac('TGa (5 V/V)','dac12',-90,-35,300,'TGb (5 V/V)','dac14',-105,-50,300)

#m._dac_vs_B_3D('Vbias(2mV/V)','dac2',-800,800,200, 0, 0.5, 50, 0, 90)
#m._dac_vs_B_3D('PG (50mV/V)','dac15', -1000, 0, 1000 , 1.0, 0.0, 20, 75, 2)
#m._dac_vs_B_3D('PG (50mV/V)','dac15', 0, 1000, 1000, 0.0, 1.0, 20, 75, 2)
#m._dac_vs_B_3D('PG (50mV/V)','dac15', -1900, -1500, 600, 0, 1.0, 100, 75, 2)
#m._set_3Dfield(0.0, 75, 2)
#m._set_3Dfield(0.0, 75, 2
#m._dac_vs_B_3D('PG (50mV/V)', 'dac15', 1650, 1850, 400, 0.8, 0.0, 80, 52, 14)
#m._dac_vs_B_3D('PG(50mV/V)', 'dac15', -2000, -1500, 400, 0.0, 0.8, 80, 52, 14)


#m._dac_vs_B_3D('PG(50mV/V)', 'dac15', -1000, -500, 400, 0.0, 0.8, 80, 52, 14)
#m._dac_vs_B_3D('PG(50mV/V)', 'dac15', 1700, 1500, 320, 0.8, 0.0, 80, 52, 14)

#m._dac_vs_B_3D('PG(50mV/V)', 'dac15', -1000, -500, 1000, 0.0, 0.8, 80, 52, 14)


#Francesco

#m._set_3Dfield(0.0, 75, 2)
#m._dac_vs_dac('Vbias (1mV/V)','dac2', -1000, 1000, 300, 'BG (15V/V)','dac3', -100, 1100, 300)
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -500, 500, 400, 'TGb(5V/V)','dac14',-450,450,100)
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -500, 500, 400, 'TGa(5V/V)', 'dac12', 50, 450, 100)
#ivvi.set_dac14(-290) 
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -500, 500, 400, 'TGa(5V/V)', 'dac12', 50, 450, 100)
#ivvi.set_dac14(-240) 
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -500, 500, 400, 'TGa(5V/V)', 'dac12', 50, 450, 100)
#ivvi.set_dac14(-200)
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -500, 500, 400, 'TGa(5V/V)', 'dac12', 50, 450, 100)
#ivvi.set_dac14(-160) 
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -500, 500, 400, 'TGa(5V/V)', 'dac12', 50, 450, 100)
#ivvi.set_dac14(-120) 
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -500, 500, 400, 'TGa(5V/V)', 'dac12', 50, 450, 100)
#ivvi.set_dac14(-90) 
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -500, 500, 400, 'TGa(5V/V)', 'dac12', 50, 450, 100)
#m._dac_vs_dac('PG (50mV/V)','dac15', -200, 200, 400, 'TGa(5V/V)','dac12',-60,150,105)

#ivvi.set_dac14(400)
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -500, 500, 400, 'TGa(5V/V)','dac12',-250,450,150)

#m._set_3Dfield(0.0, 75, 2)
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -130, 130, 100, 'PG (50mV/V)','dac15', -1150, -600, 500)

#m._set_3Dfield(0.1, 75, 2)
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -120, 120, 100, 'PG (50mV/V)','dac15', -1150, -600, 500)
'''
m._set_3Dfield(0.5, 75, 2)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -100, 100, 150, 'PG (50mV/V)','dac15', 1560, 1700, 210)

m._set_3Dfield(0.6, 75, 2)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -90, 90, 150, 'PG (50mV/V)','dac15', 1560, 1700, 210 )

m._set_3Dfield(0.7, 75, 2)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -80, 80, 150, 'PG (50mV/V)','dac15', 1560, 1700, 210 )

m._set_3Dfield(0.8, 75, 2)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -70, 70, 150, 'PG (50mV/V)','dac15', 1560, 1700, 210 )
#ivvi.set_dac2(0)
#T=0.2K

m._set_3Dfield(0.0, 75, 2)
m.set_heaterrange(0.25)
magnet.set_MCTemp(0.25)
m.wait_T_set(0.25,0.001)
m._dac_vs_B_3D('PG (50mV/V)','dac15', -280, -20, 520, 0.0, 1.0, 100, 75, 2)
m._set_3Dfield(0.0, 75, 2)

m.set_heaterrange(0.15)
magnet.set_MCTemp(0.15)
m.wait_T_set(0.15,0.001)
m._dac_vs_B_3D('PG (50mV/V)','dac15', -280, -20, 520, 0.0, 1.0, 100, 75, 2)
m._set_3Dfield(0.0, 75, 2)

m.set_heaterrange(0.05)
magnet.set_MCTemp(0.05)
m.wait_T_set(0.05,0.001)
m._dac_vs_B_3D('PG (50mV/V)','dac15', -280, -20, 520, 0.0, 1.0, 100, 75, 2)
m._set_3Dfield(0.0, 75, 2)

m.set_heaterrange(0.015)
magnet.set_MCTemp(0.015)
#m._dac_vs_B_3D('PG (50mV/V)','dac15', -150, 200, 700, 0.0, 1.0, 100, 75, 2)

m._set_3Dfield(0.5, 75, 2)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -100, 100, 150, 'PG (50mV/V)','dac15', -65, 55, 180 )

m._set_3Dfield(0.4, 75, 2)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -110, 110, 150, 'PG (50mV/V)','dac15', -65, 55, 180 )

m._set_3Dfield(0.3, 75, 2)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -120, 120, 150, 'PG (50mV/V)','dac15', -65, 55, 180 )

m._set_3Dfield(0.2, 75, 2)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -130, 130, 150, 'PG (50mV/V)','dac15', -65, 55, 180 )

m._set_3Dfield(0.1, 75, 2)
m._dac_vs_dac('Vbias (2mV/V)','dac2', -140, 140, 150, 'PG (50mV/V)','dac15', -65, 55, 180 )


'''


#m._set_3Dfield(0.2, 75, 2)
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -110, 110, 130, 'PG (50mV/V)','dac15', 885, 985, 150 )


#m._dac_vs_dac('Vbias (2mV/V)','dac2',-110, 110, 110, 'PG (50mV/V)','dac15', 680, 860, 360 )
#m._set_3Dfield(0.12, 75, 2)
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -600, 600, 200, 'PG (50mV/V)','dac15', -1400, -1000, 400 )
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-130, 130, 130, 'PG (50mV/V)','dac15', 680, 1060, 380 )
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-500, 500, 150, 'PG (50mV/V)','dac15', 700, 1200, 500 )

#ivvi.set_dac15(850)
#m._dac_vs_dac('TGa (5 V/V)','dac12',-88,-72,300,'TGb (5 V/V)','dac14',-105,-70,180)
#ivvi.set_dac15(800)
#m._dac_vs_dac('TGa (5 V/V)','dac12',-88,-72,380,'TGb (5 V/V)','dac14',-105,-70,180)
#ivvi.set_dac15(950)
#m._dac_vs_dac('TGa (5 V/V)','dac12',-88,-72,300,'TGb (5 V/V)','dac14',-105,-70,180)
#m._dac_vs_dac('TGb (5 V/V)','dac14',-90,-90,100,'TGa (5 V/V)','dac12',-100,-90,100)

#ivvi.set_dac2(0)
#m._dac_vs_B_3D('PG(50mV/V)', 'dac15', 650, 1100, 900, -1.0, 1.0, 200, 75, 2)
#m._dac_vs_B_3D('PG(50mV/V)', 'dac15', -1200, -900, 600, 0.8, 0.0, 80, 52, 14)

#m._dac_vs_B_3D('TGa (50 mV/V)','dac11', 1400, 1600, 200, 0.8, 0, 80,52,14)

#m._set_3Dfield(0.0, 75, 2)
#m._dac_vs_dac('Vbias (2mV/V)','dac2', -600, 600, 200, 'PG (50mV/V)','dac15', -1400, -1000, 400 )
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-240, 240, 100, 'PG (50mV/V)','dac15', -1150, -700, 450 )

'''
# Dac vs Dac
#m._dac_vs_dac('TGa (5 V/V)','dac12',-100,100,400,'TGb (5 V/V)','dac14',-400,0,400)
#m._dac_vs_dac('TGb (1 V/V)','dac14',-350,-300,300,'TGa (1 V/V)','dac12',-100,-50,500)
#ivvi.set_dac12(2000)
#m._dac_vs_dac('TGa (5 V/V)','dac12',-110,-140,180, 'PG (5 V/V)','dac16',1000,0,200)
#m._set_3Dfield(0.4,75,2)
#m._dac_vs_dac('TGa (5 V/V)','dac12',-80,-140,280, 'PG (5 V/V)','dac16',1000,-1000,200)
#m._set_3Dfield(0.6,75,2)
#m._dac_vs_dac('TGa (5 V/V)','dac12',-80,-140,280, 'PG (5 V/V)','dac16',1000,-1000,200)
#ivvi.set_dac14(2000)
#m._dac_vs_dac('TGa (1 V/V)','dac12',1000,-1000,200, 'PG (1 V/V)','dac16',2000,-2000,200)
#m._set_3Dfield(0.4,52,14)
#ivvi.set_dac16(1000)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-150,150,300,'PG (5V/V)','dac16',500,1000,10)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-300,300,300,'TGb (5 V/V)','dac14',-400,-550,150)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-200,200,200,'TGa (5V/V)','dac12',-115,-135,40)

#ivvi.set_dac14(2000)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-400,400,200,'TGa (5 V/V)','dac12',-124,-139,30)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-150,150,300,'TGa (10 mV/V)','dac11',500,1500,100)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-150,150,300,'PG (10 mV/V)','dac15',500,1000,250)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-100,100,150,'PG (5 V/V)','dac16',400,600,20)
#m._dac_vs_dac('TGb (1 V/V)','dac14',-1000,2000,400, 'Vbias (10mV/V)','dac2',-1000,1000,300)


#ivvi.set_dac16(0)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-150,150,200,'PG (1V/V)','dac16',-435,-440,150)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-150,150,200,'PG (10mV/V)','dac15',0,800,200)
#m._set_3Dfield(0.35,75,2)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-150,150,200,'PG (10mV/V)','dac15',0,800,200)
# PG: TGb= 10; PG: TGa=5
#ivvi.set_dac12(-35)



#m._2dacs_sweep( 'PG (1V/V)', 'dac16',-100,100, 'TGb (10mV/V)', 'dac13',2000,-2000,2000)
#m._2dacs_sweep( 'PG (50mV/V)','dac15',-2000,2000, 'TGb (50mV/V)', 'dac13',2000,-2000,2000)
#m._3dacs_sweep( 'PG (10mV/V)', 'dac15',-200,600, 'TGa (1V/V)', 'dac12',-70,-50, 'TGb (1V/V)', 'dac14',-270,-230,200)
#m._3dacs_sweep( 'PG (1V/V)', 'dac16',-1000,-800, 'TGa (1V/V)', 'dac12',-112,-124, 'TGb (1V/V)', 'dac14',12,-5,2000)
#ivvi.set_dac16(-0)
#ivvi.set_dac12(-170)
#ivvi.set_dac14(-70)
#m._3dacs_sweep( 'PG-fine (10mV/V)', 'dac15',-2000,2000, 'TGa-fine (10mV/V)', 'dac11',125,-125, 'TGb-fine (10mV/V)', 'dac13',175,-75,1000)
#m._3dacs_sweep( 'PG-coarse (1V/V)', 'dac16',-100,100, 'TGa-fine (10mV/V)', 'dac11',625,-625, 'TGb-fine (10mV/V)', 'dac13',875,-875,4000)
#m._dac_vs_3dacs('Vbias(2mV/V)', 'dac2', -150, 150, 300, 'PG-fine (10mV/V)', 'dac15',-2000,2000, 'TGa-fine (10mV/V)', 'dac11',125,-125, 'TGb-fine (10mV/V)', 'dac13',175,-75,500)


#m._set_3Dfield(0.18,75,2)
#m._dac_vs_2dacs('Vbias(2mV/V)', 'dac2',-150,150,300, 'PG (1V/V)','dac16',-1800,1800, 'TGb (1V/V)', 'dac14',-310,-490,500)


# -----theta=52, phi=14 for device4
# -----theta=75, phi=2 for device3

# -----theta=63, phi=2 for device4 for second cooling down



#m._set_3Dfield(0.5,52,14)
#ivvi.set_dac2(0)
#ivvi.set_dac16(-400)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-300,300,150,'TGb (5V/V)','dac14',-400,-540,140)
#ivvi.set_dac16(-700)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-300,300,150,'TGb (5V/V)','dac14',-400,-540,140)
#ivvi.set_dac16(-1000)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-300,300,150,'TGb (5V/V)','dac14',-400,-540,140)
#ivvi.set_dac16(1000)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-300,300,150,'TGb (5V/V)','dac14',-400,-540,140)

#m._dac_vs_dac('TGb (5 V/V)','dac14',-400,-540,140,'PG (5 V/V)','dac16',0,1000,100)
#m._dac_vs_theta('Vbias (2 mV/V)','dac2',-150,150,200,0,360,180,0.3,0)
#m._dac_vs_phi('Vbias (2 mV/V)','dac2',-150,150,200,0,360,180,0.3,63)

#ivvi.set_dac16(-1000)
#ivvi.set_dac12(-132)
#ivvi.set_dac14(-510)
#m._dac_vs_B_3D('Vbias (2mV/V)','dac2',-400,400,200,0.0,0.0,100,52,14)
#ivvi.set_dac14(-520)
#m._dac_vs_B_3D('Vbias (2mV/V)','dac2',-400,400,200,1.0,0.0,100,52,14)
#ivvi.set_dac14(-530)
#m._dac_vs_B_3D('Vbias (2mV/V)','dac2',-400,400,200,0.0,0.0,100,52,14)
#ivvi.set_dac14(-540)
#m._dac_vs_B_3D('Vbias (2mV/V)','dac2',-400,400,200,1.0,0.0,100,52,14)
#ivvi.set_dac12(-133)
#m._dac_vs_B_3D('Vbias(2mV/V)','dac2',-375,375,250,1.0,0.0,100,75,2)
#ivvi.set_dac12(-134)
#m._dac_vs_B_3D('Vbias(2mV/V)','dac2',-375,375,250,0.0,1.0,100,75,2)
#ivvi.set_dac12(-135)
#m._dac_vs_B_3D('Vbias(2mV/V)','dac2',-375,375,250,1.0,0.0,100,75,2)

#m._set_3Dfield(0.4,52,14)
#m._dac_vs_2dacs('Vbias(2mV/V)', 'dac2',-150,150,150, 'PG (5V/V)','dac16',-1000,1000, 'TGb (5V/V)', 'dac14',-445,-520,200)
#m._set_3Dfield(0.5,52,14)
#m._dac_vs_2dacs('Vbias(2mV/V)', 'dac2',-150,150,150, 'PG (5V/V)','dac16',-1000,1000, 'TGb (5V/V)', 'dac14',-445,-520,200)
#m._dac_vs_B_3D('PG (10 mV/V)','dac15',300,2000,400,0.0,1.0,75,75,2)
#m._set_3Dfield(0.0,75,2)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-250,250,300,'PG (10mV/V)','dac15',600,1600,250)

#scan of Vbias at given PG and TGB from 0 to 1 T in 100 steps with angles 75 and 2
#ivvi.set_dac15(-750)
#ivvi.set_dac13(127.5)

#m._dac_vs_B_3D('PG(50mV/V)','dac15',-300,-180,360,0.0,0.8,80,52,14)
#m._dac_vs_B_3D('PG(50mV/V)','dac15',-900,-780,360,0.8,0.0,80,52,14)
#m._dac_vs_B_3D('TGa(1V/V)','dac12',-200,150,3500,0.9,0.0,70,52,14)
#ivvi.set_dac16(-600)
#ivvi.set_dac14(-422)
#m._dac_vs_B_3D('Vbias(2mV/V)','dac2',-300,300,300,0.9,0.0,90,52,14)




                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                

#m._set_3Dfield(0.5,52,14)
#m._dac_vs_dac('Vbias (2mV/V)','dac2',-250,250,300,'PG (1V/V)','dac16',2000,-2000,200)


#m._2dacs_vs_B_3D('PG (5V/V)','dac16',-600,600,'TGb (5V/V)','dac14',-448,-490, 300, 0.0, 1.0, 100, 52, 14)

#m._2dacs_vs_B_3D('PG (10mV/V)','dac15',-1500,-500,'TGb (10mV/V)','dac13',255,85, 400, 0.0, 1.0,100,75,2)
#m._set_3Dfield(0,75,2)





#m._2dacs_vs_B_3D('PG (10mV/V)','dac15', -2000, -1000, 'TGb (10mV/V)','dac13',-350, -174, 500, 0.0, 1.0, 50, 75, 2)

#m._dac_vs_2dacs('PG (10mV/V)', 'dac15',-1000,1000,400, 'PG (1V/V)','dac16',-1800,1800, 'TGb (1V/V)', 'dac14',-188,-332,90)

#m._dac_vs_2dacs('PG (10mV/V)', 'dac15',-1000,1000,400, 'PG (1V/V)','dac16',-1800,1800, 'TGb (1V/V)', 'dac14',-30,-130,90)

#m._dac_vs_3dacs('PG-fine (10mV/V)', 'dac15',-1000,1000,400, 'PG-coarse (1V/V)','dac16',-1800,1800, 'TGa (1V/V)', 'dac12',-50,-300,'TGb (1V/V)', 'dac14',100,-250,90)

#m._dac_vs_3dacs('Vbias(2mV/V)', 'dac2', -150, 150, 300, 'PG-coarse (1V/V)','dac16',-1800,1800, 'TGa (1V/V)', 'dac12',-50,-300,'TGb (1V/V)', 'dac14',100,-250, 1000)




#T=17mK
#m._2dacs_vs_B_3D('PG (10mV/V)', 'dac15', 2000,-2000, 'TGb (10mV/V)', 'dac13', 2, -350, 1000, 0.0, 1.0, 100, 75, 2)
#m._2dacs_sweep('PG (10mV/V)', 'dac15', 2000,-2000, 'TGb (10mV/V)', 'dac13', 2, -350, 1000)

#m._2dacs_sweep('PG (1V/V)', 'dac16', 1800,1700, 'TGb (1V/V)', 'dac14',-500,2000,3000)
#ivvi.set_dac12(-400)
#m._2dacs_vs_B_3D('PG (1V/V)', 'dac16', 1510,1500, 'TGb (1V/V)', 'dac14',-500,500,2000, 0.0, 1.0, 75, 75, 2)
#ivvi.set_dac14(100)
#m._2dacs_sweep('PG (1V/V)', 'dac16', -1800,-1810, 'TGa (1V/V)', 'dac12',-600,2000,15600)
#m._2dacs_vs_B_3D('PG (1V/V)', 'dac16', -1800,-1810, 'TGa (1V/V)', 'dac12',0,1800,10800, 0.0, 1.0, 50, 75, 2)
#m._3dacs_vs_B_3D('PG (1V/V)', 'dac16', -1800,-1810, 'TGa (1V/V)', 'dac12',-100,1000, 'TGb (1V/V)', 'dac14',-300,1200,4000, 0.0, 1.0, 75, 75, 2)

#gate vs gate
#m._dac_vs_dac('TGa-coarse (1V/V)', 'dac12', -1000, 1000, 200, 'PG-coarse (1V/V)','dac16',-1000, 1000, 200)

'''
'''
Tunnelrange = np.linspace(0.0, 1.0, 75)
for B in Tunnelrange:
    filename = 'DEVICE3_SymmetricVbias_after_another_CoolingDown----amplitude'.format(B)
    ivvi.set_dac15(-1000)
    m._set_3Dfield(B,75,2)
    #m._3dacs_sweep( 'PG (1V/V)', 'dac16',-2000,-1900, 'TGa (1V/V)', 'dac12',-500,1000, 'TGb (1V/V)', 'dac14',-500,500,1000)
    m._dac_vs_3dacs('PG-fine (10mV/V)', 'dac15',-2000,2000,1000, 'PG-coarse (1V/V)','dac16',0,1800, 'TGa (1V/V)', 'dac12',-175,-300,'TGb (1V/V)', 'dac14',-75,-250,45)

    #m._dac_vs_3dacs('PG-fine (10mV/V)', 'dac15',-1000,1000,500, 'PG-coarse (1V/V)','dac16',500,700, 'TGa (1V/V)', 'dac12',-206.25,-218.75,'TGb (1V/V)', 'dac14',-118.75,-136.25,10)
    #m._dac_vs_2dacs('PG-fine (10mV/V)', 'dac15',-1000,1000,400, 'PG-coarse (1V/V)','dac16',-2000,2000, 'TGb (1V/V)', 'dac14',0,-700,100)


Tunnelrange = np.linspace(0.00, 0.7, 71)
for B in Tunnelrange:
    filename = 'DEVICE4_SymmetricVbias_after_another_CoolingDown_PG_VS_B(0-0.7T_70steps)&TGa=-30_finer'.format(B)
    ivvi.set_dac15(-200)
    m._set_3Dfield(B,52,14)
    m._dac_vs_2dacs('PG (10mV/V)', 'dac15',-200,200,400, 'PG (1V/V)','dac16',0,360, 'TGb (1V/V)', 'dac14',-80,-98,90)

#m._set_3Dfield(0,51,14)

Tunnelrange = np.linspace(1000,-1000,6)

for TC in Tunnelrange:
    filename = 'W5_BiasA_K1C_floatB_floatS_floatTB_2D_bias_vs_SG_TC_{:g}mV'.format(TC)
    ivvi.set_dac5(TC)    m._dac_vs_dac('Bias (1 mV/V)','dac1',-700+offset,700+offset,280,'SG (1 V/V)','dac7',-200,-250,50)

'''
#m._single_dac_sweep('SG (1 V/V)','dac7',-1000,1000,200)-+