# 3Flex - 3D Printable Parametric Tendon-driven Manipulator
#### Authors:  
F. Trauzettel, E. Vander Poorten, M. Ourak, J. Dankelman, P. Breedveld  
Medical Instruments  & Bio-Inspired Technology  

Corresponding author: F. Trauzettel  


#### Contact Information:
f.trauzettel@tudelft.nl  

Delft University of Technology - Faculty of Mechanical, Maritime and Materials Engineering  
Mekelweg 2  
2628CD Delft  
The Netherlands  

#### General Introduction
This dataset contains the parametric 3D CAD file and 3D printing settings required to adjust and 3D print the Fused Filament Fabricated Flexible Instrument (3Flex) Designed by Fabian Trauzettel as part of his PhD thesis project and submitted for publication in _Science and Technology of Welding and Joining_ (DOI pending acceptance).  
The data is being made public both to act as supplemetary material to the publication entitled "_Six smart design guidelines for high-tech manufacture on low-tech 3D printers - the case of the 3Flex_" as well as to allow other researchers to reuse and adapt the design in their own research.  
The design was created in the Medical Instruments & Bio-Inspired Technology group in 2021 and 2022.  
This work was supported by the ATLAS project. This project has received funding from the European Union’s Horizon 2020 research and innovation program under the Marie Skłodowska-Curie grant agreement No 813782.

#### Purpose of the design
The purpose of the design was to enable the 3D printing of compliant, tendon driven manipulators on affordable 3D printers using the Fused Filament Fabrication (FFF) process. While this was formerly only possible on more expensive stereolithography (SLA) or Digital Light Processing (DLP) 3D printers, the 3Flex is proof that these manipulators can be reliably and cheaply made, even on hobbyist-level machines. 

#### 3D printing 
All parts were 3D printed on a Prusa i3 Mk3s (Prusa Research a.s., Prague, Czechia) with a 0.25mm nozzle and using AmazonBasics Blue PLA filament.

#### Description of the Dataset
The Dataset contains two files, **3Flex.scad** and **PrusaSlicerConfig.ini**.  

**3Flex.scad** is an OpenSCAD file containing the 3D design of the 3Flex. OpenSCAD is a free and open source parametric Computer-Aided Design software that is available for Linux, Windows and Mac OS. Upon opening the file with OpenSCAD, the user will be able to preview and modify the parameters of the design to their preference, and then render and export an .stl to 3D print with their preferred 3D slicer and 3D printer. The .stl file should export in millimeters.

**PrusaSlicerConfig.ini** is a configuration file for PrusaSlicer, a free and open source 3D slicer software that can be used to prepare the .stl file exported from OpenSCAD for 3D printing. After importing PrusaSlicerConfig.ini into PrusaSlicer, the user will be able to use the same print settings as used in the original research. If another 3D slicer is to be used, the file can be opened in a text editor to manually tranfer the settings to the other software; most of the settings are analogous to those found in the most common 3D slicers, e.g. Cura.
