%% MPSA analysis 
% The analysis contains the following steps: 
%  1) 21 input parameters are varied in range [20%,500%] comparing to original values 
%  2) Randomly generated parameters using hypercube sampling are saved as Par_MC 
%  3) For each paramter set simulations are performed (RunSim.m) and
%     absolute difference between basal and apical values in relation to 
%     absolute reference differences in percentages are calucalted for each
%     output (six in total)
%  4) Threshold is 20 - If absolute difference between basal and apical values of new
%     simulation is less than or equal to 20% of original (reference) difference then output
%     (simulation) is marked as unacceptable (index 0) and vice versa
%     (index 1)
%  5) For all 6 outputs the cumulative distributions of the acceptable and
%     unaccaptable simulations are computed and visualed by executing plot_figures.m.  

close all;clear all;clc

%% Parameters to be analysed
Par = [0.5,1,2.5,... # Ic, delta_C, alpha_C,
	   0.5,1,1.5,...# Ir, delta_R, beta_R 
       3.3,1,0.7,2.5,... # Irho, delta_Rho, beta_rho, alpha_rho
       0.5,2,2,0.2,... # k_on_P, k_off_P, beta_PR, beta_PS
       4,2,0.2,... # k_on_S, k_off_S, beta_SP
       10,1,30,1.5]'; % I_I, delta_I, Itot, alpha_I
% Reference simulation
feature0 = RunSim(Par);
diff0=abs(feature0(1,:)-feature0(end,:));   % difference between basal and apical value

%% Monte Carlo simulations
Np =length(Par);    % no. of parameters included in analysis
Nd = Np;            % no. of dummies
Par=[Par;ones(Nd,1)];

% Number of simulations
n_MPSA = 3000;
% Latin Hypercube sampling of parameter space
scale = lhsdesign(n_MPSA, Np+Nd);   % random uniformly distributed parameter sets (values [0,1])
% Adjust parameter sets for range 20% to 500% in relation to original value
par_MC=((0.2+4.8*scale)'.*Par)';

%% Parallel loop for runing simulations
parfor (j = 1 : n_MPSA)
    partemp=par_MC(j,1:Np); %select the Np model parameters from set j
    % Run simulation with new set of parameters
    feature = RunSim(partemp);
    % Calculate sensitivity criteria
    V(j,:) = 100*abs(feature(1,:)-feature(end,:))./abs(feature0(1,:)-feature0(end,:));
end

%% Saving the results of the analysis
time = datestr(now, 'mm_dd_hh');
filename = sprintf('MSPA3_%s.mat',time)
save(filename)

%% Performing sensitivity Kolmogrov-Smirnof statistics and making plots 
Plot_figures
