clear all, close all

dPdx = [-logspace(0,1.75,8) -logspace(2,6,41) -logspace(6.25,10,16)];
H = 100e-6;
%b = [0 5].*1e-6;
b = linspace(-5,15,21).*1e-6;

no = 0;
no_total = length(dPdx) * length(b);

for k = 1:length(dPdx)
    tic
    for l = 1:length(b)
        [U,U_real_av] = finitedifference_carreau_dimless(dPdx(k),H,b(l),0);
        u_av(k,l) = U_real_av;
        no = no + 1;
        disp(['grid point no. ' num2str(no) ' of ' num2str(no_total)])
    end
    toc
end

save finitedifference_carreau_evaluation_100um_XG01_2

%cmap = paruly;
colormap(jet)
%colormap winter
pcolor(b,log10(-dPdx),log10(u_av))
shading interp
colorbar
xlabel('b [m]')
ylabel('log_{10}(-dP/dx) [Pa/m]')
zlabel('log_{10}(u_{av}) [m/s]')
set(gca,'YScale','linear','ZScale','linear')
tikzfile = ['finitedifference_carreau_evaluation.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
