# Data and code underlying the publication: Spatial optimization of circular timber hubs

This repository contains the data and code used for a research paper currently under peer review, titled "Spatial optimization of circular timber hubs". The aim of this research was to identify the optimal location and scale of circular construction hubs processing timber waste in Amsterdam, using a spatial simulated annealing as an optimization algorithm.

## Structure
The repository is organized into two main directories, 'data' and 'code'.

### Code
The 'code' directory includes the following files:

1. `costEffectiveness_v3.py` - A Python script for calculating the cost effectiveness (euros / tCO2eq reduction) of a given configuration of circular construction hubs.
2. `spatialAnnealing_parallel_hpc.R` - An R script for running the spatial simulated annealing algorithm on a high performance computing cluster.
3. `resultsVisualization_v2.ipynb` - A Jupyter notebook for visualizing the results of the research.

### Data
The 'data' directory contains:

1. `ams_edges.shp` - A shapefile representing the major street network in Amsterdam.
2. `candiHubs_ams.shp` - A shapefile of potential locations for circular construction hubs. This shapefile was extracted from the [IBIS dataset on industrial sites](https://data.overheid.nl/dataset/ibis-bedrijventerreinen). It contains the following columns:
    - `RIN_NUMMER` - Unique ID number of the industrial site.
    - `MAX_MILIEU` - The environmental category of the industrial site, a zoning category that determines the distance from residential areas, which regulates the amount of nuisance for residents. The dataset includes only categories 2-3, suitable for circular construction hubs. More about environmental categories can be found [here](https://www.infomil.nl/onderwerpen/ruimte/functies/bedrijven/milieuzonering/).
    - `pPerSqm` - Price per square meter for the industrial site.
    - `hubName` - Unique ID for each site. This column is used for the optimization algorithm.
    - `geometry` - Geometry of the site.
3. `matGrid_ams.shp` - A shapefile showing the predicted future supply and demand for timber (for construction) in Amsterdam, which was modified from a dataset created by the Planbureau voor de Leefomgeving and researchers from Leiden University. You can see their original publication [here](https://www.sciencedirect.com/science/article/pii/S0921344921007138). The predictions cover the timeframe of 2022 - 2026. The shapefile has the following columns:
    - `kgDemand` - Future predicted demand for timber for construction in kg.
    - `kgSupply` - Future predicted supply of timber construction waste in kg.
    - `geometry` - Location of future supply and demand of timber waste.

## Usage
You can download the entire repository as a ZIP file. After extraction, you'll have access to both the 'code' and 'data' directories. Please ensure that you have the required dependencies installed on your local machine before running the code scripts.

## Citation
If you use this data or code in your own work, please cite our paper. Citation details will be updated once the paper has completed the peer review process. For now a pre-print is available [here](https://www.researchsquare.com/article/rs-3013682/v1). 

## Contact
For any questions or issues, please contact the corresponding author, Tanya Tsui, at t.p.y.tsui@tudelft.nl 

## License
This work is licensed under a Creative Commons Attribution 4.0 International License. For more details, see the LICENSE file in this repository.