This readme file was generated on 2025-02-16 by Matheus H.C. Barboza

# 1 INTRODUCTORY INFORMATION
- Title: Data associated with the paper "Transit Fares and Space-Time Accessibility: measuring inequalities in park accessibility for São Paulo Favela Residents using Mobile Phone and Smart Card Data"
- Paper authors: Matheus H.C. Barboza, Mariana Giannotti. Anna B. Grigolon, and Karst T. Geurs
- Contact: matheushenriquebarboza@gmail.com
- Short description of files:
    - \data_base
		- rmsp.pbf: an OpenStreetMap street network of São Paulo, used by the r5r package
		- SP20181016_Base-modified.zip: GTFS of the São Paulo public transport network
	- \layers
		- \Bases_CEM_PMH_SEHAB_2016
			- CEM_FAV_SEHAB2016.shp: location of favelas
        - \SIRGAS_SHP_parquespde5
			- SIRGAS_SHP_parquespde5.shp: location of parks
		- \SIRGAS_SHP_represanivelmax
			- SIRGAS_SHP_represanivelmax.shp: location of water
		- Area_funcionamento_parques.csv: info about the parks
		- rail_base.shp: location of rail passenger lines
		- Zonas2017b.shp: layer with the traffic zones
		- zones.rds: layer with the traffic zones
		- zones_selec_dissolved: layer with the traffic zones
		- centroids_zones_coord.shp: zones centroids
	- ttm_df.rds: previously calculated travel time between traffic zones using the gtfs
	- stm bd-published.Rmd: code to process the data and generate the results and pictures of the paper
 
# 2 METHODOLOGICAL INFORMATION
- Methods: descripted in the paper
- Software: RStudio 2023.03.0

# 3 SHARING AND ACCESS INFORMATION
- License: CC-BY

# 4 DATA SPECIFIC INFORMATION FOR \data_base\rmsp.pbf
- an OpenStreetMap street network of São Paulo, used by the setup_r5 function of the r5r package
- available at the research group

# 4 DATA SPECIFIC INFORMATION FOR \data_base\SP20181016_Base-modified.zip
- General Transit Feed Specification (GTFS) of the São Paulo public transport network for the base scenario, including municipal buses, and rail lines
- it represents the network from 2018-10-16
- available at the research group

# 4 DATA SPECIFIC INFORMATION FOR \data_prop\rmsp.pbf
- an OpenStreetMap street network of São Paulo, used by the setup_r5 function of the r5r package, the same of the base scenario
- available at the research group

# 4 DATA SPECIFIC INFORMATION FOR \Bases_CEM_PMH_SEHAB_2016\CEM_FAV_SEHAB2016.shp
- polygons of favelas in São Paulo, which we use to classify the individuals, based on their estimated home location, as living in favelas or not
- available at the research group

# 4 DATA SPECIFIC INFORMATION FOR \input\layers\SIRGAS_SHP_parquespde5\SIRGAS_SHP_parquespde5.shp
- Number of variables: 7
- Number of cases/rows: 501
- Variable List:
	- pde5_id: identifier
	- pde5_nome: not used;
	- pde5_codig: not used;
	- pde5_esfer: not used;
	- pde5_area: not used;
	- pde5_categ: class of the park, we filter those listed as "Parque Estadual de Proteção Integral", "Parque Estadual Urbano" or "Parque Municipal Existente"
- Missing data codes: NA

# 4 DATA SPECIFIC INFORMATION FOR \layers\SIRGAS_SHP_represanivelmax\SIRGAS_SHP_represanivelmax.shp
- polygons of location of large water bodies in São Paulo, which we use in some maps
- available at https://geosampa.prefeitura.sp.gov.br/PaginasPublicas/_SBC.aspx

# 4 DATA SPECIFIC INFORMATION FOR \input\layers\Area_funcionamento_parques.csv
- Number of variables: 10
- Number of cases/rows: 105
- Variable List: 
	- OBJECTID: identifier;
	- pq_nome: name of the park;
	- ORIG_FID: not used;
	- Abertura: opening hour of the park;
	- Fechamento: closing hour of the park;
	- OBJECTID_1: not used;
	- pq_nome_1: not used;
	- SHAPE_Length: not used;
	- SHAPE_Area: not used;
	- Area: not used.
- Missing data codes: NA

# 4 DATA SPECIFIC INFORMATION FOR \layers\rail_base.shp
- lines of location of rail passenger lines, which we use in some maps
- available at https://geosampa.prefeitura.sp.gov.br/PaginasPublicas/_SBC.aspx

# 4 DATA SPECIFIC INFORMATION FOR \layers\Zonas2017b.shp
- Number of variables: 8
- Number of cases/rows: 517
- Variable List:
	- NumeroZona: identifier;
	- NomeZona: associated name;
	- NumeroMuni: number of the municipality. we use it to filter the zones in São Paulo;
	- NomeMunici: associated name;
	- NumDistrit: number of the district;
	- NomeDistri: associated name;
	- Area_ha_2: area in hectare
- Missing data codes: NA

# 4 DATA SPECIFIC INFORMATION FOR \layers\zones.rds
- polygons of traffic zones in São Paulo, which we use in some maps

# 4 DATA SPECIFIC INFORMATION FOR \layers\zones_selec_dissolved
- polygons of traffic zones in São Paulo, which we use in some maps
				
# 4 DATA SPECIFIC INFORMATION FOR \layers\centroids_zones_coord.shp
- Number of variables: 10
- Number of cases/rows: 517
- Variable List:
	- NumeroZona: identifier;
	- NomeZona: associated name;
	- NumeroMuni: number of the municipality. we use it to filter the zones in São Paulo;
	- NomeMunici: associated name;
	- NumDistrit: number of the district;
	- NomeDistri: associated name;
	- Area_ha_2: area in hectare;
	- xcoord: longitude;
	- ycoord: latitude:
- Missing data codes: NA

# 4 DATA SPECIFIC INFORMATION FOR ttm_df.rds
- previously calculated travel time between traffic zones using the gtfs

# 4 DATA SPECIFIC INFORMATION FOR stm bd-published.Rmd
- code to process the data and generate the results and pictures of the paper