clc
close all
clear all

%% start script

% % font settings
% font = 'Times New Roman';
% font_size = 10;

% legend formatting settings
x1 = 15;
x2 = 18;%18

color_order = [0,0.447000000000000,0.741000000000000;
0.850000000000000,0.325000000000000,0.0980000000000000;
0.929000000000000,0.694000000000000,0.125000000000000;
0.494000000000000,0.184000000000000,0.556000000000000;
0.466000000000000,0.674000000000000,0.188000000000000;
0.301000000000000,0.745000000000000,0.933000000000000;
0.635000000000000,0.0780000000000000,0.184000000000000];

% font settings
font = 'Times New Roman';
font_size = 9;
legend_font_size = 9;

% legend settings
% x1 = 15; % 30
% x2 = 5;


f_min = 18;
f_max = 21;
%% Load eigenvectors
AoA = 0;
filepath2 = 'Middle_LE_eigenvector/eigvec_2_AoA_' + string(AoA);
AoA_0_eigvec = load(filepath2 + '.mat').V_eigvec_lst_2_all;

AoA = 2;
filepath2 = 'Middle_LE_eigenvector/eigvec_2_AoA_' + string(AoA);
AoA_2_eigvec = load(filepath2 + '.mat').V_eigvec_lst_2_all;

AoA = 4;
filepath2 = 'Middle_LE_eigenvector/eigvec_2_AoA_' + string(AoA);
AoA_4_eigvec = load(filepath2 + '.mat').V_eigvec_lst_2_all;

AoA = 6;
filepath2 = 'Middle_LE_eigenvector/eigvec_2_AoA_' + string(AoA);
AoA_6_eigvec = load(filepath2 + '.mat').V_eigvec_lst_2_all;


Velocity_lst_AoA_0 = [20, 21, 22, 22.5, 23, 23.5, 24, 24.5, 25];
Velocity_lst_AoA_2 = [19, 20, 21, 21.5, 22, 23, 23.5];
Velocity_lst_AoA_4 = [18, 18.5, 19, 20, 21, 21.5, 22, 23];
Velocity_lst_AoA_6 = [16, 17, 18, 19, 20, 21];




%% Collect all eigenvectors at 20 m/s
real_20_ms_AoA_0 = AoA_0_eigvec(2, :);
real_20_ms_AoA_2 = AoA_2_eigvec(4, :); 
real_20_ms_AoA_4 = AoA_4_eigvec(8, :);
real_20_ms_AoA_6 = AoA_6_eigvec(10, :);

im_20_ms_AoA_0 = AoA_0_eigvec(1, :);
im_20_ms_AoA_2 = AoA_2_eigvec(3, :); 
im_20_ms_AoA_4 = AoA_4_eigvec(7, :);
im_20_ms_AoA_6 = AoA_6_eigvec(9, :);


%% Plot eigenvector at 20 m/s
x1 = 10;%30;
x2 = 18;
fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [6.5,3.5];
set(gca,'fontsize', font_size)


t = tiledlayout(1,2);%, 'Padding', 'none', 'TileSpacing', 'none');

nexttile(t)

freq = linspace(18, 23, max(size(real_20_ms_AoA_0)));
plot(freq, abs(real_20_ms_AoA_0), 'Linestyle', '-', 'color', color_order(1, :), 'Displayname', "AoA = $0^{\circ}$")
hold on
plot(freq, abs(im_20_ms_AoA_0), 'Linestyle', '--', 'color', color_order(1, :), 'HandleVisibility', 'off')


freq = linspace(18, 21, max(size(real_20_ms_AoA_2)));
plot(freq, abs(real_20_ms_AoA_2), 'Linestyle', '-', 'color', color_order(2, :), 'Displayname', "AoA = $2^{\circ}$")
hold on
plot(freq, abs(im_20_ms_AoA_2), 'Linestyle', '--', 'color', color_order(2, :), 'HandleVisibility', 'off')


freq = linspace(18, 21, max(size(real_20_ms_AoA_4)));
plot(freq, abs(real_20_ms_AoA_4), 'Linestyle', '-', 'color', color_order(3, :), 'Displayname', "AoA = $4^{\circ}$")
hold on
plot(freq, abs(im_20_ms_AoA_4), 'Linestyle', '--', 'color', color_order(3, :), 'HandleVisibility', 'off')

freq = linspace(18, 21, max(size(real_20_ms_AoA_6)));
plot(freq, abs(real_20_ms_AoA_6), 'Linestyle', '-', 'color', color_order(4, :), 'Displayname', "AoA = $6^{\circ}$")
hold on
plot(freq, abs(im_20_ms_AoA_6), 'Linestyle', '--', 'color', color_order(4, :), 'HandleVisibility', 'off')
ylim([0,1.05])
xlim([f_min, f_max])
xlabel('Frequency [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
ylabel('Magnitude','Interpreter','latex', 'FontSize', font_size, 'FontName', font)



% set(gca,'XTickLabel',[]);



% leg = legend('Interpreter','latex', 'FontSize', font_size, 'Location', 'west');
% leg.ItemTokenSize = [x1,x2];
% leg.FontName = font;
set(gca,'fontname', font)
set(gca,'fontsize', font_size)

text(18.5, 0.95, 'z-component', 'Interpreter','latex', 'FontSize', font_size, 'HorizontalAlignment', 'center')
text(18.5, 0.2, 'x-component', 'Interpreter','latex', 'FontSize', font_size, 'HorizontalAlignment', 'center')

nexttile(t);

% yline(0,'HandleVisibility','off')
% yline(pi,'HandleVisibility','off')
% yline(-pi,'HandleVisibility','off')
% delta = angle(complex_comp_x);% - angle(real_comp_z);
% 
% %     ax2 = freq;
% plot(freq, angle(real_comp_z))
% hold on
% plot(freq, delta)%, 'Displayname', 'Angle between x and z component')

freq = linspace(18, 23, max(size(real_20_ms_AoA_0)));
plot(freq, angle(real_20_ms_AoA_0), 'Linestyle', '-', 'color', color_order(1, :), 'Displayname', "AoA = $0^{\circ}$")
hold on
plot(freq, angle(im_20_ms_AoA_0), 'Linestyle', '--', 'color', color_order(1, :), 'HandleVisibility', 'off')


freq = linspace(18, 21, max(size(real_20_ms_AoA_2)));
plot(freq, angle(real_20_ms_AoA_2), 'Linestyle', '-', 'color', color_order(2, :), 'Displayname', "AoA = $2^{\circ}$")
hold on
plot(freq, angle(im_20_ms_AoA_2), 'Linestyle', '--', 'color', color_order(2, :), 'HandleVisibility', 'off')


freq = linspace(18, 21, max(size(real_20_ms_AoA_4)));
plot(freq, angle(real_20_ms_AoA_4), 'Linestyle', '-', 'color', color_order(3, :), 'Displayname', "AoA = $4^{\circ}$")
hold on
plot(freq, angle(im_20_ms_AoA_4), 'Linestyle', '--', 'color', color_order(3, :), 'HandleVisibility', 'off')

freq = linspace(18, 21, max(size(real_20_ms_AoA_6)));
plot(freq, angle(real_20_ms_AoA_6), 'Linestyle', '-', 'color', color_order(4, :), 'Displayname', "AoA = $6^{\circ}$")
hold on
plot(freq, angle(im_20_ms_AoA_6), 'Linestyle', '--', 'color', color_order(4, :), 'HandleVisibility', 'off')

leg = legend('Interpreter','latex', 'FontSize', font_size, 'Location', 'southwest');
leg.ItemTokenSize = [x1,x2];
leg.FontName = font;
set(gca,'fontname', font)
set(gca,'fontsize', font_size)

xlim([f_min, f_max])

xlabel('Frequency [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
ylabel('Phase angle [rad]','Interpreter','latex', 'FontSize', font_size, 'FontName', font) 

set(gca,'fontname', font)
set(gca,'fontsize', font_size)


yline(0,'HandleVisibility','off', 'color', 'black')
yline(pi,'HandleVisibility','off', 'color', 'black')
yline(-pi,'HandleVisibility','off', 'color', 'black')

%     linkaxes([ax1,ax2],'x')



t.TileSpacing = 'none';
t.Padding = 'none';


evolution_filename = "Figures/Eigenvectors/Raw/for_paper/Eigvec_all_20ms";
%         saveas(gcf, evolution_filename + ".pdf", 'Resolution',600);
%         saveas(gcf, evolution_filename + ".jpg");
exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution',600)
%         exportgraphics(gcf, evolution_filename + ".jpg")
saveas(gcf, evolution_filename + ".jpg");


% complex_comp_x = V_eigvec_lst_2_all(V_idx, :);
% real_comp_z = V_eigvec_lst_2_all(V_idx+1, :);  


%% Collect all eigenvectors at/close to onset V
% AoA = 0, 24 m/s 13, 14
% AoA = 2, 21.5 m/s 7, 8
% AoA = 4, 21.5 m/s 11, 12
real_20_ms_AoA_0 = AoA_0_eigvec(14, :);
real_20_ms_AoA_2 = AoA_2_eigvec(8, :); 
real_20_ms_AoA_4 = AoA_4_eigvec(12, :);
% real_20_ms_AoA_6 = AoA_6_eigvec(10, :);

im_20_ms_AoA_0 = AoA_0_eigvec(13, :);
im_20_ms_AoA_2 = AoA_2_eigvec(7, :); 
im_20_ms_AoA_4 = AoA_4_eigvec(11, :);
% im_20_ms_AoA_6 = AoA_6_eigvec(9, :);


%% Plot eigenvector at/close to onset V
x1 = 10;%30;
x2 = 18;
fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [6.5,3.5];
set(gca,'fontsize', font_size)


t = tiledlayout(1,2);%, 'Padding', 'none', 'TileSpacing', 'none');

nexttile(t)

freq = linspace(18, 23, max(size(real_20_ms_AoA_0)));
plot(freq, abs(real_20_ms_AoA_0), 'Linestyle', '-', 'color', color_order(1, :), 'Displayname', "AoA = $0^{\circ}$, 24 m/s")
hold on
plot(freq, abs(im_20_ms_AoA_0), 'Linestyle', '--', 'color', color_order(1, :), 'HandleVisibility', 'off')

xline(20.48, '-', "$0^{\circ}$",'Interpreter','latex','LabelHorizontalAlignment', 'center', 'LabelVerticalAlignment', 'middle', 'HandleVisibility', 'off')


freq = linspace(18, 21, max(size(real_20_ms_AoA_2)));
plot(freq, abs(real_20_ms_AoA_2), 'Linestyle', '-', 'color', color_order(2, :), 'Displayname', "AoA = $2^{\circ}$, 21.5 m/s")
hold on
plot(freq, abs(im_20_ms_AoA_2), 'Linestyle', '--', 'color', color_order(2, :), 'HandleVisibility', 'off')

xline(20.02, '-', "$2^{\circ}$",'Interpreter','latex','LabelHorizontalAlignment', 'center', 'LabelVerticalAlignment', 'middle', 'HandleVisibility', 'off')


freq = linspace(18, 21, max(size(real_20_ms_AoA_4)));
plot(freq, abs(real_20_ms_AoA_4), 'Linestyle', '-', 'color', color_order(3, :), 'Displayname', "AoA = $4^{\circ}$, 21.5 m/s")
hold on
plot(freq, abs(im_20_ms_AoA_4), 'Linestyle', '--', 'color', color_order(3, :), 'HandleVisibility', 'off')

xline(19.59, '-', "$4^{\circ}$",'Interpreter','latex','LabelHorizontalAlignment', 'center', 'LabelVerticalAlignment', 'middle', 'HandleVisibility', 'off')

% freq = linspace(18, 21, max(size(real_20_ms_AoA_6)));
% plot(freq, abs(real_20_ms_AoA_6), 'Linestyle', '-', 'color', color_order(4, :), 'Displayname', "AoA = $6^{\circ}$")
% hold on
% plot(freq, abs(im_20_ms_AoA_6), 'Linestyle', '--', 'color', color_order(4, :), 'HandleVisibility', 'off')
ylim([0,1.05])
xlim([f_min, f_max])
xlabel('Frequency [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
ylabel('Magnitude','Interpreter','latex', 'FontSize', font_size, 'FontName', font)


% set(gca,'XTickLabel',[]);



% leg = legend('Interpreter','latex', 'FontSize', font_size, 'Location', 'west');
% leg.ItemTokenSize = [x1,x2];
% leg.FontName = font;
set(gca,'fontname', font)
set(gca,'fontsize', font_size)

text(18.5, 0.95, 'z-component', 'Interpreter','latex', 'FontSize', font_size, 'HorizontalAlignment', 'center')
text(18.5, 0.2, 'x-component', 'Interpreter','latex', 'FontSize', font_size, 'HorizontalAlignment', 'center')

nexttile(t);

% yline(0,'HandleVisibility','off', 'color', 'black')
% yline(pi,'HandleVisibility','off', 'color', 'black')
% yline(-pi,'HandleVisibility','off', 'color', 'black')
% delta = angle(complex_comp_x);% - angle(real_comp_z);
% 
% %     ax2 = freq;
% plot(freq, angle(real_comp_z))
% hold on
% plot(freq, delta)%, 'Displayname', 'Angle between x and z component')

freq = linspace(18, 23, max(size(real_20_ms_AoA_0)));
plot(freq, angle(real_20_ms_AoA_0), 'Linestyle', '-', 'color', color_order(1, :), 'Displayname', "AoA = $0^{\circ}$, 24 m/s")
hold on
plot(freq, angle(im_20_ms_AoA_0), 'Linestyle', '--', 'color', color_order(1, :), 'HandleVisibility', 'off')

xline(20.48, '-', "$0^{\circ}$",'Interpreter','latex','LabelHorizontalAlignment', 'center', 'LabelVerticalAlignment', 'top', 'HandleVisibility', 'off')

freq = linspace(18, 21, max(size(real_20_ms_AoA_2)));
plot(freq, angle(real_20_ms_AoA_2), 'Linestyle', '-', 'color', color_order(2, :), 'Displayname', "AoA = $2^{\circ}$, 21.5 m/s")
hold on
plot(freq, angle(im_20_ms_AoA_2), 'Linestyle', '--', 'color', color_order(2, :), 'HandleVisibility', 'off')

xline(20.02, '-', "$2^{\circ}$",'Interpreter','latex','LabelHorizontalAlignment', 'center', 'LabelVerticalAlignment', 'top', 'HandleVisibility', 'off')

freq = linspace(18, 21, max(size(real_20_ms_AoA_4)));
plot(freq, angle(real_20_ms_AoA_4), 'Linestyle', '-', 'color', color_order(3, :), 'Displayname', "AoA = $4^{\circ}$, 21.5 m/s")
hold on
plot(freq, angle(im_20_ms_AoA_4), 'Linestyle', '--', 'color', color_order(3, :), 'HandleVisibility', 'off')

xline(19.59, '-', "$4^{\circ}$",'Interpreter','latex','LabelHorizontalAlignment', 'center', 'LabelVerticalAlignment', 'top', 'HandleVisibility', 'off')
% freq = linspace(18, 21, max(size(real_20_ms_AoA_6)));
% plot(freq, angle(real_20_ms_AoA_6), 'Linestyle', '-', 'color', color_order(4, :), 'Displayname', "AoA = $6^{\circ}$")
% hold on
% plot(freq, angle(im_20_ms_AoA_6), 'Linestyle', '--', 'color', color_order(4, :), 'HandleVisibility', 'off')


leg = legend('Interpreter','latex', 'FontSize', font_size, 'Location', 'southwest');
leg.ItemTokenSize = [x1,x2];
leg.FontName = font;
set(gca,'fontname', font)
set(gca,'fontsize', font_size)

yline(0,'HandleVisibility','off', 'color', 'black')
yline(pi,'HandleVisibility','off', 'color', 'black')
yline(-pi,'HandleVisibility','off', 'color', 'black')


xlim([f_min, f_max])

xlabel('Frequency [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
ylabel('Phase angle [rad]','Interpreter','latex', 'FontSize', font_size, 'FontName', font) 

set(gca,'fontname', font)
set(gca,'fontsize', font_size)




%     linkaxes([ax1,ax2],'x')



t.TileSpacing = 'none';
t.Padding = 'none';


evolution_filename = "Figures/Eigenvectors/Raw/for_paper/Eigvec_all_onset";
%         saveas(gcf, evolution_filename + ".pdf", 'Resolution',600);
%         saveas(gcf, evolution_filename + ".jpg");
exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution',600)
%         exportgraphics(gcf, evolution_filename + ".jpg")
saveas(gcf, evolution_filename + ".jpg");



%% Plot function
% Eigenvector corresponding to lambda_2
font_size = 9;
font_size_legend = 9;
Vel_lst = repelem(Velocity_AoA_0, 2);
test_test = 0;
for V_idx =1:2:min(size(smooth_eigvec_lst_2_all))
    Vel_val = Vel_lst(V_idx);
%     current_fig_n = get(gcf,'Number');
%     if current_fig_n == 1 && test_test == 0
%         n = current_fig_n;
%         test_test = 1;
%     else
%         n = current_fig_n + 1;
%     end

    complex_comp_x = smooth_eigvec_lst_2_all(V_idx, :);
    real_comp_z = smooth_eigvec_lst_2_all(V_idx+1, :);
    
    complex_comp_x = V_eigvec_lst_2_all(V_idx, :);
    real_comp_z = V_eigvec_lst_2_all(V_idx+1, :);  
    
    x1 = 10;%30;
    x2 = 18;
    fh = figure;
    fh.Units = 'inches';
    fh.Position(3:4) = [3.25,3.5];
    set(gca,'fontsize', font_size)
    
    
    t = tiledlayout(2,1);%, 'Padding', 'none', 'TileSpacing', 'none');
%     t.Padding = 'none';
%     t.TileSpacing = 'none';
    
%     subplot(2, 1, 1)
    nexttile(t)
    
%     ax1 = freq;
    plot(freq, abs(real_comp_z), 'Linestyle', '-', 'Displayname', "z-component")
    hold on
    plot(freq, abs(complex_comp_x), 'Linestyle', '--', 'Displayname', "x-component")
    ylim([0,1.05])
    xlim([f_min, f_max])
    xlabel('Frequency [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
    ylabel('Magnitude','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
    
%     set(gca,'XTickLabel',[]);
    
%     yticklabels(linspace(0, 1, 11));
    
    leg = legend('Interpreter','latex', 'FontSize', font_size_legend, 'Location', 'west');
    leg.ItemTokenSize = [x1,x2];
    leg.FontName = font;
    set(gca,'fontname', font)
    set(gca,'fontsize', font_size)
%     % grid on
%     % grid minor
    
%     title("Complex Eigenvector AoA " + AoA + ", " + string(Vel_val) + " m/s")
    
    
    
    
%     subplot(2, 1, 2)
    nexttile(t);
    delta = angle(complex_comp_x);% - angle(real_comp_z);
    
%     ax2 = freq;
    plot(freq, angle(real_comp_z))
    hold on
    plot(freq, delta)%, 'Displayname', 'Angle between x and z component')
    
    
    xlim([f_min, f_max])
    
    xlabel('Frequency [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
    ylabel('Phase angle [rad]','Interpreter','latex', 'FontSize', font_size, 'FontName', font) 
    
    set(gca,'fontname', font)
    set(gca,'fontsize', font_size)
    
%     yticklabels({'-\pi', '-0.75\pi','-0.5\pi','-0.25\pi', '0', '0.25\pi', '0.5\pi', '0.75\pi', '\pi'});
%     % grid on
%     % grid minor
    
%     leg = legend('Interpreter','latex', 'FontSize', font_size_legend, 'Location', 'south');
%     leg.ItemTokenSize = [x1,x2];
%     leg.FontName = font;
    yline(0,'HandleVisibility','off')
    yline(pi,'HandleVisibility','off')
    yline(-pi,'HandleVisibility','off')
    
%     linkaxes([ax1,ax2],'x')
    
    
    
    t.TileSpacing = 'none';
    t.Padding = 'none';
    
    if savefig == 1
        set(gcf,'Units','Inches');
        pos = get(gcf,'Position');
        set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

    
        evolution_filename = "Figures/Eigenvectors/Raw/Raw_eigenvector_2_contribution_AoA_" + AoA + "_" + string(Vel_val) + "_ms";
%         saveas(gcf, evolution_filename + ".pdf", 'Resolution',600);
%         saveas(gcf, evolution_filename + ".jpg");
        exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution',600)
%         exportgraphics(gcf, evolution_filename + ".jpg")
        saveas(gcf, evolution_filename + ".jpg");
    end

end