clc
clear all
close all

%% Script starts
% Scripts settings

% font settings
font = 'Times New Roman';

pf = 9.6808; % gram (stationary)
m_s = 6.418; % gram (moving)

mu = pf/m_s;

% mu = 1;
% mu = 28.90682/6.418;


n_round = 10;

smooth_param = struct();

order_zz_ex = 15;
framelen_zz_ex = 19; 
order_xz_ex = 12; 
framelen_xz_ex = 15; 

order_zx_ex = 3; 
framelen_zx_ex = 5; 
order_xx_ex = 3; 
framelen_xx_ex = 5; 

% % Smoothing of FRF w.r.t x is done using sgolayfilt


% smoothing of FRF's w.r.t. z and x is done using smoothdata


% Smoothdata function parameters (not used, using sgolayfilt to smooth PFM
% data, correction factors still using smoothdata)
method = 'gaussian';
% method = 'sgolay';
% method = 'rlowess';
% method = 'rloess';
% method = 'movmedian';

window = 10; %10; 20

method_z_ex = method;
method_x_ex = 'rloess'; % 'rloess';

method_xx_ex = 'gaussian';
method_zx_ex = 'gaussian';

method_xz_ex = 'sgolay';
method_zz_ex = 'sgolay';

window_xx_ex = 1;
window_zx_ex = 1;

window_xz_ex = 12; % 15

window_zz_ex = 11; % 15

window_z_ex = 1; %15; % 11
window_x_ex = 1; %[3, 6]; % [2, 4]; [3, 6];

% zoom in onto section of plot and have original plot in same figure
% http://we15hang.blogspot.com/2012/02/matlab-making-zoom-in-plot-on-top-of.html

% Smoothdata parameters correction factors
window_correction = 30;
method_correction = method;

% % Plot FRF's
% Plot_FRF = 0; % 0: False; 1: True
% 
% % Plot FRF as an eigenvalue evolution
% plot_FRF_eigval = 0; % 0: False; 1: True

% Save plots
savefig = 0; % 0: False; 1: True

% % Perform SISO PFM Interpolation
% interp_SISO = 0; % 0: False; 1: True

% Plot Eigvals
plot_eigvals = 1; % 0: False; 1: True

% Plot Bode Plot of eigenvalues
Bode_eigval = 1; % 0: False; 1: True

font_size = 12;
font_size_legend = 12;


% % AoA_0
AoA = 0; % Needed for title in plots
filename = "Middle_LE_Shroud_FRF_data/Matlab_Analysis_Files/Middle_LE_shroud_AoA_0.mat";
Column_name = ["Freq","20_x/x", "20_y/x", "20_z/x", "20_x/z", "20_y/z", "20_z/z", "21_x/x", "21_y/x", "21_z/x", "21_x/z", "21_y/z", "21_z/z", "22_x/x", "22_y/x", "22_z/x", "22_x/z", "22_y/z", "22_z/z", "22_5_x/x", "22_5_y/x", "22_5_z/x", "22_5_x/z", "22_5_y/z", "22_5_z/z","23_x/x", "23_y/x", "23_z/x", "23_x/z", "23_y/z", "23_z/z", "23_5_x/x", "23_5_y/x", "23_5_z/x", "23_5_x/z", "23_5_y/z", "23_5_z/z", "24_x/x", "24_y/x", "24_z/x", "24_x/z", "24_y/z", "24_z/z", "24_5_x/x", "24_5_y/x", "24_5_z/x", "24_5_x/z", "24_5_y/z", "24_5_z/z", "25_x/x", "25_y/x", "25_z/x", "25_x/z", "25_y/z", "25_z/z"];
Velocity_lst = [20, 21, 22, 22.5, 23, 23.5, 24, 24.5, 25];
SISO_figures_filename = "Figures/FRF/SISO_PFM_AoA_0_";
MIMO_figures_filename = "Figures/MIMO/MIMO_PFM_AoA_0_";
eigval_fig_name_bode = "Figures/Eigenvalues/Bode/Bode_PFM_AoA_0";
eigval_fig_name_real_im = "Figures/Eigenvalues/Real_v_Im/real_v_im_PFM_AoA_0_";
f_min = 18; % Hz 18
f_max = 23; % Hz 25 23
time_data_file = "Middle_LE_Shroud_Time_data/Analysis_data_Matlab/Middle_LE_shroud_Time_AoA_0.mat"';
smooth_factor_smooth_FRF = 0.11;
smooth_FRF_filename = "Middle_LE_Smooth_FRF/Smooth_FRF_AoA_0.mat";
raw_signal_set = 0;

% AoA_2 
AoA = 2; % Needed for title in plots
filename = "Middle_LE_Shroud_FRF_data/Matlab_Analysis_Files/Middle_LE_shroud_AoA_2.mat";
Column_name = ["Freq", "19_x/x", "19_y/x", "19_z/x", "19_x/z", "19_y/z", "19_z/z", "20_x/x", "20_y/x", "20_z/x", "20_x/z", "20_y/z", "20_z/z", "21_x/x", "21_y/x", "21_z/x", "21_x/z", "21_y/z", "21_z/z", "21_5_x/x", "21_5_y/x", "21_5_z/x", "21_5_x/z", "21_5_y/z", "21_5_z/z", "22_x/x", "22_y/x", "22_z/x", "22_x/z", "22_y/z", "22_z/z","23_x/x", "23_y/x", "23_z/x", "23_x/z", "23_y/z", "23_z/z", "23_5_x/x", "23_5_y/x", "23_5_z/x", "23_5_x/z", "23_5_y/z", "23_5_z/z"];
Velocity_lst = [19, 20, 21, 21.5, 22, 23, 23.5];
SISO_figures_filename = "Figures/SISO/SISO_PFM_AoA_2_";
MIMO_figures_filename = "Figures/MIMO/MIMO_PFM_AoA_2_";
eigval_fig_name_bode = "Figures/Eigenvalues/Bode/Bode_PFM_AoA_2";
eigval_fig_name_real_im = "Figures/Eigenvalues/Real_v_Im/real_v_im_PFM_AoA_2_";
f_min = 18; % Hz
f_max = 21; % Hz
time_data_file = "Middle_LE_Shroud_Time_data/Analysis_data_Matlab/Middle_LE_shroud_Time_AoA_2.mat"';
smooth_FRF_filename = "Middle_LE_Smooth_FRF/Smooth_FRF_AoA_2.mat";
raw_signal_set = 0;
smooth_factor_smooth_FRF = 0.11;
% raw_FRF_filename = "Middle_LE_Smooth_FRF/Raw_FRF_AoA_2.mat";
% raw_signal_set = 1;

% % AoA_4
% AoA = 4; % Needed for title in plots
% filename = "Middle_LE_Shroud_FRF_data/Matlab_Analysis_Files/Middle_LE_shroud_AoA_4.mat";
% Column_name = ["Freq","18_x/x", "18_y/x", "18_z/x", "18_x/z", "18_y/z", "18_z/z", "18_5_x/x", "18_5_y/x", "18_5_z/x", "18_5_x/z", "18_5_y/z", "18_5_z/z", "19_x/x", "19_y/x", "19_z/x", "19_x/z", "19_y/z", "19_z/z", "20_x/x", "20_y/x", "20_z/x", "20_x/z", "20_y/z", "20_z/z", "21_x/x", "21_y/x", "21_z/x", "21_x/z", "21_y/z", "21_z/z", "21_5_x/x", "21_5_y/x", "21_5_z/x", "21_5_x/z", "21_5_y/z", "21_5_z/z", "22_x/x", "22_y/x", "22_z/x", "22_x/z", "22_y/z", "22_z/z","23_x/x", "23_y/x", "23_z/x", "23_x/z", "23_y/z", "23_z/z"];
% Velocity_lst = [18, 18.5, 19, 20, 21, 21.5, 22, 23];
% SISO_figures_filename = "Figures/FRF/SISO_PFM_AoA_4_";
% MIMO_figures_filename = "Figures/MIMO/MIMO_PFM_AoA_4";
% eigval_fig_name_bode = "Figures/Eigenvalues/Bode/Bode_PFM_AoA_4";
% eigval_fig_name_real_im = "Figures/Eigenvalues/Real_v_Im/real_v_im_PFM_AoA_4_";
% f_min = 17; % Hz
% f_max = 21; % Hz 
% time_data_file = "Middle_LE_Shroud_Time_data/Analysis_data_Matlab/Middle_LE_shroud_Time_AoA_4.mat"';
% smooth_FRF_filename = "Middle_LE_Smooth_FRF/Smooth_FRF_AoA_4.mat";
% raw_signal_set = 0;
% smooth_factor_smooth_FRF = 0.11; % Smoothing parameter for Gaussian smoothing in smoothdata for eigenvalues and eigenvectors
% % raw_FRF_filename = "Middle_LE_Smooth_FRF/Raw_FRF_AoA_4.mat";
% % raw_signal_set = 1;
% 
% 
% 
% 
% 
% % AoA_6
% AoA = 6; % Needed for title in plots
% filename = "Middle_LE_Shroud_FRF_data/Matlab_Analysis_Files/Middle_LE_shroud_AoA_6.mat";
% Column_name = ["Freq","16_x/x", "16_y/x", "16_z/x", "16_x/z", "16_y/z", "16_z/z", "17_x/x", "17_y/x", "17_z/x", "17_x/z", "17_y/z", "17_z/z",  "18_x/x", "18_y/x", "18_z/x", "18_x/z", "18_y/z", "18_z/z", "19_x/x", "19_y/x", "19_z/x", "19_x/z", "19_y/z", "19_z/z", "20_x/x", "20_y/x", "20_z/x", "20_x/z", "20_y/z", "20_z/z", "21_x/x", "21_y/x", "21_z/x", "21_x/z", "21_y/z", "21_z/z"];
% Velocity_lst = [16, 17, 18, 19, 20, 21];
% SISO_figures_filename = "Figures/FRF/SISO_PFM_AoA_6_";
% MIMO_figures_filename = "Figures/MIMO/MIMO_PFM_AoA_6_";
% eigval_fig_name_bode = "Figures/Eigenvalues/Bode/Bode_PFM_AoA_6_";
% eigval_fig_name_real_im = "Figures/Eigenvalues/Real_v_Im/real_v_im_PFM_AoA_6_";
% smooth_FRF_filename = "Middle_LE_Smooth_FRF/Smooth_FRF_AoA_6.mat";
% raw_signal_set = 0;
% smooth_factor_smooth_FRF = 0.11;
% % raw_FRF_filename = "Middle_LE_Smooth_FRF/Raw_FRF_AoA_6.mat";
% % raw_signal_set = 1;
% f_min = 17; % Hz
% f_max = 21; % Hz

%% Set input variables to variables used in script
Velocity_AoA_0 = Velocity_lst;
column_name_AoA_0 = Column_name;
filename_AoA_0 = filename;

%% Create T matrix

if raw_signal_set == 1
    AoA_0_mag_phase = load(raw_FRF_filename).AoA_0_mag_phase;
else
    AoA_0_mag_phase = load(smooth_FRF_filename).AoA_0_mag_phase;
end


freq = AoA_0_mag_phase(:, 1);


real_positive_lambda_1 = [];
corresp_vel_1 = [];
real_positive_lambda_2 = [];
corresp_vel_2 = [];
corresp_omega_all_idx_1 = [];
corresp_omega_all_idx_2 = [];
lambda_lst_all = [];

V_eigvec_lst_1_all = [];
V_eigvec_lst_2_all = [];

real_lambdas = [];

smooth_lambda_2_all = [];
smooth_eigvec_lst_2_all = [];


for Vel=1:length(Velocity_AoA_0)
    Velocity = Velocity_AoA_0(Vel);
    Txx_all = AoA_0_mag_phase(:, 2+ 6*(Vel-1));
    Tzx_all = AoA_0_mag_phase(:, 4+ 6*(Vel-1)); 
    Txz_all = AoA_0_mag_phase(:, 5+ 6*(Vel-1));
    Tzz_all = AoA_0_mag_phase(:, 7+ 6*(Vel-1));
    
    lambda_lst = [];
    corresp_omega_idx_1 = [];
    corresp_omega_idx_2 = [];
    
    V_eigvec_lst_1 = [];
    V_eigvec_lst_2 = [];
    MAC_val_lst = [];

    for omega = 1:length(Txx_all) % omega = 1:5:length(Txx_all) --> Only evaluate eigenvalues every approx. 0.1 Hz
        % 
%         if omega > 200
%             break
%         end
        Txx = Txx_all(omega);
        Tzx = Tzx_all(omega);
        Txz = Txz_all(omega);
        Tzz = Tzz_all(omega);
        
        T = [Txx, Txz; 
            Tzx, Tzz];
        
        [V, D] = eig(T);
        
        
        v1 = V(:, 1);
        v2 = V(:, 2);
        
        V_eigvec_lst_1 = [V_eigvec_lst_1, v1];
        V_eigvec_lst_2 = [V_eigvec_lst_2, v2];
        
        if omega > 1
            MAC_val_11 = MAC(V_eigvec_lst_1(:,end-1), V_eigvec_lst_1(:,end));
            MAC_val_12 = MAC(V_eigvec_lst_1(:,end-1), V_eigvec_lst_2(:,end));
            MAC_val_21 = MAC(V_eigvec_lst_2(:,end-1), V_eigvec_lst_1(:,end));
            MAC_val_22 = MAC(V_eigvec_lst_2(:,end-1), V_eigvec_lst_2(:,end));
%             test = 1;
            MAC_val_lst = [MAC_val_lst; [MAC_val_11, MAC_val_12, MAC_val_21, MAC_val_22]];

            
            if MAC_val_21 > 0.7 || MAC_val_12 > 0.7
                lambdas = [D(2,2); D(1,1)];
            end
            
            if MAC_val_22 > 0.7 || MAC_val_11 > 0.7
            lambdas = [D(1,1); D(2,2)];
            end

            
        end
        
        if omega == 1
            lambdas = diag(D);
        end
        
        lambda_lst = [lambda_lst, lambdas];
        
    end
    
    smoothed_lambda_2 = [];
    for lambda_idx = 1:length(lambda_lst(2, :))
        if lambda_idx > 1 && lambda_idx < length(lambda_lst(2, :))
            Y_lambda_min_1 = lambda_lst(2, lambda_idx - 1);
            Y_lambda = lambda_lst(2, lambda_idx);
            Y_lambda_plus_1 = lambda_lst(2, lambda_idx + 1);
            
            smooth_lambda = (Y_lambda_min_1 + 2*Y_lambda + Y_lambda_plus_1)/4;
        else
            smooth_lambda = lambda_lst(2, lambda_idx);
        end
        
        smoothed_lambda_2 = [smoothed_lambda_2, smooth_lambda];
    end
    
    
    smoothed_eigvec_2 = [];
    for V_idx =1:length(V_eigvec_lst_2)
        if V_idx > 1 && V_idx < length(V_eigvec_lst_2)
            Y_V_min_1 = V_eigvec_lst_2(:, V_idx-1);
            Y_V = V_eigvec_lst_2(:, V_idx);
            Y_V_plus_1 = V_eigvec_lst_2(:, V_idx+1);
            
            smooth_eigvec = (Y_V_min_1 + 2*Y_V + Y_V_plus_1)/4;
        else
            smooth_eigvec = V_eigvec_lst_2(:, V_idx);
        end
        
        smoothed_eigvec_2 = [smoothed_eigvec_2, smooth_eigvec];
    end
    
    if raw_signal_set == 1
        smoothing_factor = 0.2;
    else
        smoothing_factor = smooth_factor_smooth_FRF;
    end
    
    
    method = 'gaussian';
    window = [];
    
    smoothed_lambda_2 = smoothdata(lambda_lst(2, :), method, window, 'SmoothingFactor', smoothing_factor);
    
    method = 'gaussian';
    window = [];
%     smoothing_factor = 0.09; 
    smoothed_eigvec_2 = smoothdata(V_eigvec_lst_2, 2, method, window, 'SmoothingFactor', smoothing_factor);
    
        
    smooth_eigvec_lst_2_all = [smooth_eigvec_lst_2_all; smoothed_eigvec_2];
    smooth_lambda_2_all = [smooth_lambda_2_all; smoothed_lambda_2];
    
    lambda_lst_all = [lambda_lst_all; lambda_lst];
    
    
    V_eigvec_lst_1_all = [V_eigvec_lst_1_all; V_eigvec_lst_1];
    
    V_eigvec_lst_2_all = [V_eigvec_lst_2_all; V_eigvec_lst_2];

        

end



%% Plot Eigenvalues

% Plot raw eigenvalues
qdx = 0;
if plot_eigvals == 1
    test_plot = 0;
    current_fig_n = get(gcf,'Number');
    if current_fig_n == 1
        n = current_fig_n;
        test_plot = 1;
    else
        n = current_fig_n + 1;
    end
    Vel_lst = repelem(Velocity_AoA_0, 2);
    for ldx = 1:min(size((lambda_lst_all))) % 2:2:

        marker_symbols = ["o", "o", "<", "<","d", "d", "^", "^", "h", "h", ">", ">", "s", "s", "v", "v",  "p", "p"];
        lambda_val_raw = lambda_lst_all(ldx, :);
        
        lambda_val = lambda_val_raw;


        if rem(ldx, 2) == 0
            fh = figure(n);
        else
            fh = figure(n+1);
        end

        fh.Units = 'centimeters';
        fh.Position = [1, 1, 29, 29];
        

        spacing = 1;
        cmap = cool(length(freq(1:spacing:end)));
        v = freq;
       
        numValues = length(lambda_val(1:spacing:end));
        markerColors = zeros(numValues, 3);
        % Now assign marker colors according to the value of the data.
        for k = 1 : numValues

            row = k;
            markerColors(k, :) = cmap(row, :);
        end 
        
        if rem(ldx, 2) == 0
            condition = string(Vel_lst(ldx));% +  " $\lambda_2$";
            label_name = condition;
            
        else
            condition = string(Vel_lst(ldx));% +  " $\lambda_1$";
            label_name = condition;
        end
        plot(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), 'Color', [0, 0, 0, 0.2],'HandleVisibility','off')
        hold on
        scatter(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), [], markerColors, marker_symbols(ldx), 'filled', 'DisplayName', label_name)
        
        set(gca,'fontsize', font_size) 
        
        
        colormap(cmap);
        q = colorbar;
        
        caxis([min(freq), max(freq)]);
        ylabel(q, 'Frequency [Hz]', 'Rotation', 270,'Interpreter','latex', 'FontSize', font_size, 'FontName', font);
        q.Label.Position(1) = 4;
        q.FontSize = font_size;
        q.FontName = font;
        
        xlabel('Re$\left(\lambda\right)$','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
        ylabel('Im$\left(\lambda\right)$','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
        
        if rem(ldx, 2) == 0
            condition = "_lambda_2";
            title("Eigenvalue $\lambda_2$ evolution with frequency AoA = " + AoA + " deg", 'Interpreter','latex', 'FontName', font)
        else
            condition =  "_lambda_1";
            title("Eigenvalue $\lambda_2$ evolution with frequency AoA = " + AoA + " deg", 'Interpreter','latex', 'FontName', font)
        end
        hold on
        
        

        
        
    end
    axis square;
    qdx = ldx;

    figure(n);
    legend('Interpreter','latex', 'FontSize', font_size_legend, 'Fontname', font)
    set(gca,'fontsize', font_size)
    figure(n+1);
    legend('Interpreter','latex', 'FontSize', font_size_legend, 'Fontname', font)
    set(gca,'fontsize', font_size)
    if savefig == 1
        
        figure(n);
        set(gcf,'Units','Inches');
        pos = get(gcf,'Position');
        set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);
        
        evolution_filename = "Figures/Eigenvalues/Real_v_Im/evolution/Eigval_evolution_AoA_" + AoA + '_lambda_2';

        exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution',600)
        saveas(gcf, evolution_filename + ".jpg");
        
        figure(n+1);
        legend('Interpreter','latex', 'FontSize', font_size_legend)
        set(gcf,'Units','Inches');
        pos = get(gcf,'Position');
        set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);
        
        evolution_filename = "Figures/Eigenvalues/Real_v_Im/evolution/Eigval_evolution_AoA_" + AoA + '_lambda_1';

        exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution',600)
        saveas(gcf, evolution_filename + ".jpg");
    end
    
    
    % Plot smoothed eigenvalues
    current_fig_n = get(gcf,'Number');
    if current_fig_n == 1 && test_plot == 0
        n = current_fig_n;
    else
        n = current_fig_n + 1;
    end
    Vel_lst = Velocity_AoA_0;
    for ldx = 1:min(size((smooth_lambda_2_all))) %1:

        marker_symbols = ["o", "<","d", "^", "h", ">", "s", "v",  "p",];
        lambda_val_raw = smooth_lambda_2_all(ldx, :);
        

        lambda_val = lambda_val_raw;


        fh = figure(n);


        fh.Units = 'Inches';
        fh.Position = [1, 1, 3.25, 3.25];
        
        spacing = 1;
        cmap = cool(length(freq(1:spacing:end)));

        v = freq;       
        numValues = length(lambda_val(1:spacing:end));
        markerColors = zeros(numValues, 3);
        % Now assign marker colors according to the value of the data.
        for k = 1 : numValues

            row = k;
            markerColors(k, :) = cmap(row, :);
        end 
        

        condition = string(Vel_lst(ldx)) +  " $\lambda_2$";
        label_name = condition;
        set(gca,'fontsize', font_size)    

        plot(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), 'Color', [0, 0, 0, 0.2],'HandleVisibility','off')
        hold on
        scatter(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), [], markerColors, marker_symbols(ldx), 'filled', 'DisplayName', label_name)
        
        
        
        
        colormap(cmap);
        q = colorbar;
        
        caxis([min(freq), max(freq)]);
        ylabel(q, 'Frequency [Hz]', 'Rotation', 270,'Interpreter','latex', 'FontSize', font_size, 'FontName', font);
        q.Label.Position(1) = 4;
        
        q.FontSize = font_size;
        q.FontName = font;
        
        xlabel('Re$\left(\lambda\right)$','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
        ylabel('Im$\left(\lambda\right)$','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
    end
    axis square;
    qdx = ldx;

    x1 = 10;
    x2 = 18;
    leg = legend('Interpreter','latex', 'FontSize', font_size_legend);
    leg.ItemTokenSize = [x1,x2];
    leg.FontName = font;
    title("Eigenvalue evolution with frequency AoA = " + AoA + " deg", 'Interpreter','latex', 'FontName', font)
    set(gca,'fontsize', font_size)
    
    if savefig == 1
        set(gcf,'Units','Inches');
        pos = get(gcf,'Position');
        set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);
        
        evolution_filename = "Figures/Eigenvalues/Real_v_Im/evolution/Smoothed_Eigval_evolution_AoA_" + AoA;

        exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution',600)
        saveas(gcf, evolution_filename + ".jpeg");
    end
end



%% Create Bode Plot of eigenvalues
if Bode_eigval == 1
    test_plot = 0;
    current_fig_n = get(gcf,'Number');
    if current_fig_n == 1
        n = current_fig_n;
        test_plot = 1;
    else
        n = current_fig_n + 1;
    end

        
    Vel_lst = repelem(Velocity_AoA_0, 2);
    for ldx = 2:2:min(size((lambda_lst_all)))  % 1:   

        lambda_val_raw = lambda_lst_all(ldx, :);
        lambda_val = lambda_val_raw;

        
        freq_new = linspace(f_min, f_max, length(lambda_val));

        mag_lambda = abs(lambda_val);
        mag_lambda_db = mag2db(mag_lambda);
        phase_lambda = angle(lambda_val);


        if rem(ldx, 2) == 0
            label_name = string(Vel_lst(ldx)) + " $\lambda_2$";

            figure(n)
            subplot(2, 1, 1)
            plot(freq_new, mag_lambda, 'DisplayName', label_name )
            hold on
            set(gca,'fontsize', font_size)
            set(gca,'fontname', font)
            legend('Interpreter','latex', 'FontSize', font_size_legend, 'FontName', font)
            yline(1,'HandleVisibility','off')

            xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
            ylabel('Magnitude','Interpreter','latex', 'FontSize', font_size, 'FontName', font)

  

            subplot(2, 1, 2)
            plot(freq_new, phase_lambda, 'DisplayName' , label_name)
            hold on
            set(gca,'fontsize', font_size)
            set(gca,'fontname', font)

            legend('Interpreter','latex', 'FontSize', font_size_legend)
            yline(0,'HandleVisibility','off')
            yline(pi,'HandleVisibility','off')
            yline(-pi,'HandleVisibility','off')

            xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
            ylabel('$\phi$ [rad]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)  

            


        else
            label_name = string(Vel_lst(ldx)) + " $\lambda_1$";
            figure(n)
            subplot(2, 1, 1)
            plot(freq_new, mag_lambda, 'DisplayName', label_name)
            hold on
            legend('Interpreter','latex', 'FontSize', font_size_legend)
            yline(1,'HandleVisibility','off')

            xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size)
            ylabel('Magnitude','Interpreter','latex', 'FontSize', font_size)
            
  

            subplot(2, 1, 2)
            plot(freq_new, phase_lambda, 'DisplayName' , label_name)
            hold on

            legend('Interpreter','latex', 'FontSize', font_size_legend)
            yline(0,'HandleVisibility','off')
            yline(pi,'HandleVisibility','off')
            yline(-pi,'HandleVisibility','off')

            xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size)
            ylabel('$\phi$ [rad]','Interpreter','latex', 'FontSize', font_size) 
    
        end

        n = n + 1;
        hold off
    end
    
    current_fig_n = get(gcf,'Number');
    if current_fig_n == 1 && test_plot == 0
        n = current_fig_n;
    else
        n = current_fig_n + 1;
    end
    Vel_lst = Velocity_AoA_0;
    for ldx = 1:min(size((smooth_lambda_2_all))) %1: 

        lambda_val_raw = smooth_lambda_2_all(ldx, :);
        lambda_val = lambda_val_raw;

        freq_new = linspace(f_min, f_max, length(lambda_val));

        mag_lambda = abs(lambda_val);
        mag_lambda_db = mag2db(mag_lambda);
        phase_lambda = angle(lambda_val);


        if rem(ldx, 2) == 0
            label_name = string(Vel_lst(ldx)) + " $\lambda_2$";
            
            figure(n)
            
            subplot(2, 1, 1)
            set(gca,'fontsize', font_size)
            plot(freq_new, mag_lambda, 'DisplayName', label_name )
            hold on

            legend('Interpreter','latex', 'FontSize', font_size_legend)
            yline(1,'HandleVisibility','off')

            xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size)
            ylabel('Magnitude','Interpreter','latex', 'FontSize', font_size)
  
            subplot(2, 1, 2)
            plot(freq_new, phase_lambda, 'DisplayName' , label_name)
            hold on
            legend('Interpreter','latex', 'FontSize', font_size_legend)
            yline(0,'HandleVisibility','off')
            yline(pi,'HandleVisibility','off')
            yline(-pi,'HandleVisibility','off')
            set(gca,'fontsize', font_size)
            xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size)
            ylabel('$\phi$ [rad]','Interpreter','latex', 'FontSize', font_size)  
            



        else
            label_name = string(Vel_lst(ldx)) + " $\lambda_1$";
            figure(n)
            subplot(2, 1, 1)
            set(gca,'fontsize', font_size)
            plot(freq_new, mag_lambda, 'DisplayName', label_name)
            hold on
            legend('Interpreter','latex', 'FontSize', font_size_legend)
            yline(1,'HandleVisibility','off')
            
            xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size)
            ylabel('Magnitude','Interpreter','latex', 'FontSize', font_size)
            
  
            subplot(2, 1, 2)
            set(gca,'fontsize', font_size)
            plot(freq_new, phase_lambda, 'DisplayName' , label_name)
            hold on
            legend('Interpreter','latex', 'FontSize', font_size_legend)
            yline(0,'HandleVisibility','off')
            yline(pi,'HandleVisibility','off')
            yline(-pi,'HandleVisibility','off')

            xlabel('$\omega$ [Hz]','Interpreter','latex', 'FontSize', font_size)
            ylabel('$\phi$ [rad]','Interpreter','latex', 'FontSize', font_size) 
            
      
        end

        n = n + 1;
        hold off
    end


end


%% Linear interpolation of eigenvalues to find PCO

MIMO_PFM_data_eigval = struct();

idx_min_lambda_lst = [];

min_prev_lambda_lst = [];
min_next_lambda_lst = [];

min_lambda_lst = [];
freq_min_lambda_lst = [];


Vel_lst = Velocity_AoA_0;
for ldx = 1:min(size((smooth_lambda_2_all))) % min(size((lambda_lst_all))) when using lambda_lst_all(ldx, :)
    V_val = "V_"+ string(Vel_lst(ldx)) + "ms";
    V_val = strrep(V_val, ".", "_");
%     lambda_val = pf*lambda_lst_all(ldx, :);
%     lambda_val = lambda_lst_all(ldx, :);
    % Using smoothed eigenvalues
    lambda_val = smooth_lambda_2_all(ldx, :);
    
    freq_new = linspace(f_min, f_max, length(lambda_val));
    
%     [~, idx_min_lambda] = min(abs(imag(lambda_val)));
%     idx_min_lambda_lst = [idx_min_lambda_lst, idx_min_lambda];
%     min_lambda_lst = [min_lambda_lst, lambda_val(idx_min_lambda)];
%     freq_min_lambda_lst = [freq_min_lambda_lst, freq_new(idx_min_lambda)];
    
%     min_prev_lambda_lst = [min_prev_lambda_lst, lambda_val(idx_min_lambda-1)];
%     min_next_lambda_lst = [min_next_lambda_lst, lambda_val(idx_min_lambda+1)];
    
    

    mag_lambda = abs(lambda_val);
    mag_lambda_db = mag2db(mag_lambda);
    phase_lambda = angle(lambda_val);
%     phase_lambda = unwrap(phase_lambda);
    
    
%     idx_pos = find(phase_lambda > 0);
%     idx_neg = find(phase_lambda < 0);

    % Find location of crossing of Im(lambda_i) = 0
    idx_pos = []; % Positive side of crossing
    idx_neg = []; % Negative side of crossing
    for kdx=2:length(lambda_val)
        x_new = imag(lambda_val(kdx)); 
        x_old = imag(lambda_val(kdx-1)); 
        
        if sign(x_new) == 1 && sign(x_old) == -1 % || sign(x_new-pi) == 1 && sign(x_old-pi) == -1 || sign(x_new+pi) == 1 && sign(x_old+pi) == -1 || sign(x_new-2*pi) == 1 && sign(x_old-2*pi) == -1 || sign(x_new+2*pi) == 1 && sign(x_old+2*pi) == -1
            % Crossing 0 || Crossing pi || crossing -pi || crossing 2*pi || crossing -2*pi
            idx_pos = [idx_pos, kdx];
            idx_neg = [idx_neg, kdx-1];
        end
        if sign(x_new) == -1 && sign(x_old) == 1 % || sign(x_new-pi) == -1 && sign(x_old-pi) == 1 || sign(x_new+pi) == -1 && sign(x_old+pi) == 1 || sign(x_new-2*pi) == -1 && sign(x_old-2*pi) == 1 || sign(x_new+2*pi) == -1 && sign(x_old+2*pi) == 1
            % Crossing 0 || Crossing pi || crossing -pi || crossing 2*pi || crossing -2*pi
            idx_neg = [idx_neg, kdx];
            idx_pos = [idx_pos, kdx-1];
        end
    end
    
    lambda_im_zero_lst = [];
    freq_im_zero_lst = [];
    if isempty(idx_neg) == 1
        lambda_im_zero = NaN;
        freq_im_zero_interp = NaN;
        
        lambda_im_zero_lst = [lambda_im_zero_lst; lambda_im_zero];
        freq_im_zero_lst = [freq_im_zero_lst; freq_im_zero_interp];
        
    else
        for gdx = 1:length(idx_neg)
            
            % Interpolation to find eigenvalue with Im(lambda) = 0
            real_plus_lambda = real(lambda_val(idx_pos(gdx)));
            imag_plus_lambda = imag(lambda_val(idx_pos(gdx)));
            
            real_min_lambda = real(lambda_val(idx_neg(gdx)));
            imag_min_lambda = imag(lambda_val(idx_neg(gdx)));
            
            imag_lst = [imag_plus_lambda, imag_min_lambda];
            real_lst = [real_plus_lambda, real_plus_lambda];
                   
                       
            lambda_im_zero_interp = interp1(imag_lst, real_lst, 0);
            
            lambda_im_zero = lambda_im_zero_interp + j*0;
            
            if real(lambda_im_zero) > 0 % || real(lambda_im_zero) < 0 || real(lambda_im_zero) == 0 
                % no phase flip allowed. Only PCO at phi = 0
                lambda_im_zero_lst = [lambda_im_zero_lst; lambda_im_zero];

                % Interpolation to find frequency at which Im(lambda) = 0
                freq_plus_lambda = freq(idx_pos(gdx));
                freq_min_lambda = freq(idx_neg(gdx));

                freq_lambda_lst = [freq_plus_lambda, freq_min_lambda];


                freq_lambda_lst_test = linspace(freq_plus_lambda, freq_min_lambda, 1000);
    %             
                freq_im_zero_interp_lst = zeros([length(freq_lambda_lst), 1]);

                M = [real_lst.', imag_lst.'];
                freq_im_zero_lst_avg = [];
                for freq_idx=1:length(freq_lambda_lst_test)
                    freq_test = freq_lambda_lst_test(freq_idx);
                    interp_sol = interp1(freq_lambda_lst, M, freq_test);

                    real_comp = interp_sol(1);
                    imag_comp = interp_sol(2);

                    freq_im_zero_interp = real_comp + j*imag_comp;
                    
%                     round(imag(freq_im_zero_interp), 4)
                    freq_im_zero_interp_lst(freq_idx) = freq_im_zero_interp;

                    if round(imag(freq_im_zero_interp), 3) == imag(lambda_im_zero) % 4, 3
                        freq_im_zero_lst_avg = [freq_im_zero_lst_avg; freq_test];
                    
                        
                    end
                end
            
%             F = scatteredInterpolant(real_lst.',imag_lst.',freq_lambda_lst.');

%             M = [real_lst.', imag_lst.'];
%             freq_im_zero_interp = interp1(freq_lambda_lst, M, );
%             end
                freq_im_zero_lst = [freq_im_zero_lst; mean(freq_im_zero_lst_avg)];
                
            end
          
        end
        
        
        
    end
    MIMO_PFM_data_single_V_array = [freq_im_zero_lst, lambda_im_zero_lst];
    MIMO_PFM_data_single_V = array2table(MIMO_PFM_data_single_V_array, 'VariableNames',{'Frequency', 'Lambda_im_zero'});
        
    MIMO_PFM_data_eigval.(V_val).lambda_2 = MIMO_PFM_data_single_V;
    % Use section below when using lambda_lst_all(ldx, :)
%     if rem(ldx, 2) == 0
%         MIMO_PFM_data.(V_val).lambda_2 = MIMO_PFM_data_single_V;
%     else
%         MIMO_PFM_data.(V_val).lambda_1 = MIMO_PFM_data_single_V;
%     end
end
%             cross_over_value = 0;
%     %         lambda_omega_PCO
%             if isnan(lambda_omega_PCO) == 1
%                 lambda_omega_PCO = NaN;
%                 gain_lambda_PCO = NaN;
%                 cross_over_value = NaN;
%             else
%                 gain_lambda_PCO = interp1(freq_lambda_lst, gain_lambda_lst, lambda_omega_PCO);
%             end
            

% Using smoothed lambda_2
MIMO_PFM_data_bode = struct();

idx_min_lambda_lst = [];

min_prev_lambda_lst = [];
min_next_lambda_lst = [];

min_lambda_lst = [];
freq_min_lambda_lst = [];

% Vel_lst = repelem(Velocity_AoA_0, 2); when using lambda_lst_all(ldx, :)
Vel_lst = Velocity_AoA_0;
for ldx = 1:min(size((smooth_lambda_2_all)))   
    V_val = "V_"+ string(Vel_lst(ldx)) + "ms";
    V_val = strrep(V_val, ".", "_");

    lambda_val = smooth_lambda_2_all(ldx, :);
    
    freq_new = linspace(f_min, f_max, length(lambda_val));
    
    

    mag_lambda = abs(lambda_val);
    mag_lambda_db = mag2db(mag_lambda);
    phase_lambda = angle(lambda_val);
    
    
    % Find locations of phase cross-over
    % Do not allow for unwrapping of phase --> Check only for crossing of 0
    % allow for crossing of zero from negative to positive or vice versa
    idx_pos = [];
    idx_neg = [];
    for kdx=2:length(phase_lambda)
        x_new = phase_lambda(kdx); 
        x_old = phase_lambda(kdx-1); 
        
        if sign(x_new) == 1 && sign(x_old) == -1 % || sign(x_new-pi) == 1 && sign(x_old-pi) == -1 || sign(x_new+pi) == 1 && sign(x_old+pi) == -1 || sign(x_new-2*pi) == 1 && sign(x_old-2*pi) == -1 || sign(x_new+2*pi) == 1 && sign(x_old+2*pi) == -1
            % Crossing 0 %|| Crossing pi || crossing -pi || crossing 2*pi || crossing -2*pi
            idx_pos = [idx_pos, kdx];
            idx_neg = [idx_neg, kdx-1];
        end
        if sign(x_new) == -1 && sign(x_old) == 1 % || sign(x_new-pi) == -1 && sign(x_old-pi) == 1 || sign(x_new+pi) == -1 && sign(x_old+pi) == 1 || sign(x_new-2*pi) == -1 && sign(x_old-2*pi) == 1 || sign(x_new+2*pi) == -1 && sign(x_old+2*pi) == 1
            % Crossing 0 %|| Crossing pi || crossing -pi || crossing 2*pi || crossing -2*pi
            idx_neg = [idx_neg, kdx];
            idx_pos = [idx_pos, kdx-1];
        end
    end
    [~, idx_neg_minus_pos] = min(abs(idx_neg - min(idx_pos)));
    [~, idx_pos_minus_neg] = min(abs(idx_pos - min(idx_neg)));
    difference = phase_lambda(idx_neg) - phase_lambda(idx_neg_minus_pos);
    
    gain_lambda_pco_lst = [];
    omega_lambda_pco_lst = [];
    cross_over_value_lst = [];
    if isempty(idx_neg) == 1
        lambda_omega_PCO = "NaN";
        gain_lambda_PCO = "NaN";
        cross_over_value = "NaN";
        
        gain_lambda_pco_lst = [gain_lambda_pco_lst; gain_lambda_PCO];
        omega_lambda_pco_lst = [omega_lambda_pco_lst; lambda_omega_PCO];
        cross_over_value_lst = [cross_over_value_lst; cross_over_value];
    else
        for gdx = 1:length(idx_neg)

            phase_lambda_plus = phase_lambda(idx_pos(gdx));
            phase_lambda_minus = phase_lambda(idx_neg(gdx));
            
            if isempty(phase_lambda_minus) == 1
                lambda_omega_PCO = NaN;
                gain_lambda_PCO = NaN;
                cross_over_value = NaN;
            else
                if abs(phase_lambda_minus - phase_lambda_plus) < 1.7*pi

                    gain_lambda_plus = mag_lambda(idx_pos(gdx));
                    gain_lambda_minus = mag_lambda(idx_neg(gdx));

                    freq_lambda_plus = freq_new(idx_pos(gdx));
                    freq_lambda_minus = freq_new(idx_neg(gdx));

                    gain_lambda_lst = [gain_lambda_plus, gain_lambda_minus];
                    phase_lambda_lst = [phase_lambda_plus, phase_lambda_minus];
                    freq_lambda_lst = [freq_lambda_plus, freq_lambda_minus];



                    lambda_omega_PCO = interp1(phase_lambda_lst, freq_lambda_lst, 0);
                    cross_over_value = 0;
            
                    if isnan(lambda_omega_PCO) == 1
                        lambda_omega_PCO = NaN;
                        gain_lambda_PCO = NaN;
                        cross_over_value = NaN;
                    else
                        gain_lambda_PCO = interp1(freq_lambda_lst, gain_lambda_lst, lambda_omega_PCO);
                    end
                else
                    lambda_omega_PCO = NaN;
                    gain_lambda_PCO = NaN;
                    cross_over_value = NaN;
                    disp("Phase Flip")
                end
               
            end
                        
            
            gain_lambda_pco_lst = [gain_lambda_pco_lst; gain_lambda_PCO];
            omega_lambda_pco_lst = [omega_lambda_pco_lst; lambda_omega_PCO];
            cross_over_value_lst = [cross_over_value_lst; cross_over_value];
        end   
        
        % Use structure to save each mode at each corresponding velocity
        
    end
    MIMO_PFM_data_single_V_array = [gain_lambda_pco_lst, omega_lambda_pco_lst, cross_over_value_lst];
    MIMO_PFM_data_single_V = array2table(MIMO_PFM_data_single_V_array, 'VariableNames',{'Gain_PCO', 'Omega_PCO', 'Cross-over_value'});
    
    MIMO_PFM_data_bode.(V_val).lambda_2 = MIMO_PFM_data_single_V;
    
end    

% Using raw lambda_2
MIMO_PFM_data_bode_raw = struct();

idx_min_lambda_lst = [];

min_prev_lambda_lst = [];
min_next_lambda_lst = [];

min_lambda_lst = [];
freq_min_lambda_lst = [];

% Vel_lst = repelem(Velocity_AoA_0, 2); when using lambda_lst_all(ldx, :)
Vel_lst = repelem(Velocity_AoA_0, 2);
for ldx = 2:2:min(size((lambda_lst_all)))  % 1:   
    lambda_val_raw = lambda_lst_all(ldx, :);
    V_val = "V_"+ string(Vel_lst(ldx)) + "ms";
    V_val = strrep(V_val, ".", "_");

    lambda_val = lambda_val_raw;
    
    freq_new = linspace(f_min, f_max, length(lambda_val));
    


    mag_lambda = abs(lambda_val);
    mag_lambda_db = mag2db(mag_lambda);
    phase_lambda = angle(lambda_val);
    
    
    % Find locations of phase cross-over
    % Do not allow for unwrapping of phase --> Check only for crossing of 0
    % allow for crossing of zero from negative to positive or vice versa
    idx_pos = [];
    idx_neg = [];
    for kdx=2:length(phase_lambda)
        x_new = phase_lambda(kdx); 
        x_old = phase_lambda(kdx-1); 
        
        if sign(x_new) == 1 && sign(x_old) == -1 % || sign(x_new-pi) == 1 && sign(x_old-pi) == -1 || sign(x_new+pi) == 1 && sign(x_old+pi) == -1 || sign(x_new-2*pi) == 1 && sign(x_old-2*pi) == -1 || sign(x_new+2*pi) == 1 && sign(x_old+2*pi) == -1
            % Crossing 0 % || Crossing pi || crossing -pi || crossing 2*pi || crossing -2*pi
            idx_pos = [idx_pos, kdx];
            idx_neg = [idx_neg, kdx-1];
        end
        if sign(x_new) == -1 && sign(x_old) == 1 % || sign(x_new-pi) == -1 && sign(x_old-pi) == 1 || sign(x_new+pi) == -1 && sign(x_old+pi) == 1 || sign(x_new-2*pi) == -1 && sign(x_old-2*pi) == 1 || sign(x_new+2*pi) == -1 && sign(x_old+2*pi) == 1
            % Crossing 0 %|| Crossing pi || crossing -pi || crossing 2*pi || crossing -2*pi
            idx_neg = [idx_neg, kdx];
            idx_pos = [idx_pos, kdx-1];
        end
    end
    [~, idx_neg_minus_pos] = min(abs(idx_neg - min(idx_pos)));
    [~, idx_pos_minus_neg] = min(abs(idx_pos - min(idx_neg)));
    difference = phase_lambda(idx_neg) - phase_lambda(idx_neg_minus_pos);
    
    gain_lambda_pco_lst = [];
    omega_lambda_pco_lst = [];
    cross_over_value_lst = [];
    if isempty(idx_neg) == 1
        lambda_omega_PCO = "NaN";
        gain_lambda_PCO = "NaN";
        cross_over_value = "NaN";
        
        gain_lambda_pco_lst = [gain_lambda_pco_lst; gain_lambda_PCO];
        omega_lambda_pco_lst = [omega_lambda_pco_lst; lambda_omega_PCO];
        cross_over_value_lst = [cross_over_value_lst; cross_over_value];
    else
        for gdx = 1:length(idx_neg)

            phase_lambda_plus = phase_lambda(idx_pos(gdx));
            phase_lambda_minus = phase_lambda(idx_neg(gdx));
            
            if isempty(phase_lambda_minus) == 1
                lambda_omega_PCO = NaN;
                gain_lambda_PCO = NaN;
                cross_over_value = NaN;
            else
                if abs(phase_lambda_minus - phase_lambda_plus) < 1.7*pi

                    gain_lambda_plus = mag_lambda(idx_pos(gdx));
                    gain_lambda_minus = mag_lambda(idx_neg(gdx));

                    freq_lambda_plus = freq_new(idx_pos(gdx));
                    freq_lambda_minus = freq_new(idx_neg(gdx));

                    gain_lambda_lst = [gain_lambda_plus, gain_lambda_minus];
                    phase_lambda_lst = [phase_lambda_plus, phase_lambda_minus];
                    freq_lambda_lst = [freq_lambda_plus, freq_lambda_minus];



                    lambda_omega_PCO = interp1(phase_lambda_lst, freq_lambda_lst, 0);
                    cross_over_value = 0;
            
                    if isnan(lambda_omega_PCO) == 1
                        lambda_omega_PCO = NaN;
                        gain_lambda_PCO = NaN;
                        cross_over_value = NaN;
                    else
                        gain_lambda_PCO = interp1(freq_lambda_lst, gain_lambda_lst, lambda_omega_PCO);
                    end
                else
                    lambda_omega_PCO = NaN;
                    gain_lambda_PCO = NaN;
                    cross_over_value = NaN;
                    disp("Phase Flip")
                end
               
            end
                        
            
            gain_lambda_pco_lst = [gain_lambda_pco_lst; gain_lambda_PCO];
            omega_lambda_pco_lst = [omega_lambda_pco_lst; lambda_omega_PCO];
            cross_over_value_lst = [cross_over_value_lst; cross_over_value];
        end
    
        % Use structure to save each mode at each corresponding velocity
        
    end
    MIMO_PFM_data_single_V_array = [gain_lambda_pco_lst, omega_lambda_pco_lst, cross_over_value_lst];
    MIMO_PFM_data_single_V = array2table(MIMO_PFM_data_single_V_array, 'VariableNames',{'Gain_PCO', 'Omega_PCO', 'Cross-over_value'});
    
    MIMO_PFM_data_bode_raw.(V_val).lambda_2 = MIMO_PFM_data_single_V;

end    


%% Plot MIMO Results
current_fig_n = get(gcf,'Number');
if current_fig_n == 1
    n = current_fig_n;
else
    n = current_fig_n + 1;
end

G_PCO_MIMO = [];
omega_PCO_MIMO = [];

Vel_lst = Velocity_AoA_0;
for MIMO_idx = 1:min(size((smooth_lambda_2_all))) % min(size((lambda_lst_all))) when using lambda_lst_all(ldx, :)
    V_val = "V_"+ string(Vel_lst(MIMO_idx)) + "ms";
    V_val = strrep(V_val, ".", "_");

           

    Gain_PCO_PFM_lst = MIMO_PFM_data_eigval.(V_val).lambda_2.('Lambda_im_zero');
    omega_PCO_PFM_lst = MIMO_PFM_data_eigval.(V_val).lambda_2.('Frequency');


    G_PCO_MIMO = [G_PCO_MIMO, Gain_PCO_PFM_lst(1)];
    omega_PCO_MIMO = [omega_PCO_MIMO, omega_PCO_PFM_lst(1)];

end
figure(n)

plot(Velocity_AoA_0, G_PCO_MIMO)
set(gca,'fontsize', font_size)
title("$G(\omega_{PCO})$ vs V AoA = " + AoA + " deg", 'Interpreter','latex')
xlabel('V [m/s]','Interpreter','latex', 'FontSize', font_size)
ylabel('$G(\omega_{PCO})$','Interpreter','latex', 'FontSize', font_size)
xlim([min(Velocity_AoA_0), max(Velocity_AoA_0)]);


if savefig == 1
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

    evolution_filename = "Figures/MIMO/Allow_PCO_at_plus_PI/MIMO_PFM_G_PCO_AoA_" + AoA;

    exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution',600)
    saveas(gcf, evolution_filename + ".jpg");
end

figure(n+1)
set(gca,'fontsize', font_size)
plot(Velocity_AoA_0, omega_PCO_MIMO)
title("$\omega_{PCO}$ vs V AoA = " + AoA + " deg", 'Interpreter','latex')
xlabel('V [m/s]','Interpreter','latex', 'FontSize', font_size)
ylabel('$\omega_{PCO}$ [Hz]','Interpreter','latex', 'FontSize', font_size)
xlim([min(Velocity_AoA_0), max(Velocity_AoA_0)]);
% grid()

if savefig == 1
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

    evolution_filename = "Figures/MIMO/Allow_PCO_at_plus_PI/MIMO_PFM_omega_PCO_AoA_" + AoA;
    
    exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution',600)
    saveas(gcf, evolution_filename + ".jpg");
end



%% Plot dpf
dpf = pf - 1./(G_PCO_MIMO/pf);

figure(n+2)
set(gca,'fontsize', font_size)
plot(Velocity_AoA_0, dpf)
title("$\Delta p_f$ AoA = " + AoA + " deg", 'Interpreter','latex')

set(gca,'fontsize', font_size)

xlabel('V [m/s]','Interpreter','latex', 'FontSize', font_size)
ylabel('$\Delta p_{f}$ [g]','Interpreter','latex', 'FontSize', font_size)
xlim([min(Velocity_AoA_0), max(Velocity_AoA_0)]);


if savefig == 1
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

    evolution_filename = "Figures/MIMO/MIMO_PFM_dpf_AoA_" + AoA;

    exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution',600)
    saveas(gcf, evolution_filename + ".jpg");
end


%% Save eigenvectors
filepath1 = 'Middle_LE_eigenvector/eigvec_1_AoA_' + string(AoA);
filepath2 = 'Middle_LE_eigenvector/eigvec_2_AoA_' + string(AoA);
save(filepath2 + '.mat', 'V_eigvec_lst_2_all')
save(filepath1 + '.mat', 'V_eigvec_lst_1_all')


%% Plot eigenvector contributions



% Eigenvector corresponding to lambda_2
font_size = 9;
font_size_legend = 9;
Vel_lst = repelem(Velocity_AoA_0, 2);
test_test = 0;
for V_idx =1:2:min(size(smooth_eigvec_lst_2_all))
    Vel_val = Vel_lst(V_idx);


    complex_comp_x = smooth_eigvec_lst_2_all(V_idx, :);
    real_comp_z = smooth_eigvec_lst_2_all(V_idx+1, :);
    
    complex_comp_x = V_eigvec_lst_2_all(V_idx, :);
    real_comp_z = V_eigvec_lst_2_all(V_idx+1, :);  
    
    x1 = 10;%30;
    x2 = 18;
    fh = figure;
    fh.Units = 'inches';
    fh.Position(3:4) = [3.25,3.5];
    set(gca,'fontsize', font_size)
    
    
    t = tiledlayout(2,1);%, 'Padding', 'none', 'TileSpacing', 'none');

    nexttile(t)

    plot(freq, abs(real_comp_z), 'Displayname', "z-component")
    hold on
    plot(freq, abs(complex_comp_x), 'Displayname', "x-component")
    ylim([0,1.05])
    xlim([f_min, f_max])
    ylabel('Magnitude','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
    
    set(gca,'XTickLabel',[]);
    
    
    leg = legend('Interpreter','latex', 'FontSize', font_size_legend, 'Location', 'west');
    leg.ItemTokenSize = [x1,x2];
    leg.FontName = font;
    set(gca,'fontname', font)
    set(gca,'fontsize', font_size)

    nexttile(t);
    delta = angle(complex_comp_x);% - angle(real_comp_z);
    

    plot(freq, angle(real_comp_z))
    hold on
    plot(freq, delta)%, 'Displayname', 'Angle between x and z component')
    
    
    xlim([f_min, f_max])
    
    xlabel('Frequency [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
    ylabel('Phase angle [rad]','Interpreter','latex', 'FontSize', font_size, 'FontName', font) 
    
    set(gca,'fontname', font)
    set(gca,'fontsize', font_size)
    
    yline(0,'HandleVisibility','off')
    yline(pi,'HandleVisibility','off')
    yline(-pi,'HandleVisibility','off')
    

    
    
    
    t.TileSpacing = 'none';
    t.Padding = 'none';
    
    if savefig == 1
        set(gcf,'Units','Inches');
        pos = get(gcf,'Position');
        set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

    
        evolution_filename = "Figures/Eigenvectors/Raw/Raw_eigenvector_2_contribution_AoA_" + AoA + "_" + string(Vel_val) + "_ms";
        
        exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution',600)
        saveas(gcf, evolution_filename + ".jpg");
    end

end


% Eigenvector corresponding to lambda_1
font_size = 9;
font_size_legend = 9;
Vel_lst = repelem(Velocity_AoA_0, 2);
test_test = 0;
for V_idx =1:2:min(size(V_eigvec_lst_1_all))
    Vel_val = Vel_lst(V_idx);
    current_fig_n = get(gcf,'Number');
    if current_fig_n == 1 && test_test == 0
        n = current_fig_n;
        test_test = 1;
    else
        n = current_fig_n + 1;
    end

   
    complex_comp_x = V_eigvec_lst_1_all(V_idx, :);
    real_comp_z = V_eigvec_lst_1_all(V_idx+1, :);  
    
    x1 = 10;%30;
    x2 = 18;
    fh = figure;
    fh.Units = 'inches';
    fh.Position(3:4) = [3.25,3.5];
    set(gca,'fontsize', font_size)
    
    
    t = tiledlayout(2,1);%, 'Padding', 'none', 'TileSpacing', 'none');

    nexttile(t)
    
    plot(freq, abs(real_comp_z), 'Displayname', "z-component")
    hold on
    plot(freq, abs(complex_comp_x), 'Displayname', "x-component")
    ylim([0,1.05])
    xlim([f_min, f_max])
    ylabel('Magnitude','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
    
    set(gca,'XTickLabel',[]);
    
    
    leg = legend('Interpreter','latex', 'FontSize', font_size_legend, 'Location', 'southwest');
    leg.ItemTokenSize = [x1,x2];
    leg.FontName = font;
    set(gca,'fontname', font)
    set(gca,'fontsize', font_size)
    nexttile(t);
    delta = angle(complex_comp_x);% - angle(real_comp_z);
    
    plot(freq, angle(real_comp_z))
    hold on
    plot(freq, delta)%, 'Displayname', 'Angle between x and z component')
    xlim([f_min, f_max])
    
    xlabel('Frequency [Hz]','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
    ylabel('Phase angle [rad]','Interpreter','latex', 'FontSize', font_size, 'FontName', font) 
    
    set(gca,'fontname', font)
    set(gca,'fontsize', font_size)
    

    yline(0,'HandleVisibility','off')
    yline(pi,'HandleVisibility','off')
    yline(-pi,'HandleVisibility','off')
    

    
    
    
    t.TileSpacing = 'none';
    t.Padding = 'none';
    
    if savefig == 1
        set(gcf,'Units','Inches');
        pos = get(gcf,'Position');
        set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);

    
        evolution_filename = "Figures/Eigenvectors/Raw/Raw_eigenvector_1_contribution_AoA_" + AoA + "_" + string(Vel_val) + "_ms";

        exportgraphics(gcf, evolution_filename + ".pdf", 'Resolution',600)
        saveas(gcf, evolution_filename + ".jpg");
    end

end

%% Plot Smoothing Comparison Plots

Compare_Eigenvalues_Smooth_raw

% Compare_Eigenvectors_Smooth_raw


%% Plotting of eigenvalue Bode Plots
% plot_MIMO_Bode