%% Data reading file
% Clear matlab
clear all
close all
clc

%% Part 1: Initialization
% Folders where files are saved, one per Plate
Fold = {'Plate A','Plate B','Plate C','Plate B Right','Plate B Left'};
NFold = 5;  % Number of "Wing" folders
An = 2;     % Number of angles of attack
Freq = 5;   % Number of gust frequencies
Rel = 6;    % Number of release conditions

% Create matrices for linear fit of polars 
Pl = zeros(2,5);    %Locked hinge polar
Pf=Pl;              %Free hinge polar

% Test constants
A_factor = (40*40)/(35*40); % Correction factor accounting for WT contraction (A_outlet/A_gust generator)
b = 700;                    % Semispan [mm]
Surf = 0.1*0.7;             % Wing surface (Chord [m] x Semispan[m])
U = 10*A_factor;            % Airspeed [m/s]
rho = 1.225;                % Air density [kg/m3]
q = 0.5*rho*U*U;            % Dynamic pressure [Pa]

%% Part 2: Reading
% Process every wing:
% Wings A to C: i = [1,2,3]
% Wings B Right and B Left: i = [4,5] (Coresponding to B_WI and B_WO)
for i=1:1:NFold
    if i<=3
        %Process different stiffness plates
        Results(i).plate = Fold(i);
        Results(i).Polar = Static(string(Fold(i)));
        Results(i).Dynamic = Gusts(string(Fold(i)));
    else
        %Process tailored plates (file names have an extra "_" and require
        %different functions
        Results(i).plate = Fold(i);
        Results(i).Polar = Static_tail(string(Fold(i)));
        Results(i).Dynamic = Gusts_tail(string(Fold(i)));
    end

    % LINEAR REGRESSION OF LOCKED POLAR
    x= zeros(size(Results(i).Polar.locked(1,1,:),3),1);
    y=x;
    x(:)=Results(i).Polar.locked(1,1,:);
    %Bending moment converted to moment coefficient
    y(:)=Results(i).Polar.locked(1,11,:)/(q*Surf*b);
    Pl(:,i)=polyfit(x(1:9),y(1:9),1);
    
    % LINEAR REGRESSION OF FREE POLAR
    x= zeros(size(Results(i).Polar.free(1,1,:),3),1);
    y=x;
    x(:)=Results(i).Polar.free(1,1,:);
    %Bending moment converted to moment coefficient
    y(:)=Results(i).Polar.free(1,11,:)/(q*Surf*b);
    Pf(:,i)=polyfit(x(1:9),y(1:9),1);

    % Save the results of the interpolation in the Results structure
    Results(i).Polar.inter_F = Pf(:,i);
    Results(i).Polar.inter_L = Pl(:,i);
end

%% Part 3: Create summary files
count=1;            % Counter used to write each line of the summary
% Loop around wings
for i=1:1:NFold 
    Plate = Results(i).plate;   % Temporary variable with Plate name
    for j=1:1:An
        AoA = Results(i).Dynamic(j).AoA;    % Temporary variable with AoA
        for k=1:1:Freq
            Frequency = Results(i).Dynamic(j).results(k).frequency;   % Temporary variable with gust frequency
            for z=1:1:Rel
                % Temporary variable with release condition
                Release = Results(i).Dynamic(j).results(k).results(z).release;
                % Temporary variable with number of used samples
                Samples = size(Results(i).Dynamic(j).results(k).results(z).results,3);

                % Save temporary variables into Summary matrix
                Summary(count).plate=Plate;
                Summary(count).AoA=AoA;
                Summary(count).freq=Frequency;
                Summary(count).rele=Release;
                Summary(count).Samp=Samples;
                Summary(count).SR=mean(Results(i).Dynamic(j).results(k).results(z).SR);
                Summary(count).SRmin=min(Results(i).Dynamic(j).results(k).results(z).SR);
                Summary(count).SRmax=max(Results(i).Dynamic(j).results(k).results(z).SR);
                count=count+1;
            end
        end
    end
end

% Write the summary data into Excel file
writetable(struct2table(Summary),'Summary.xlsx');

% Save into .mat file
save('Test_Mat.mat','Results');
