function [Alpha] = Gusts_tail(Wing)
    % Function that reads a "dynamic" folder within wing folder of results 
    % and saves it into structure Alpha. Each folder contains 2 angles of 
    % attack and 5 gust frequencies.
    % Input: 
    %   - Wing: String with wing folder name
    % Output:
    %   - Alpha: Structure with the results of a wing for each AoA and gust
    %            frequency
    % Note: Different than "Gusts.m" because of naming convention of wings.
    % however, the procedure is the same

    % Define folder names where process will occur
    Angle = ["A0", "A5"];                           % Define AoA folders
    Frequency = ["F05","F5","F8","FBend","FFlap"];  % Define gust frequency folders

    % First loop: Angle of attack folders (2 folders)
    for An = 1:1:2
        % Second loop: Frequency folders (5 folders)
        for freq = 1:1:5

            % Read folder at defined wing, AoA and frequency
            [Gusts]= ReadFolder_tail(Wing,Angle(An),Frequency(freq));

            % Save results of each frequency in a temporary variable FF
            FF(freq).frequency = Frequency(freq);   % Save frequency
            FF(freq).results = Gusts;               % Save results
        end
        Alpha(An).AoA = Angle(An);      % Save the angle of attack
        Alpha(An).results = FF;         % Save the results of the frequency sweep
        clearvars FF                    % Reset FF variable
    end
end